/* Script you may use to ReGet File */
blocksize=2048
parse arg fr t bl
if (t='') then
do
 say "RECOPY.CMD. Script for copying files (no EA support)"
 say "Usage: recopy <from> <to> [<block size>]"
 say "   <from> <to>  : source and destination file names"
 say "   <block size> : Size of block for copying. Default value is 2048 bytes."
 say "                  Use larger value for faster hosts"
 return
end
if bl<>'' then blocksize=bl
say "Copying "||fr||" -> "||t
if stream(t,'c','OPEN WRITE')<>"READY:" then
do
 say "Can't open destination"
 exit
end
a=stream(t,"c","QUERY SIZE")
if (a='') then a=0
if stream(fr,'c','OPEN READ')<>"READY:" then
do
 say "Can't open source"
 exit
end
sz=stream(fr,"c","QUERY SIZE")-(a+1)
call time 'r'
call stream fr,'c','seek ='||(a+1)
do while stream(fr,'s')='READY'
 s=charin(fr,,blocksize)
 call charout t,s
 p=(stream(fr,'c','seek')-(a+1))
 eta=(sz-p)/(p/time(e))
 etah=eta%3600
 etas=''
 if etah<>0 then etas=etah||':'
 etam=trunc((eta%60)//60)
 etas=etas||etam||':'
 etas=etas||trunc(eta//60)
 call charout, d2c(13)||p||' bytes copied ('||trunc((p/sz)*100,1)||'%) cps='trunc(p/time('e'))||' ETA='||etas||'     '
end
call lineout ,'a'x'd'x'Done in '||trunc(time('e'))||' seconds'
call stream fr,'c','close'
call stream t,'c','close'

