/*
Copyright (C) 2003-2004 Narcis Ilisei

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
  
#include "os.h"

#ifdef UNIX_OS
#include <unistd.h>
#include <sys/stat.h>

void os_sleep_ms(int ms)
{
    usleep(ms*1000);
}

int  os_get_socket_error (void)
{
    return errno;
}

RC_TYPE os_ip_support_startup(void)
{
    return RC_OK;
}

RC_TYPE os_ip_support_cleanup(void)
{
    return RC_OK;
}


/* MAIN FUNCTION */
RC_TYPE os_install_signal_handler(OS_SIGNAL_HANDLER_TYPE hand)
{
    return RC_OK;
}

/*
    closes current console 

  July 5th, 2004 - Krev
  ***
  This function is used to close the console window to start the 
  software as a service on Windows. On Unix, closing the console window
  isn't used for a daemon, but rather it forks. Modified this function
  to fork into a daemon mode under Unix-compatible systems.
  
  Actions:
    - for child:
        - close in and err console
        - become session leader 
        - change working directory 
        - clear the file mode creation mask 
    - for parent 
        just exit
*/
RC_TYPE close_console_window(void)
{
    pid_t pid = fork();
    
    if(pid < 0)
    {
        return RC_OS_FORK_FAILURE;
    }
    
    if (pid == 0)
    { /* child */
        fclose(stdin);
        fclose(stderr);
        setsid();  
        chdir("/");
        umask(0);  
        return RC_OK;
    }
    else 
    {
        exit(0);
    }
    return RC_OK;
}

/* MAIN - Dyn DNS update entry point.*/
int main(int argc, char* argv[])
{
    return inadyn_main(argc, argv);
}

RC_TYPE os_syslog_open(const char *p_prg_name)
{
    openlog(p_prg_name, LOG_PID, LOG_USER);
    return RC_OK;
}

RC_TYPE os_syslog_close(void)
{
    closelog();
    return RC_OK;
}

#endif 
