/* 
   DYN 2.x.x * a complete DynDNS client for Monolith's DynDNS service

   Written by Jon Klippenstein <random@ocii.com>
   Copyright (C) 1997 Jon Klippenstein

   Network code based in part on fetchwww.c 1.0 by Artur Skawina 
   <skawina@usa.net>

     * MS3 modifications by Method <method@arena.cwnet.com>
     * OS/2 port and modifications by Jeff Irvine <jirvine@usa.net>

   Tested on:

   OS/2 Warp 3.0 (FixPak 26)
   OS/2 Warp 4.0 (FixPak 6)
   
 */

#include <stdio.h>
#include <stdlib.h>
#include <strings.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <errno.h>
#include <unistd.h>
#include <netinet/in.h>
#include <netdb.h>
#include <arpa/inet.h>

#ifdef USE_SYSLOG
#include <syslog.h>
#endif

#define NAME		"DYN"
#define VERSION		"2.1.0"

/* Uncomment DEBUG if you want to see raw HTML output from the server. */
/* NOTE: You may also add -DDEBUG on GCC's commandline. */

/* #define      DEBUG */

#define WWW_PORT	80
#define SERVER		"members.ml.org"
#define SCRIPT  	"/mis-bin/ms3/nic/dyndns"
#define STATUS		"MS3V STATUS:OK"
#define DYNDOMAIN       ".dyn.ml.org"

void nuke_string(char *targetstring)
{
    char *mystring = targetstring;
    while (*targetstring != '\0') {
        *targetstring++ = ' ';
    }
    *mystring = '\0';
}

void show_help(void)
{
    printf("\n Invalid command line.  Proper usage:\n\n");
    printf(" DYN.EXE <username> <password> <domain> <on/off> [mail exchanger]\n\n");
    printf("   <username>       ; Your ML.ORG DynDNS username.\n");
    printf("   <password>       ; Your ML.ORG DynDNS password.\n");
    printf("   <domain>         ; Your dynamic DNS name (ie: todbbs).\n");
    printf("   <on/off>         ; Activate (on) or deactivate (off) your domain.\n");
    printf("   [mail exchanger] ; Mail exchanger for your domain (optional).\n\n");
    printf(" Example usage:\n\n");
    printf("   DYN.EXE indem1 11-22-33 todbbs on mail.exchanger.domain\n\n");
}

int main(int argc, void *argv[])
{
    FILE *rfile;

    struct sockaddr_in sin;
    struct hostent *host;

    int sock, port, connected;

    char send[BUFSIZ], temp[1024];
    char mid[10], hostname[10];
    char mx[256], pass[64], action[4];
    char enc[256], cmd[256], *cp;

    printf("\n%s %s  Monolith MS3 DynDNS Client for OS/2\n"
           "Copyright (c) 1997 by Jon Klippenstein <random@ocii.com>\n"
           "MS3 Modificatons by Method <method@arena.cwnet.com>\n"
           "OS/2 Port and Modifications by Jeff Irvine <jirvine@usa.net>\n", NAME, VERSION);

#ifdef DEBUG
    printf("\n * NOTE:  DEBUG MODE ENABLED\n");
#endif

#ifdef USE_SYSLOG
    openlog(me, LOG_PID, LOG_USER);
#endif

    if (argc < 5) {
        show_help();
        exit(1);
    }

    if(argc == 6)
        strcpy(mx, argv[5]);
    else
        *mx = '\0';

    strcpy(mid, argv[1]);
    strcpy(pass, argv[2]);
    strcpy(hostname, argv[3]);

    if(stricmp(argv[4], "on") == 0)
        strcpy(action, "act");
    else
        strcpy(action, "dec");

    nuke_string(argv[1]);
    nuke_string(argv[2]);
    nuke_string(argv[3]);
    nuke_string(argv[4]);

    if(*mx)
        nuke_string(argv[5]);

    cp = (char *)malloc(strlen(mid) + strlen(pass) + 3);

    strcpy(cp, mid);
    strcat(cp, ":");
    strcat(cp, pass);
    encode(cp, strlen(cp), enc);

    /* Ensure that we have all of the necessary data to continue. */

    if (!hostname || !mid || !pass) {
        show_help();
        exit(1);
    }
      
    printf("\n - Host      :  %s%s\n", hostname, DYNDOMAIN);
    printf(" - User name :  %s\n", mid);
    printf(" - Action    :  %s\n", action);
    if(*mx)
        printf(" - MX        :  %s\n", mx);

    sin.sin_family = AF_INET;
    sin.sin_port = htons(80);

    if (!(host = gethostbyname(SERVER))) {

#ifdef USE_SYSLOG
        syslog(LOG_WARNING, "gethostbyname: %m");

#endif
        perror("gethostbyname");
        exit(1);
    }
    memcpy((char *) &sin.sin_addr, host->h_addr, host->h_length);

    printf("\n - Connecting to %s . . . ", SERVER);

    if ((sock = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP)) == -1) {

#ifdef USE_SYSLOG
        syslog(LOG_WARNING, "socket: %m");
#endif

        perror("socket");
        exit(1);
    }

    if (connect(sock, (struct sockaddr *) &sin, sizeof(sin)) == -1) {

#ifdef USE_SYSLOG
        syslog(LOG_WARNING, "connect: %m");
#endif

        perror("connect:");
        exit(1);
    }
    printf("Ok\n");

    /* Now create line to send to HTTP server */

    printf(" - Sending update . . . ");

    sprintf(cmd,
            "command=Update+Host&do=mod&domain=%s&act=%s&wildcard=on&mail=%s&agree=agree",
            hostname, action, *mx ? mx : "");

    sprintf(send,
            "POST %s HTTP/1.0\n"
            "Referer: http://%s%s?host=%scommand=Edit+Host\n"
            "Connection: Keep-Alive\n"
            "User-Agent: %s %s MS3 DynDNS Client (OS/2 Warp)\n"
            "Host: %s\n"
            "Accept: image/gif, image/x-xbitmap, image/jpeg, image/pjpeg, */*\n"
            "Accept-Language: en\n"
            "Accept-Charset: iso-8859-1,*,utf-8\n"
            "Authorization: Basic %s\n"
            "Content-type: application/x-www-form-urlencoded\n"
            "Content-length: %d\n"
            "\n"
            "%s\n"
            "\n",
            SCRIPT, SERVER, SCRIPT, hostname, NAME, VERSION, SERVER, enc,
            strlen(cmd), cmd);

#ifdef DEBUG
    printf("\n\n%s\n\n", send);
#endif

    write(sock, send, strlen(send));

    printf("Ok\n");

    printf(" - Waiting for reply . . . ");

    rfile = fdopen(sock, "r");

    while (!feof(rfile)) {
        fgets(temp, (int) sizeof(temp), (FILE *) rfile);

#ifdef DEBUG
        printf("\n\n%s", temp);
#endif

        /* If "MS3V STATUS:OK" is present if the host was added/modified OK */

        if (strstr(temp, STATUS)) {
            printf("Ok\n");
            printf(" - Host \"%s\" updated successfully\n", hostname);

#ifdef USE_SYSLOG
            syslog(LOG_INFO, "Host \"%s\" update successful.", hostname);*/
#endif

            exit(0);
        }
    }

    printf("\n - ERROR: \"%s\" token not found in reply.  Host not updated.\n", STATUS);

#ifdef USE_SYSLOG
    syslog(LOG_ERR, "ERROR: %s not found, update unsuccessful.", STATUS);*/
#endif

    exit(1);
}
