/***************************************************************************
 *   Copyright (C) 2007 by Anistratov Oleg                                 *
 *   ower@users.sourceforge.net                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation;                         *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 ***************************************************************************/

#ifndef SINGLEMESSAGEWGT_H
#define SINGLEMESSAGEWGT_H

#include <QDialog>
#include <QPushButton>
#include <QTextEdit>
#include <QWidget>
#include <QHostAddress>
#include <QCloseEvent>
#include <QCheckBox>
#include <QLabel>

class InputTextWgt;
class ChatTextWgt;
class SingleMessage;

/**
	@author Anistratov Oleg <ower@users.sourceforge.net>
*/
class SingleMessageWgt : /*public QDialog*/public QWidget
{
  Q_OBJECT
  private:
    static QList<SingleMessageWgt*> m_newMessages;
    static QList<SingleMessageWgt*> m_openedMessages;
    static int m_currentNewMessage;
    static int m_currentOpenedMessage;

  private:
    bool          m_isIncoming;
    bool          m_quot;

    QHostAddress  m_destAddr;
    uint          m_destUid;
    QString       m_title;
    QPushButton*  m_sendBtn;
    QPushButton*  m_closeBtn;
    QPushButton*  m_replyBtn;
    QPushButton*  m_replyQuotedBtn;
    ChatTextWgt*  m_messageIn;
    InputTextWgt* m_inputText;
    QCheckBox*    m_importantChbx;
//     QLabel*       m_infoLab;
    SingleMessage*      m_message;

    /// Stores position of last moved SingleMessageWgt for restoring this position for newly created SingleMessageWgt widgets
    static QPoint m_lastPosition;

    /// Stores size of last resized SingleMessageWgt for restoring this size for newly created SingleMessageWgt widgets
    static QSize m_lastSize;

  private:
    static void nextPrevMessage(const QList<SingleMessageWgt*>&, int&, int, bool);
    static void closeMessages(QList<SingleMessageWgt*>&, int&);

  public:
    SingleMessageWgt(const QString &, const QString &, uint, const QHostAddress &, bool isIncoming_ = false, QWidget *parent = 0);
    SingleMessageWgt(SingleMessage*, bool isIncoming_ = false, QWidget *parent = 0);
    ~SingleMessageWgt();

    void init(const QString &, const QString &, uint, const QHostAddress &, bool isIncoming_);

    void retranslate();

    static void addNewMessage   (SingleMessageWgt* msg){if(!m_newMessages.contains(msg)   ) m_newMessages.append(msg);}
    static void addOpenedMessage(SingleMessageWgt* msg){if(!m_openedMessages.contains(msg)) m_openedMessages.append(msg);}

    static void nextPrevNewMessage    (int direction = 1, bool closeCurrent = false)
    {nextPrevMessage  (m_newMessages   , m_currentNewMessage, direction, closeCurrent);}

    static void nextPrevOpenedMessage (int direction = 1, bool closeCurrent = false)
    {nextPrevMessage  (m_openedMessages, m_currentOpenedMessage, direction, closeCurrent);}

    static void closeAllNewMessages   (){closeMessages(m_newMessages   , m_currentNewMessage);}
    static void closeAllOpenedMessages(){closeMessages(m_openedMessages, m_currentOpenedMessage);}

  public slots:
    void slot_reply      ();
    void slot_replyQuoted();
    void slot_selfDestroy();
    void slot_sendMessage();

  signals:
    void singleMessage(const QString&, quint64, bool);

  protected:
    void closeEvent(QCloseEvent* ev);
    void resizeEvent(QResizeEvent* ev);
    void moveEvent(QMoveEvent* ev);
};

#endif
