/***************************************************************************
 *   Copyright (C) 2007 by Anistratov Oleg                                 *
 *   ower86@gmail.com                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation;                         *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 ***************************************************************************/
#ifndef ANIMATEDSMILE_H
#define ANIMATEDSMILE_H

#include <QObject>
#include <QTextCursor>
#include <QMovie>
#include <QTextDocument>

/**
        @author Anistratov Oleg <ower86@gmail.com>
*/
class AnimatedSmile : public QObject
{
  Q_OBJECT
  private:
    QMovie*        m_smile;
    QTextDocument* m_document;
    int            m_pos;
    QString        m_filename;

    bool           m_running;

    static QMap<QByteArray, QMovie*> m_allSmiles;

  public:
    AnimatedSmile(QObject *parent = 0);
    ~AnimatedSmile();

    void init(int, const QString&, QTextDocument*);
    void start(){m_smile->start(); m_running = true; nextFrame();}
    void stop(){m_smile->stop(); m_running = false;}
    void setPaused(bool b){/*m_smile->setPaused(b);*/ m_running = !b;}

    bool animated(){return true;}

    void pauseIfHidden(int, int);

  public slots:
    void nextFrame();

};

#endif
