/***************************************************************************
 *   Copyright (C) 2007 by Anistratov Oleg                                 *
 *   ower86@gmail.com                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation;                         *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 ***************************************************************************/

#include <QCoreApplication>

#include "qchatserver.h"

void myMessageOutput(QtMsgType type, const char *msg)
{
  switch (type)
  {
    case QtDebugMsg:
//       fprintf(stdout, "Debug: %s\n", msg);
      break;

    case QtWarningMsg:
      fprintf(stderr, "Warning: %s\n", msg);
      break;

    case QtCriticalMsg:
      fprintf(stderr, "Critical: %s\n", msg);
      break;

    case QtFatalMsg:
      fprintf(stderr, "Fatal: %s\n", msg);
  }
}


void printHelp()
{
  printf("QChat Server - server application for lan chat\n");
  printf("  Available options:\n");
  printf("         --kick       <login>  kick user with login <login> from the server\n");
  printf("         --ban        <login>  ban user on by login\n");
  printf("         --unbun      <login>  unban user on by login\n");
  printf("         --kickip     <ip>     kick user with IP address <ip> from the server\n");
  printf("         --banip      <ip>     ban user by IP address\n");
  printf("         --unbunip    <ip>     unban user by IP address\n");
  printf("         --unbunall            unban all users by login\n");
  printf("         --unbunallip          unban all users by IP address\n");
  printf("    -h,  --help                prints this message\n");
}

int main(int argc, char *argv[])
{
  qInstallMsgHandler(myMessageOutput);

  QCoreApplication app(argc, argv);

  QStringList kick_users;
  QStringList ban_users;
  QStringList unban_users;

//   QList<QHostAddress> kick_ips;
//   QList<QHostAddress> ban_ips;
//   QList<QHostAddress> unban_ips;

  QStringList kick_ips;
  QStringList ban_ips;
  QStringList unban_ips;

  QHostAddress addr;

  bool options     = false;
  bool unbunAll    = false;
  bool unbunAllIPs = false;

  for(int i = 1; i < argc; i++)
  {
    if(!strcmp(argv[i], "--kick") && (++i < argc))
    {
      kick_users.append(argv[i]);
      options = true;
    }

    else if(!strcmp(argv[i], "--ban") && (++i < argc))
    {
      ban_users.append(argv[i]);
      options = true;
    }

    else if(!strcmp(argv[i], "--unban") && (++i < argc))
    {
      if(addr.setAddress(argv[i]))
      {
        unban_ips.append(argv[i]);
        options = true;
      }
    }

    else if(!strcmp(argv[i], "--kickip") && (++i < argc))
    {
      if(addr.setAddress(argv[i]))
      {
        kick_ips.append(argv[i]);
        options = true;
      }
    }

    else if(!strcmp(argv[i], "--banip") && (++i < argc))
    {
      if(addr.setAddress(argv[i]))
      {
        ban_ips.append(argv[i]);
        options = true;
      }
    }

    else if(!strcmp(argv[i], "--unbanip") && (++i < argc))
    {
      unban_users.append(argv[i]);
      options = true;
    }

    else if(!strcmp(argv[i], "--unbanall"))
    {
      unbunAll = true;
      options = true;
    }

    else if(!strcmp(argv[i], "--unbanallip"))
    {
      unbunAllIPs = true;
      options = true;
    }

    else if(!strcmp(argv[i], "-h") || !strcmp(argv[i], "--help"))
    {
      unban_users.append(argv[i]);
      printHelp();
      exit(0);
    }
    else
    {
      printf("Unknown option: %s\nUse -h for list of available options\n", argv[i]);
      exit(1);
    }
  }

  QChatServer serv;

  foreach(QString u, kick_users)
    serv.sendInstruction(u, "Kick");

  foreach(QString u, ban_users)
    serv.sendInstruction(u, "Ban");

  foreach(QString u, unban_users)
    serv.sendInstruction(u, "Unban");

  foreach(QString u, kick_ips)
    serv.sendInstruction(u, "KickIp");

  foreach(QString u, ban_ips)
    serv.sendInstruction(u, "BanIp");

  foreach(QString u, unban_ips)
    serv.sendInstruction(u, "UnbanIp");

  if(unbunAll)
    serv.sendInstruction("", "UnbanAll");

  if(unbunAllIPs)
    serv.sendInstruction("", "UnbanAllIPs");

  if(options)
    exit(0);

  app.exec();
}
