#include "common.h"

#define PROTOCOL "19981001"

#define PACK_UNKNOWN 0
#define PACK_CONNECTION 1
#define PACK_LOGIN 2
#define PACK_MESSAGE 3
#define PACK_STATUS 4
#define PACK_ROSTER 5
#define PACK_LOGOUT 6

#define STATUS_NORMAL 0
#define STATUS_OFFLINE 1
#define STATUS_ONLINE 2

#define ROSTER_REMOVE 0
#define ROSTER_ADD 1
#define ROSTER_GET 2


/*
 * Structure that holds decoded packets
 */
typedef struct
{
	int type;

	pair *par;

	char *version;
	char *protocol;
	char *id;
	char *user;
	char *pass;
	char *thread;
	char *subject;
	char *ext;
	char *say;
	char *status;
	int priority;
	int flag_type;
	int flag_misc;

} package;

package *package_init(int type);
void free_package(package *p);

/*****************************************************************/
/* These are the available functions in the client lib right now */
/*****************************************************************/

/* for SIMPLE clients that are based on the standard cli rules */
int jab_send(package *p);
package *jab_receive();

/* for custom clients that want to do their own work */
conn *jab_connect(char *server, int port, char *version);
void jab_select(conn *(*handle_packet)());
package *jab_handle(char *p);
void jab_set_sender(conn *c, char *id); /* if multi-login connect */

int jab_send_login(char *user, char *pass, char *nick);
int jab_send_status(char *say, char *status, int type, int priority);
int jab_send_message(pair *to, char *subject, char *say, char *thread, char *ext, int priority);
int jab_send_roster(pair *commands);
int jab_send_logout();

char *strgrow(char *old, char *new, int old_free, int new_free);

