/* REXX installation script for iceCQ
 * Copyright (C) 2000 by ilfat Kutdusov
 *
 */

call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs

/*------------------------------------------------------------------
 * Initialization 
 *------------------------------------------------------------------*/

D.Folder = 'IceCQ/2'
D.Object = 'IceCQ/2'
D.Program = 'IceCQ.EXE'
D.Readme = 'Readme_english.txt'
D.DOC = 'demo_readme_english.txt'


installdir = directory()"\"
installlog = installdir"install.log"

if GetYesNo( "Install" D.Object "in" installdir ) == 0 then
   exit

/*------------------------------------------------------------------
 * Create folder
 *------------------------------------------------------------------*/

rc = SysCreateObject( "WPFolder",D.Folder,"<WP_DESKTOP>",,
                      "OBJECTID=<WTFolder>;ALWAYSSORT=Yes" ,"REPLACE" )

if rc then
   call log D.Fodler "folder successfully created on desktop..."
else
   call log "ERROR:" D.Folder "folder creating failed!"

/*------------------------------------------------------------------
 * Create object
 *------------------------------------------------------------------*/

rc = SysCreateObject( "WPProgram", D.Object, "<WTFolder>",,
                      "OBJECTID=<MINITUN>;EXENAME="installdir""D.Program";STARTUPDIR="installdir";REPLACE" )

if rc then
   call log D.Object "object successfully created..."
else 
   call log "ERROR:" D.Object "object creating failed!"

rc = SysCreateObject( "WPShadow", D.Object, "<WP_START>",,
                      "SHADOWID=<MINITUN>",,
                      "REPLACE" )

if rc then
   call log D.Object "object added in Startup folder..."
else 
   call log "ERROR:" D.Object "object adding in Startup folder failed!"

/*------------------------------------------------------------------
 * Create object
 *------------------------------------------------------------------*/

rc =SysCreateObject("WPProgram", D.Object || "^Readme" , "<WTFolder>", "EXENAME=E.EXE;PARAMETERS=" || installdir || "" || D.Readme, "replace")

if rc then
   call log "Readme object successfully created..."
else 
   call log "ERROR:" D.Readme "object creating failed!"

rc =SysCreateObject("WPProgram", D.Object || "^Demo limitation" , "<WTFolder>", "EXENAME=E.EXE;PARAMETERS=" || installdir || "" || D.DOC, "replace")

if rc then
   call log "Demo limitations object successfully created..."
else 
   call log "ERROR:" "Demo limitations object creating failed!"



Exit

/*------------------------------------------------------------------
 * Get Yes or No
 *------------------------------------------------------------------*/
GetYesNo: procedure

   ok = 0

   do until ok
      call charout, arg(1) || "? "
      pull reply
      reply = left(reply, 1)
      ok = (reply = "Y") | (reply = "N")
      if \ok then do
         say 'Huh? Please enter "Y" or "N".'
      end
   end

return (reply = "Y")

/*------------------------------------------------------------------
 * Write log message
 *------------------------------------------------------------------*/
Log: procedure expose installlog; parse arg msg

   say  " "msg
   call lineout installlog, "INSTALL: "msg

return
