/*  Michal Necasek  <mike@mendelu.cz>
    Daniel Hellerstein (danielh@econ.ag.gov)
Create a big-text banner using TTF fonts. 
*/

/********** Begin user changable parameters (used as defaults ******/

/* The "foreground" character                    */
forechar='W'

/* and the background character                  */
backchar=' '

/* Instead of a single foreground character, you can use the characters
  from a message. To enable this, set:
      use_filler_message=1, 2 or 3
      filler_message=character_string_to_fill_with
  use_filler_message =1 ==> use the filler_message
  use_filler_message =2 ==> use the "displayed" message
  use_filler_message =3 ==> try to use the "own character"

 Note: use_filler_message=1 and filler_message='' is the same as 
       use_filler_message=2
*/
use_filler_message=3
filler_message=''

/* Use ansi for bold, reverse, etc. when displaying prompts 
     use_ansi=1  : use ansi 
     use_ansi=0  : do not use ansi 
   Note:
      If you see a lot of [,$, and other such junk on screen, then you do
      NOT have ansi support installed. To install ansi support, 
      add the following line to config.sys  
          device=x:\os2\mdos\ansi.sys
      where x: is your boot drive               */
use_ansi=1


/* default "ttf-fonts root directory". If the requested font is not
   found in the current directory, it will be searched for in all directories under
   this default_ttfdir. Set default_ttfdir='' to suppress this */
default_ttfdir='d:\os2\mdos\winos2'


/* default output file. Leave blank to output to screen
   Note: this is NOT used when command line parameters are specified;
         in which case the default is output to stdout, which
         can be easily redirected (using >) to a file */
outfile='ttf_text.out'


/* Use this program to display results -- either fully qualified executable,
   or an executable that is in your PATH. Leave blank and this option
   will not be available */
disp_prog='LST '

/* ============= End of user changeable parameters =============== */


call init               /* initialize some stuff */


parse arg ttfont psize as_landscape  message 
wastt=ttfont

if ttfont='?' then  do          /* a request for help ? */
 call show_intro
 exit
end

getinf:
/* ask user to supply them, and/or check command line parameters. */
call get_params force

/* ---  THIS DOES THE WORK!!!!  ---- */

rc = rxttf_image(message,ttfont,psize, data)


/* Check for an error */
if rc<>0 then do
    say "Error in rxttf_image: "rc
    exit
end /* do */


/* Note: data.!rows and data.!cols are the dimensions of the image */

say data.!rows 'rows x' data.!cols 'cols'

/* Now, convert the "bitmap" to printable characters */

call convert_data

/* And, finally, display the big-text "image" */

if as_landscape<>1 then do              /* portrait orientation */
   do i = 0 to data.!rows - 1                      /* for each row of the image */
      aline=data.i
      if wastt='' & outfile<>'' then do
         call lineout outfile,aline
      end
      else do
         say aline
      end
   end
end
else do                         /* landscape */
   do icol=1 to data.!cols
      aline=''
      do irow=data.!rows-1 to 0 by -1
         aline=aline||substr(data.irow,icol,1)
      end 
      if wastt='' & outfile<>'' then do
         call lineout outfile,aline
      end
      else do
         say aline
      end
   end 
end                     /* as_landscape */

if wastt='' & outfile<>'' then do
  call lineout outfile
  say " Output appended to: " bold ||outfile||normal
end

if disp_prog<>'' & arg(1)='' then do
   address cmd disp_Prog' 'outfile
   call charout, "Enter 1 to try again: "
   pull aa
   force=1
   if aa=1 then signal getinf
end

exit


/**************************/
/* convert data to printable characters */
convert_data:

/* this is needed if use_filler_message=1 */
if filler_message='' | use_filler_message=2 then filler_message=message 
len_filler=length(filler_message)

do i = 0 to data.!rows - 1                      /* for each row of the image */
  iat=1

/* convert ascii 0 & 1 to back and fore ground characters */
  aline=translate(data.i, backchar||forechar, '0001'x)  

/* Display the big-text using characters from a message? */
  if use_filler_message=1 | use_filler_message=2 then do        
     achar=substr(filler_message,iat,1)                  
     do kk=1 to data.!cols                     /* substitute in cyclical fashion */
        if substr(aline,kk,1)=forechar then do
           aline=overlay(achar,aline,kk,1)
           iat=iat+1 ; if iat>len_filler then iat=1
           achar=substr(filler_message,iat,1)
        end
     end /* do */
  end /* do */
  data.i=aline                  /* save it */
end

say '====' use_filler_message
/* DISPLAY character using own character? */

if use_filler_message=3 then do

/* find first non blank column */
  iat=non_blank(0)
  ithc=0
  do until iat=0
     ito=all_blank(iat)
     do forever
       ithc=ithc+1
       athc=substr(message,ithc,1)
       if athc<>''  then leave
       if ithc>=length(message) then return 1
     end
     if ito=0 then ito=length(data.0)+1
     do lr=0 to data.!rows-1
       do nbb=iat to ito-1
         ac=substr(data.lr,nbb,1)
         if ac<>'' then data.lr=overlay(athc,data.lr,nbb,1)
       end /* do */
     end /* do */
     iat=non_blank(ito)
  end /* do */

end

return 1



/********************************/
/* find non blank col */

non_blank:procedure expose data.
parse arg iwas
if iwas>=length(data.0) then return 0    /* past end of line */

do ik=iwas+1 to length(data.0)
  do ir=0 to data.!rows-1
     ac=substr(data.ir,ik,1)
     if ac<>'' then return ik  /* found a non blank */
  end 
end 
return 0                /* no blank cols */


/********************************/
/* find blank col */

ALL_blank:procedure expose data.
parse arg iwas
if iwas>=length(data.0) then return 0    /* past end of line */

do ik=iwas+1 to length(data.0)
  do ir=0 to data.!rows-1
     ac=substr(data.ir,ik,1)
     if ac<>'' then ITERATE ik  /* found a blank */
  end 
  RETURN IK             /* IF HERE, ALL BLANK */
end 
return 0                /* no blank cols */



/***************/
show_intro:
   say "Create a text banner using a TTF font"
   say
   say "Usage: TTF_TEXT ttf_file  point_size landscape message"
   say ' Where:'
   say '   TTF_FILE = name of a TTF font file '
   say '  POINT_SIZE= Point size '
   say '   LANDSCAPE= Orientation: 0 for portrait, 1 for landscape'
   say '     MESSAGE= The message to write (it may contain multiple words)'
   say ' '
   say " Or, run TTF_TEXT without arguments to be prompted."
   say
   say "Hint: To create long messages, use > to redirect output to a file"
return 1


/*********************/
/* ask user for some input parameters */
get_params:
parse arg force

if force=1 then do
   message=''; psize='' ;  ttfont=''; as_landscape=''
end /* do */

if ttfont='' then do
  say cy_ye"   >>> Create a text banner using TTF fonts  <<< "normal
  say
end 

if message=''  then do
  call charout,bold'Enter a message string:'normal
  parse pull message
  if message='' then message='Hello!'
end


do forever
  if psize='' then do
    call charout,bold"Choose the point size: "normal
    pull psize
  end
  if psize='' then psize=12
  if datatype(psize)<>'NUM'  then do
     say reverse"   Please enter an integer point size "normal
     psize=''     
     iterate
  end /* do */
  leave
end


do forever
   if ttfont=''  then do
     call charout,bold'Select a TTF font (? to list .TTF files): 'normal  
     pull ttfont ; ttfont=strip(ttfont)
   end
   if left(ttfont,1)="?" then do
     call showttfs
     ttfont=''
     iterate
   end

   if ttfont='' then ttfont='bisque'
   if pos('.',ttfont)=0 then ttfont=ttfont'.ttf'
   foo=stream(ttfont,'c','query exists')
   if foo='' then do
      ttfont=lookfont(ttfont)
      if ttfont='' then do
          say "Sorry, could not find "ttfont
          ttfont=''
         iterate
      end
   end
   leave
end /* do */

do forever
    if as_landscape<>' ' then leave
    call charout,bold'Orientation:'normal' 0 (or ENTER) for portrait, 1 for Landscape: '
    pull foo
    if foo='' then foo=0
    foo=strip(foo)
    if wordpos(foo,'0 1')=0 then do
       as_landscape=''
       iterate
    end
    as_landscape=foo
    leave
end

return 1


/***************************************/
/* show ttf fonts in current and under default directory */
showttfs:
      lookdef=0
      parse var ttfont . thisdir
      if thisdir='' then lookdef=1

      if thisdir="" then    thisdir=directory()
      say 
      say  cy_ye' List of .TTF files in: ' normal bold thisdir normal
      do while queued()>0
         pull .
      end 
      '@DIR /b  '||strip(thisdir,'t','\')'\*.ttf  | rxqueue'
      foo=show_dir_queue('.TTF')
      say

if lookdef<>1 |  default_ttfdir='' then return 0
      thisdir=default_ttfdir
      say  cy_ye' List of .TTF files under: ' normal bold thisdir normal
      do while queued()>0
         pull .
      end 
      '@DIR /b /s '||strip(thisdir,'t','\')'\*.ttf  | rxqueue'
      foo=show_dir_queue('.TTF')
      say
      ttfont=''
return 1

/***********************************************/
/* look for font using sysfiletree */
/* Load up advanced REXX functions */
lookfont:procedure expose default_ttfdir
parse arg ttfont
foo=rxfuncquery('sysloadfuncs')
if foo=1 then do
  call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
  call SysLoadFuncs
end
if rxfuncquery('sysloadfuncs')=1 then return ''      /* give up */
if default_ttfdir='' then return ''

aa=strip(default_ttfdir,'t','\')'\'ttfont
foo=sysfiletree(aa,'goo','FSO')
if goo.0=0 then return ''
return goo.1




/***********************************************/
/* initialize some stuff */
init:

isis=rxfuncquery('rxttf_image')
if isis=1 then do
  call RxFuncAdd 'rxttf_image', 'RXTTF', 'rxttf_image'
  isis=rxfuncquery('rxttf_image')
  if isis<>0 then do
      say "Sorry, RXTTF.DLL is not available."
      exit
  end
end 

/* Enable these character if you want to use some ansi screen controls   */
if use_ansi=1 then do
   aesc='1B'x
   cy_ye=aesc||'[37;46;m'
   cyanon=cy_ye
   normal=aesc||'[0;m'
   bold=aesc||'[1;m'
   re_wh=aesc||'[31;47;m'
   reverse=aesc||'[7;m'
end
else do
   cy_ye=' '; cyanon=' ';normal=' '; bold=' '; re_wh=' ';reverse=' ' 
end
force=0
return 1

/*********/
/* show stuff in queue as a list */
show_dir_queue:procedure expose qlist.
parse arg lookfor
    ibs=0 ;mxlen=0
    if lookfor<>1 then
       nq=queued()
     else
        nq=qlist.0
    do ii=1 to nq
       if lookfor=1 then do
          aa=qlist.ii
          ii2=lastpos('\',aa) ; anam=substr(aa,ii2+1)
       end /* do */
       else do
          pull aa
          if pos(lookfor,aa)=0 then iterate
          parse var aa anam (lookfor) .
          if strip(anam)='.' | strip(anam)='..' then iterate
       end
       ibs=ibs+1
       anam=filespec('n',anam)
       blist.ibs=anam
       mxlen=max(length(anam),mxlen)
    end /* do */
arf=""
do il=1 to ibs
   anam=blist.il
   arf=arf||left(anam,mxlen+2)
   if length(arf)+mxlen+2>75  then do
        say arf
        arf=""
   end /* do */
end /* do */
if length(arf)>1 then say arf
say
return 1


