/**/
/*                                                                      */
/*                           USB Info Test                              */
/*                                                                      */
/*                           Team Arum Japan                            */
/*                                                                      */
/*                Maeda Haruyuki   2002.09.29                           */
/*                                 2002.10.03  Add szInfo init          */
/*                                 2003.10.16  Add New Function         */
/*                                 2004.01.14  Fixd Serial number       */
/*                                                                      */
/**/

/*###########################################################################*/
/*####                        INCLUDE STATEMENT                         ####*/
/*###########################################################################*/

#pragma pack( 1 )

	#define		INCL_DOS
	#define		INCL_DOSDEVIOCTL
	#include	<os2.h>

	#include	<stdio.h>
	#include	<string.h>

typedef struct _USB_DEVICE_INFO
{
   USHORT   cIndex;                 // (00) call index
   UCHAR    ctrlID;                 // (02) controller ID
   UCHAR    deviceAddress;          // (03) USB device address
   UCHAR    entryName[9];           // (04) driver's entry name
   USHORT   altIntfce;              // (13) alternate interface index
   USHORT   bcdUSB;                 // (15) USB Specification Release umber
   UCHAR    bDeviceClass;           // (17) Device class cord
   UCHAR    bDeviceSubClass;        // (18) Device sub class cord
   UCHAR    bDeviceProtocol;        // (19) Device protocol cord
   UCHAR    bMaxPacketSize0;        // (20) Endpoint 0 Max packet size
   USHORT   idVendor;               // (21) Vendor ID
   USHORT   idProduct;              // (23) Product ID
   USHORT   bcdDevice;              // (25) Device release number
   USHORT   rStringCount;           // (27) string count packed in buffer
   USHORT   strBuffLen;             // (29) string buffer length
   UCHAR    id[256];                // (31) string buffer
}  USB_DEVICE_INFO;

typedef struct _USB_CONFIG_INFO
{
   USHORT   wTotalLength;        // (00) total data length returned in request
   UCHAR    bNumInterfaces;      // (02) number of interfaces in this configuration
   UCHAR    bConfigurationValue; // (03) value to be used in Set configuration
   UCHAR    bmAttributes;        // (04) Configuration characteristics
   UCHAR    bMaxPower;           // (05) power consumption in 2 mA units
}  USB_CONFIG_INFO;

typedef struct _USB_INTF_INFO
{
   UCHAR    bInterfaceNumber;    // (00) 0 based index in interface array for this item
   UCHAR    bAlternateSetting;   // (01) value to select alternate interface
   UCHAR    bNumEndpoints;       // (02) no of endpoints used by current interface (excluding enpoint 0)
   UCHAR    bInterfaceClass;     // (03) Class code
   UCHAR    bInterfaceSubClass;  // (04) Subclass code
   UCHAR    bInterfaceProtocol;  // (05) Protocol code
}  USB_INTF_INFO;

typedef struct _USB_ENDPOINT
{
   UCHAR    bEndpointAddress; // (00) address of endpoint
   UCHAR    bmAttributes;     // (01) endpoint's attributes
   USHORT   wMaxPacketSize;   // (02) maximum packet size for this endpoint
   UCHAR    bInterval;        // (04) interval for polling endpoint for data
}  USB_ENDPOINT;

typedef struct _USB_ENDPOINT_INFO
{
   USB_ENDPOINT    ueWrite; // (00) interface Write edpoint
   USB_ENDPOINT    ueRead;  // (05) interface Read endpoint
}  USB_ENDPOINT_INFO;

typedef struct _USB_DEVICE_DESCRIPTOR
{
   UCHAR      bmRequestType;     // (00) Characteristics of request
   UCHAR      bRequest;          // (01) Specific Request
   USHORT     wValue;            // (02) Word-sized field (value depends on request)
   USHORT     wIndex;            // (04) typically Index or Offset
   USHORT     wLength;           // (06) Number of bytes to Transfer
                                 // (08)
}  USB_DEVICE_DESCRIPTOR;


#define  REQTYPE_XFERDIR_DEVTOHOST     0x80  // data transfer direction device to host
#define  REQTYPE_XFERDIR_HOSTTODEV     0x00  // data transfer direction host to device

#define  REQTYPE_TYPE_MASK             0x60  // type mask
#define  REQTYPE_TYPE_STANDARD         0x00  // Standard
#define  REQTYPE_TYPE_CLASS            0x20  // class
#define  REQTYPE_TYPE_VENDOR           0x40  // vendor
#define  REQTYPE_TYPE_RESERV           0x60  // reserved

#define  REQTYPE_RECIPIENT_DEVICE      0
#define  REQTYPE_RECIPIENT_INTERFACE   1
#define  REQTYPE_RECIPIENT_ENDPOINT    2
#define  REQTYPE_RECIPIENT_OTHER       3
#define  REQTYPE_RECIPIENT_MASK        0x0f


VOID	GetStringName( PSZ, PSZ, PSZ );
VOID	StringUniCode( PSZ, PSZ, ULONG );				//@ 2004-01-14 add


/******************************************************************** main() */
/*                                                                           */
/*yreturnz   0     : TRUE                                                  */
/*           0 other : API return value                                      */
/*                                                                           */
/*****************************************************************************/
int main (void)
{
	CHAR	szFile[9];
	CHAR	szInfo[1024];
	CHAR	szString[1024];
	CHAR	ucClass[256];
	UCHAR	Param;
	USHORT	usCount;
	USHORT	usLen;
	ULONG	ulAction;
	ULONG	ulData;
	ULONG	ulParam;
	ULONG	ulRc;

	HFILE	hfCom;
	USB_DEVICE_INFO		Data;
	USB_CONFIG_INFO		Conf;
	USB_INTF_INFO		Intf;
	USB_ENDPOINT_INFO	Endpoint;


/*****************/
/*  Device Open  */
/*****************/
	strcpy( szFile, "USBSCAN$" );

	ulRc = DosOpen( szFile, &hfCom, &ulAction, 0, FILE_NORMAL, FILE_OPEN,
						OPEN_ACCESS_READWRITE | OPEN_SHARE_DENYNONE, 0 );
	if( ulRc ){
		printf( " DosOpen \"%s\" error code = %ld\n", szFile, ulRc );
		return( ulRc );
	}

	printf( " DosOpen \"%s\" Useing \n\n", szFile );

/****************************************/
/*  Device Discriptor (Function = 0x71) */
/****************************************/
	memset( &Param, 0, sizeof( Param ) );
	memset( &Data,  0, sizeof( Data ) );

	Data.strBuffLen = sizeof( Data.id );
	ulParam = sizeof( Param );
	ulData  = sizeof( Data );

	ulRc = DosDevIOCtl( hfCom, 0x93, 0x71,
				(PVOID)&Param, sizeof(Param), &ulParam,
				(PVOID)&Data,  sizeof(Data), &ulData );
	if( ulRc ){
		printf( " DosDevIOCtl Error = %ld ( 0x%X )\n", ulRc, ulRc );
		DosClose( hfCom );
		return( ulRc );
	}

	printf( " cIndex      = 0x%02x,      ctrlID        = 0x%02x\n",  Data.cIndex,			Data.ctrlID );
	printf( " Address     = 0x%02x,      bcdUSB        = 0x%04x\n",  Data.deviceAddress,	Data.bcdUSB );
	printf( " idVendor    = 0x%04x,    idProduct     = 0x%04x\n",	 Data.idVendor,		Data.idProduct );
	printf( " Name        = %s,  altInterface  = 0x%02x\n",  Data.entryName,		Data.altIntfce );
	printf( " bcdDevice   = 0x%04x,    StringCount   = %x\n",		 Data.bcdDevice,		Data.rStringCount );
	printf( " Class       = 0x%02x,      SubClass      = 0x%02x\n",  Data.bDeviceClass,	Data.bDeviceSubClass );
	printf( " Protocol    = 0x%02x,      MaxPacketSize = 0x%02x\n",  Data.bDeviceProtocol, Data.bMaxPacketSize0 );
	printf( " String Len  = 0x%02x\n", Data.strBuffLen );

/****  Device Serial Number(UNICODE)  ****/
	usCount = 0;
	memcpy( &usLen, &Data.id[usCount], sizeof( USHORT ) );
	usCount += sizeof( USHORT );

	if( usLen ){
		memcpy( szInfo, &Data.id[usCount], usLen );		//@ 2004-01-14 fixed
		szInfo[usLen] = '\0';							//@ 2004-01-14 add
		StringUniCode( szInfo, szInfo, (ULONG)usLen );	//@ 2004-01-14 add
		printf( " Serial Len  = 0x%04x, Serial Num  = %s\n", usLen, szInfo );
//		usCount += usLen - sizeof( USHORT );			//@ 2004-01-14 fixed
	}
	else {
		printf( " Serial Number = NULL\n" );
	}

/****  Device Strings Infomation  ****/
	if( usLen ) usCount += usLen - sizeof( USHORT );
	memcpy( &usLen, &Data.id[usCount], sizeof( USHORT ) );
	usCount += sizeof( USHORT );
	szInfo[0] = 0;								// 2002-10-03 add. Thank, Sid
	strncpy( szInfo, &Data.id[usCount], usLen );
	szInfo[usLen] = '\0';							//@ 2004-01-14 add
	printf( " Device Len  = 0x%04x, Device Info = %s\n", usLen, szInfo );

/****  Device Manufacturer Infomation(UNICODE)  ****/
	if( usLen ) usCount += usLen - sizeof( USHORT );
	memcpy( &usLen, &Data.id[usCount], sizeof( USHORT ) );
	usCount += sizeof( USHORT );
	szInfo[0] = 0;		  				            //@ 2002-10-03 add
	memcpy( szInfo, &Data.id[usCount], usLen );		//@ 2004-01-14 fixed
	szInfo[usLen] = '\0';							//@ 2004-01-14 add
	StringUniCode( szInfo, szInfo, (ULONG)usLen );	//@ 2004-01-14 add
	printf( " Manufact Len  = 0x%04x, Manufact Info = %s\n", usLen, szInfo );

/****  Device Product Infomation(UNICODE)  ****/
	if( usLen ) usCount += usLen - sizeof( USHORT );
	memcpy( &usLen, &Data.id[usCount], sizeof( USHORT ) );
	usCount += sizeof( USHORT );
	szInfo[0] = 0;      	        				//@ 2002-10-03 add
	memcpy( szInfo, &Data.id[usCount], usLen );		//@ 2004-01-14 fixed
	szInfo[usLen] = '\0';							//@ 2004-01-14 add
	StringUniCode( szInfo, szInfo, (ULONG)usLen );	//@ 2004-01-14 add
	printf( " Product Len  = 0x%04x, Product Info = %s\n\n", usLen, szInfo );

/***********************************************/
/*  Configuration Discriptor (Function = 0x72) */
/***********************************************/
	memset( &Param, 0, sizeof( Param ) );
	memset( &Conf,  0, sizeof( Conf ) );
	ulParam = sizeof( Param );
	ulData  = sizeof( Conf );

	ulRc = DosDevIOCtl( hfCom, 0x93, 0x72,
						(PVOID)&Param, sizeof(Param), &ulParam,
						(PVOID)&Conf,  sizeof(Conf),  &ulData );
	if( ulRc ){
		printf( " DosDevIOCtl Error = %ld", ulRc );
		DosClose( hfCom );
		return( ulRc );
	}

	printf( " TotalLength = 0x%04x,      NumInterfaces = 0x%02x\n ConfigValue = 0x%02x,       ",
		Conf.wTotalLength, Conf.bNumInterfaces, Conf.bConfigurationValue );
	printf( " Attribute     = 0x%02x\n MaxPower    = 0x%02x\n\n",
		Conf.bmAttributes, Conf.bMaxPower );

/*******************************************/
/*  Interface Discriptor (Function = 0x73) */
/*******************************************/
	memset( &Param, 0, sizeof( Param ) );
	memset( &Intf,  0, sizeof( Intf ) );
	ulParam = sizeof( Param );
	ulData  = sizeof( Intf );

	ulRc = DosDevIOCtl( hfCom, 0x93, 0x73,
						(PVOID)&Param, sizeof(Param), &ulParam,
						(PVOID)&Intf,  sizeof(Intf),  &ulData );
	if( ulRc ){
		printf( " DosDevIOCtl Error = %ld", ulRc );
		DosClose( hfCom );
		return( ulRc );
	}

	printf( " IntrfaceNumber    = 0x%02x,  AlternateSetting  = 0x%02x\n NumEndpoints      = 0x%02x, ",
		Intf.bInterfaceNumber, Intf.bAlternateSetting, Intf.bNumEndpoints );
	printf( " InterfaceClass    = 0x%02x\n InterfaceSubClass = 0x%02x,  InterfaceProtocol = 0x%02x\n\n",
		Intf.bInterfaceClass, Intf.bInterfaceSubClass, Intf.bInterfaceProtocol );


/*****************************************/
/*  Device Infomation (Function = 0x74)  */
/*****************************************/
	memset( &Param,   0, sizeof( Param ) );
	memset( &szInfo,  0, sizeof( szInfo ) );
	ulParam = sizeof( Param );
	ulData  = sizeof( szInfo );

	ulRc = DosDevIOCtl( hfCom, 0x93, 0x74,
							(PVOID)&Param, sizeof(Param), &ulParam,
							(PVOID)&szInfo, sizeof(szInfo),  &ulData );
	if( ulRc ){
		printf( " DosDevIOCtl Error = %ld (0x%X)\n\n", ulRc, ulRc );
		DosClose( hfCom );
		return( ulRc );
	}

	printf( " Length = %d\n Info = %s\n", szInfo[1], &szInfo[2] );

	GetStringName( &szInfo[2], "MFG:", szString );
	printf( " Manufacturer = %s\n", szString );

	GetStringName( &szInfo[2], "MDL:", szString );
	printf( " Model = %s\n\n", szString );


/******************************************/
/*  Endpoint Discriptor (Function = 0x75) */
/******************************************/
	memset( &Param, 0, sizeof( Param ) );
	memset( &Endpoint,  0, sizeof( Endpoint ) );
	ulParam = sizeof( Param );
	ulData  = sizeof( Endpoint );

	ulRc = DosDevIOCtl( hfCom, 0x93, 0x75,
						(PVOID)&Param, sizeof(Param), &ulParam,
						(PVOID)&Endpoint,  sizeof(Endpoint),  &ulData );
	if( ulRc ){
		printf( " DosDevIOCtl Error = %ld", ulRc );
		DosClose( hfCom );
		return( ulRc );
	}

	printf( " WriteAddress      = 0x%02x,    WriteAttributes  = 0x%02x\n",
		Endpoint.ueWrite.bEndpointAddress, Endpoint.ueWrite.bmAttributes );
	printf( " WiteMaxPacketSize = 0x%04x,  WriteInterval    = 0x%02x\n",
		Endpoint.ueWrite.wMaxPacketSize, Endpoint.ueWrite.bInterval );

	printf( " ReadAddress       = 0x%02x,    ReadAttributes   = 0x%02x\n",
		Endpoint.ueRead.bEndpointAddress,  Endpoint.ueRead.bmAttributes );
	printf( " ReadMaxPacketSize = 0x%04x,  ReadInterval     = 0x%02x\n\n",
		Endpoint.ueRead.wMaxPacketSize, Endpoint.ueRead.bInterval );


/**********************************************/
/*  Get Device Request( USBSCAN.SYS Ver0.4 )  */
/*   (Function = 0x77)                        */
/*  Note : Sample source code                 */
/**********************************************/
/*
	USB_DEVICE_DESCRIPTOR	Descriptor;
	UCHAR					Request[???];

	memset( &Descriptor, 0, sizeof( Descriptor ) );
	memset( &Request,  0, sizeof( Request ) );
	ulParam = sizeof( Descriptor );
	ulData  = sizeof( Request );
	Descriptor.bmRequestType =	REQTYPE_XFERDIR_DEVTOHOST |
								REQTYPE_TYPE_VENDOR       |
								REQTYPE_RECIPIENT_DEVICE;
	Descriptor.bRequest = 6;
	Descriptor.wValue	= MAKEUSHORT(0x00, 0x01);
	Descriptor.wIndex	= 0;
	Descriptor.wLength	= ulData;

	ulRc = DosDevIOCtl( hfCom, 0x93, 0x77,
						(PVOID)&Descriptor, sizeof(Descriptor), &ulParam,
						(PVOID)&Request,  sizeof(Request),  &ulData );

	if( ulRc ){
		printf( " DosDevIOCtl Error = %ld", ulRc );
		DosClose( hfCom );
		return( ulRc );
	}

*/

/**********************************************/
/*  Set Device Request( USBSCAN.SYS Ver0.4 )  */
/*   (Function = 0x78)                        */
/*  Note : Sample source code                 */
/**********************************************/
/*
	USB_DEVICE_DESCRIPTOR	Descriptor;
	UCHAR					Request[???];

	memset( &Descriptor, 0, sizeof( Descriptor ) );
	memset( &Request,  0, sizeof( Request ) );
	ulParam = sizeof( Descriptor );
	ulData  = sizeof( Request );
	Descriptor.bmRequestType =	REQTYPE_XFERDIR_HOSTTODEV |
								REQTYPE_TYPE_VENDOR       |
								REQTYPE_RECIPIENT_DEVICE;
	Descriptor.bRequest = 6;
	Descriptor.wValue	= MAKEUSHORT(0x00, 0x01);
	Descriptor.wIndex	= 0;
	Descriptor.wLength	= ulData;

	ulRc = DosDevIOCtl( hfCom, 0x93, 0x78,
						(PVOID)&Descriptor, sizeof(Descriptor), &ulParam,
						(PVOID)&Request,  sizeof(Request),  &ulData );

	if( ulRc ){
		printf( " DosDevIOCtl Error = %ld", ulRc );
		DosClose( hfCom );
		return( ulRc );
	}

*/


/******************/
/*  Device Close  */
/******************/
	DosClose( hfCom );

	return( 0 );
}



VOID	GetStringName( PSZ szData, PSZ szString, PSZ szName )
{
	ULONG	ulCount;
	ULONG	ulLoop;

	szName[0]  = 0;
	ulCount    = 0L;
	ulLoop     = 0L;

	while( szData[ulLoop] ){
		if( szData[ulLoop] == szString[ulCount] ){
			ulCount++;

			if( strlen( szString ) == ulCount ){
				ulCount = 0L;
				ulLoop++;

				while( szData[ulLoop] ){
					if( szData[ulLoop] == ';' ) break;

					szName[ulCount] = szData[ulLoop];
					ulCount++;
					ulLoop++;
				}

				szName[ulCount] = 0;
				return;
			}
		}
		else	ulCount = 0L;

		ulLoop++;
	}

	return;
}


VOID	StringUniCode( PSZ szData, PSZ szString, ULONG ulLen )
{
	ULONG	ulNum;
	ULONG	ulLoop;

	ulLoop = 0L;
	ulNum  = 0L;

	while( ulLoop < ulLen ){
		szData[ulNum] = szString[ulLoop];
		ulLoop += 2L;
		ulNum++;
	}

	szData[ulNum] = '\0';
	return;
}


