/***************************************************************************/
/* ptpro.h
 *
 * Copyright (C) 2001-2005 Mariusz Woloszyn <emsi@ipartners.pl>
 *
 *  This file is part of ptpro.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 */
/***************************************************************************/
/*
 *  PTPro for OS/2 is based on ptpcam, part of the libptp2 package.
 *  Because it has been extensively rewritten and restructured, its
 *  name has been changed to avoid confusion with the original.
 *  All changes and new code are
 *      Copyright (C) 2006 Richard L Walsh <rich@e-vertise.com>
 */
/***************************************************************************/

#ifndef __PTPRO_H__
#define __PTPRO_H__

#pragma pack(1)

/***************************************************************************/

// USB interface class
#ifndef USB_CLASS_PTP
#define USB_CLASS_PTP               6
#endif

// USB control message data phase direction
#ifndef USB_DP_HTD
#define USB_DP_HTD                  (0x00 << 7)    /* host to device */
#endif

#ifndef USB_DP_DTH
#define USB_DP_DTH                  (0x01 << 7)    /* device to host */
#endif

// PTP class specific requests
#ifndef USB_REQ_DEVICE_RESET
#define USB_REQ_DEVICE_RESET        0x66
#endif

#ifndef USB_REQ_GET_DEVICE_STATUS
#define USB_REQ_GET_DEVICE_STATUS   0x67
#endif

// USB Feature selector HALT
#ifndef USB_FEATURE_HALT
#define USB_FEATURE_HALT            0x00
#endif

#define USB_TIMEOUT                 4000

// commandline option flags
#define OPT_FORCE                   1
#define OPT_REPLACE                 2
#define OPT_THUMBNAIL               4

// printing value type
#define PTPCAM_PRINT_HEX            0
#define PTPCAM_PRINT_DEC            1

// property value printing macros
#define PRINT_PROPVAL_DEC(value) \
    print_propval(dpd.DataType, value, PTPCAM_PRINT_DEC)

#define PRINT_PROPVAL_HEX(value) \
    print_propval(dpd.DataType, value, PTPCAM_PRINT_HEX)

/***************************************************************************/

/* requested actions */
#define ACT_DEVICE_RESET        0x01
#define ACT_LIST_DEVICES        0x02
#define ACT_LIST_PROPERTIES     0x03
#define ACT_LIST_OPERATIONS     0x04
#define ACT_GETSET_PROPERTY     0x05
#define ACT_SHOW_INFO           0x06
#define ACT_LIST_FILES          0x07
#define ACT_GET_FILE            0x08
#define ACT_DELETE_FILE         0x09
#define ACT_HANDLE_INFO         0x0A
#define ACT_STORAGE_INFO        0x0B


/***************************************************************************/

//  structures

struct usb_device;

typedef struct _PTP_USB {
    struct usb_device *dev;
    usb_dev_handle *handle;
    int inep;
    int outep;
    int intep;
} PTP_USB;


typedef struct _OPTS {
    int         busn;
    int         devn;
    uint32_t    flags;
    uint32_t    first;
    uint32_t    last;
    uint32_t    property;
    char *      value;
} OPTS;


typedef struct _FNSTRUCT {
    uint    namePos;
    uint    nbrPos;
    uint    extPos;
    uint    seqNbr;
    char    format[260];
} FNSTRUCT;


/***************************************************************************/

//  functions

int     parse_options( OPTS * pOpts, int argc, char ** argv);
int     range_from_arg( char* arg, uint32_t* first, uint32_t* last);
void    usage();
void    help();
char *  underline( const char *str);

void    list_devices( PTP_USB *ptp_usb, PTPParams *params, OPTS *pOpts);
void    show_info( PTPParams *params);
void    list_operations( PTPParams *params);
void    show_storage_info( PTPParams *params);
void    list_properties( PTPParams *params);
void    getset_property( PTPParams *params, OPTS *pOpts);
short   print_propval( uint16_t datatype, void* value, short hex);
uint16_t set_property( PTPParams* params, uint16_t property,
                       char* value, uint16_t datatype);

void    list_files( PTPParams *params);
void    show_handle_info( PTPParams *params, OPTS *pOpts);
int     validate_range( PTPParams *params, OPTS *pOpts,
                        uint32_t **ppFirst, uint32_t **ppLast);
void    delete_files( PTPParams *params, OPTS *pOpts);
void    get_files( PTPParams *params, OPTS *pOpts);
int     parse_filename( char *filename, FNSTRUCT *fns);
void    make_filename( char* pOut, char* pIn, FNSTRUCT *fns);

void    reset_device( PTP_USB *ptp_usb, PTPParams *params);
int     usb_ptp_get_device_status( PTP_USB* ptp_usb, uint16_t* devstatus);
int     usb_ptp_device_reset( PTP_USB* ptp_usb);
void    clear_stall( PTP_USB* ptp_usb);
int     usb_get_endpoint_status( PTP_USB* ptp_usb, int ep, uint16_t* status);
int     usb_clear_stall_feature( PTP_USB* ptp_usb, int ep);

int     init_usb( PTP_USB *ptp_usb, PTPParams *params);
int     open_camera( PTP_USB *ptp_usb, PTPParams *params);
struct usb_device* find_device( int busn, int devn, short force);
void    find_endpoints( PTP_USB *ptp_usb);
int     init_ptp_usb( PTPParams* params, PTP_USB* ptp_usb);
void    close_camera( PTP_USB *ptp_usb, PTPParams *params);
void    close_usb( PTP_USB* ptp_usb);

static short ptp_read_func( unsigned char *bytes, unsigned int size, void *data);
static short ptp_write_func( unsigned char *bytes, unsigned int size, void *data);
static short ptp_check_int( unsigned char *bytes, unsigned int size, void *data);
void    ptp_debug_func( void *data, const char *format, va_list args);
void    ptp_error_func( void *data, const char *format, va_list args);
void    ptpro_error( const char* format, ...);
void    ptpro_debug( const char* format, ...);

// in ptpos2.c
int     os2_get_file( PTPParams *params, PTPObjectInfo *oi, uint32_t handle,
                      char* filename, int replace, int thumb);

/***************************************************************************/

#pragma pack()

#endif /* __PTPRO_H__ */

/***************************************************************************/

