/***************************************************************************/
/* ptp-strings.c
 *
 * Copyright (C) 2001-2004 Mariusz Woloszyn <emsi@ipartners.pl>
 *
 *  This file is part of libptp2.
 *
 *  libptp2 is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  libptp2 is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with libptp2; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */
/***************************************************************************/
/*
 *  This version of libptp2 for OS/2 has been partially rewritten
 *  and extensively restructured.  All changes and new code are
 *      Copyright (C) 2006 Richard L Walsh <rich@e-vertise.com>
 */
/***************************************************************************/
/*
    ptp-strings.c - routines for translating codes to strings.
    Formerly part of ptp.c, the existing code & data was excerpted,
    extended, and restructured to make it readable and more useful.
*/
/***************************************************************************/

#include "ptp.h"

#pragma pack(1)

// artifact from unsupported I18N scheme for user messages
#define N_(String) (String)

/***************************************************************************/
// Errors
/***************************************************************************/
#if 0

// This is all useless:  none of these error codes are ever retrieved
// from the camera.  The only ones actually used are PTP_ERROR_* and
// they're changed to PTP_ERROR_IO before a function returns.

CODE2NAME ptp_errors[] = {
    {PTP_RC_Undefined,                  N_("PTP: Undefined Error")},
    {PTP_RC_OK,                         N_("PTP: OK!")},
    {PTP_RC_GeneralError,               N_("PTP: General Error")},
    {PTP_RC_SessionNotOpen,             N_("PTP: Session Not Open")},
    {PTP_RC_InvalidTransactionID,       N_("PTP: Invalid Transaction ID")},
    {PTP_RC_OperationNotSupported,      N_("PTP: Operation Not Supported")},
    {PTP_RC_ParameterNotSupported,      N_("PTP: Parameter Not Supported")},
    {PTP_RC_IncompleteTransfer,         N_("PTP: Incomplete Transfer")},
    {PTP_RC_InvalidStorageId,           N_("PTP: Invalid Storage ID")},
    {PTP_RC_InvalidObjectHandle,        N_("PTP: Invalid Object Handle")},
    {PTP_RC_DevicePropNotSupported,     N_("PTP: Device Prop Not Supported")},
    {PTP_RC_InvalidObjectFormatCode,    N_("PTP: Invalid Object Format Code")},
    {PTP_RC_StoreFull,                  N_("PTP: Store Full")},
    {PTP_RC_ObjectWriteProtected,       N_("PTP: Object Write Protected")},
    {PTP_RC_StoreReadOnly,              N_("PTP: Store Read Only")},
    {PTP_RC_AccessDenied,               N_("PTP: Access Denied")},
    {PTP_RC_NoThumbnailPresent,         N_("PTP: No Thumbnail Present")},
    {PTP_RC_SelfTestFailed,             N_("PTP: Self Test Failed")},
    {PTP_RC_PartialDeletion,            N_("PTP: Partial Deletion")},
    {PTP_RC_StoreNotAvailable,          N_("PTP: Store Not Available")},
    {PTP_RC_SpecificationByFormatUnsupported,
                        N_("PTP: Specification By Format Unsupported")},
    {PTP_RC_NoValidObjectInfo,          N_("PTP: No Valid Object Info")},
    {PTP_RC_InvalidCodeFormat,          N_("PTP: Invalid Code Format")},
    {PTP_RC_UnknownVendorCode,          N_("PTP: Unknown Vendor Code")},
    {PTP_RC_CaptureAlreadyTerminated,   N_("PTP: Capture Already Terminated")},
    {PTP_RC_DeviceBusy,                 N_("PTP: Device Bus")},
    {PTP_RC_InvalidParentObject,        N_("PTP: Invalid Parent Object")},
    {PTP_RC_InvalidDevicePropFormat,    N_("PTP: Invalid Device Prop Format")},
    {PTP_RC_InvalidDevicePropValue,     N_("PTP: Invalid Device Prop Value")},
    {PTP_RC_InvalidParameter,           N_("PTP: Invalid Parameter")},
    {PTP_RC_SessionAlreadyOpened,       N_("PTP: Session Already Opened")},
    {PTP_RC_TransactionCanceled,        N_("PTP: Transaction Canceled")},
    {PTP_RC_SpecificationOfDestinationUnsupported,
                        N_("PTP: Specification Of Destination Unsupported")},
    {PTP_ERROR_IO,                      N_("PTP: I/O error")},
    {PTP_ERROR_BADPARAM,                N_("PTP: Error: bad parameter")},
    {PTP_ERROR_DATA_EXPECTED,           N_("PTP: Protocol error, data expected")},
    {PTP_ERROR_RESP_EXPECTED,           N_("PTP: Protocol error, response expected")},
    {0, NULL}
};

CODE2NAME ptp_errors_EK[] = {
    {PTP_RC_EK_FilenameRequired,        N_("PTP EK: Filename Required")},
    {PTP_RC_EK_FilenameConflicts,       N_("PTP EK: Filename Conflicts")},
    {PTP_RC_EK_FilenameInvalid,         N_("PTP EK: Filename Invalid")},
    {0, NULL}
};

#endif

/***************************************************************************/
// operations
/***************************************************************************/

CODE2NAME ptp_operations[] = {
    {PTP_OC_Undefined,                  N_("UndefinedOperation")},
    {PTP_OC_GetDeviceInfo,              N_("GetDeviceInfo")},
    {PTP_OC_OpenSession,                N_("OpenSession")},
    {PTP_OC_CloseSession,               N_("CloseSession")},
    {PTP_OC_GetStorageIDs,              N_("GetStorageIDs")},
    {PTP_OC_GetStorageInfo,             N_("GetStorageInfo")},
    {PTP_OC_GetNumObjects,              N_("GetNumObjects")},
    {PTP_OC_GetObjectHandles,           N_("GetObjectHandles")},
    {PTP_OC_GetObjectInfo,              N_("GetObjectInfo")},
    {PTP_OC_GetObject,                  N_("GetObject")},
    {PTP_OC_GetThumb,                   N_("GetThumb")},
    {PTP_OC_DeleteObject,               N_("DeleteObject")},
    {PTP_OC_SendObjectInfo,             N_("SendObjectInfo")},
    {PTP_OC_SendObject,                 N_("SendObject")},
    {PTP_OC_InitiateCapture,            N_("InitiateCapture")},
    {PTP_OC_FormatStore,                N_("FormatStore")},
    {PTP_OC_ResetDevice,                N_("ResetDevice")},
    {PTP_OC_SelfTest,                   N_("SelfTest")},
    {PTP_OC_SetObjectProtection,        N_("SetObjectProtection")},
    {PTP_OC_PowerDown,                  N_("PowerDown")},
    {PTP_OC_GetDevicePropDesc,          N_("GetDevicePropDesc")},
    {PTP_OC_GetDevicePropValue,         N_("GetDevicePropValue")},
    {PTP_OC_SetDevicePropValue,         N_("SetDevicePropValue")},
    {PTP_OC_ResetDevicePropValue,       N_("ResetDevicePropValue")},
    {PTP_OC_TerminateOpenCapture,       N_("TerminateOpenCapture")},
    {PTP_OC_MoveObject,                 N_("MoveObject")},
    {PTP_OC_CopyObject,                 N_("CopyObject")},
    {PTP_OC_GetPartialObject,           N_("GetPartialObject")},
    {PTP_OC_InitiateOpenCapture,        N_("InitiateOpenCapture")},
    {0, NULL}
};

CODE2NAME ptp_operations_EK[] = {
    {PTP_OC_EK_SendFileObjectInfo,      N_("EK SendFileObjectInfo")},
    {PTP_OC_EK_SendFileObject,          N_("EK SendFileObject")},
    {0, NULL}
};

CODE2NAME ptp_operations_CANON[] = {
    {PTP_OC_CANON_GetObjectSize,        N_("CANON GetObjectSize")},
    {PTP_OC_CANON_StartShootingMode,    N_("CANON StartShootingMode")},
    {PTP_OC_CANON_EndShootingMode,      N_("CANON EndShootingMode")},
    {PTP_OC_CANON_ViewfinderOn,         N_("CANON ViewfinderOn")},
    {PTP_OC_CANON_ViewfinderOff,        N_("CANON ViewfinderOff")},
    {PTP_OC_CANON_ReflectChanges,       N_("CANON ReflectChanges")},
    {PTP_OC_CANON_CheckEvent,           N_("CANON CheckEvent")},
    {PTP_OC_CANON_FocusLock,            N_("CANON FocusLock")},
    {PTP_OC_CANON_FocusUnlock,          N_("CANON FocusUnlock")},
    {PTP_OC_CANON_InitiateCaptureInMemory,
                        N_("CANON InitiateCaptureInMemory")},
    {PTP_OC_CANON_GetPartialObject,     N_("CANON GetPartialObject")},
    {PTP_OC_CANON_GetViewfinderImage,   N_("CANON GetViewfinderImage")},
    {PTP_OC_CANON_GetChanges,           N_("CANON GetChanges")},
    {PTP_OC_CANON_GetFolderEntries,     N_("CANON GetFolderEntries")},
    {0, NULL}
};

/***************************************************************************/
// properties
/***************************************************************************/

CODE2NAME ptp_device_properties[] = {
    {PTP_DPC_Undefined,                 N_("PTP Undefined Property")},
    {PTP_DPC_BatteryLevel,              N_("Battery Level")},
    {PTP_DPC_FunctionalMode,            N_("Functional Mode")},
    {PTP_DPC_ImageSize,                 N_("Image Size")},
    {PTP_DPC_CompressionSetting,        N_("Compression Setting")},
    {PTP_DPC_WhiteBalance,              N_("White Balance")},
    {PTP_DPC_RGBGain,                   N_("RGB Gain")},
    {PTP_DPC_FNumber,                   N_("F-Number")},
    {PTP_DPC_FocalLength,               N_("Focal Length")},
    {PTP_DPC_FocusDistance,             N_("Focus Distance")},
    {PTP_DPC_FocusMode,                 N_("Focus Mode")},
    {PTP_DPC_ExposureMeteringMode,      N_("Exposure Metering Mode")},
    {PTP_DPC_FlashMode,                 N_("Flash Mode")},
    {PTP_DPC_ExposureTime,              N_("Exposure Time")},
    {PTP_DPC_ExposureProgramMode,       N_("Exposure Program Mode")},
    {PTP_DPC_ExposureIndex,             N_("Exposure Index (film speed ISO)")},
    {PTP_DPC_ExposureBiasCompensation,  N_("Exposure Bias Compensation")},
    {PTP_DPC_DateTime,                  N_("Date Time")},
    {PTP_DPC_CaptureDelay,              N_("Pre-Capture Delay")},
    {PTP_DPC_StillCaptureMode,          N_("Still Capture Mode")},
    {PTP_DPC_Contrast,                  N_("Contrast")},
    {PTP_DPC_Sharpness,                 N_("Sharpness")},
    {PTP_DPC_DigitalZoom,               N_("Digital Zoom")},
    {PTP_DPC_EffectMode,                N_("Effect Mode")},
    {PTP_DPC_BurstNumber,               N_("Burst Number")},
    {PTP_DPC_BurstInterval,             N_("Burst Interval")},
    {PTP_DPC_TimelapseNumber,           N_("Timelapse Number")},
    {PTP_DPC_TimelapseInterval,         N_("Timelapse Interval")},
    {PTP_DPC_FocusMeteringMode,         N_("Focus Metering Mode")},
    {PTP_DPC_UploadURL,                 N_("Upload URL")},
    {PTP_DPC_Artist,                    N_("Artist")},
    {PTP_DPC_CopyrightInfo,             N_("Copyright Info")},
    {0, NULL}
};

CODE2NAME ptp_device_properties_EK[] = {
    {PTP_DPC_EK_ColorTemperature,       N_("EK Color Temperature")},
    {PTP_DPC_EK_DateTimeStampFormat,    N_("EK Date Time Stamp Format")},
    {PTP_DPC_EK_BeepMode,               N_("EK Beep Mode")},
    {PTP_DPC_EK_VideoOut,               N_("EK Video Out")},
    {PTP_DPC_EK_PowerSaving,            N_("EK Power Saving")},
    {PTP_DPC_EK_UI_Language,            N_("EK UI Language")},
    {0, NULL}
};

CODE2NAME ptp_device_properties_CANON[] = {
    {PTP_DPC_CANON_BeepMode,            N_("CANON Beep Mode")},
    {PTP_DPC_CANON_ViewfinderMode,      N_("CANON Viewfinder Mode")},
    {PTP_DPC_CANON_ImageQuality,        N_("CANON Image Quality")},
    {PTP_DPC_CANON_ImageSize,           N_("CANON Image Size")},
    {PTP_DPC_CANON_FlashMode,           N_("CANON Flash Mode")},
    {PTP_DPC_CANON_TvAvSetting,         N_("CANON TvAv Setting")},
    {PTP_DPC_CANON_MeteringMode,        N_("CANON Metering Mode")},
    {PTP_DPC_CANON_MacroMode,           N_("CANON Macro Mode")},
    {PTP_DPC_CANON_FocusingPoint,       N_("CANON Focusing Point")},
    {PTP_DPC_CANON_WhiteBalance,        N_("CANON White Balance")},
    {PTP_DPC_CANON_ISOSpeed,            N_("CANON ISO Speed")},
    {PTP_DPC_CANON_Aperture,            N_("CANON Aperture")},
    {PTP_DPC_CANON_ShutterSpeed,        N_("CANON Shutter Speed")},
    {PTP_DPC_CANON_ExpCompensation,     N_("CANON Exp Compensation")},
    {PTP_DPC_CANON_Zoom,                N_("CANON Zoom")},
    {PTP_DPC_CANON_SizeQualityMode,     N_("CANON Size Quality Mode")},
    {PTP_DPC_CANON_FlashMemory,         N_("CANON Flash Card Capacity")},
    {PTP_DPC_CANON_CameraModel,         N_("CANON Camera Model")},
    {PTP_DPC_CANON_CameraOwner,         N_("CANON Camera Owner")},
    {PTP_DPC_CANON_UnixTime,            N_("CANON Unix Time")},
    {PTP_DPC_CANON_RealImageWidth,      N_("CANON Real Image Width")},
    {PTP_DPC_CANON_PhotoEffect,         N_("CANON Photo Effect")},
    {PTP_DPC_CANON_AssistLight,         N_("CANON Assist Light")},
    {0, NULL}
};

/* Nikon Codes added by Corey Manders and Mehreen Chaudary */
CODE2NAME ptp_device_properties_NIKON[] = {
    {PTP_DPC_NIKON_ShootingBank,        N_("NIKON Shooting Bank")},
    {PTP_DPC_NIKON_ShootingBankNameA,   N_("NIKON Shooting Bank Name A")},
    {PTP_DPC_NIKON_ShootingBankNameB,   N_("NIKON Shooting Bank Name B")},
    {PTP_DPC_NIKON_ShootingBankNameC,   N_("NIKON Shooting Bank Name C")},
    {PTP_DPC_NIKON_ShootingBankNameD,   N_("NIKON Shooting Bank Name D")},
    {PTP_DPC_NIKON_RawCompression,      N_("NIKON Raw Compression")},
    {PTP_DPC_NIKON_WhiteBalanceAutoBias,
                                N_("NIKON White Balance Auto Bias")},
    {PTP_DPC_NIKON_WhiteBalanceTungstenBias,
                                N_("NIKON White Balance Tungsten Bias")},
    {PTP_DPC_NIKON_WhiteBalanceFlourescentBias,
                                N_("NIKON White Balance Flourescent Bias")},
    {PTP_DPC_NIKON_WhiteBalanceDaylightBias,
                                N_("NIKON White Balance Daylight Bias")},
    {PTP_DPC_NIKON_WhiteBalanceFlashBias,
                                N_("NIKON White Balance Flash Bias")},
    {PTP_DPC_NIKON_WhiteBalanceCloudyBias,
                                N_("NIKON White Balance Cloudy Bias")},
    {PTP_DPC_NIKON_WhiteBalanceShadeBias,
                                N_("NIKON White Balance Shade Bias")},
    {PTP_DPC_NIKON_WhiteBalanceColourTemperature,
                                N_("NIKON White Balance Colour Temperature")},
    {PTP_DPC_NIKON_ImageSharpening,     N_("NIKON Image Sharpening")},
    {PTP_DPC_NIKON_ToneCompensation,    N_("NIKON Tone Compensation")},
    {PTP_DPC_NIKON_ColourMode,          N_("NIKON Colour Mode")},
    {PTP_DPC_NIKON_HueAdjustment,       N_("NIKON Hue Adjustment")},
    {PTP_DPC_NIKON_NonCPULensDataFocalLength,
                                N_("NIKON Non CPU Lens Data Focal Length")},
    {PTP_DPC_NIKON_NonCPULensDataMaximumAperture,
                                N_("NIKON Non CPU Lens Data Maximum Aperture")},
    {PTP_DPC_NIKON_CSMMenuBankSelect,   N_("NIKON CSM Menu Bank Select")},
    {PTP_DPC_NIKON_MenuBankNameA,       N_("NIKON Menu Bank Name A")},
    {PTP_DPC_NIKON_MenuBankNameB,       N_("NIKON Menu Bank Name B")},
    {PTP_DPC_NIKON_MenuBankNameC,       N_("NIKON Menu Bank Name C")},
    {PTP_DPC_NIKON_MenuBankNameD,       N_("NIKON Menu Bank Name D")},
    {PTP_DPC_NIKON_A1AFCModePriority,   N_("NIKON (A1) AFC Mode Priority")},
    {PTP_DPC_NIKON_A2AFSModePriority,   N_("NIKON (A2) AFS Mode Priority")},
    {PTP_DPC_NIKON_A3GroupDynamicAF,    N_("NIKON (A3) Group Dynamic AF")},
    {PTP_DPC_NIKON_A4AFActivation,      N_("NIKON (A4) AF Activation")},    
    {PTP_DPC_NIKON_A5FocusAreaIllumManualFocus,
                                N_("NIKON (A5) Focus Area Illum Manual Focus")},
    {PTP_DPC_NIKON_FocusAreaIllumContinuous,
                                N_("NIKON Focus Area Illum Continuous")},
    {PTP_DPC_NIKON_FocusAreaIllumWhenSelected,
                                N_("NIKON Focus Area Illum When Selected")},
    {PTP_DPC_NIKON_A6FocusArea,         N_("NIKON (A6) Focus Area")},
    {PTP_DPC_NIKON_A7VerticalAFON,      N_("NIKON (A7) Vertical AF ON")},
    {PTP_DPC_NIKON_B1ISOAuto,           N_("NIKON (B1) ISO Auto")},
    {PTP_DPC_NIKON_B2ISOStep,           N_("NIKON (B2)    ISO Step")},
    {PTP_DPC_NIKON_B3EVStep,            N_("NIKON (B3) EV Step")},
    {PTP_DPC_NIKON_B4ExposureCompEv,    N_("NIKON (B4) Exposure Comp Ev")},
    {PTP_DPC_NIKON_B5ExposureComp,      N_("NIKON (B5) Exposure Comp")},
    {PTP_DPC_NIKON_B6CenterWeightArea,  N_("NIKON (B6) Center Weight Area")},
    {PTP_DPC_NIKON_C1AELock,            N_("NIKON (C1) AE Lock")},
    {PTP_DPC_NIKON_C2AELAFL,            N_("NIKON (C2) AE_L/AF_L")},
    {PTP_DPC_NIKON_C3AutoMeterOff,      N_("NIKON (C3) Auto Meter Off")},
    {PTP_DPC_NIKON_C4SelfTimer,         N_("NIKON (C4) Self Timer")},    
    {PTP_DPC_NIKON_C5MonitorOff,        N_("NIKON (C5) Monitor Off")},
    {PTP_DPC_NIKON_D1ShootingSpeed,     N_("NIKON (D1) Shooting Speed")},
    {PTP_DPC_NIKON_D2MaximumShots,      N_("NIKON (D2) Maximum Shots")},
    {PTP_DPC_NIKON_D3ExpDelayMode,      N_("NIKON (D3) ExpDelayMode")},    
    {PTP_DPC_NIKON_D4LongExposureNoiseReduction,
                                N_("NIKON (D4) Long Exposure Noise Reduction")},
    {PTP_DPC_NIKON_D5FileNumberSequence,
                                N_("NIKON (D5) File Number Sequence")},
    {PTP_DPC_NIKON_D6ControlPanelFinderRearControl,
                                N_("NIKON (D6) Control Panel Finder Rear Control")},
    {PTP_DPC_NIKON_ControlPanelFinderViewfinder,
                                N_("NIKON Control Panel Finder Viewfinder")},
    {PTP_DPC_NIKON_D7Illumination,      N_("NIKON (D7) Illumination")},
    {PTP_DPC_NIKON_E1FlashSyncSpeed,    N_("NIKON (E1) Flash Sync Speed")},
    {PTP_DPC_NIKON_E2FlashShutterSpeed, N_("NIKON (E2) Flash Shutter Speed")},
    {PTP_DPC_NIKON_E3AAFlashMode,       N_("NIKON (E3) AA Flash Mode")},
    {PTP_DPC_NIKON_E4ModelingFlash,     N_("NIKON (E4) Modeling Flash")},
    {PTP_DPC_NIKON_E5AutoBracketSet,    N_("NIKON (E5) Auto Bracket Set")},
    {PTP_DPC_NIKON_E6ManualModeBracketing,
                                N_("NIKON (E6) Manual Mode Bracketing")},
    {PTP_DPC_NIKON_E7AutoBracketOrder,  N_("NIKON (E7) Auto Bracket Order")},
    {PTP_DPC_NIKON_E8AutoBracketSelection,
                                N_("NIKON (E8) Auto Bracket Selection")},
    {PTP_DPC_NIKON_F1CenterButtonShootingMode,
                                N_("NIKON (F1) Center Button Shooting Mode")},
    {PTP_DPC_NIKON_CenterButtonPlaybackMode,
                                N_("NIKON Center Button Playback Mode")},
    {PTP_DPC_NIKON_F2Multiselector,     N_("NIKON (F2) Multiselector")},
    {PTP_DPC_NIKON_F3PhotoInfoPlayback, N_("NIKON (F3) PhotoInfoPlayback")},    
    {PTP_DPC_NIKON_F4AssignFuncButton,  N_("NIKON (F4) Assign Function Button")},
    {PTP_DPC_NIKON_F5CustomizeCommDials,N_("NIKON (F5) Customize Comm Dials")},
    {PTP_DPC_NIKON_ChangeMainSub,       N_("NIKON Change Main Sub")},
    {PTP_DPC_NIKON_ApertureSetting,     N_("NIKON Aperture Setting")},
    {PTP_DPC_NIKON_MenusAndPlayback,    N_("NIKON Menus and Playback")},
    {PTP_DPC_NIKON_F6ButtonsAndDials,   N_("NIKON (F6) Buttons and Dials")},
    {PTP_DPC_NIKON_F7NoCFCard,          N_("NIKON (F7) No CF Card")},
    {PTP_DPC_NIKON_AutoImageRotation,   N_("NIKON Auto Image Rotation")},
    {PTP_DPC_NIKON_ExposureBracketingOnOff,
                                N_("NIKON Exposure Bracketing On Off")},
    {PTP_DPC_NIKON_ExposureBracketingIntervalDist,
                                N_("NIKON Exposure Bracketing Interval Distance")},
    {PTP_DPC_NIKON_ExposureBracketingNumBracketPlace,
                                N_("NIKON Exposure Bracketing Number Bracket Place")},
    {PTP_DPC_NIKON_AutofocusLCDTopMode2,
                                N_("NIKON Autofocus LCD Top Mode 2")},
    {PTP_DPC_NIKON_AutofocusLCDTopMode3AndMode4,
                                N_("NIKON Autofocus LCD Top Mode 3 and Mode 4")},
    {PTP_DPC_NIKON_LightMeter,          N_("NIKON Light Meter")},
    {PTP_DPC_NIKON_ExposureApertureLock,N_("NIKON Exposure Aperture Lock")},
    {PTP_DPC_NIKON_MaximumShots,        N_("NIKON Maximum Shots")},
    {PTP_DPC_NIKON_Beep,                N_("NIKON AF Beep Mode")},
    {PTP_DPC_NIKON_AFC,                 N_("NIKON ??? AF Related")},
    {PTP_DPC_NIKON_AFLampOff,           N_("NIKON AF Lamp")},
    {PTP_DPC_NIKON_PADVPMode,           N_("NIKON Auto ISO P/A/DVP Setting")},
    {PTP_DPC_NIKON_ReviewOff,           N_("NIKON Image Review")},
    {PTP_DPC_NIKON_GridDisplay,         N_("NIKON Viewfinder Grid Display")},
    {PTP_DPC_NIKON_AFAreaIllumination,  N_("NIKON AF Area Illumination")},
    {PTP_DPC_NIKON_FlashMode,           N_("NIKON Flash Mode")},
    {PTP_DPC_NIKON_FlashPower,          N_("NIKON Flash Power")},
    {PTP_DPC_NIKON_FlashSignOff,        N_("NIKON Flash Sign")},
    {PTP_DPC_NIKON_FlashExposureCompensation,
                                N_("NIKON Flash Exposure Compensation")},
    {PTP_DPC_NIKON_RemoteTimeout,       N_("NIKON Remote Timeout")},
    {PTP_DPC_NIKON_ImageCommentString,  N_("NIKON Image Comment String")},
    {PTP_DPC_NIKON_FlashOpen,           N_("NIKON Flash Open")},
    {PTP_DPC_NIKON_FlashCharged,        N_("NIKON Flash Charged")},
    {PTP_DPC_NIKON_LensID,              N_("NIKON Lens ID")},
    {PTP_DPC_NIKON_FocalLengthMin,      N_("NIKON Min. Focal Length")},
    {PTP_DPC_NIKON_FocalLengthMax,      N_("NIKON Max. Focal Length")},
    {PTP_DPC_NIKON_MaxApAtMinFocalLength,
                                N_("NIKON Max. Aperture at Min. Focal Length")},
    {PTP_DPC_NIKON_MaxApAtMaxFocalLength,
                                N_("NIKON Max. Aperture at Max. Focal Length")},
    {PTP_DPC_NIKON_LowLight,            N_("NIKON Low Light")},
    {PTP_DPC_NIKON_ExtendedCSMMenu,     N_("NIKON Extended CSM Menu")},
    {PTP_DPC_NIKON_OptimiseImage,       N_("NIKON Optimise Image")},
    {0, NULL}
};

/***************************************************************************/
// miscellanea
/***************************************************************************/

// PTP Association Types
CODE2NAME ptp_association[] = {
    {PTP_AT_Undefined,                  N_("none")},
    {PTP_AT_GenericFolder,              N_("Generic Folder")},
    {PTP_AT_Album,                      N_("Album")},
    {PTP_AT_TimeSequence,               N_("Time Sequence")},
    {PTP_AT_HorizontalPanoramic,        N_("Horizontal Panoramic")},
    {PTP_AT_VerticalPanoramic,          N_("Vertical Panoramic")},
    {PTP_AT_2DPanoramic,                N_("2D Panoramic")},
    {PTP_AT_AncillaryData,              N_("Ancillary Data")},
    {0, NULL}
};
                                            
// PTP Protection Status
CODE2NAME ptp_protection[] = {
    {PTP_PS_NoProtection,               N_("No Protection")},
    {PTP_PS_ReadOnly,                   N_("Read Only")},
    {0, NULL}
};

// PTP Storage Types
CODE2NAME ptp_storagetype[] = {
    {PTP_ST_Undefined,                  N_("Undefined")},
    {PTP_ST_FixedROM,                   N_("Fixed ROM")},
    {PTP_ST_RemovableROM,               N_("Removable ROM")},
    {PTP_ST_FixedRAM,                   N_("Fixed RAM")},
    {PTP_ST_RemovableRAM,               N_("Removable RAM")},
    {0, NULL}
};

// PTP StorageInfo AccessCapability Values
CODE2NAME ptp_storageaccess[] = {
    {PTP_AC_ReadWrite,                  N_("Read Write")},
    {PTP_AC_ReadOnly,                   N_("Read Only")},
    {PTP_AC_ReadOnly_with_Object_Deletion, N_("Read Only with Object Deletion")},
    {0, NULL}
};

// PTP FilesystemType Values
CODE2NAME ptp_filesystem[] = {
    {PTP_FST_Undefined,                 N_("Undefined")},
    {PTP_FST_GenericFlat,               N_("Generic Flat")},
    {PTP_FST_GenericHierarchical,       N_("Generic Hierarchical")},
    {PTP_FST_DCF,                       N_("DCF")},
    {0, NULL}
};

// PTP Object Format Codes
CODE2NAME ptp_objectformat[] = {
    {PTP_OFC_EXIF_JPEG,                 N_("EXIF JPEG")},
    {PTP_OFC_TIFF_EP,                   N_("TIFF EP")},
    {PTP_OFC_FlashPix,                  N_("FlashPix")},
    {PTP_OFC_BMP,                       N_("BMP")},
    {PTP_OFC_CIFF,                      N_("CIFF")},
    {PTP_OFC_Undefined_0x3806,          N_("Undefined")},
    {PTP_OFC_GIF,                       N_("GIF")},
    {PTP_OFC_JFIF,                      N_("JFIF")},
    {PTP_OFC_PCD,                       N_("PCD")},
    {PTP_OFC_PICT,                      N_("PICT")},
    {PTP_OFC_PNG,                       N_("PNG")},
    {PTP_OFC_Undefined_0x380C,          N_("Undefined")},
    {PTP_OFC_TIFF,                      N_("TIFF")},
    {PTP_OFC_TIFF_IT,                   N_("TIFF IT")},
    {PTP_OFC_JP2,                       N_("JP2")},
    {PTP_OFC_JPX,                       N_("JPX")},
    {PTP_OFC_Undefined,                 N_("Undefined")},
    {PTP_OFC_Association,               N_("Association")},
    {PTP_OFC_Script,                    N_("Script")},
    {PTP_OFC_Executable,                N_("Executable")},
    {PTP_OFC_Text,                      N_("Text")},
    {PTP_OFC_HTML,                      N_("HTML")},
    {PTP_OFC_DPOF,                      N_("DPOF")},
    {PTP_OFC_AIFF,                      N_("AIFF")},
    {PTP_OFC_WAV,                       N_("WAV")},
    {PTP_OFC_MP3,                       N_("MP3")},
    {PTP_OFC_AVI,                       N_("AVI")},
    {PTP_OFC_MPEG,                      N_("MPEG")},
    {PTP_OFC_ASF,                       N_("ASF")},
    {PTP_OFC_QT,                        N_("QT")},  // guessing
    {PTP_OFC_EK_M3U,                    N_("Kodak M3U")},
    {0, NULL}
};

/***************************************************************************/
// get miscellaneous names

const char* ptp_get_codename( uint16_t code, int type)
{
    CODE2NAME *c2n = 0;

    switch (type) {
        case PTP_OBJECT_FORMAT:
            c2n = ptp_objectformat;
            break;
        case PTP_ASSOCIATION:
            c2n = ptp_association;
            break;
        case PTP_PROTECTION:
            c2n = ptp_protection;
            break;
        case PTP_FILESYSTEM:
            c2n = ptp_filesystem;
            break;
        case PTP_STORAGE:
            c2n = ptp_storagetype;
            break;
        case PTP_STORAGE_ACCESS:
            c2n = ptp_storageaccess;
            break;
    }

    if (c2n) {
        for (; c2n->name; c2n++)
            if (c2n->code == code)
                return (c2n->name);
    }

    return "[Unknown]";
}

/***************************************************************************/

#if 0

// report PTP errors
// useless (see above)

void ptp_perror( PTPParams* params, uint16_t error)
{
    int i;

    for (i = 0; ptp_errors[i].name != NULL; i++)
        if (ptp_errors[i].code == error) {
            ptp_error( params, ptp_errors[i].name);
            return;
        }

    switch (params->deviceinfo.VendorExtensionID) {
        case PTP_VENDOR_EASTMAN_KODAK:
            for (i = 0; ptp_errors_EK[i].name != NULL; i++)
                if (ptp_errors_EK[i].code == error)
                    ptp_error( params, ptp_errors_EK[i].name);
            break;
    }

    return;
}

#endif

/***************************************************************************/
// return ptp operation name

const char* ptp_get_operation_name( PTPParams* params, uint16_t oc)
{
    CODE2NAME *c2n;

    switch (params->deviceinfo.VendorExtensionID) {
        case PTP_VENDOR_EASTMAN_KODAK:
            for (c2n = ptp_operations_EK; c2n->name; c2n++)
                if (c2n->code == oc)
                    return (c2n->name);
            break;

        case PTP_VENDOR_CANON:
            for (c2n = ptp_operations_CANON; c2n->name; c2n++)
                if (c2n->code == oc)
                    return (c2n->name);
            break;
    }

    for (c2n = ptp_operations; c2n->name; c2n++)
        if (c2n->code == oc)
            return (c2n->name);

    return NULL;
}

/***************************************************************************/
// return ptp property name

const char* ptp_get_property_name( PTPParams* params, uint16_t dpc)
{
    CODE2NAME *c2n;

    for (c2n = ptp_device_properties; c2n->name; c2n++)
        if (c2n->code == dpc)
            return (c2n->name);

    switch (params->deviceinfo.VendorExtensionID) {
        case PTP_VENDOR_EASTMAN_KODAK:
            for (c2n = ptp_device_properties_EK; c2n->name; c2n++)
                if (c2n->code == dpc)
                    return (c2n->name);
            break;
        case PTP_VENDOR_CANON:
            for (c2n = ptp_device_properties_CANON; c2n->name; c2n++)
                if (c2n->code == dpc)
                    return (c2n->name);
            break;
        case PTP_VENDOR_NIKON:
            for (c2n = ptp_device_properties_NIKON; c2n->name; c2n++)
                if (c2n->code == dpc)
                    return (c2n->name);
            break;
    
        }

    return NULL;
}
/***************************************************************************/

#pragma pack()

/***************************************************************************/

