#include "TPalleteBar.h"

#include <QtGui/QMouseEvent>

/*!
 \brief конструктор для тулбара с палитрой

 \param parent
*/
TPalleteBar::TPalleteBar(QWidget *parent) :
    QToolBar(parent)
{
    paletteSet = new CPaletteWidget();
    connect(paletteSet, SIGNAL(sendPaletteColor(QColor)), this, SLOT(setFirstColor(QColor)));
    connect(paletteSet, SIGNAL(sendPaletteBrush(QColor)), this, SLOT(setSecondColor(QColor)));
    setMovable(true);

    setAllowedAreas(Qt::NoToolBarArea);
    addWidget(paletteSet);
}

/*!
 \brief обработчик нажатия клавиши мыши

 \param event обрабатываемый эвент
*/
void TPalleteBar::mousePressEvent(QMouseEvent *event)
{
    int x = event->pos().x() - 12;
    int y = event->pos().y() - (height() - paletteSet->height())/2;
    if(event->button() == Qt::LeftButton)
         paletteSet->setColor(QPoint(x, y), true);
    if(event->button() == Qt::RightButton)
         paletteSet->setColor(QPoint(x, y), false);
}

/*!
 \brief установка цвета пера

 \param color устнавливаемый цвет
*/
void TPalleteBar::setFirstColor(QColor color)
{
    firstColor = color;
    emit sendFirstColor(color);
}

/*!
 \brief установка цвета заливки

 \param color устанавливаемый цвет
*/
void TPalleteBar::setSecondColor(QColor color)
{
    secondColor = color;
    emit sendSecondColor(color);
}

