#include "FNewFile.h"

#include <QtGui/QPushButton>
#include <QtGui/QLabel>
#include <QtGui/QLineEdit>
#include <QtGui/QLayout>
#include <QRegExp>
#include <QRegExpValidator>

/*!
 \brief конструктор формы для задания размеров нового изображения

 \param parent указатель на родителся
*/
FNewFile::FNewFile(QWidget *parent) : QDialog(parent)
{
    setWindowTitle(tr("Set size"));
    buttonOK = new QPushButton("OK");
    buttonCancel = new QPushButton("Cancel");
    QLabel *labelX = new QLabel("Width:");
    QLabel *labelY = new QLabel("Height:");
    lineX = new QLineEdit();
    lineX->setFixedWidth(80);
    lineY = new QLineEdit();
    lineY->setFixedWidth(80);
    QGridLayout *gLayout = new QGridLayout();
    gLayout->addWidget(labelX, 0, 0);
    gLayout->addWidget(lineX, 0, 1);
    gLayout->addWidget(labelY, 1, 0);
    gLayout->addWidget(lineY, 1, 1);
    QHBoxLayout *hLayout = new QHBoxLayout();
    hLayout->addWidget(buttonOK);
    hLayout->addWidget(buttonCancel);
    gLayout->addLayout(hLayout, 2, 0, 1, 2);
    regExp = new QRegExp("[0-9]{1,4}");
    lineX->setValidator(new QRegExpValidator(*regExp, this));
    lineY->setValidator(new QRegExpValidator(*regExp, this));
    lineX->setText("540");
    lineY->setText("400");
    setLayout(gLayout);
    layout()->setSizeConstraint(QLayout::SetFixedSize);
    show();
    loadSignals();
}

/*!
 \brief деструктор формы

*/
FNewFile::~FNewFile()
{
    delete regExp;
}

/*!
 \brief инициализация сигналов

*/
void FNewFile::loadSignals()
{
    connect(buttonOK, SIGNAL(clicked()), this, SLOT(clickOK()));
    connect(buttonCancel, SIGNAL(clicked()), this, SLOT(close()));
    connect(lineX, SIGNAL(textChanged(QString)), this, SLOT(onLineXTextChanged()));
    connect(lineY, SIGNAL(textChanged(QString)), this, SLOT(onLineYTextChanged()));
}

/*!
 \brief обработчик нажатия кнопки buttonOK

*/
void FNewFile::clickOK()
{
    emit newImage(lineX->text().toInt(), lineY->text().toInt());
    close();
}

/*!
 \brief обработчик регулярного выражения для lineX

*/
void FNewFile::onLineXTextChanged()
{
    buttonOK->setEnabled(lineX->hasAcceptableInput() && lineY->hasAcceptableInput());
}

/*!
 \brief обработчик регулярного выражения для lineY

*/
void FNewFile::onLineYTextChanged()
{
    buttonOK->setEnabled(lineX->hasAcceptableInput() && lineY->hasAcceptableInput());
}
