#include "CPaletteWidget.h"

#include <QtGui/QPixmap>
#include <QtGui/QImage>
#include <QtGui/QMouseEvent>
#include <QtGui/QColor>

/*!
 \brief коструктор виджета палитра

*/
CPaletteWidget::CPaletteWidget()
{
    palette = new QPixmap(":/program/icons/program/palette.png");
    resize(palette->size());
    setAlignment(Qt::AlignHCenter);
    setPixmap(*palette);
}

/*!
 \brief деструктор виджета палитра

*/
CPaletteWidget::~CPaletteWidget()
{
    delete palette;
}

/*!
 \brief обработка выбора цвета

 \param point точнка
 \param left если нажата левая кнопка
*/
void CPaletteWidget::setColor(QPoint point, bool left)
{
    if(this->pixmap()->toImage().valid(point))
    {
        if(left)
        {
            QColor getColor;
            getColor.setRgb(this->pixmap()->toImage().pixel(point));
            emit sendPaletteColor(getColor);
        }
        else
        {
            QColor getColor;
            getColor.setRgb(this->pixmap()->toImage().pixel(point));
            emit sendPaletteBrush(getColor);
        }
    }
}
