#ifndef CIMAGECV_H
#define CIMAGECV_H

#include <QtGui/QWidget>
#include <QString>
#include <QtGui/QColor>
#include <QPoint>
#include <QtGui/QImage>
#include <QVector>
#include <QRect>

#include "CImageModel.h"
#include "ETools.h"

QT_BEGIN_NAMESPACE
class QPaintEvent;
class QMouseEvent;
class QCursor;
QT_END_NAMESPACE

/*!
 \brief виджет реализующий отображение и контроль над
        действиями изменяющими его
        (viewer and controller)

*/
class CImageCV : public QWidget
{
    Q_OBJECT
public:
    CImageCV(int width_ = 520, int height_ = 400);
    ~CImageCV();

    bool setLoadImage(const QString&);
    void setSaveImage(const QString&);
    QString setFilePath(QString);
    QString getFilePath();
    void setBlackWhite();
    void setNegative();
    void setRotate();
    void setResizeImage(int, int);
    void setResizeArea(int, int);
    void setPenColor(const QColor&);
    void setBrushColor(const QColor&);
    void setPenTrickness(const int&);
    void setActiveTool(const ETools&);
    void setPreviousAction();
    void setNextAction();
    bool getModifiedFlag();
    int zoomFactor;
    void setZoom(int);
    void setModifiedFlag(bool);
    void setURButtons();
    void printImage();
    int getStored();
    void setStored(int);
    bool cut(QImage&);
    bool copy(QImage&);
    void paste(QImage);
    void setImage(QImage);

private:
    void backInTime();
    void drawLine(bool);
    QColor drawPipet();
    void drawRectangle(bool);
    void drawEllipse(bool);
    void drawFill(bool);
    void drawFillRecurs(int, int, QColor, QColor, QImage&);
    void drawSpray(bool);
    void drawLoupe();
    void rememberChanges();
    void drawSelect();
    void dragSelectedArea(int, int);
    void clickToInsert();

    QRect selectRect;
    QColor brushColor, penColor, tempColor;
    CImageModel *imageModel;
    ETools activeTool;
    QPoint startPoint, endPoint, displacePoint;
    bool drawFlag, loupeFlag, modifiedFlag,
         rightIsDrawing, leftIsDrawing,
         undoFlag, redoFlag,
         isDraging, isSelecting;
    QImage bufImage, selectImage;
    int penWidth, actions, stored;
    QVector<QImage> actionsHistory;
    QCursor *defaultCursor;

protected:
    void paintEvent(QPaintEvent*);
    void mousePressEvent(QMouseEvent*);
    void mouseMoveEvent(QMouseEvent*);
    void mouseReleaseEvent(QMouseEvent*);

signals:
    void sendPenColor(QColor);
    void sendBrushColor(QColor);
    void sendScrolBarsPos(int, int);
    void sendWait(bool);
    void sendURButton(bool, bool);
    void noActiveTool();

public slots:

};

#endif // CIMAGECV_H
