/*****************************************************************************
*
*  string.cpp - string Utility functions
*
*  (C) Marcel Mueller, Fulda, Germany
*
****************************************************************************/


#include <stdio.h>
#include <algorithm>

#include "string.hpp"


/*****************************************************************************
*
*  overload global toupper with string extension
*
*****************************************************************************/
/*static inline void mytouppercore(char& c)
{  c = toupper(c); // toupper won't work because it's a macro
}

std::string toupper(std::string s)
{  std::for_each(s.begin(), s.end(), &mytouppercore);
   return s;
}*/

/*****************************************************************************
*
*  string trim function
*
*****************************************************************************/
std::string trim(std::string s)
{  std::string::size_type p = s.find_last_not_of(" \t");
   if (p == std::string::npos)
      return std::string(); // string contains only spaces
   s.erase(p+1);
   s.erase(0, s.find_first_not_of(" \t")); // can't return npos
   return s;
}

/*****************************************************************************
*
*  string abbrevation test
*
*****************************************************************************/
bool starts_with(const std::string& s, const std::string& w)
{  return s.size() >= w.size()
    && memcmp(s.data(), w.data(), w.length() * sizeof(char)) == 0;
}

/*****************************************************************************
*
*  sprintf to a string object, buffer overflow safe
*
*****************************************************************************/
#if defined(_MSC_VER)
std::string vstringf(const char* fmt, va_list ap)
{  size_t len = _vscprintf(fmt, ap);
   char* cp = new char[len +1];
   vsprintf(cp, fmt, ap);
   std::string ret(cp, len);
   delete[] cp;
   return ret;
}

#elif defined(__GNUC__)
std::string vstringf(const char* fmt, va_list va)
{  // BSD and compatible environments only:
   size_t len = vsnprintf(NULL, 0, fmt, va);
   char* cp = new char[len+1]; // political correct (do not write the internal string data structures directly)
   vsnprintf(cp, len+1, fmt, va);
   std::string s(cp, len);
   delete[] cp;
   return s;
}
#else
#error unsupported platform
#endif

std::string stringf(const char* fmt, ...)
{  va_list ap;
   va_start(ap, fmt);
   std::string ret = vstringf(fmt, ap);
   va_end(ap);
   return ret;
}

