
# File: MetadataToolkit/Build/UNIX/shared.mak

clean :
	rm -f *.o *.a *.so* *.sl* *log core

TOP = ../..

XMP_HDR_DIR         = $(TOP)/Headers
XMP_SRC_DIR_DOM     = $(TOP)/Source/DOM
XMP_SRC_DIR_PARSER  = $(TOP)/Source/Parser
XMP_SRC_DIR_TOOLKIT = $(TOP)/Source/Toolkit

INC_FLAGS =                 \
   -I$(XMP_HDR_DIR)         \
   -I$(XMP_SRC_DIR_DOM)     \
   -I$(XMP_SRC_DIR_PARSER)  \
   -I$(XMP_SRC_DIR_TOOLKIT)

XMP_FLAGS =                 \
   -DUNIX_ENV=1             \
   -DXAP_BUILT_IN=1         \
   -DXAP_FORCE_NORMAL_ALLOC=1 \
   -DXAP_LIB=1

CC_FLAGS =                  \
   $(INC_FLAGS)             \
   $(XMP_FLAGS)             \
   $(XMP_DEBUG_FLAGS)       \
   $(CC_DEBUG_FLAGS)        \
   $(CC_PLATFORM_FLAGS)     \
   -Wno-multichar           \
   -ansi                    \
   -Wall

CC_DEPEND_FLAGS =           \
   $(INC_FLAGS)             \
   $(XMP_FLAGS)             \
   -ansi

XMP_OBJ_FILES_DOM =         \
	DOMDoc.o            \
	XPDOM.o             \
	XPElementFactory.o  \
	XPHashtable.o       \
	XPNode.o            \
	XPPtrList.o         \
	XPString.o          \
	XPXMLParser.o


XMP_OBJ_FILES_PARSER =      \
	dllmain.o           \
	hashtable.o         \
	xmlparse.o          \
	xmlrole.o           \
	xmltok.o

XMP_OBJ_FILES_TOOLKIT =     \
	DefaultAllocator.o  \
	DOMGlue.o           \
	gen_convert_text.o  \
	MetaXAP.o           \
	NormTree.o          \
	NormTreeSerialize.o \
	Paths.o             \
	RDFToNormTrees.o    \
	UtilityXAP.o        \
	XAPStatics.o        \
	XAPTkAlloc.o        \
	XAPTkData.o         \
	XAPTkFuncs.o

XMP_OBJ_FILES_SPECIAL =     \
	ConvertUTF.o

OBJECT_FILES = \
	$(XMP_OBJ_FILES_DOM) \
	$(XMP_OBJ_FILES_PARSER) \
	$(XMP_OBJ_FILES_TOOLKIT) \
	$(XMP_OBJ_FILES_SPECIAL)

#
# Special rule for ConvertUTF.c because it has a .c suffix and
# all the other files in the same directory have .cpp as suffix.
#
ConvertUTF.o :
	$(CC) $(CC_FLAGS) -c $(XMP_SRC_DIR_TOOLKIT)/ConvertUTF.c

$(XMP_OBJ_FILES_DOM) :
	$(CC) $(CC_FLAGS) -c $(XMP_SRC_DIR_DOM)/$(@:.o=.cpp)

$(XMP_OBJ_FILES_PARSER) :
	$(CC) $(CC_FLAGS) -c $(XMP_SRC_DIR_PARSER)/$(@:.o=.c)

$(XMP_OBJ_FILES_TOOLKIT) :
	$(CC) $(CC_FLAGS) -c $(XMP_SRC_DIR_TOOLKIT)/$(@:.o=.cpp)

$(STATIC_LIB) : $(OBJECT_FILES)
	@ echo ""
	@ echo "========== Creating $@ (static library) =========="
	@ echo ""
	$(AR) $(AR_FLAGS) $@ $(OBJECT_FILES)
	$(RANLIB) $@

$(DYNAMIC_LIB) : $(OBJECT_FILES)
	@ echo ""
	@ echo "========== Creating $@ (shared library) =========="
	@ echo ""
	$(LD) $(LD_FLAGS) -o $@ $(OBJECT_FILES)

depend :
	echo ""                                                       > $(BUILD_DIR)/depends.mak
	echo "# Do not edit this file. It is a derived file."        >> $(BUILD_DIR)/depends.mak
	echo "# To regenerate this file, run 'make depend'."         >> $(BUILD_DIR)/depends.mak
	echo ""                                                      >> $(BUILD_DIR)/depends.mak
	$(CC_DEPEND) $(CC_DEPEND_FLAGS) $(XMP_SRC_DIR_DOM)/*.cpp     >> $(BUILD_DIR)/depends.mak
	$(CC_DEPEND) $(CC_DEPEND_FLAGS) $(XMP_SRC_DIR_PARSER)/*.c    >> $(BUILD_DIR)/depends.mak
	$(CC_DEPEND) $(CC_DEPEND_FLAGS) $(XMP_SRC_DIR_TOOLKIT)/*.cpp >> $(BUILD_DIR)/depends.mak
	$(CC_DEPEND) $(CC_DEPEND_FLAGS) $(XMP_SRC_DIR_TOOLKIT)/*.c   >> $(BUILD_DIR)/depends.mak

