/**************************************************************
 *                                                            *
 *                   MainActor Rexx Script                    *
 *                                                            *
 *  Sorts the pictures of a picture list by their size        *
 *  Can be easily modified to sort by any other attribute     *
 *                                                            *
 *  Last modified: 09/18/97, Written by: Markus Moenig        *
 *                                                            *
 **************************************************************/

  IF GetGlobalInfo("LOADEDPROJECTS")= "0" THEN DO     /* Check if there are */
   BEGIN                                              /* any projects loaded */
    say "No project loaded! Trying to load project..."/* No: try to load one */
    rc=LoadProject("")                                /* If succeeded, rc = 0 */
    IF rc <> "0" THEN DO
      say "No project loaded! Exiting ..."            /* Failed, exiting ... */
      exit
    END 
   END

  IF GetProjectInfo("TYPE") <> "Picture List" THEN DO /* Only works for pictures */
    say "This script needs a picture list! Exiting..."
    exit
   END

  /* I use a simple sort routine here, however you can easily write your */
  /* own routine to do the sorting of the pictures. Note that we disable the */
  /* frame container prior to sorting, otherwise the swaping of pictures */
  /* would get very slow (due to the necessary GUI updates) */

  ShrinkFactor=13
  frames=GetProjectInfo("FRAMES")
  gap=frames

  DisableFrameContainer()    /* Disable the frame container for faster updates */
  DO WHILE (gap > 1) | (finished=1)
   BEGIN

    i=0
    finished=1
    gap=(gap * 10) % ShrinkFactor
    IF gap < 1 THEN gap=1

    DO WHILE i < (frames - gap)
     BEGIN
      index=i+1               /* index + gapindex now contain the picture numbers */
      gapindex=i+gap+1        /* which shall be compared in this pass */

      ssize=GetFrameInfo(index, "SIZE")        /* Fetch the size of the two pictures */
      dsize=GetFrameInfo(gapindex, "SIZE")

      IF ssize > dsize THEN DO                 /* Swap them if necessary */
        say "Swaping" index "with" gapindex
        SwapPictures(index, gapindex)
        finished=0
      END

      i=i+1
     END  
   END
  EnableFrameContainer()

  say "Ok, the pictures are now sorted by their size!"