/**************************************************************
 *                                                            *
 *                   MainActor Rexx Script                    *
 *                                                            *
 *  Converts all projects inside a directory to AVI. Shows    *   
 *  how to use LoadProjectPattern for automatic loading and   *
 *  converting of whole directories.                          *
 *                                                            *
 *  Last modified: 09/19/97, Written by: Markus Moenig        *
 *                                                            *
 **************************************************************/

  filepattern="h:\gfx\anims\Quick\*.*"   /* Substitute any other directory here */

  DO WHILE LoadProjectPattern(filepattern) =0  /* This loop runs over all files */
   BEGIN
    name=GetProjectInfo("NAME")     /* Name of the project */
    newname=LEFT(name,LENGTH(name)-4,0)  /* Cut off .??? from name */  
    filename="c:\"newname           /* filename, write new files to c:\ */
    format="AVI"                    /* Format */
    codec="Intel Indeo"             /* Use Ultimotion */
    frames="AllFrames"              /* Save all frames of the anim */
    width=0                         /* Use original width */
    height=0                        /* Use original height */

    say "Converting" GetProjectInfo("NAME") "to" filename "as" format "..."
    Save( filename, format, codec, frames, width, height ) /* Save it ... */
  END