/**************************************************************
 *                                                            *
 *                   MainActor Rexx Script                    *
 *                                                            *
 *  De/Accelerates a range of pictures from one timecode to   *
 *  another timecode. The range of pictures and the two time- *
 *  codes are requested from the users.                       *
 *  If the end timecode is smaller than the start timecode    *
 *  the script will perform acceleration, otherwise the       *
 *  pictures will be deaccelerated.                           *
 *  The timecodes will be spread in a linear fashion.         *
 *                                                            *
 *  Example: First picture=10, last picture=20                *
 *  first timecode=1000ms(1 fps), last timecode=100ms(10 fps) *
 *                                                            *
 *       Timecode of picture 10 = 1000 ms                     *  
 *       Timecode of picture 11 =  910 ms                     *  
 *       Timecode of picture 12 =  820 ms                     *  
 *       Timecode of picture 13 =  730 ms                     *  
 *       Timecode of picture 14 =  640 ms                     *  
 *       Timecode of picture 15 =  550 ms                     *  
 *       Timecode of picture 16 =  460 ms                     *  
 *       Timecode of picture 17 =  370 ms                     *  
 *       Timecode of picture 18 =  280 ms                     *  
 *       Timecode of picture 19 =  190 ms                     *  
 *       Timecode of picture 20 =  100 ms                     *  
 *                                                            *
 *  Last modified: 10/11/97, Written by: Markus Moenig        *
 *                                                            *
 **************************************************************/

  say "This script accelerates a range of pictures."

  IF GetGlobalInfo("LOADEDPROJECTS")= "0" THEN DO     /* Check if there are */
   BEGIN                                              /* any projects loaded */
    say "No picture list loaded! Exiting ..."         /* Failed, exiting ... */
    exit
   END

  IF GetProjectInfo("TYPE") <> "Picture List" THEN DO /* Only works for pictures */
    say "This script needs a picture list! Exiting..."
    exit
   END

  say "Please enter the first picture ('quit' to exit):"
  pull from
  IF from="QUIT" THEN exit

  say "Please enter the last picture ('quit' to exit):"
  pull to
  IF to="QUIT" THEN exit

  say "Please enter the start timecode in ms ('quit' to exit):"
  pull starttime
  IF starttime="QUIT" THEN exit

  say "Please enter end timecode in ms ('quit' to exit):"
  pull endtime
  IF endtime="QUIT" THEN exit

                                                     /* Check if input is valid */
  IF (to < from) | (to > GetProjectInfo("FRAMES")) THEN DO
   BEGIN
     say "Invalid input. Exiting ..."
     exit
   END
                                                     /* de- or acceleration ? */
  IF starttime > endtime THEN acceleration=1
    ELSE acceleration=0

  range=to-from                                      /* Calc the number of pictures in the range */
  IF acceleration THEN DO
   BEGIN
    time=starttime-endtime                           /* De/Acceleration: Calc the difference between */
    timetoadd=time/range                             /* the two timecodes and get the value which has */
    time=starttime                                   /* to be either added to the start timecode for */
   END                                               /* deacceleration or substracted for acceleration */
  ELSE DO
   BEGIN
    time=endtime-starttime
    timetoadd=time/range
    time=starttime
   END

  say "Settings timecodes ..."
  DisableFrameContainer()                            /* Disable the Frame Container */
  DO WHILE from <= to
   BEGIN
     tmp=time % 1                                    /* Make sure we set a numeric value */
     SetLocalTimecode(from,tmp)                      /* Set new timecode */
     from=from+1                                     /* Go to next picture */
     IF acceleration THEN time=time-timetoadd        /* Acceleration: substract the calculated amount */
       ELSE time=time+timetoadd                      /* Deacceleration: add the calculated amount */
   END
  EnableFrameContainer()                             /* Enable the Frame Container again */
  say "Finished !"