/*** TMS34010: Portable TMS34010 emulator ***********************************

	Copyright (C) Alex Pasadyn/Zsolt Vasvari 1998
	 originally based on code by Aaron Giles

	Public include file

*****************************************************************************/

#ifndef _TMS34010_H
#define _TMS34010_H

#include "osd_cpu.h"

#define TMS34010_AVGCYCLES			1
#define TMS34010_ACCURATE_TIMING	0

enum {
	TMS34010_PC=1, TMS34010_SP, TMS34010_ST,
	TMS34010_A0, TMS34010_A1, TMS34010_A2, TMS34010_A3,
	TMS34010_A4, TMS34010_A5, TMS34010_A6, TMS34010_A7,
	TMS34010_A8, TMS34010_A9, TMS34010_A10, TMS34010_A11,
	TMS34010_A12,TMS34010_A13,TMS34010_A14,
	TMS34010_B0, TMS34010_B1, TMS34010_B2, TMS34010_B3,
	TMS34010_B4, TMS34010_B5, TMS34010_B6, TMS34010_B7,
	TMS34010_B8, TMS34010_B9, TMS34010_B10, TMS34010_B11,
	TMS34010_B12,TMS34010_B13,TMS34010_B14 };

/* Interrupt Types that can be generated by outside sources */
#define TMS34010_INT_NONE	0x0000
#define TMS34010_INT1		0x0002	/* External Interrupt 1 */
#define TMS34010_INT2		0x0004	/* External Interrupt 2 */

/* Configuration structure */
struct tms34010_config
{
	UINT8	halt_on_reset;						/* /HCS pin, which determines HALT state after reset */
	void	(*output_int)(int state);			/* output interrupt callback */
	void	(*to_shiftreg  )(UINT32, UINT16 *);	/* shift register write */
	void	(*from_shiftreg)(UINT32, UINT16 *);	/* shift register read */
};

/* PUBLIC FUNCTIONS */
extern void tms34010_reset(void *param);
extern void tms34010_exit(void);
extern int	tms34010_execute(int cycles);
extern unsigned tms34010_get_context(void *dst);
extern void tms34010_set_context(void *src);
extern unsigned tms34010_get_pc(void);
extern void tms34010_set_pc(unsigned val);
extern unsigned tms34010_get_sp(void);
extern void tms34010_set_sp(unsigned val);
extern unsigned tms34010_get_reg(int regnum);
extern void tms34010_set_reg(int regnum, unsigned val);
extern void tms34010_set_nmi_line(int linestate);
extern void tms34010_set_irq_line(int irqline, int linestate);
extern void tms34010_set_irq_callback(int (*callback)(int irqline));
extern void tms34010_internal_interrupt(int type);
extern const char *tms34010_info(void *context, int regnum);
extern unsigned tms34010_dasm(char *buffer, unsigned pc);

extern void TMS34010_State_Save(int cpunum, void *f);
extern void TMS34010_State_Load(int cpunum, void *f);

/* Host control interface */
#define TMS34010_HOST_ADDRESS_L		0
#define TMS34010_HOST_ADDRESS_H		1
#define TMS34010_HOST_DATA			2
#define TMS34010_HOST_CONTROL		3
extern void tms34010_host_w(int cpunum, int reg, int data);
extern int tms34010_host_r(int cpunum, int reg);

/* Sets base and offset of the stack */
void TMS34010_set_stack_base(int cpu, UINT8* stackbase, UINT32 stackoffs);

/* Reads & writes to the 34010 I/O registers; place at TOBYTE(0xc0000000) */
void TMS34010_io_register_w(int offset, int data);
int TMS34010_io_register_r(int offset);

/* Checks whether the display is inhibited */
int TMS34010_io_display_blanked(int cpu);

int TMS34010_get_DPYSTRT(int cpu);

/* PUBLIC GLOBALS */
extern int tms34010_ICount;


/* Use this macro in the memory definitions to specify bit-based addresses */
#define TOBYTE(bitaddr) ((UINT32) (bitaddr)>>3)

#ifdef MAME_DEBUG
extern unsigned Dasm34010 (char *buff, unsigned _pc);
#endif

#endif /* _TMS34010_H */
