/* ======================================================================== */
/* ========================= OPCODE TABLE BUILDER ========================= */
/* ======================================================================== */

#include "m68kops.h"
#include "m68kcpu.h"
#include <stdlib.h>

#include <string.h>

extern void  (*m68k_instruction_jump_table[])(void); /* opcode handler jump table */

/* This is used to generate the opcode handler jump table */
typedef struct
{
	void (*opcode_handler)(void); /* handler function */
	uint bits;			/* number of bits set in mask */
	uint mask;			/* mask on opcode */
	uint match;			/* what to match after masking */
} opcode_handler_struct;


/* Opcode handler table */
static opcode_handler_struct m68k_opcode_handler_table[] =
{
/*  opcode handler              mask   match */
	{m68000_1010             ,  4, 0xf000, 0xa000},
	{m68000_1111             ,  4, 0xf000, 0xf000},
	{m68000_abcd_rr          , 10, 0xf1f8, 0xc100},
	{m68000_abcd_mm_ax7      , 13, 0xfff8, 0xcf08},
	{m68000_abcd_mm_ay7      , 13, 0xf1ff, 0xc10f},
	{m68000_abcd_mm_axy7     , 16, 0xffff, 0xcf0f},
	{m68000_abcd_mm          , 10, 0xf1f8, 0xc108},
	{m68000_add_er_d_8       , 10, 0xf1f8, 0xd000},
	{m68000_add_er_ai_8      , 10, 0xf1f8, 0xd010},
	{m68000_add_er_pi_8      , 10, 0xf1f8, 0xd018},
	{m68000_add_er_pi7_8     , 13, 0xf1ff, 0xd01f},
	{m68000_add_er_pd_8      , 10, 0xf1f8, 0xd020},
	{m68000_add_er_pd7_8     , 13, 0xf1ff, 0xd027},
	{m68000_add_er_di_8      , 10, 0xf1f8, 0xd028},
	{m68000_add_er_ix_8      , 10, 0xf1f8, 0xd030},
	{m68000_add_er_aw_8      , 13, 0xf1ff, 0xd038},
	{m68000_add_er_al_8      , 13, 0xf1ff, 0xd039},
	{m68000_add_er_pcdi_8    , 13, 0xf1ff, 0xd03a},
	{m68000_add_er_pcix_8    , 13, 0xf1ff, 0xd03b},
	{m68000_add_er_i_8       , 13, 0xf1ff, 0xd03c},
	{m68000_add_er_d_16      , 10, 0xf1f8, 0xd040},
	{m68000_add_er_a_16      , 10, 0xf1f8, 0xd048},
	{m68000_add_er_ai_16     , 10, 0xf1f8, 0xd050},
	{m68000_add_er_pi_16     , 10, 0xf1f8, 0xd058},
	{m68000_add_er_pd_16     , 10, 0xf1f8, 0xd060},
	{m68000_add_er_di_16     , 10, 0xf1f8, 0xd068},
	{m68000_add_er_ix_16     , 10, 0xf1f8, 0xd070},
	{m68000_add_er_aw_16     , 13, 0xf1ff, 0xd078},
	{m68000_add_er_al_16     , 13, 0xf1ff, 0xd079},
	{m68000_add_er_pcdi_16   , 13, 0xf1ff, 0xd07a},
	{m68000_add_er_pcix_16   , 13, 0xf1ff, 0xd07b},
	{m68000_add_er_i_16      , 13, 0xf1ff, 0xd07c},
	{m68000_add_er_d_32      , 10, 0xf1f8, 0xd080},
	{m68000_add_er_a_32      , 10, 0xf1f8, 0xd088},
	{m68000_add_er_ai_32     , 10, 0xf1f8, 0xd090},
	{m68000_add_er_pi_32     , 10, 0xf1f8, 0xd098},
	{m68000_add_er_pd_32     , 10, 0xf1f8, 0xd0a0},
	{m68000_add_er_di_32     , 10, 0xf1f8, 0xd0a8},
	{m68000_add_er_ix_32     , 10, 0xf1f8, 0xd0b0},
	{m68000_add_er_aw_32     , 13, 0xf1ff, 0xd0b8},
	{m68000_add_er_al_32     , 13, 0xf1ff, 0xd0b9},
	{m68000_add_er_pcdi_32   , 13, 0xf1ff, 0xd0ba},
	{m68000_add_er_pcix_32   , 13, 0xf1ff, 0xd0bb},
	{m68000_add_er_i_32      , 13, 0xf1ff, 0xd0bc},
	{m68000_add_re_ai_8      , 10, 0xf1f8, 0xd110},
	{m68000_add_re_pi_8      , 10, 0xf1f8, 0xd118},
	{m68000_add_re_pi7_8     , 13, 0xf1ff, 0xd11f},
	{m68000_add_re_pd_8      , 10, 0xf1f8, 0xd120},
	{m68000_add_re_pd7_8     , 13, 0xf1ff, 0xd127},
	{m68000_add_re_di_8      , 10, 0xf1f8, 0xd128},
	{m68000_add_re_ix_8      , 10, 0xf1f8, 0xd130},
	{m68000_add_re_aw_8      , 13, 0xf1ff, 0xd138},
	{m68000_add_re_al_8      , 13, 0xf1ff, 0xd139},
	{m68000_add_re_ai_16     , 10, 0xf1f8, 0xd150},
	{m68000_add_re_pi_16     , 10, 0xf1f8, 0xd158},
	{m68000_add_re_pd_16     , 10, 0xf1f8, 0xd160},
	{m68000_add_re_di_16     , 10, 0xf1f8, 0xd168},
	{m68000_add_re_ix_16     , 10, 0xf1f8, 0xd170},
	{m68000_add_re_aw_16     , 13, 0xf1ff, 0xd178},
	{m68000_add_re_al_16     , 13, 0xf1ff, 0xd179},
	{m68000_add_re_ai_32     , 10, 0xf1f8, 0xd190},
	{m68000_add_re_pi_32     , 10, 0xf1f8, 0xd198},
	{m68000_add_re_pd_32     , 10, 0xf1f8, 0xd1a0},
	{m68000_add_re_di_32     , 10, 0xf1f8, 0xd1a8},
	{m68000_add_re_ix_32     , 10, 0xf1f8, 0xd1b0},
	{m68000_add_re_aw_32     , 13, 0xf1ff, 0xd1b8},
	{m68000_add_re_al_32     , 13, 0xf1ff, 0xd1b9},
	{m68000_adda_d_16        , 10, 0xf1f8, 0xd0c0},
	{m68000_adda_a_16        , 10, 0xf1f8, 0xd0c8},
	{m68000_adda_ai_16       , 10, 0xf1f8, 0xd0d0},
	{m68000_adda_pi_16       , 10, 0xf1f8, 0xd0d8},
	{m68000_adda_pd_16       , 10, 0xf1f8, 0xd0e0},
	{m68000_adda_di_16       , 10, 0xf1f8, 0xd0e8},
	{m68000_adda_ix_16       , 10, 0xf1f8, 0xd0f0},
	{m68000_adda_aw_16       , 13, 0xf1ff, 0xd0f8},
	{m68000_adda_al_16       , 13, 0xf1ff, 0xd0f9},
	{m68000_adda_pcdi_16     , 13, 0xf1ff, 0xd0fa},
	{m68000_adda_pcix_16     , 13, 0xf1ff, 0xd0fb},
	{m68000_adda_i_16        , 13, 0xf1ff, 0xd0fc},
	{m68000_adda_d_32        , 10, 0xf1f8, 0xd1c0},
	{m68000_adda_a_32        , 10, 0xf1f8, 0xd1c8},
	{m68000_adda_ai_32       , 10, 0xf1f8, 0xd1d0},
	{m68000_adda_pi_32       , 10, 0xf1f8, 0xd1d8},
	{m68000_adda_pd_32       , 10, 0xf1f8, 0xd1e0},
	{m68000_adda_di_32       , 10, 0xf1f8, 0xd1e8},
	{m68000_adda_ix_32       , 10, 0xf1f8, 0xd1f0},
	{m68000_adda_aw_32       , 13, 0xf1ff, 0xd1f8},
	{m68000_adda_al_32       , 13, 0xf1ff, 0xd1f9},
	{m68000_adda_pcdi_32     , 13, 0xf1ff, 0xd1fa},
	{m68000_adda_pcix_32     , 13, 0xf1ff, 0xd1fb},
	{m68000_adda_i_32        , 13, 0xf1ff, 0xd1fc},
	{m68000_addi_d_8         , 13, 0xfff8, 0x0600},
	{m68000_addi_ai_8        , 13, 0xfff8, 0x0610},
	{m68000_addi_pi_8        , 13, 0xfff8, 0x0618},
	{m68000_addi_pi7_8       , 16, 0xffff, 0x061f},
	{m68000_addi_pd_8        , 13, 0xfff8, 0x0620},
	{m68000_addi_pd7_8       , 16, 0xffff, 0x0627},
	{m68000_addi_di_8        , 13, 0xfff8, 0x0628},
	{m68000_addi_ix_8        , 13, 0xfff8, 0x0630},
	{m68000_addi_aw_8        , 16, 0xffff, 0x0638},
	{m68000_addi_al_8        , 16, 0xffff, 0x0639},
	{m68000_addi_d_16        , 13, 0xfff8, 0x0640},
	{m68000_addi_ai_16       , 13, 0xfff8, 0x0650},
	{m68000_addi_pi_16       , 13, 0xfff8, 0x0658},
	{m68000_addi_pd_16       , 13, 0xfff8, 0x0660},
	{m68000_addi_di_16       , 13, 0xfff8, 0x0668},
	{m68000_addi_ix_16       , 13, 0xfff8, 0x0670},
	{m68000_addi_aw_16       , 16, 0xffff, 0x0678},
	{m68000_addi_al_16       , 16, 0xffff, 0x0679},
	{m68000_addi_d_32        , 13, 0xfff8, 0x0680},
	{m68000_addi_ai_32       , 13, 0xfff8, 0x0690},
	{m68000_addi_pi_32       , 13, 0xfff8, 0x0698},
	{m68000_addi_pd_32       , 13, 0xfff8, 0x06a0},
	{m68000_addi_di_32       , 13, 0xfff8, 0x06a8},
	{m68000_addi_ix_32       , 13, 0xfff8, 0x06b0},
	{m68000_addi_aw_32       , 16, 0xffff, 0x06b8},
	{m68000_addi_al_32       , 16, 0xffff, 0x06b9},
	{m68000_addq_d_8         , 10, 0xf1f8, 0x5000},
	{m68000_addq_ai_8        , 10, 0xf1f8, 0x5010},
	{m68000_addq_pi_8        , 10, 0xf1f8, 0x5018},
	{m68000_addq_pi7_8       , 13, 0xf1ff, 0x501f},
	{m68000_addq_pd_8        , 10, 0xf1f8, 0x5020},
	{m68000_addq_pd7_8       , 13, 0xf1ff, 0x5027},
	{m68000_addq_di_8        , 10, 0xf1f8, 0x5028},
	{m68000_addq_ix_8        , 10, 0xf1f8, 0x5030},
	{m68000_addq_aw_8        , 13, 0xf1ff, 0x5038},
	{m68000_addq_al_8        , 13, 0xf1ff, 0x5039},
	{m68000_addq_d_16        , 10, 0xf1f8, 0x5040},
	{m68000_addq_a_16        , 10, 0xf1f8, 0x5048},
	{m68000_addq_ai_16       , 10, 0xf1f8, 0x5050},
	{m68000_addq_pi_16       , 10, 0xf1f8, 0x5058},
	{m68000_addq_pd_16       , 10, 0xf1f8, 0x5060},
	{m68000_addq_di_16       , 10, 0xf1f8, 0x5068},
	{m68000_addq_ix_16       , 10, 0xf1f8, 0x5070},
	{m68000_addq_aw_16       , 13, 0xf1ff, 0x5078},
	{m68000_addq_al_16       , 13, 0xf1ff, 0x5079},
	{m68000_addq_d_32        , 10, 0xf1f8, 0x5080},
	{m68000_addq_a_32        , 10, 0xf1f8, 0x5088},
	{m68000_addq_ai_32       , 10, 0xf1f8, 0x5090},
	{m68000_addq_pi_32       , 10, 0xf1f8, 0x5098},
	{m68000_addq_pd_32       , 10, 0xf1f8, 0x50a0},
	{m68000_addq_di_32       , 10, 0xf1f8, 0x50a8},
	{m68000_addq_ix_32       , 10, 0xf1f8, 0x50b0},
	{m68000_addq_aw_32       , 13, 0xf1ff, 0x50b8},
	{m68000_addq_al_32       , 13, 0xf1ff, 0x50b9},
	{m68000_addx_rr_8        , 10, 0xf1f8, 0xd100},
	{m68000_addx_rr_16       , 10, 0xf1f8, 0xd140},
	{m68000_addx_rr_32       , 10, 0xf1f8, 0xd180},
	{m68000_addx_mm_8_ax7    , 13, 0xfff8, 0xdf08},
	{m68000_addx_mm_8_ay7    , 13, 0xf1ff, 0xd10f},
	{m68000_addx_mm_8_axy7   , 16, 0xffff, 0xdf0f},
	{m68000_addx_mm_8        , 10, 0xf1f8, 0xd108},
	{m68000_addx_mm_16       , 10, 0xf1f8, 0xd148},
	{m68000_addx_mm_32       , 10, 0xf1f8, 0xd188},
	{m68000_and_er_d_8       , 10, 0xf1f8, 0xc000},
	{m68000_and_er_ai_8      , 10, 0xf1f8, 0xc010},
	{m68000_and_er_pi_8      , 10, 0xf1f8, 0xc018},
	{m68000_and_er_pi7_8     , 13, 0xf1ff, 0xc01f},
	{m68000_and_er_pd_8      , 10, 0xf1f8, 0xc020},
	{m68000_and_er_pd7_8     , 13, 0xf1ff, 0xc027},
	{m68000_and_er_di_8      , 10, 0xf1f8, 0xc028},
	{m68000_and_er_ix_8      , 10, 0xf1f8, 0xc030},
	{m68000_and_er_aw_8      , 13, 0xf1ff, 0xc038},
	{m68000_and_er_al_8      , 13, 0xf1ff, 0xc039},
	{m68000_and_er_pcdi_8    , 13, 0xf1ff, 0xc03a},
	{m68000_and_er_pcix_8    , 13, 0xf1ff, 0xc03b},
	{m68000_and_er_i_8       , 13, 0xf1ff, 0xc03c},
	{m68000_and_er_d_16      , 10, 0xf1f8, 0xc040},
	{m68000_and_er_ai_16     , 10, 0xf1f8, 0xc050},
	{m68000_and_er_pi_16     , 10, 0xf1f8, 0xc058},
	{m68000_and_er_pd_16     , 10, 0xf1f8, 0xc060},
	{m68000_and_er_di_16     , 10, 0xf1f8, 0xc068},
	{m68000_and_er_ix_16     , 10, 0xf1f8, 0xc070},
	{m68000_and_er_aw_16     , 13, 0xf1ff, 0xc078},
	{m68000_and_er_al_16     , 13, 0xf1ff, 0xc079},
	{m68000_and_er_pcdi_16   , 13, 0xf1ff, 0xc07a},
	{m68000_and_er_pcix_16   , 13, 0xf1ff, 0xc07b},
	{m68000_and_er_i_16      , 13, 0xf1ff, 0xc07c},
	{m68000_and_er_d_32      , 10, 0xf1f8, 0xc080},
	{m68000_and_er_ai_32     , 10, 0xf1f8, 0xc090},
	{m68000_and_er_pi_32     , 10, 0xf1f8, 0xc098},
	{m68000_and_er_pd_32     , 10, 0xf1f8, 0xc0a0},
	{m68000_and_er_di_32     , 10, 0xf1f8, 0xc0a8},
	{m68000_and_er_ix_32     , 10, 0xf1f8, 0xc0b0},
	{m68000_and_er_aw_32     , 13, 0xf1ff, 0xc0b8},
	{m68000_and_er_al_32     , 13, 0xf1ff, 0xc0b9},
	{m68000_and_er_pcdi_32   , 13, 0xf1ff, 0xc0ba},
	{m68000_and_er_pcix_32   , 13, 0xf1ff, 0xc0bb},
	{m68000_and_er_i_32      , 13, 0xf1ff, 0xc0bc},
	{m68000_and_re_ai_8      , 10, 0xf1f8, 0xc110},
	{m68000_and_re_pi_8      , 10, 0xf1f8, 0xc118},
	{m68000_and_re_pi7_8     , 13, 0xf1ff, 0xc11f},
	{m68000_and_re_pd_8      , 10, 0xf1f8, 0xc120},
	{m68000_and_re_pd7_8     , 13, 0xf1ff, 0xc127},
	{m68000_and_re_di_8      , 10, 0xf1f8, 0xc128},
	{m68000_and_re_ix_8      , 10, 0xf1f8, 0xc130},
	{m68000_and_re_aw_8      , 13, 0xf1ff, 0xc138},
	{m68000_and_re_al_8      , 13, 0xf1ff, 0xc139},
	{m68000_and_re_ai_16     , 10, 0xf1f8, 0xc150},
	{m68000_and_re_pi_16     , 10, 0xf1f8, 0xc158},
	{m68000_and_re_pd_16     , 10, 0xf1f8, 0xc160},
	{m68000_and_re_di_16     , 10, 0xf1f8, 0xc168},
	{m68000_and_re_ix_16     , 10, 0xf1f8, 0xc170},
	{m68000_and_re_aw_16     , 13, 0xf1ff, 0xc178},
	{m68000_and_re_al_16     , 13, 0xf1ff, 0xc179},
	{m68000_and_re_ai_32     , 10, 0xf1f8, 0xc190},
	{m68000_and_re_pi_32     , 10, 0xf1f8, 0xc198},
	{m68000_and_re_pd_32     , 10, 0xf1f8, 0xc1a0},
	{m68000_and_re_di_32     , 10, 0xf1f8, 0xc1a8},
	{m68000_and_re_ix_32     , 10, 0xf1f8, 0xc1b0},
	{m68000_and_re_aw_32     , 13, 0xf1ff, 0xc1b8},
	{m68000_and_re_al_32     , 13, 0xf1ff, 0xc1b9},
	{m68000_andi_to_ccr      , 16, 0xffff, 0x023c},
	{m68000_andi_to_sr       , 16, 0xffff, 0x027c},
	{m68000_andi_d_8         , 13, 0xfff8, 0x0200},
	{m68000_andi_ai_8        , 13, 0xfff8, 0x0210},
	{m68000_andi_pi_8        , 13, 0xfff8, 0x0218},
	{m68000_andi_pi7_8       , 16, 0xffff, 0x021f},
	{m68000_andi_pd_8        , 13, 0xfff8, 0x0220},
	{m68000_andi_pd7_8       , 16, 0xffff, 0x0227},
	{m68000_andi_di_8        , 13, 0xfff8, 0x0228},
	{m68000_andi_ix_8        , 13, 0xfff8, 0x0230},
	{m68000_andi_aw_8        , 16, 0xffff, 0x0238},
	{m68000_andi_al_8        , 16, 0xffff, 0x0239},
	{m68000_andi_d_16        , 13, 0xfff8, 0x0240},
	{m68000_andi_ai_16       , 13, 0xfff8, 0x0250},
	{m68000_andi_pi_16       , 13, 0xfff8, 0x0258},
	{m68000_andi_pd_16       , 13, 0xfff8, 0x0260},
	{m68000_andi_di_16       , 13, 0xfff8, 0x0268},
	{m68000_andi_ix_16       , 13, 0xfff8, 0x0270},
	{m68000_andi_aw_16       , 16, 0xffff, 0x0278},
	{m68000_andi_al_16       , 16, 0xffff, 0x0279},
	{m68000_andi_d_32        , 13, 0xfff8, 0x0280},
	{m68000_andi_ai_32       , 13, 0xfff8, 0x0290},
	{m68000_andi_pi_32       , 13, 0xfff8, 0x0298},
	{m68000_andi_pd_32       , 13, 0xfff8, 0x02a0},
	{m68000_andi_di_32       , 13, 0xfff8, 0x02a8},
	{m68000_andi_ix_32       , 13, 0xfff8, 0x02b0},
	{m68000_andi_aw_32       , 16, 0xffff, 0x02b8},
	{m68000_andi_al_32       , 16, 0xffff, 0x02b9},
	{m68000_asr_s_8          , 10, 0xf1f8, 0xe000},
	{m68000_asr_s_16         , 10, 0xf1f8, 0xe040},
	{m68000_asr_s_32         , 10, 0xf1f8, 0xe080},
	{m68000_asr_r_8          , 10, 0xf1f8, 0xe020},
	{m68000_asr_r_16         , 10, 0xf1f8, 0xe060},
	{m68000_asr_r_32         , 10, 0xf1f8, 0xe0a0},
	{m68000_asr_ea_ai        , 13, 0xfff8, 0xe0d0},
	{m68000_asr_ea_pi        , 13, 0xfff8, 0xe0d8},
	{m68000_asr_ea_pd        , 13, 0xfff8, 0xe0e0},
	{m68000_asr_ea_di        , 13, 0xfff8, 0xe0e8},
	{m68000_asr_ea_ix        , 13, 0xfff8, 0xe0f0},
	{m68000_asr_ea_aw        , 16, 0xffff, 0xe0f8},
	{m68000_asr_ea_al        , 16, 0xffff, 0xe0f9},
	{m68000_asl_s_8          , 10, 0xf1f8, 0xe100},
	{m68000_asl_s_16         , 10, 0xf1f8, 0xe140},
	{m68000_asl_s_32         , 10, 0xf1f8, 0xe180},
	{m68000_asl_r_8          , 10, 0xf1f8, 0xe120},
	{m68000_asl_r_16         , 10, 0xf1f8, 0xe160},
	{m68000_asl_r_32         , 10, 0xf1f8, 0xe1a0},
	{m68000_asl_ea_ai        , 13, 0xfff8, 0xe1d0},
	{m68000_asl_ea_pi        , 13, 0xfff8, 0xe1d8},
	{m68000_asl_ea_pd        , 13, 0xfff8, 0xe1e0},
	{m68000_asl_ea_di        , 13, 0xfff8, 0xe1e8},
	{m68000_asl_ea_ix        , 13, 0xfff8, 0xe1f0},
	{m68000_asl_ea_aw        , 16, 0xffff, 0xe1f8},
	{m68000_asl_ea_al        , 16, 0xffff, 0xe1f9},
	{m68000_bhi_16           , 16, 0xffff, 0x6200},
	{m68020_bhi_32           , 16, 0xffff, 0x62ff},
	{m68000_bhi_8            ,  8, 0xff00, 0x6200},
	{m68000_bls_16           , 16, 0xffff, 0x6300},
	{m68020_bls_32           , 16, 0xffff, 0x63ff},
	{m68000_bls_8            ,  8, 0xff00, 0x6300},
	{m68000_bcc_16           , 16, 0xffff, 0x6400},
	{m68020_bcc_32           , 16, 0xffff, 0x64ff},
	{m68000_bcc_8            ,  8, 0xff00, 0x6400},
	{m68000_bcs_16           , 16, 0xffff, 0x6500},
	{m68020_bcs_32           , 16, 0xffff, 0x65ff},
	{m68000_bcs_8            ,  8, 0xff00, 0x6500},
	{m68000_bne_16           , 16, 0xffff, 0x6600},
	{m68020_bne_32           , 16, 0xffff, 0x66ff},
	{m68000_bne_8            ,  8, 0xff00, 0x6600},
	{m68000_beq_16           , 16, 0xffff, 0x6700},
	{m68020_beq_32           , 16, 0xffff, 0x67ff},
	{m68000_beq_8            ,  8, 0xff00, 0x6700},
	{m68000_bvc_16           , 16, 0xffff, 0x6800},
	{m68020_bvc_32           , 16, 0xffff, 0x68ff},
	{m68000_bvc_8            ,  8, 0xff00, 0x6800},
	{m68000_bvs_16           , 16, 0xffff, 0x6900},
	{m68020_bvs_32           , 16, 0xffff, 0x69ff},
	{m68000_bvs_8            ,  8, 0xff00, 0x6900},
	{m68000_bpl_16           , 16, 0xffff, 0x6a00},
	{m68020_bpl_32           , 16, 0xffff, 0x6aff},
	{m68000_bpl_8            ,  8, 0xff00, 0x6a00},
	{m68000_bmi_16           , 16, 0xffff, 0x6b00},
	{m68020_bmi_32           , 16, 0xffff, 0x6bff},
	{m68000_bmi_8            ,  8, 0xff00, 0x6b00},
	{m68000_bge_16           , 16, 0xffff, 0x6c00},
	{m68020_bge_32           , 16, 0xffff, 0x6cff},
	{m68000_bge_8            ,  8, 0xff00, 0x6c00},
	{m68000_blt_16           , 16, 0xffff, 0x6d00},
	{m68020_blt_32           , 16, 0xffff, 0x6dff},
	{m68000_blt_8            ,  8, 0xff00, 0x6d00},
	{m68000_bgt_16           , 16, 0xffff, 0x6e00},
	{m68020_bgt_32           , 16, 0xffff, 0x6eff},
	{m68000_bgt_8            ,  8, 0xff00, 0x6e00},
	{m68000_ble_16           , 16, 0xffff, 0x6f00},
	{m68020_ble_32           , 16, 0xffff, 0x6fff},
	{m68000_ble_8            ,  8, 0xff00, 0x6f00},
	{m68000_bchg_r_d         , 10, 0xf1f8, 0x0140},
	{m68000_bchg_r_ai        , 10, 0xf1f8, 0x0150},
	{m68000_bchg_r_pi        , 10, 0xf1f8, 0x0158},
	{m68000_bchg_r_pi7       , 13, 0xf1ff, 0x015f},
	{m68000_bchg_r_pd        , 10, 0xf1f8, 0x0160},
	{m68000_bchg_r_pd7       , 13, 0xf1ff, 0x0167},
	{m68000_bchg_r_di        , 10, 0xf1f8, 0x0168},
	{m68000_bchg_r_ix        , 10, 0xf1f8, 0x0170},
	{m68000_bchg_r_aw        , 13, 0xf1ff, 0x0178},
	{m68000_bchg_r_al        , 13, 0xf1ff, 0x0179},
	{m68000_bchg_s_d         , 13, 0xfff8, 0x0840},
	{m68000_bchg_s_ai        , 13, 0xfff8, 0x0850},
	{m68000_bchg_s_pi        , 13, 0xfff8, 0x0858},
	{m68000_bchg_s_pi7       , 16, 0xffff, 0x085f},
	{m68000_bchg_s_pd        , 13, 0xfff8, 0x0860},
	{m68000_bchg_s_pd7       , 16, 0xffff, 0x0867},
	{m68000_bchg_s_di        , 13, 0xfff8, 0x0868},
	{m68000_bchg_s_ix        , 13, 0xfff8, 0x0870},
	{m68000_bchg_s_aw        , 16, 0xffff, 0x0878},
	{m68000_bchg_s_al        , 16, 0xffff, 0x0879},
	{m68000_bclr_r_d         , 10, 0xf1f8, 0x0180},
	{m68000_bclr_r_ai        , 10, 0xf1f8, 0x0190},
	{m68000_bclr_r_pi        , 10, 0xf1f8, 0x0198},
	{m68000_bclr_r_pi7       , 13, 0xf1ff, 0x019f},
	{m68000_bclr_r_pd        , 10, 0xf1f8, 0x01a0},
	{m68000_bclr_r_pd7       , 13, 0xf1ff, 0x01a7},
	{m68000_bclr_r_di        , 10, 0xf1f8, 0x01a8},
	{m68000_bclr_r_ix        , 10, 0xf1f8, 0x01b0},
	{m68000_bclr_r_aw        , 13, 0xf1ff, 0x01b8},
	{m68000_bclr_r_al        , 13, 0xf1ff, 0x01b9},
	{m68000_bclr_s_d         , 13, 0xfff8, 0x0880},
	{m68000_bclr_s_ai        , 13, 0xfff8, 0x0890},
	{m68000_bclr_s_pi        , 13, 0xfff8, 0x0898},
	{m68000_bclr_s_pi7       , 16, 0xffff, 0x089f},
	{m68000_bclr_s_pd        , 13, 0xfff8, 0x08a0},
	{m68000_bclr_s_pd7       , 16, 0xffff, 0x08a7},
	{m68000_bclr_s_di        , 13, 0xfff8, 0x08a8},
	{m68000_bclr_s_ix        , 13, 0xfff8, 0x08b0},
	{m68000_bclr_s_aw        , 16, 0xffff, 0x08b8},
	{m68000_bclr_s_al        , 16, 0xffff, 0x08b9},
	{m68020_bfchg_d          , 13, 0xfff8, 0xeac0},
	{m68020_bfchg_ai         , 13, 0xfff8, 0xead0},
	{m68020_bfchg_di         , 13, 0xfff8, 0xeae8},
	{m68020_bfchg_ix         , 13, 0xfff8, 0xeaf0},
	{m68020_bfchg_aw         , 16, 0xffff, 0xeaf8},
	{m68020_bfchg_al         , 16, 0xffff, 0xeaf9},
	{m68020_bfclr_d          , 13, 0xfff8, 0xecc0},
	{m68020_bfclr_ai         , 13, 0xfff8, 0xecd0},
	{m68020_bfclr_di         , 13, 0xfff8, 0xece8},
	{m68020_bfclr_ix         , 13, 0xfff8, 0xecf0},
	{m68020_bfclr_aw         , 16, 0xffff, 0xecf8},
	{m68020_bfclr_al         , 16, 0xffff, 0xecf9},
	{m68020_bfexts_d         , 13, 0xfff8, 0xebc0},
	{m68020_bfexts_ai        , 13, 0xfff8, 0xebd0},
	{m68020_bfexts_di        , 13, 0xfff8, 0xebe8},
	{m68020_bfexts_ix        , 13, 0xfff8, 0xebf0},
	{m68020_bfexts_aw        , 16, 0xffff, 0xebf8},
	{m68020_bfexts_al        , 16, 0xffff, 0xebf9},
	{m68020_bfexts_pcdi      , 16, 0xffff, 0xebfa},
	{m68020_bfexts_pcix      , 16, 0xffff, 0xebfb},
	{m68020_bfextu_d         , 13, 0xfff8, 0xe9c0},
	{m68020_bfextu_ai        , 13, 0xfff8, 0xe9d0},
	{m68020_bfextu_di        , 13, 0xfff8, 0xe9e8},
	{m68020_bfextu_ix        , 13, 0xfff8, 0xe9f0},
	{m68020_bfextu_aw        , 16, 0xffff, 0xe9f8},
	{m68020_bfextu_al        , 16, 0xffff, 0xe9f9},
	{m68020_bfextu_pcdi      , 16, 0xffff, 0xe9fa},
	{m68020_bfextu_pcix      , 16, 0xffff, 0xe9fb},
	{m68020_bfffo_d          , 13, 0xfff8, 0xedc0},
	{m68020_bfffo_ai         , 13, 0xfff8, 0xedd0},
	{m68020_bfffo_di         , 13, 0xfff8, 0xede8},
	{m68020_bfffo_ix         , 13, 0xfff8, 0xedf0},
	{m68020_bfffo_aw         , 16, 0xffff, 0xedf8},
	{m68020_bfffo_al         , 16, 0xffff, 0xedf9},
	{m68020_bfffo_pcdi       , 16, 0xffff, 0xedfa},
	{m68020_bfffo_pcix       , 16, 0xffff, 0xedfb},
	{m68020_bfins_d          , 13, 0xfff8, 0xefc0},
	{m68020_bfins_ai         , 13, 0xfff8, 0xefd0},
	{m68020_bfins_di         , 13, 0xfff8, 0xefe8},
	{m68020_bfins_ix         , 13, 0xfff8, 0xeff0},
	{m68020_bfins_aw         , 16, 0xffff, 0xeff8},
	{m68020_bfins_al         , 16, 0xffff, 0xeff9},
	{m68020_bfset_d          , 13, 0xfff8, 0xeec0},
	{m68020_bfset_ai         , 13, 0xfff8, 0xeed0},
	{m68020_bfset_di         , 13, 0xfff8, 0xeee8},
	{m68020_bfset_ix         , 13, 0xfff8, 0xeef0},
	{m68020_bfset_aw         , 16, 0xffff, 0xeef8},
	{m68020_bfset_al         , 16, 0xffff, 0xeef9},
	{m68020_bftst_d          , 13, 0xfff8, 0xe8c0},
	{m68020_bftst_ai         , 13, 0xfff8, 0xe8d0},
	{m68020_bftst_di         , 13, 0xfff8, 0xe8e8},
	{m68020_bftst_ix         , 13, 0xfff8, 0xe8f0},
	{m68020_bftst_aw         , 16, 0xffff, 0xe8f8},
	{m68020_bftst_al         , 16, 0xffff, 0xe8f9},
	{m68020_bftst_pcdi       , 16, 0xffff, 0xe8fa},
	{m68020_bftst_pcix       , 16, 0xffff, 0xe8fb},
	{m68010_bkpt             , 13, 0xfff8, 0x4848},
	{m68000_bra_16           , 16, 0xffff, 0x6000},
	{m68020_bra_32           , 16, 0xffff, 0x60ff},
	{m68000_bra_8            ,  8, 0xff00, 0x6000},
	{m68000_bset_r_d         , 10, 0xf1f8, 0x01c0},
	{m68000_bset_r_ai        , 10, 0xf1f8, 0x01d0},
	{m68000_bset_r_pi        , 10, 0xf1f8, 0x01d8},
	{m68000_bset_r_pi7       , 13, 0xf1ff, 0x01df},
	{m68000_bset_r_pd        , 10, 0xf1f8, 0x01e0},
	{m68000_bset_r_pd7       , 13, 0xf1ff, 0x01e7},
	{m68000_bset_r_di        , 10, 0xf1f8, 0x01e8},
	{m68000_bset_r_ix        , 10, 0xf1f8, 0x01f0},
	{m68000_bset_r_aw        , 13, 0xf1ff, 0x01f8},
	{m68000_bset_r_al        , 13, 0xf1ff, 0x01f9},
	{m68000_bset_s_d         , 13, 0xfff8, 0x08c0},
	{m68000_bset_s_ai        , 13, 0xfff8, 0x08d0},
	{m68000_bset_s_pi        , 13, 0xfff8, 0x08d8},
	{m68000_bset_s_pi7       , 16, 0xffff, 0x08df},
	{m68000_bset_s_pd        , 13, 0xfff8, 0x08e0},
	{m68000_bset_s_pd7       , 16, 0xffff, 0x08e7},
	{m68000_bset_s_di        , 13, 0xfff8, 0x08e8},
	{m68000_bset_s_ix        , 13, 0xfff8, 0x08f0},
	{m68000_bset_s_aw        , 16, 0xffff, 0x08f8},
	{m68000_bset_s_al        , 16, 0xffff, 0x08f9},
	{m68000_bsr_16           , 16, 0xffff, 0x6100},
	{m68020_bsr_32           , 16, 0xffff, 0x61ff},
	{m68000_bsr_8            ,  8, 0xff00, 0x6100},
	{m68000_btst_r_d         , 10, 0xf1f8, 0x0100},
	{m68000_btst_r_ai        , 10, 0xf1f8, 0x0110},
	{m68000_btst_r_pi        , 10, 0xf1f8, 0x0118},
	{m68000_btst_r_pi7       , 13, 0xf1ff, 0x011f},
	{m68000_btst_r_pd        , 10, 0xf1f8, 0x0120},
	{m68000_btst_r_pd7       , 13, 0xf1ff, 0x0127},
	{m68000_btst_r_di        , 10, 0xf1f8, 0x0128},
	{m68000_btst_r_ix        , 10, 0xf1f8, 0x0130},
	{m68000_btst_r_aw        , 13, 0xf1ff, 0x0138},
	{m68000_btst_r_al        , 13, 0xf1ff, 0x0139},
	{m68000_btst_r_pcdi      , 13, 0xf1ff, 0x013a},
	{m68000_btst_r_pcix      , 13, 0xf1ff, 0x013b},
	{m68000_btst_r_i         , 13, 0xf1ff, 0x013c},
	{m68000_btst_s_d         , 13, 0xfff8, 0x0800},
	{m68000_btst_s_ai        , 13, 0xfff8, 0x0810},
	{m68000_btst_s_pi        , 13, 0xfff8, 0x0818},
	{m68000_btst_s_pi7       , 16, 0xffff, 0x081f},
	{m68000_btst_s_pd        , 13, 0xfff8, 0x0820},
	{m68000_btst_s_pd7       , 16, 0xffff, 0x0827},
	{m68000_btst_s_di        , 13, 0xfff8, 0x0828},
	{m68000_btst_s_ix        , 13, 0xfff8, 0x0830},
	{m68000_btst_s_aw        , 16, 0xffff, 0x0838},
	{m68000_btst_s_al        , 16, 0xffff, 0x0839},
	{m68000_btst_s_pcdi      , 16, 0xffff, 0x083a},
	{m68000_btst_s_pcix      , 16, 0xffff, 0x083b},
	{m68020_callm_ai         , 13, 0xfff8, 0x06d0},
	{m68020_callm_di         , 13, 0xfff8, 0x06e8},
	{m68020_callm_ix         , 13, 0xfff8, 0x06f0},
	{m68020_callm_aw         , 16, 0xffff, 0x06f8},
	{m68020_callm_al         , 16, 0xffff, 0x06f9},
	{m68020_callm_pcdi       , 16, 0xffff, 0x06fa},
	{m68020_callm_pcix       , 16, 0xffff, 0x06fb},
	{m68020_cas_ai_8         , 13, 0xfff8, 0x0ad0},
	{m68020_cas_pi_8         , 13, 0xfff8, 0x0ad8},
	{m68020_cas_pi7_8        , 16, 0xffff, 0x0adf},
	{m68020_cas_pd_8         , 13, 0xfff8, 0x0ae0},
	{m68020_cas_pd7_8        , 16, 0xffff, 0x0ae7},
	{m68020_cas_di_8         , 13, 0xfff8, 0x0ae8},
	{m68020_cas_ix_8         , 13, 0xfff8, 0x0af0},
	{m68020_cas_aw_8         , 16, 0xffff, 0x0af8},
	{m68020_cas_al_8         , 16, 0xffff, 0x0af9},
	{m68020_cas_ai_16        , 13, 0xfff8, 0x0cd0},
	{m68020_cas_pi_16        , 13, 0xfff8, 0x0cd8},
	{m68020_cas_pd_16        , 13, 0xfff8, 0x0ce0},
	{m68020_cas_di_16        , 13, 0xfff8, 0x0ce8},
	{m68020_cas_ix_16        , 13, 0xfff8, 0x0cf0},
	{m68020_cas_aw_16        , 16, 0xffff, 0x0cf8},
	{m68020_cas_al_16        , 16, 0xffff, 0x0cf9},
	{m68020_cas_ai_32        , 13, 0xfff8, 0x0ed0},
	{m68020_cas_pi_32        , 13, 0xfff8, 0x0ed8},
	{m68020_cas_pd_32        , 13, 0xfff8, 0x0ee0},
	{m68020_cas_di_32        , 13, 0xfff8, 0x0ee8},
	{m68020_cas_ix_32        , 13, 0xfff8, 0x0ef0},
	{m68020_cas_aw_32        , 16, 0xffff, 0x0ef8},
	{m68020_cas_al_32        , 16, 0xffff, 0x0ef9},
	{m68020_cas2_16          , 16, 0xffff, 0x0cfc},
	{m68020_cas2_32          , 16, 0xffff, 0x0efc},
	{m68000_chk_d_16         , 10, 0xf1f8, 0x4180},
	{m68000_chk_ai_16        , 10, 0xf1f8, 0x4190},
	{m68000_chk_pi_16        , 10, 0xf1f8, 0x4198},
	{m68000_chk_pd_16        , 10, 0xf1f8, 0x41a0},
	{m68000_chk_di_16        , 10, 0xf1f8, 0x41a8},
	{m68000_chk_ix_16        , 10, 0xf1f8, 0x41b0},
	{m68000_chk_aw_16        , 13, 0xf1ff, 0x41b8},
	{m68000_chk_al_16        , 13, 0xf1ff, 0x41b9},
	{m68000_chk_pcdi_16      , 13, 0xf1ff, 0x41ba},
	{m68000_chk_pcix_16      , 13, 0xf1ff, 0x41bb},
	{m68000_chk_i_16         , 13, 0xf1ff, 0x41bc},
	{m68020_chk_d_32         , 10, 0xf1f8, 0x4100},
	{m68020_chk_ai_32        , 10, 0xf1f8, 0x4110},
	{m68020_chk_pi_32        , 10, 0xf1f8, 0x4118},
	{m68020_chk_pd_32        , 10, 0xf1f8, 0x4120},
	{m68020_chk_di_32        , 10, 0xf1f8, 0x4128},
	{m68020_chk_ix_32        , 10, 0xf1f8, 0x4130},
	{m68020_chk_aw_32        , 13, 0xf1ff, 0x4138},
	{m68020_chk_al_32        , 13, 0xf1ff, 0x4139},
	{m68020_chk_pcdi_32      , 13, 0xf1ff, 0x413a},
	{m68020_chk_pcix_32      , 13, 0xf1ff, 0x413b},
	{m68020_chk_i_32         , 13, 0xf1ff, 0x413c},
	{m68020_chk2_cmp2_ai_8   , 13, 0xfff8, 0x00d0},
	{m68020_chk2_cmp2_di_8   , 13, 0xfff8, 0x00e8},
	{m68020_chk2_cmp2_ix_8   , 13, 0xfff8, 0x00f0},
	{m68020_chk2_cmp2_aw_8   , 16, 0xffff, 0x00f8},
	{m68020_chk2_cmp2_al_8   , 16, 0xffff, 0x00f9},
	{m68020_chk2_cmp2_pcdi_8 , 16, 0xffff, 0x00fa},
	{m68020_chk2_cmp2_pcix_8 , 16, 0xffff, 0x00fb},
	{m68020_chk2_cmp2_ai_16  , 13, 0xfff8, 0x02d0},
	{m68020_chk2_cmp2_di_16  , 13, 0xfff8, 0x02e8},
	{m68020_chk2_cmp2_ix_16  , 13, 0xfff8, 0x02f0},
	{m68020_chk2_cmp2_aw_16  , 16, 0xffff, 0x02f8},
	{m68020_chk2_cmp2_al_16  , 16, 0xffff, 0x02f9},
	{m68020_chk2_cmp2_pcdi_16, 16, 0xffff, 0x02fa},
	{m68020_chk2_cmp2_pcix_16, 16, 0xffff, 0x02fb},
	{m68020_chk2_cmp2_ai_32  , 13, 0xfff8, 0x04d0},
	{m68020_chk2_cmp2_di_32  , 13, 0xfff8, 0x04e8},
	{m68020_chk2_cmp2_ix_32  , 13, 0xfff8, 0x04f0},
	{m68020_chk2_cmp2_aw_32  , 16, 0xffff, 0x04f8},
	{m68020_chk2_cmp2_al_32  , 16, 0xffff, 0x04f9},
	{m68020_chk2_cmp2_pcdi_32, 16, 0xffff, 0x04fa},
	{m68020_chk2_cmp2_pcix_32, 16, 0xffff, 0x04fb},
	{m68000_clr_d_8          , 13, 0xfff8, 0x4200},
	{m68000_clr_ai_8         , 13, 0xfff8, 0x4210},
	{m68000_clr_pi_8         , 13, 0xfff8, 0x4218},
	{m68000_clr_pi7_8        , 16, 0xffff, 0x421f},
	{m68000_clr_pd_8         , 13, 0xfff8, 0x4220},
	{m68000_clr_pd7_8        , 16, 0xffff, 0x4227},
	{m68000_clr_di_8         , 13, 0xfff8, 0x4228},
	{m68000_clr_ix_8         , 13, 0xfff8, 0x4230},
	{m68000_clr_aw_8         , 16, 0xffff, 0x4238},
	{m68000_clr_al_8         , 16, 0xffff, 0x4239},
	{m68000_clr_d_16         , 13, 0xfff8, 0x4240},
	{m68000_clr_ai_16        , 13, 0xfff8, 0x4250},
	{m68000_clr_pi_16        , 13, 0xfff8, 0x4258},
	{m68000_clr_pd_16        , 13, 0xfff8, 0x4260},
	{m68000_clr_di_16        , 13, 0xfff8, 0x4268},
	{m68000_clr_ix_16        , 13, 0xfff8, 0x4270},
	{m68000_clr_aw_16        , 16, 0xffff, 0x4278},
	{m68000_clr_al_16        , 16, 0xffff, 0x4279},
	{m68000_clr_d_32         , 13, 0xfff8, 0x4280},
	{m68000_clr_ai_32        , 13, 0xfff8, 0x4290},
	{m68000_clr_pi_32        , 13, 0xfff8, 0x4298},
	{m68000_clr_pd_32        , 13, 0xfff8, 0x42a0},
	{m68000_clr_di_32        , 13, 0xfff8, 0x42a8},
	{m68000_clr_ix_32        , 13, 0xfff8, 0x42b0},
	{m68000_clr_aw_32        , 16, 0xffff, 0x42b8},
	{m68000_clr_al_32        , 16, 0xffff, 0x42b9},
	{m68000_cmp_d_8          , 10, 0xf1f8, 0xb000},
	{m68000_cmp_ai_8         , 10, 0xf1f8, 0xb010},
	{m68000_cmp_pi_8         , 10, 0xf1f8, 0xb018},
	{m68000_cmp_pi7_8        , 13, 0xf1ff, 0xb01f},
	{m68000_cmp_pd_8         , 10, 0xf1f8, 0xb020},
	{m68000_cmp_pd7_8        , 13, 0xf1ff, 0xb027},
	{m68000_cmp_di_8         , 10, 0xf1f8, 0xb028},
	{m68000_cmp_ix_8         , 10, 0xf1f8, 0xb030},
	{m68000_cmp_aw_8         , 13, 0xf1ff, 0xb038},
	{m68000_cmp_al_8         , 13, 0xf1ff, 0xb039},
	{m68000_cmp_pcdi_8       , 13, 0xf1ff, 0xb03a},
	{m68000_cmp_pcix_8       , 13, 0xf1ff, 0xb03b},
	{m68000_cmp_i_8          , 13, 0xf1ff, 0xb03c},
	{m68000_cmp_d_16         , 10, 0xf1f8, 0xb040},
	{m68000_cmp_a_16         , 10, 0xf1f8, 0xb048},
	{m68000_cmp_ai_16        , 10, 0xf1f8, 0xb050},
	{m68000_cmp_pi_16        , 10, 0xf1f8, 0xb058},
	{m68000_cmp_pd_16        , 10, 0xf1f8, 0xb060},
	{m68000_cmp_di_16        , 10, 0xf1f8, 0xb068},
	{m68000_cmp_ix_16        , 10, 0xf1f8, 0xb070},
	{m68000_cmp_aw_16        , 13, 0xf1ff, 0xb078},
	{m68000_cmp_al_16        , 13, 0xf1ff, 0xb079},
	{m68000_cmp_pcdi_16      , 13, 0xf1ff, 0xb07a},
	{m68000_cmp_pcix_16      , 13, 0xf1ff, 0xb07b},
	{m68000_cmp_i_16         , 13, 0xf1ff, 0xb07c},
	{m68000_cmp_d_32         , 10, 0xf1f8, 0xb080},
	{m68000_cmp_a_32         , 10, 0xf1f8, 0xb088},
	{m68000_cmp_ai_32        , 10, 0xf1f8, 0xb090},
	{m68000_cmp_pi_32        , 10, 0xf1f8, 0xb098},
	{m68000_cmp_pd_32        , 10, 0xf1f8, 0xb0a0},
	{m68000_cmp_di_32        , 10, 0xf1f8, 0xb0a8},
	{m68000_cmp_ix_32        , 10, 0xf1f8, 0xb0b0},
	{m68000_cmp_aw_32        , 13, 0xf1ff, 0xb0b8},
	{m68000_cmp_al_32        , 13, 0xf1ff, 0xb0b9},
	{m68000_cmp_pcdi_32      , 13, 0xf1ff, 0xb0ba},
	{m68000_cmp_pcix_32      , 13, 0xf1ff, 0xb0bb},
	{m68000_cmp_i_32         , 13, 0xf1ff, 0xb0bc},
	{m68000_cmpa_d_16        , 10, 0xf1f8, 0xb0c0},
	{m68000_cmpa_a_16        , 10, 0xf1f8, 0xb0c8},
	{m68000_cmpa_ai_16       , 10, 0xf1f8, 0xb0d0},
	{m68000_cmpa_pi_16       , 10, 0xf1f8, 0xb0d8},
	{m68000_cmpa_pd_16       , 10, 0xf1f8, 0xb0e0},
	{m68000_cmpa_di_16       , 10, 0xf1f8, 0xb0e8},
	{m68000_cmpa_ix_16       , 10, 0xf1f8, 0xb0f0},
	{m68000_cmpa_aw_16       , 13, 0xf1ff, 0xb0f8},
	{m68000_cmpa_al_16       , 13, 0xf1ff, 0xb0f9},
	{m68000_cmpa_pcdi_16     , 13, 0xf1ff, 0xb0fa},
	{m68000_cmpa_pcix_16     , 13, 0xf1ff, 0xb0fb},
	{m68000_cmpa_i_16        , 13, 0xf1ff, 0xb0fc},
	{m68000_cmpa_d_32        , 10, 0xf1f8, 0xb1c0},
	{m68000_cmpa_a_32        , 10, 0xf1f8, 0xb1c8},
	{m68000_cmpa_ai_32       , 10, 0xf1f8, 0xb1d0},
	{m68000_cmpa_pi_32       , 10, 0xf1f8, 0xb1d8},
	{m68000_cmpa_pd_32       , 10, 0xf1f8, 0xb1e0},
	{m68000_cmpa_di_32       , 10, 0xf1f8, 0xb1e8},
	{m68000_cmpa_ix_32       , 10, 0xf1f8, 0xb1f0},
	{m68000_cmpa_aw_32       , 13, 0xf1ff, 0xb1f8},
	{m68000_cmpa_al_32       , 13, 0xf1ff, 0xb1f9},
	{m68000_cmpa_pcdi_32     , 13, 0xf1ff, 0xb1fa},
	{m68000_cmpa_pcix_32     , 13, 0xf1ff, 0xb1fb},
	{m68000_cmpa_i_32        , 13, 0xf1ff, 0xb1fc},
	{m68000_cmpi_d_8         , 13, 0xfff8, 0x0c00},
	{m68000_cmpi_ai_8        , 13, 0xfff8, 0x0c10},
	{m68000_cmpi_pi_8        , 13, 0xfff8, 0x0c18},
	{m68000_cmpi_pi7_8       , 16, 0xffff, 0x0c1f},
	{m68000_cmpi_pd_8        , 13, 0xfff8, 0x0c20},
	{m68000_cmpi_pd7_8       , 16, 0xffff, 0x0c27},
	{m68000_cmpi_di_8        , 13, 0xfff8, 0x0c28},
	{m68000_cmpi_ix_8        , 13, 0xfff8, 0x0c30},
	{m68000_cmpi_aw_8        , 16, 0xffff, 0x0c38},
	{m68000_cmpi_al_8        , 16, 0xffff, 0x0c39},
	{m68020_cmpi_pcdi_8      , 16, 0xffff, 0x0c3a},
	{m68020_cmpi_pcix_8      , 16, 0xffff, 0x0c3b},
	{m68000_cmpi_d_16        , 13, 0xfff8, 0x0c40},
	{m68000_cmpi_ai_16       , 13, 0xfff8, 0x0c50},
	{m68000_cmpi_pi_16       , 13, 0xfff8, 0x0c58},
	{m68000_cmpi_pd_16       , 13, 0xfff8, 0x0c60},
	{m68000_cmpi_di_16       , 13, 0xfff8, 0x0c68},
	{m68000_cmpi_ix_16       , 13, 0xfff8, 0x0c70},
	{m68000_cmpi_aw_16       , 16, 0xffff, 0x0c78},
	{m68000_cmpi_al_16       , 16, 0xffff, 0x0c79},
	{m68020_cmpi_pcdi_16     , 16, 0xffff, 0x0c7a},
	{m68020_cmpi_pcix_16     , 16, 0xffff, 0x0c7b},
	{m68000_cmpi_d_32        , 13, 0xfff8, 0x0c80},
	{m68000_cmpi_ai_32       , 13, 0xfff8, 0x0c90},
	{m68000_cmpi_pi_32       , 13, 0xfff8, 0x0c98},
	{m68000_cmpi_pd_32       , 13, 0xfff8, 0x0ca0},
	{m68000_cmpi_di_32       , 13, 0xfff8, 0x0ca8},
	{m68000_cmpi_ix_32       , 13, 0xfff8, 0x0cb0},
	{m68000_cmpi_aw_32       , 16, 0xffff, 0x0cb8},
	{m68000_cmpi_al_32       , 16, 0xffff, 0x0cb9},
	{m68020_cmpi_pcdi_32     , 16, 0xffff, 0x0cba},
	{m68020_cmpi_pcix_32     , 16, 0xffff, 0x0cbb},
	{m68000_cmpm_8_ax7       , 13, 0xfff8, 0xbf08},
	{m68000_cmpm_8_ay7       , 13, 0xf1ff, 0xb10f},
	{m68000_cmpm_8_axy7      , 16, 0xffff, 0xbf0f},
	{m68000_cmpm_8           , 10, 0xf1f8, 0xb108},
	{m68000_cmpm_16          , 10, 0xf1f8, 0xb148},
	{m68000_cmpm_32          , 10, 0xf1f8, 0xb188},
	{m68020_cpbcc            ,  6, 0xf180, 0xf080},
	{m68020_cpdbcc           , 10, 0xf1f8, 0xf048},
	{m68020_cpgen            ,  7, 0xf1c0, 0xf000},
	{m68020_cpscc            ,  7, 0xf1c0, 0xf040},
	{m68020_cptrapcc         , 10, 0xf1f8, 0xf078},
	{m68000_dbt              , 13, 0xfff8, 0x50c8},
	{m68000_dbf              , 13, 0xfff8, 0x51c8},
	{m68000_dbhi             , 13, 0xfff8, 0x52c8},
	{m68000_dbls             , 13, 0xfff8, 0x53c8},
	{m68000_dbcc             , 13, 0xfff8, 0x54c8},
	{m68000_dbcs             , 13, 0xfff8, 0x55c8},
	{m68000_dbne             , 13, 0xfff8, 0x56c8},
	{m68000_dbeq             , 13, 0xfff8, 0x57c8},
	{m68000_dbvc             , 13, 0xfff8, 0x58c8},
	{m68000_dbvs             , 13, 0xfff8, 0x59c8},
	{m68000_dbpl             , 13, 0xfff8, 0x5ac8},
	{m68000_dbmi             , 13, 0xfff8, 0x5bc8},
	{m68000_dbge             , 13, 0xfff8, 0x5cc8},
	{m68000_dblt             , 13, 0xfff8, 0x5dc8},
	{m68000_dbgt             , 13, 0xfff8, 0x5ec8},
	{m68000_dble             , 13, 0xfff8, 0x5fc8},
	{m68000_divs_d_16        , 10, 0xf1f8, 0x81c0},
	{m68000_divs_ai_16       , 10, 0xf1f8, 0x81d0},
	{m68000_divs_pi_16       , 10, 0xf1f8, 0x81d8},
	{m68000_divs_pd_16       , 10, 0xf1f8, 0x81e0},
	{m68000_divs_di_16       , 10, 0xf1f8, 0x81e8},
	{m68000_divs_ix_16       , 10, 0xf1f8, 0x81f0},
	{m68000_divs_aw_16       , 13, 0xf1ff, 0x81f8},
	{m68000_divs_al_16       , 13, 0xf1ff, 0x81f9},
	{m68000_divs_pcdi_16     , 13, 0xf1ff, 0x81fa},
	{m68000_divs_pcix_16     , 13, 0xf1ff, 0x81fb},
	{m68000_divs_i_16        , 13, 0xf1ff, 0x81fc},
	{m68000_divu_d_16        , 10, 0xf1f8, 0x80c0},
	{m68000_divu_ai_16       , 10, 0xf1f8, 0x80d0},
	{m68000_divu_pi_16       , 10, 0xf1f8, 0x80d8},
	{m68000_divu_pd_16       , 10, 0xf1f8, 0x80e0},
	{m68000_divu_di_16       , 10, 0xf1f8, 0x80e8},
	{m68000_divu_ix_16       , 10, 0xf1f8, 0x80f0},
	{m68000_divu_aw_16       , 13, 0xf1ff, 0x80f8},
	{m68000_divu_al_16       , 13, 0xf1ff, 0x80f9},
	{m68000_divu_pcdi_16     , 13, 0xf1ff, 0x80fa},
	{m68000_divu_pcix_16     , 13, 0xf1ff, 0x80fb},
	{m68000_divu_i_16        , 13, 0xf1ff, 0x80fc},
	{m68020_divl_d_32        , 13, 0xfff8, 0x4c40},
	{m68020_divl_ai_32       , 13, 0xfff8, 0x4c50},
	{m68020_divl_pi_32       , 13, 0xfff8, 0x4c58},
	{m68020_divl_pd_32       , 13, 0xfff8, 0x4c60},
	{m68020_divl_di_32       , 13, 0xfff8, 0x4c68},
	{m68020_divl_ix_32       , 13, 0xfff8, 0x4c70},
	{m68020_divl_aw_32       , 16, 0xffff, 0x4c78},
	{m68020_divl_al_32       , 16, 0xffff, 0x4c79},
	{m68020_divl_pcdi_32     , 16, 0xffff, 0x4c7a},
	{m68020_divl_pcix_32     , 16, 0xffff, 0x4c7b},
	{m68020_divl_i_32        , 16, 0xffff, 0x4c7c},
	{m68000_eor_d_8          , 10, 0xf1f8, 0xb100},
	{m68000_eor_ai_8         , 10, 0xf1f8, 0xb110},
	{m68000_eor_pi_8         , 10, 0xf1f8, 0xb118},
	{m68000_eor_pi7_8        , 13, 0xf1ff, 0xb11f},
	{m68000_eor_pd_8         , 10, 0xf1f8, 0xb120},
	{m68000_eor_pd7_8        , 13, 0xf1ff, 0xb127},
	{m68000_eor_di_8         , 10, 0xf1f8, 0xb128},
	{m68000_eor_ix_8         , 10, 0xf1f8, 0xb130},
	{m68000_eor_aw_8         , 13, 0xf1ff, 0xb138},
	{m68000_eor_al_8         , 13, 0xf1ff, 0xb139},
	{m68000_eor_d_16         , 10, 0xf1f8, 0xb140},
	{m68000_eor_ai_16        , 10, 0xf1f8, 0xb150},
	{m68000_eor_pi_16        , 10, 0xf1f8, 0xb158},
	{m68000_eor_pd_16        , 10, 0xf1f8, 0xb160},
	{m68000_eor_di_16        , 10, 0xf1f8, 0xb168},
	{m68000_eor_ix_16        , 10, 0xf1f8, 0xb170},
	{m68000_eor_aw_16        , 13, 0xf1ff, 0xb178},
	{m68000_eor_al_16        , 13, 0xf1ff, 0xb179},
	{m68000_eor_d_32         , 10, 0xf1f8, 0xb180},
	{m68000_eor_ai_32        , 10, 0xf1f8, 0xb190},
	{m68000_eor_pi_32        , 10, 0xf1f8, 0xb198},
	{m68000_eor_pd_32        , 10, 0xf1f8, 0xb1a0},
	{m68000_eor_di_32        , 10, 0xf1f8, 0xb1a8},
	{m68000_eor_ix_32        , 10, 0xf1f8, 0xb1b0},
	{m68000_eor_aw_32        , 13, 0xf1ff, 0xb1b8},
	{m68000_eor_al_32        , 13, 0xf1ff, 0xb1b9},
	{m68000_eori_to_ccr      , 16, 0xffff, 0x0a3c},
	{m68000_eori_to_sr       , 16, 0xffff, 0x0a7c},
	{m68000_eori_d_8         , 13, 0xfff8, 0x0a00},
	{m68000_eori_ai_8        , 13, 0xfff8, 0x0a10},
	{m68000_eori_pi_8        , 13, 0xfff8, 0x0a18},
	{m68000_eori_pi7_8       , 16, 0xffff, 0x0a1f},
	{m68000_eori_pd_8        , 13, 0xfff8, 0x0a20},
	{m68000_eori_pd7_8       , 16, 0xffff, 0x0a27},
	{m68000_eori_di_8        , 13, 0xfff8, 0x0a28},
	{m68000_eori_ix_8        , 13, 0xfff8, 0x0a30},
	{m68000_eori_aw_8        , 16, 0xffff, 0x0a38},
	{m68000_eori_al_8        , 16, 0xffff, 0x0a39},
	{m68000_eori_d_16        , 13, 0xfff8, 0x0a40},
	{m68000_eori_ai_16       , 13, 0xfff8, 0x0a50},
	{m68000_eori_pi_16       , 13, 0xfff8, 0x0a58},
	{m68000_eori_pd_16       , 13, 0xfff8, 0x0a60},
	{m68000_eori_di_16       , 13, 0xfff8, 0x0a68},
	{m68000_eori_ix_16       , 13, 0xfff8, 0x0a70},
	{m68000_eori_aw_16       , 16, 0xffff, 0x0a78},
	{m68000_eori_al_16       , 16, 0xffff, 0x0a79},
	{m68000_eori_d_32        , 13, 0xfff8, 0x0a80},
	{m68000_eori_ai_32       , 13, 0xfff8, 0x0a90},
	{m68000_eori_pi_32       , 13, 0xfff8, 0x0a98},
	{m68000_eori_pd_32       , 13, 0xfff8, 0x0aa0},
	{m68000_eori_di_32       , 13, 0xfff8, 0x0aa8},
	{m68000_eori_ix_32       , 13, 0xfff8, 0x0ab0},
	{m68000_eori_aw_32       , 16, 0xffff, 0x0ab8},
	{m68000_eori_al_32       , 16, 0xffff, 0x0ab9},
	{m68000_exg_dd           , 10, 0xf1f8, 0xc140},
	{m68000_exg_aa           , 10, 0xf1f8, 0xc148},
	{m68000_exg_da           , 10, 0xf1f8, 0xc188},
	{m68000_ext_16           , 13, 0xfff8, 0x4880},
	{m68000_ext_32           , 13, 0xfff8, 0x48c0},
	{m68020_extb             , 13, 0xfff8, 0x49c0},
	{m68000_illegal          , 16, 0xffff, 0x4afc},
	{m68000_jmp_ai           , 13, 0xfff8, 0x4ed0},
	{m68000_jmp_di           , 13, 0xfff8, 0x4ee8},
	{m68000_jmp_ix           , 13, 0xfff8, 0x4ef0},
	{m68000_jmp_aw           , 16, 0xffff, 0x4ef8},
	{m68000_jmp_al           , 16, 0xffff, 0x4ef9},
	{m68000_jmp_pcdi         , 16, 0xffff, 0x4efa},
	{m68000_jmp_pcix         , 16, 0xffff, 0x4efb},
	{m68000_jsr_ai           , 13, 0xfff8, 0x4e90},
	{m68000_jsr_di           , 13, 0xfff8, 0x4ea8},
	{m68000_jsr_ix           , 13, 0xfff8, 0x4eb0},
	{m68000_jsr_aw           , 16, 0xffff, 0x4eb8},
	{m68000_jsr_al           , 16, 0xffff, 0x4eb9},
	{m68000_jsr_pcdi         , 16, 0xffff, 0x4eba},
	{m68000_jsr_pcix         , 16, 0xffff, 0x4ebb},
	{m68000_lea_ai           , 10, 0xf1f8, 0x41d0},
	{m68000_lea_di           , 10, 0xf1f8, 0x41e8},
	{m68000_lea_ix           , 10, 0xf1f8, 0x41f0},
	{m68000_lea_aw           , 13, 0xf1ff, 0x41f8},
	{m68000_lea_al           , 13, 0xf1ff, 0x41f9},
	{m68000_lea_pcdi         , 13, 0xf1ff, 0x41fa},
	{m68000_lea_pcix         , 13, 0xf1ff, 0x41fb},
	{m68000_link_16_a7       , 16, 0xffff, 0x4e57},
	{m68000_link_16          , 13, 0xfff8, 0x4e50},
	{m68020_link_32_a7       , 16, 0xffff, 0x480f},
	{m68020_link_32          , 13, 0xfff8, 0x4808},
	{m68000_lsr_s_8          , 10, 0xf1f8, 0xe008},
	{m68000_lsr_s_16         , 10, 0xf1f8, 0xe048},
	{m68000_lsr_s_32         , 10, 0xf1f8, 0xe088},
	{m68000_lsr_r_8          , 10, 0xf1f8, 0xe028},
	{m68000_lsr_r_16         , 10, 0xf1f8, 0xe068},
	{m68000_lsr_r_32         , 10, 0xf1f8, 0xe0a8},
	{m68000_lsr_ea_ai        , 13, 0xfff8, 0xe2d0},
	{m68000_lsr_ea_pi        , 13, 0xfff8, 0xe2d8},
	{m68000_lsr_ea_pd        , 13, 0xfff8, 0xe2e0},
	{m68000_lsr_ea_di        , 13, 0xfff8, 0xe2e8},
	{m68000_lsr_ea_ix        , 13, 0xfff8, 0xe2f0},
	{m68000_lsr_ea_aw        , 16, 0xffff, 0xe2f8},
	{m68000_lsr_ea_al        , 16, 0xffff, 0xe2f9},
	{m68000_lsl_s_8          , 10, 0xf1f8, 0xe108},
	{m68000_lsl_s_16         , 10, 0xf1f8, 0xe148},
	{m68000_lsl_s_32         , 10, 0xf1f8, 0xe188},
	{m68000_lsl_r_8          , 10, 0xf1f8, 0xe128},
	{m68000_lsl_r_16         , 10, 0xf1f8, 0xe168},
	{m68000_lsl_r_32         , 10, 0xf1f8, 0xe1a8},
	{m68000_lsl_ea_ai        , 13, 0xfff8, 0xe3d0},
	{m68000_lsl_ea_pi        , 13, 0xfff8, 0xe3d8},
	{m68000_lsl_ea_pd        , 13, 0xfff8, 0xe3e0},
	{m68000_lsl_ea_di        , 13, 0xfff8, 0xe3e8},
	{m68000_lsl_ea_ix        , 13, 0xfff8, 0xe3f0},
	{m68000_lsl_ea_aw        , 16, 0xffff, 0xe3f8},
	{m68000_lsl_ea_al        , 16, 0xffff, 0xe3f9},
	{m68000_move_dd_d_8      , 10, 0xf1f8, 0x1000},
	{m68000_move_dd_ai_8     , 10, 0xf1f8, 0x1010},
	{m68000_move_dd_pi_8     , 10, 0xf1f8, 0x1018},
	{m68000_move_dd_pi7_8    , 13, 0xf1ff, 0x101f},
	{m68000_move_dd_pd_8     , 10, 0xf1f8, 0x1020},
	{m68000_move_dd_pd7_8    , 13, 0xf1ff, 0x1027},
	{m68000_move_dd_di_8     , 10, 0xf1f8, 0x1028},
	{m68000_move_dd_ix_8     , 10, 0xf1f8, 0x1030},
	{m68000_move_dd_aw_8     , 13, 0xf1ff, 0x1038},
	{m68000_move_dd_al_8     , 13, 0xf1ff, 0x1039},
	{m68000_move_dd_pcdi_8   , 13, 0xf1ff, 0x103a},
	{m68000_move_dd_pcix_8   , 13, 0xf1ff, 0x103b},
	{m68000_move_dd_i_8      , 13, 0xf1ff, 0x103c},
	{m68000_move_ai_d_8      , 10, 0xf1f8, 0x1080},
	{m68000_move_ai_ai_8     , 10, 0xf1f8, 0x1090},
	{m68000_move_ai_pi_8     , 10, 0xf1f8, 0x1098},
	{m68000_move_ai_pi7_8    , 13, 0xf1ff, 0x109f},
	{m68000_move_ai_pd_8     , 10, 0xf1f8, 0x10a0},
	{m68000_move_ai_pd7_8    , 13, 0xf1ff, 0x10a7},
	{m68000_move_ai_di_8     , 10, 0xf1f8, 0x10a8},
	{m68000_move_ai_ix_8     , 10, 0xf1f8, 0x10b0},
	{m68000_move_ai_aw_8     , 13, 0xf1ff, 0x10b8},
	{m68000_move_ai_al_8     , 13, 0xf1ff, 0x10b9},
	{m68000_move_ai_pcdi_8   , 13, 0xf1ff, 0x10ba},
	{m68000_move_ai_pcix_8   , 13, 0xf1ff, 0x10bb},
	{m68000_move_ai_i_8      , 13, 0xf1ff, 0x10bc},
	{m68000_move_pi_d_8      , 10, 0xf1f8, 0x10c0},
	{m68000_move_pi_ai_8     , 10, 0xf1f8, 0x10d0},
	{m68000_move_pi_pi_8     , 10, 0xf1f8, 0x10d8},
	{m68000_move_pi_pi7_8    , 13, 0xf1ff, 0x10df},
	{m68000_move_pi_pd_8     , 10, 0xf1f8, 0x10e0},
	{m68000_move_pi_pd7_8    , 13, 0xf1ff, 0x10e7},
	{m68000_move_pi_di_8     , 10, 0xf1f8, 0x10e8},
	{m68000_move_pi_ix_8     , 10, 0xf1f8, 0x10f0},
	{m68000_move_pi_aw_8     , 13, 0xf1ff, 0x10f8},
	{m68000_move_pi_al_8     , 13, 0xf1ff, 0x10f9},
	{m68000_move_pi_pcdi_8   , 13, 0xf1ff, 0x10fa},
	{m68000_move_pi_pcix_8   , 13, 0xf1ff, 0x10fb},
	{m68000_move_pi_i_8      , 13, 0xf1ff, 0x10fc},
	{m68000_move_pi7_d_8     , 13, 0xfff8, 0x1ec0},
	{m68000_move_pi7_ai_8    , 13, 0xfff8, 0x1ed0},
	{m68000_move_pi7_pi_8    , 13, 0xfff8, 0x1ed8},
	{m68000_move_pi7_pi7_8   , 16, 0xffff, 0x1edf},
	{m68000_move_pi7_pd_8    , 13, 0xfff8, 0x1ee0},
	{m68000_move_pi7_pd7_8   , 16, 0xffff, 0x1ee7},
	{m68000_move_pi7_di_8    , 13, 0xfff8, 0x1ee8},
	{m68000_move_pi7_ix_8    , 13, 0xfff8, 0x1ef0},
	{m68000_move_pi7_aw_8    , 16, 0xffff, 0x1ef8},
	{m68000_move_pi7_al_8    , 16, 0xffff, 0x1ef9},
	{m68000_move_pi7_pcdi_8  , 16, 0xffff, 0x1efa},
	{m68000_move_pi7_pcix_8  , 16, 0xffff, 0x1efb},
	{m68000_move_pi7_i_8     , 16, 0xffff, 0x1efc},
	{m68000_move_pd_d_8      , 10, 0xf1f8, 0x1100},
	{m68000_move_pd_ai_8     , 10, 0xf1f8, 0x1110},
	{m68000_move_pd_pi_8     , 10, 0xf1f8, 0x1118},
	{m68000_move_pd_pi7_8    , 13, 0xf1ff, 0x111f},
	{m68000_move_pd_pd_8     , 10, 0xf1f8, 0x1120},
	{m68000_move_pd_pd7_8    , 13, 0xf1ff, 0x1127},
	{m68000_move_pd_di_8     , 10, 0xf1f8, 0x1128},
	{m68000_move_pd_ix_8     , 10, 0xf1f8, 0x1130},
	{m68000_move_pd_aw_8     , 13, 0xf1ff, 0x1138},
	{m68000_move_pd_al_8     , 13, 0xf1ff, 0x1139},
	{m68000_move_pd_pcdi_8   , 13, 0xf1ff, 0x113a},
	{m68000_move_pd_pcix_8   , 13, 0xf1ff, 0x113b},
	{m68000_move_pd_i_8      , 13, 0xf1ff, 0x113c},
	{m68000_move_pd7_d_8     , 13, 0xfff8, 0x1f00},
	{m68000_move_pd7_ai_8    , 13, 0xfff8, 0x1f10},
	{m68000_move_pd7_pi_8    , 13, 0xfff8, 0x1f18},
	{m68000_move_pd7_pi7_8   , 16, 0xffff, 0x1f1f},
	{m68000_move_pd7_pd_8    , 13, 0xfff8, 0x1f20},
	{m68000_move_pd7_pd7_8   , 16, 0xffff, 0x1f27},
	{m68000_move_pd7_di_8    , 13, 0xfff8, 0x1f28},
	{m68000_move_pd7_ix_8    , 13, 0xfff8, 0x1f30},
	{m68000_move_pd7_aw_8    , 16, 0xffff, 0x1f38},
	{m68000_move_pd7_al_8    , 16, 0xffff, 0x1f39},
	{m68000_move_pd7_pcdi_8  , 16, 0xffff, 0x1f3a},
	{m68000_move_pd7_pcix_8  , 16, 0xffff, 0x1f3b},
	{m68000_move_pd7_i_8     , 16, 0xffff, 0x1f3c},
	{m68000_move_di_d_8      , 10, 0xf1f8, 0x1140},
	{m68000_move_di_ai_8     , 10, 0xf1f8, 0x1150},
	{m68000_move_di_pi_8     , 10, 0xf1f8, 0x1158},
	{m68000_move_di_pi7_8    , 13, 0xf1ff, 0x115f},
	{m68000_move_di_pd_8     , 10, 0xf1f8, 0x1160},
	{m68000_move_di_pd7_8    , 13, 0xf1ff, 0x1167},
	{m68000_move_di_di_8     , 10, 0xf1f8, 0x1168},
	{m68000_move_di_ix_8     , 10, 0xf1f8, 0x1170},
	{m68000_move_di_aw_8     , 13, 0xf1ff, 0x1178},
	{m68000_move_di_al_8     , 13, 0xf1ff, 0x1179},
	{m68000_move_di_pcdi_8   , 13, 0xf1ff, 0x117a},
	{m68000_move_di_pcix_8   , 13, 0xf1ff, 0x117b},
	{m68000_move_di_i_8      , 13, 0xf1ff, 0x117c},
	{m68000_move_ix_d_8      , 10, 0xf1f8, 0x1180},
	{m68000_move_ix_ai_8     , 10, 0xf1f8, 0x1190},
	{m68000_move_ix_pi_8     , 10, 0xf1f8, 0x1198},
	{m68000_move_ix_pi7_8    , 13, 0xf1ff, 0x119f},
	{m68000_move_ix_pd_8     , 10, 0xf1f8, 0x11a0},
	{m68000_move_ix_pd7_8    , 13, 0xf1ff, 0x11a7},
	{m68000_move_ix_di_8     , 10, 0xf1f8, 0x11a8},
	{m68000_move_ix_ix_8     , 10, 0xf1f8, 0x11b0},
	{m68000_move_ix_aw_8     , 13, 0xf1ff, 0x11b8},
	{m68000_move_ix_al_8     , 13, 0xf1ff, 0x11b9},
	{m68000_move_ix_pcdi_8   , 13, 0xf1ff, 0x11ba},
	{m68000_move_ix_pcix_8   , 13, 0xf1ff, 0x11bb},
	{m68000_move_ix_i_8      , 13, 0xf1ff, 0x11bc},
	{m68000_move_aw_d_8      , 13, 0xfff8, 0x11c0},
	{m68000_move_aw_ai_8     , 13, 0xfff8, 0x11d0},
	{m68000_move_aw_pi_8     , 13, 0xfff8, 0x11d8},
	{m68000_move_aw_pi7_8    , 16, 0xffff, 0x11df},
	{m68000_move_aw_pd_8     , 13, 0xfff8, 0x11e0},
	{m68000_move_aw_pd7_8    , 16, 0xffff, 0x11e7},
	{m68000_move_aw_di_8     , 13, 0xfff8, 0x11e8},
	{m68000_move_aw_ix_8     , 13, 0xfff8, 0x11f0},
	{m68000_move_aw_aw_8     , 16, 0xffff, 0x11f8},
	{m68000_move_aw_al_8     , 16, 0xffff, 0x11f9},
	{m68000_move_aw_pcdi_8   , 16, 0xffff, 0x11fa},
	{m68000_move_aw_pcix_8   , 16, 0xffff, 0x11fb},
	{m68000_move_aw_i_8      , 16, 0xffff, 0x11fc},
	{m68000_move_al_d_8      , 13, 0xfff8, 0x13c0},
	{m68000_move_al_ai_8     , 13, 0xfff8, 0x13d0},
	{m68000_move_al_pi_8     , 13, 0xfff8, 0x13d8},
	{m68000_move_al_pi7_8    , 16, 0xffff, 0x13df},
	{m68000_move_al_pd_8     , 13, 0xfff8, 0x13e0},
	{m68000_move_al_pd7_8    , 16, 0xffff, 0x13e7},
	{m68000_move_al_di_8     , 13, 0xfff8, 0x13e8},
	{m68000_move_al_ix_8     , 13, 0xfff8, 0x13f0},
	{m68000_move_al_aw_8     , 16, 0xffff, 0x13f8},
	{m68000_move_al_al_8     , 16, 0xffff, 0x13f9},
	{m68000_move_al_pcdi_8   , 16, 0xffff, 0x13fa},
	{m68000_move_al_pcix_8   , 16, 0xffff, 0x13fb},
	{m68000_move_al_i_8      , 16, 0xffff, 0x13fc},
	{m68000_move_dd_d_16     , 10, 0xf1f8, 0x3000},
	{m68000_move_dd_a_16     , 10, 0xf1f8, 0x3008},
	{m68000_move_dd_ai_16    , 10, 0xf1f8, 0x3010},
	{m68000_move_dd_pi_16    , 10, 0xf1f8, 0x3018},
	{m68000_move_dd_pd_16    , 10, 0xf1f8, 0x3020},
	{m68000_move_dd_di_16    , 10, 0xf1f8, 0x3028},
	{m68000_move_dd_ix_16    , 10, 0xf1f8, 0x3030},
	{m68000_move_dd_aw_16    , 13, 0xf1ff, 0x3038},
	{m68000_move_dd_al_16    , 13, 0xf1ff, 0x3039},
	{m68000_move_dd_pcdi_16  , 13, 0xf1ff, 0x303a},
	{m68000_move_dd_pcix_16  , 13, 0xf1ff, 0x303b},
	{m68000_move_dd_i_16     , 13, 0xf1ff, 0x303c},
	{m68000_move_ai_d_16     , 10, 0xf1f8, 0x3080},
	{m68000_move_ai_a_16     , 10, 0xf1f8, 0x3088},
	{m68000_move_ai_ai_16    , 10, 0xf1f8, 0x3090},
	{m68000_move_ai_pi_16    , 10, 0xf1f8, 0x3098},
	{m68000_move_ai_pd_16    , 10, 0xf1f8, 0x30a0},
	{m68000_move_ai_di_16    , 10, 0xf1f8, 0x30a8},
	{m68000_move_ai_ix_16    , 10, 0xf1f8, 0x30b0},
	{m68000_move_ai_aw_16    , 13, 0xf1ff, 0x30b8},
	{m68000_move_ai_al_16    , 13, 0xf1ff, 0x30b9},
	{m68000_move_ai_pcdi_16  , 13, 0xf1ff, 0x30ba},
	{m68000_move_ai_pcix_16  , 13, 0xf1ff, 0x30bb},
	{m68000_move_ai_i_16     , 13, 0xf1ff, 0x30bc},
	{m68000_move_pi_d_16     , 10, 0xf1f8, 0x30c0},
	{m68000_move_pi_a_16     , 10, 0xf1f8, 0x30c8},
	{m68000_move_pi_ai_16    , 10, 0xf1f8, 0x30d0},
	{m68000_move_pi_pi_16    , 10, 0xf1f8, 0x30d8},
	{m68000_move_pi_pd_16    , 10, 0xf1f8, 0x30e0},
	{m68000_move_pi_di_16    , 10, 0xf1f8, 0x30e8},
	{m68000_move_pi_ix_16    , 10, 0xf1f8, 0x30f0},
	{m68000_move_pi_aw_16    , 13, 0xf1ff, 0x30f8},
	{m68000_move_pi_al_16    , 13, 0xf1ff, 0x30f9},
	{m68000_move_pi_pcdi_16  , 13, 0xf1ff, 0x30fa},
	{m68000_move_pi_pcix_16  , 13, 0xf1ff, 0x30fb},
	{m68000_move_pi_i_16     , 13, 0xf1ff, 0x30fc},
	{m68000_move_pd_d_16     , 10, 0xf1f8, 0x3100},
	{m68000_move_pd_a_16     , 10, 0xf1f8, 0x3108},
	{m68000_move_pd_ai_16    , 10, 0xf1f8, 0x3110},
	{m68000_move_pd_pi_16    , 10, 0xf1f8, 0x3118},
	{m68000_move_pd_pd_16    , 10, 0xf1f8, 0x3120},
	{m68000_move_pd_di_16    , 10, 0xf1f8, 0x3128},
	{m68000_move_pd_ix_16    , 10, 0xf1f8, 0x3130},
	{m68000_move_pd_aw_16    , 13, 0xf1ff, 0x3138},
	{m68000_move_pd_al_16    , 13, 0xf1ff, 0x3139},
	{m68000_move_pd_pcdi_16  , 13, 0xf1ff, 0x313a},
	{m68000_move_pd_pcix_16  , 13, 0xf1ff, 0x313b},
	{m68000_move_pd_i_16     , 13, 0xf1ff, 0x313c},
	{m68000_move_di_d_16     , 10, 0xf1f8, 0x3140},
	{m68000_move_di_a_16     , 10, 0xf1f8, 0x3148},
	{m68000_move_di_ai_16    , 10, 0xf1f8, 0x3150},
	{m68000_move_di_pi_16    , 10, 0xf1f8, 0x3158},
	{m68000_move_di_pd_16    , 10, 0xf1f8, 0x3160},
	{m68000_move_di_di_16    , 10, 0xf1f8, 0x3168},
	{m68000_move_di_ix_16    , 10, 0xf1f8, 0x3170},
	{m68000_move_di_aw_16    , 13, 0xf1ff, 0x3178},
	{m68000_move_di_al_16    , 13, 0xf1ff, 0x3179},
	{m68000_move_di_pcdi_16  , 13, 0xf1ff, 0x317a},
	{m68000_move_di_pcix_16  , 13, 0xf1ff, 0x317b},
	{m68000_move_di_i_16     , 13, 0xf1ff, 0x317c},
	{m68000_move_ix_d_16     , 10, 0xf1f8, 0x3180},
	{m68000_move_ix_a_16     , 10, 0xf1f8, 0x3188},
	{m68000_move_ix_ai_16    , 10, 0xf1f8, 0x3190},
	{m68000_move_ix_pi_16    , 10, 0xf1f8, 0x3198},
	{m68000_move_ix_pd_16    , 10, 0xf1f8, 0x31a0},
	{m68000_move_ix_di_16    , 10, 0xf1f8, 0x31a8},
	{m68000_move_ix_ix_16    , 10, 0xf1f8, 0x31b0},
	{m68000_move_ix_aw_16    , 13, 0xf1ff, 0x31b8},
	{m68000_move_ix_al_16    , 13, 0xf1ff, 0x31b9},
	{m68000_move_ix_pcdi_16  , 13, 0xf1ff, 0x31ba},
	{m68000_move_ix_pcix_16  , 13, 0xf1ff, 0x31bb},
	{m68000_move_ix_i_16     , 13, 0xf1ff, 0x31bc},
	{m68000_move_aw_d_16     , 13, 0xfff8, 0x31c0},
	{m68000_move_aw_a_16     , 13, 0xfff8, 0x31c8},
	{m68000_move_aw_ai_16    , 13, 0xfff8, 0x31d0},
	{m68000_move_aw_pi_16    , 13, 0xfff8, 0x31d8},
	{m68000_move_aw_pd_16    , 13, 0xfff8, 0x31e0},
	{m68000_move_aw_di_16    , 13, 0xfff8, 0x31e8},
	{m68000_move_aw_ix_16    , 13, 0xfff8, 0x31f0},
	{m68000_move_aw_aw_16    , 16, 0xffff, 0x31f8},
	{m68000_move_aw_al_16    , 16, 0xffff, 0x31f9},
	{m68000_move_aw_pcdi_16  , 16, 0xffff, 0x31fa},
	{m68000_move_aw_pcix_16  , 16, 0xffff, 0x31fb},
	{m68000_move_aw_i_16     , 16, 0xffff, 0x31fc},
	{m68000_move_al_d_16     , 13, 0xfff8, 0x33c0},
	{m68000_move_al_a_16     , 13, 0xfff8, 0x33c8},
	{m68000_move_al_ai_16    , 13, 0xfff8, 0x33d0},
	{m68000_move_al_pi_16    , 13, 0xfff8, 0x33d8},
	{m68000_move_al_pd_16    , 13, 0xfff8, 0x33e0},
	{m68000_move_al_di_16    , 13, 0xfff8, 0x33e8},
	{m68000_move_al_ix_16    , 13, 0xfff8, 0x33f0},
	{m68000_move_al_aw_16    , 16, 0xffff, 0x33f8},
	{m68000_move_al_al_16    , 16, 0xffff, 0x33f9},
	{m68000_move_al_pcdi_16  , 16, 0xffff, 0x33fa},
	{m68000_move_al_pcix_16  , 16, 0xffff, 0x33fb},
	{m68000_move_al_i_16     , 16, 0xffff, 0x33fc},
	{m68000_move_dd_d_32     , 10, 0xf1f8, 0x2000},
	{m68000_move_dd_a_32     , 10, 0xf1f8, 0x2008},
	{m68000_move_dd_ai_32    , 10, 0xf1f8, 0x2010},
	{m68000_move_dd_pi_32    , 10, 0xf1f8, 0x2018},
	{m68000_move_dd_pd_32    , 10, 0xf1f8, 0x2020},
	{m68000_move_dd_di_32    , 10, 0xf1f8, 0x2028},
	{m68000_move_dd_ix_32    , 10, 0xf1f8, 0x2030},
	{m68000_move_dd_aw_32    , 13, 0xf1ff, 0x2038},
	{m68000_move_dd_al_32    , 13, 0xf1ff, 0x2039},
	{m68000_move_dd_pcdi_32  , 13, 0xf1ff, 0x203a},
	{m68000_move_dd_pcix_32  , 13, 0xf1ff, 0x203b},
	{m68000_move_dd_i_32     , 13, 0xf1ff, 0x203c},
	{m68000_move_ai_d_32     , 10, 0xf1f8, 0x2080},
	{m68000_move_ai_a_32     , 10, 0xf1f8, 0x2088},
	{m68000_move_ai_ai_32    , 10, 0xf1f8, 0x2090},
	{m68000_move_ai_pi_32    , 10, 0xf1f8, 0x2098},
	{m68000_move_ai_pd_32    , 10, 0xf1f8, 0x20a0},
	{m68000_move_ai_di_32    , 10, 0xf1f8, 0x20a8},
	{m68000_move_ai_ix_32    , 10, 0xf1f8, 0x20b0},
	{m68000_move_ai_aw_32    , 13, 0xf1ff, 0x20b8},
	{m68000_move_ai_al_32    , 13, 0xf1ff, 0x20b9},
	{m68000_move_ai_pcdi_32  , 13, 0xf1ff, 0x20ba},
	{m68000_move_ai_pcix_32  , 13, 0xf1ff, 0x20bb},
	{m68000_move_ai_i_32     , 13, 0xf1ff, 0x20bc},
	{m68000_move_pi_d_32     , 10, 0xf1f8, 0x20c0},
	{m68000_move_pi_a_32     , 10, 0xf1f8, 0x20c8},
	{m68000_move_pi_ai_32    , 10, 0xf1f8, 0x20d0},
	{m68000_move_pi_pi_32    , 10, 0xf1f8, 0x20d8},
	{m68000_move_pi_pd_32    , 10, 0xf1f8, 0x20e0},
	{m68000_move_pi_di_32    , 10, 0xf1f8, 0x20e8},
	{m68000_move_pi_ix_32    , 10, 0xf1f8, 0x20f0},
	{m68000_move_pi_aw_32    , 13, 0xf1ff, 0x20f8},
	{m68000_move_pi_al_32    , 13, 0xf1ff, 0x20f9},
	{m68000_move_pi_pcdi_32  , 13, 0xf1ff, 0x20fa},
	{m68000_move_pi_pcix_32  , 13, 0xf1ff, 0x20fb},
	{m68000_move_pi_i_32     , 13, 0xf1ff, 0x20fc},
	{m68000_move_pd_d_32     , 10, 0xf1f8, 0x2100},
	{m68000_move_pd_a_32     , 10, 0xf1f8, 0x2108},
	{m68000_move_pd_ai_32    , 10, 0xf1f8, 0x2110},
	{m68000_move_pd_pi_32    , 10, 0xf1f8, 0x2118},
	{m68000_move_pd_pd_32    , 10, 0xf1f8, 0x2120},
	{m68000_move_pd_di_32    , 10, 0xf1f8, 0x2128},
	{m68000_move_pd_ix_32    , 10, 0xf1f8, 0x2130},
	{m68000_move_pd_aw_32    , 13, 0xf1ff, 0x2138},
	{m68000_move_pd_al_32    , 13, 0xf1ff, 0x2139},
	{m68000_move_pd_pcdi_32  , 13, 0xf1ff, 0x213a},
	{m68000_move_pd_pcix_32  , 13, 0xf1ff, 0x213b},
	{m68000_move_pd_i_32     , 13, 0xf1ff, 0x213c},
	{m68000_move_di_d_32     , 10, 0xf1f8, 0x2140},
	{m68000_move_di_a_32     , 10, 0xf1f8, 0x2148},
	{m68000_move_di_ai_32    , 10, 0xf1f8, 0x2150},
	{m68000_move_di_pi_32    , 10, 0xf1f8, 0x2158},
	{m68000_move_di_pd_32    , 10, 0xf1f8, 0x2160},
	{m68000_move_di_di_32    , 10, 0xf1f8, 0x2168},
	{m68000_move_di_ix_32    , 10, 0xf1f8, 0x2170},
	{m68000_move_di_aw_32    , 13, 0xf1ff, 0x2178},
	{m68000_move_di_al_32    , 13, 0xf1ff, 0x2179},
	{m68000_move_di_pcdi_32  , 13, 0xf1ff, 0x217a},
	{m68000_move_di_pcix_32  , 13, 0xf1ff, 0x217b},
	{m68000_move_di_i_32     , 13, 0xf1ff, 0x217c},
	{m68000_move_ix_d_32     , 10, 0xf1f8, 0x2180},
	{m68000_move_ix_a_32     , 10, 0xf1f8, 0x2188},
	{m68000_move_ix_ai_32    , 10, 0xf1f8, 0x2190},
	{m68000_move_ix_pi_32    , 10, 0xf1f8, 0x2198},
	{m68000_move_ix_pd_32    , 10, 0xf1f8, 0x21a0},
	{m68000_move_ix_di_32    , 10, 0xf1f8, 0x21a8},
	{m68000_move_ix_ix_32    , 10, 0xf1f8, 0x21b0},
	{m68000_move_ix_aw_32    , 13, 0xf1ff, 0x21b8},
	{m68000_move_ix_al_32    , 13, 0xf1ff, 0x21b9},
	{m68000_move_ix_pcdi_32  , 13, 0xf1ff, 0x21ba},
	{m68000_move_ix_pcix_32  , 13, 0xf1ff, 0x21bb},
	{m68000_move_ix_i_32     , 13, 0xf1ff, 0x21bc},
	{m68000_move_aw_d_32     , 13, 0xfff8, 0x21c0},
	{m68000_move_aw_a_32     , 13, 0xfff8, 0x21c8},
	{m68000_move_aw_ai_32    , 13, 0xfff8, 0x21d0},
	{m68000_move_aw_pi_32    , 13, 0xfff8, 0x21d8},
	{m68000_move_aw_pd_32    , 13, 0xfff8, 0x21e0},
	{m68000_move_aw_di_32    , 13, 0xfff8, 0x21e8},
	{m68000_move_aw_ix_32    , 13, 0xfff8, 0x21f0},
	{m68000_move_aw_aw_32    , 16, 0xffff, 0x21f8},
	{m68000_move_aw_al_32    , 16, 0xffff, 0x21f9},
	{m68000_move_aw_pcdi_32  , 16, 0xffff, 0x21fa},
	{m68000_move_aw_pcix_32  , 16, 0xffff, 0x21fb},
	{m68000_move_aw_i_32     , 16, 0xffff, 0x21fc},
	{m68000_move_al_d_32     , 13, 0xfff8, 0x23c0},
	{m68000_move_al_a_32     , 13, 0xfff8, 0x23c8},
	{m68000_move_al_ai_32    , 13, 0xfff8, 0x23d0},
	{m68000_move_al_pi_32    , 13, 0xfff8, 0x23d8},
	{m68000_move_al_pd_32    , 13, 0xfff8, 0x23e0},
	{m68000_move_al_di_32    , 13, 0xfff8, 0x23e8},
	{m68000_move_al_ix_32    , 13, 0xfff8, 0x23f0},
	{m68000_move_al_aw_32    , 16, 0xffff, 0x23f8},
	{m68000_move_al_al_32    , 16, 0xffff, 0x23f9},
	{m68000_move_al_pcdi_32  , 16, 0xffff, 0x23fa},
	{m68000_move_al_pcix_32  , 16, 0xffff, 0x23fb},
	{m68000_move_al_i_32     , 16, 0xffff, 0x23fc},
	{m68000_movea_d_16       , 10, 0xf1f8, 0x3040},
	{m68000_movea_a_16       , 10, 0xf1f8, 0x3048},
	{m68000_movea_ai_16      , 10, 0xf1f8, 0x3050},
	{m68000_movea_pi_16      , 10, 0xf1f8, 0x3058},
	{m68000_movea_pd_16      , 10, 0xf1f8, 0x3060},
	{m68000_movea_di_16      , 10, 0xf1f8, 0x3068},
	{m68000_movea_ix_16      , 10, 0xf1f8, 0x3070},
	{m68000_movea_aw_16      , 13, 0xf1ff, 0x3078},
	{m68000_movea_al_16      , 13, 0xf1ff, 0x3079},
	{m68000_movea_pcdi_16    , 13, 0xf1ff, 0x307a},
	{m68000_movea_pcix_16    , 13, 0xf1ff, 0x307b},
	{m68000_movea_i_16       , 13, 0xf1ff, 0x307c},
	{m68000_movea_d_32       , 10, 0xf1f8, 0x2040},
	{m68000_movea_a_32       , 10, 0xf1f8, 0x2048},
	{m68000_movea_ai_32      , 10, 0xf1f8, 0x2050},
	{m68000_movea_pi_32      , 10, 0xf1f8, 0x2058},
	{m68000_movea_pd_32      , 10, 0xf1f8, 0x2060},
	{m68000_movea_di_32      , 10, 0xf1f8, 0x2068},
	{m68000_movea_ix_32      , 10, 0xf1f8, 0x2070},
	{m68000_movea_aw_32      , 13, 0xf1ff, 0x2078},
	{m68000_movea_al_32      , 13, 0xf1ff, 0x2079},
	{m68000_movea_pcdi_32    , 13, 0xf1ff, 0x207a},
	{m68000_movea_pcix_32    , 13, 0xf1ff, 0x207b},
	{m68000_movea_i_32       , 13, 0xf1ff, 0x207c},
	{m68010_move_fr_ccr_d    , 13, 0xfff8, 0x42c0},
	{m68010_move_fr_ccr_ai   , 13, 0xfff8, 0x42d0},
	{m68010_move_fr_ccr_pi   , 13, 0xfff8, 0x42d8},
	{m68010_move_fr_ccr_pd   , 13, 0xfff8, 0x42e0},
	{m68010_move_fr_ccr_di   , 13, 0xfff8, 0x42e8},
	{m68010_move_fr_ccr_ix   , 13, 0xfff8, 0x42f0},
	{m68010_move_fr_ccr_aw   , 16, 0xffff, 0x42f8},
	{m68010_move_fr_ccr_al   , 16, 0xffff, 0x42f9},
	{m68000_move_to_ccr_d    , 13, 0xfff8, 0x44c0},
	{m68000_move_to_ccr_ai   , 13, 0xfff8, 0x44d0},
	{m68000_move_to_ccr_pi   , 13, 0xfff8, 0x44d8},
	{m68000_move_to_ccr_pd   , 13, 0xfff8, 0x44e0},
	{m68000_move_to_ccr_di   , 13, 0xfff8, 0x44e8},
	{m68000_move_to_ccr_ix   , 13, 0xfff8, 0x44f0},
	{m68000_move_to_ccr_aw   , 16, 0xffff, 0x44f8},
	{m68000_move_to_ccr_al   , 16, 0xffff, 0x44f9},
	{m68000_move_to_ccr_pcdi , 16, 0xffff, 0x44fa},
	{m68000_move_to_ccr_pcix , 16, 0xffff, 0x44fb},
	{m68000_move_to_ccr_i    , 16, 0xffff, 0x44fc},
	{m68000_move_fr_sr_d     , 13, 0xfff8, 0x40c0},
	{m68000_move_fr_sr_ai    , 13, 0xfff8, 0x40d0},
	{m68000_move_fr_sr_pi    , 13, 0xfff8, 0x40d8},
	{m68000_move_fr_sr_pd    , 13, 0xfff8, 0x40e0},
	{m68000_move_fr_sr_di    , 13, 0xfff8, 0x40e8},
	{m68000_move_fr_sr_ix    , 13, 0xfff8, 0x40f0},
	{m68000_move_fr_sr_aw    , 16, 0xffff, 0x40f8},
	{m68000_move_fr_sr_al    , 16, 0xffff, 0x40f9},
	{m68000_move_to_sr_d     , 13, 0xfff8, 0x46c0},
	{m68000_move_to_sr_ai    , 13, 0xfff8, 0x46d0},
	{m68000_move_to_sr_pi    , 13, 0xfff8, 0x46d8},
	{m68000_move_to_sr_pd    , 13, 0xfff8, 0x46e0},
	{m68000_move_to_sr_di    , 13, 0xfff8, 0x46e8},
	{m68000_move_to_sr_ix    , 13, 0xfff8, 0x46f0},
	{m68000_move_to_sr_aw    , 16, 0xffff, 0x46f8},
	{m68000_move_to_sr_al    , 16, 0xffff, 0x46f9},
	{m68000_move_to_sr_pcdi  , 16, 0xffff, 0x46fa},
	{m68000_move_to_sr_pcix  , 16, 0xffff, 0x46fb},
	{m68000_move_to_sr_i     , 16, 0xffff, 0x46fc},
	{m68000_move_fr_usp      , 13, 0xfff8, 0x4e68},
	{m68000_move_to_usp      , 13, 0xfff8, 0x4e60},
	{m68010_movec_cr         , 16, 0xffff, 0x4e7a},
	{m68010_movec_rc         , 16, 0xffff, 0x4e7b},
	{m68000_movem_pd_16      , 13, 0xfff8, 0x48a0},
	{m68000_movem_pd_32      , 13, 0xfff8, 0x48e0},
	{m68000_movem_pi_16      , 13, 0xfff8, 0x4c98},
	{m68000_movem_pi_32      , 13, 0xfff8, 0x4cd8},
	{m68000_movem_re_ai_16   , 13, 0xfff8, 0x4890},
	{m68000_movem_re_di_16   , 13, 0xfff8, 0x48a8},
	{m68000_movem_re_ix_16   , 13, 0xfff8, 0x48b0},
	{m68000_movem_re_aw_16   , 16, 0xffff, 0x48b8},
	{m68000_movem_re_al_16   , 16, 0xffff, 0x48b9},
	{m68000_movem_re_ai_32   , 13, 0xfff8, 0x48d0},
	{m68000_movem_re_di_32   , 13, 0xfff8, 0x48e8},
	{m68000_movem_re_ix_32   , 13, 0xfff8, 0x48f0},
	{m68000_movem_re_aw_32   , 16, 0xffff, 0x48f8},
	{m68000_movem_re_al_32   , 16, 0xffff, 0x48f9},
	{m68000_movem_er_ai_16   , 13, 0xfff8, 0x4c90},
	{m68000_movem_er_di_16   , 13, 0xfff8, 0x4ca8},
	{m68000_movem_er_ix_16   , 13, 0xfff8, 0x4cb0},
	{m68000_movem_er_aw_16   , 16, 0xffff, 0x4cb8},
	{m68000_movem_er_al_16   , 16, 0xffff, 0x4cb9},
	{m68000_movem_er_pcdi_16 , 16, 0xffff, 0x4cba},
	{m68000_movem_er_pcix_16 , 16, 0xffff, 0x4cbb},
	{m68000_movem_er_ai_32   , 13, 0xfff8, 0x4cd0},
	{m68000_movem_er_di_32   , 13, 0xfff8, 0x4ce8},
	{m68000_movem_er_ix_32   , 13, 0xfff8, 0x4cf0},
	{m68000_movem_er_aw_32   , 16, 0xffff, 0x4cf8},
	{m68000_movem_er_al_32   , 16, 0xffff, 0x4cf9},
	{m68000_movem_er_pcdi_32 , 16, 0xffff, 0x4cfa},
	{m68000_movem_er_pcix_32 , 16, 0xffff, 0x4cfb},
	{m68000_movep_er_16      , 10, 0xf1f8, 0x0108},
	{m68000_movep_er_32      , 10, 0xf1f8, 0x0148},
	{m68000_movep_re_16      , 10, 0xf1f8, 0x0188},
	{m68000_movep_re_32      , 10, 0xf1f8, 0x01c8},
	{m68010_moves_ai_8       , 13, 0xfff8, 0x0e10},
	{m68010_moves_pi_8       , 13, 0xfff8, 0x0e18},
	{m68010_moves_pi7_8      , 16, 0xffff, 0x0e1f},
	{m68010_moves_pd_8       , 13, 0xfff8, 0x0e20},
	{m68010_moves_pd7_8      , 16, 0xffff, 0x0e27},
	{m68010_moves_di_8       , 13, 0xfff8, 0x0e28},
	{m68010_moves_ix_8       , 13, 0xfff8, 0x0e30},
	{m68010_moves_aw_8       , 16, 0xffff, 0x0e38},
	{m68010_moves_al_8       , 16, 0xffff, 0x0e39},
	{m68010_moves_ai_16      , 13, 0xfff8, 0x0e50},
	{m68010_moves_pi_16      , 13, 0xfff8, 0x0e58},
	{m68010_moves_pd_16      , 13, 0xfff8, 0x0e60},
	{m68010_moves_di_16      , 13, 0xfff8, 0x0e68},
	{m68010_moves_ix_16      , 13, 0xfff8, 0x0e70},
	{m68010_moves_aw_16      , 16, 0xffff, 0x0e78},
	{m68010_moves_al_16      , 16, 0xffff, 0x0e79},
	{m68010_moves_ai_32      , 13, 0xfff8, 0x0e90},
	{m68010_moves_pi_32      , 13, 0xfff8, 0x0e98},
	{m68010_moves_pd_32      , 13, 0xfff8, 0x0ea0},
	{m68010_moves_di_32      , 13, 0xfff8, 0x0ea8},
	{m68010_moves_ix_32      , 13, 0xfff8, 0x0eb0},
	{m68010_moves_aw_32      , 16, 0xffff, 0x0eb8},
	{m68010_moves_al_32      , 16, 0xffff, 0x0eb9},
	{m68000_moveq            ,  5, 0xf100, 0x7000},
	{m68000_muls_d_16        , 10, 0xf1f8, 0xc1c0},
	{m68000_muls_ai_16       , 10, 0xf1f8, 0xc1d0},
	{m68000_muls_pi_16       , 10, 0xf1f8, 0xc1d8},
	{m68000_muls_pd_16       , 10, 0xf1f8, 0xc1e0},
	{m68000_muls_di_16       , 10, 0xf1f8, 0xc1e8},
	{m68000_muls_ix_16       , 10, 0xf1f8, 0xc1f0},
	{m68000_muls_aw_16       , 13, 0xf1ff, 0xc1f8},
	{m68000_muls_al_16       , 13, 0xf1ff, 0xc1f9},
	{m68000_muls_pcdi_16     , 13, 0xf1ff, 0xc1fa},
	{m68000_muls_pcix_16     , 13, 0xf1ff, 0xc1fb},
	{m68000_muls_i_16        , 13, 0xf1ff, 0xc1fc},
	{m68000_mulu_d_16        , 10, 0xf1f8, 0xc0c0},
	{m68000_mulu_ai_16       , 10, 0xf1f8, 0xc0d0},
	{m68000_mulu_pi_16       , 10, 0xf1f8, 0xc0d8},
	{m68000_mulu_pd_16       , 10, 0xf1f8, 0xc0e0},
	{m68000_mulu_di_16       , 10, 0xf1f8, 0xc0e8},
	{m68000_mulu_ix_16       , 10, 0xf1f8, 0xc0f0},
	{m68000_mulu_aw_16       , 13, 0xf1ff, 0xc0f8},
	{m68000_mulu_al_16       , 13, 0xf1ff, 0xc0f9},
	{m68000_mulu_pcdi_16     , 13, 0xf1ff, 0xc0fa},
	{m68000_mulu_pcix_16     , 13, 0xf1ff, 0xc0fb},
	{m68000_mulu_i_16        , 13, 0xf1ff, 0xc0fc},
	{m68020_mull_d_32        , 13, 0xfff8, 0x4c00},
	{m68020_mull_ai_32       , 13, 0xfff8, 0x4c10},
	{m68020_mull_pi_32       , 13, 0xfff8, 0x4c18},
	{m68020_mull_pd_32       , 13, 0xfff8, 0x4c20},
	{m68020_mull_di_32       , 13, 0xfff8, 0x4c28},
	{m68020_mull_ix_32       , 13, 0xfff8, 0x4c30},
	{m68020_mull_aw_32       , 16, 0xffff, 0x4c38},
	{m68020_mull_al_32       , 16, 0xffff, 0x4c39},
	{m68020_mull_pcdi_32     , 16, 0xffff, 0x4c3a},
	{m68020_mull_pcix_32     , 16, 0xffff, 0x4c3b},
	{m68020_mull_i_32        , 16, 0xffff, 0x4c3c},
	{m68000_nbcd_d           , 13, 0xfff8, 0x4800},
	{m68000_nbcd_ai          , 13, 0xfff8, 0x4810},
	{m68000_nbcd_pi          , 13, 0xfff8, 0x4818},
	{m68000_nbcd_pi7         , 16, 0xffff, 0x481f},
	{m68000_nbcd_pd          , 13, 0xfff8, 0x4820},
	{m68000_nbcd_pd7         , 16, 0xffff, 0x4827},
	{m68000_nbcd_di          , 13, 0xfff8, 0x4828},
	{m68000_nbcd_ix          , 13, 0xfff8, 0x4830},
	{m68000_nbcd_aw          , 16, 0xffff, 0x4838},
	{m68000_nbcd_al          , 16, 0xffff, 0x4839},
	{m68000_neg_d_8          , 13, 0xfff8, 0x4400},
	{m68000_neg_ai_8         , 13, 0xfff8, 0x4410},
	{m68000_neg_pi_8         , 13, 0xfff8, 0x4418},
	{m68000_neg_pi7_8        , 16, 0xffff, 0x441f},
	{m68000_neg_pd_8         , 13, 0xfff8, 0x4420},
	{m68000_neg_pd7_8        , 16, 0xffff, 0x4427},
	{m68000_neg_di_8         , 13, 0xfff8, 0x4428},
	{m68000_neg_ix_8         , 13, 0xfff8, 0x4430},
	{m68000_neg_aw_8         , 16, 0xffff, 0x4438},
	{m68000_neg_al_8         , 16, 0xffff, 0x4439},
	{m68000_neg_d_16         , 13, 0xfff8, 0x4440},
	{m68000_neg_ai_16        , 13, 0xfff8, 0x4450},
	{m68000_neg_pi_16        , 13, 0xfff8, 0x4458},
	{m68000_neg_pd_16        , 13, 0xfff8, 0x4460},
	{m68000_neg_di_16        , 13, 0xfff8, 0x4468},
	{m68000_neg_ix_16        , 13, 0xfff8, 0x4470},
	{m68000_neg_aw_16        , 16, 0xffff, 0x4478},
	{m68000_neg_al_16        , 16, 0xffff, 0x4479},
	{m68000_neg_d_32         , 13, 0xfff8, 0x4480},
	{m68000_neg_ai_32        , 13, 0xfff8, 0x4490},
	{m68000_neg_pi_32        , 13, 0xfff8, 0x4498},
	{m68000_neg_pd_32        , 13, 0xfff8, 0x44a0},
	{m68000_neg_di_32        , 13, 0xfff8, 0x44a8},
	{m68000_neg_ix_32        , 13, 0xfff8, 0x44b0},
	{m68000_neg_aw_32        , 16, 0xffff, 0x44b8},
	{m68000_neg_al_32        , 16, 0xffff, 0x44b9},
	{m68000_negx_d_8         , 13, 0xfff8, 0x4000},
	{m68000_negx_ai_8        , 13, 0xfff8, 0x4010},
	{m68000_negx_pi_8        , 13, 0xfff8, 0x4018},
	{m68000_negx_pi7_8       , 16, 0xffff, 0x401f},
	{m68000_negx_pd_8        , 13, 0xfff8, 0x4020},
	{m68000_negx_pd7_8       , 16, 0xffff, 0x4027},
	{m68000_negx_di_8        , 13, 0xfff8, 0x4028},
	{m68000_negx_ix_8        , 13, 0xfff8, 0x4030},
	{m68000_negx_aw_8        , 16, 0xffff, 0x4038},
	{m68000_negx_al_8        , 16, 0xffff, 0x4039},
	{m68000_negx_d_16        , 13, 0xfff8, 0x4040},
	{m68000_negx_ai_16       , 13, 0xfff8, 0x4050},
	{m68000_negx_pi_16       , 13, 0xfff8, 0x4058},
	{m68000_negx_pd_16       , 13, 0xfff8, 0x4060},
	{m68000_negx_di_16       , 13, 0xfff8, 0x4068},
	{m68000_negx_ix_16       , 13, 0xfff8, 0x4070},
	{m68000_negx_aw_16       , 16, 0xffff, 0x4078},
	{m68000_negx_al_16       , 16, 0xffff, 0x4079},
	{m68000_negx_d_32        , 13, 0xfff8, 0x4080},
	{m68000_negx_ai_32       , 13, 0xfff8, 0x4090},
	{m68000_negx_pi_32       , 13, 0xfff8, 0x4098},
	{m68000_negx_pd_32       , 13, 0xfff8, 0x40a0},
	{m68000_negx_di_32       , 13, 0xfff8, 0x40a8},
	{m68000_negx_ix_32       , 13, 0xfff8, 0x40b0},
	{m68000_negx_aw_32       , 16, 0xffff, 0x40b8},
	{m68000_negx_al_32       , 16, 0xffff, 0x40b9},
	{m68000_nop              , 16, 0xffff, 0x4e71},
	{m68000_not_d_8          , 13, 0xfff8, 0x4600},
	{m68000_not_ai_8         , 13, 0xfff8, 0x4610},
	{m68000_not_pi_8         , 13, 0xfff8, 0x4618},
	{m68000_not_pi7_8        , 16, 0xffff, 0x461f},
	{m68000_not_pd_8         , 13, 0xfff8, 0x4620},
	{m68000_not_pd7_8        , 16, 0xffff, 0x4627},
	{m68000_not_di_8         , 13, 0xfff8, 0x4628},
	{m68000_not_ix_8         , 13, 0xfff8, 0x4630},
	{m68000_not_aw_8         , 16, 0xffff, 0x4638},
	{m68000_not_al_8         , 16, 0xffff, 0x4639},
	{m68000_not_d_16         , 13, 0xfff8, 0x4640},
	{m68000_not_ai_16        , 13, 0xfff8, 0x4650},
	{m68000_not_pi_16        , 13, 0xfff8, 0x4658},
	{m68000_not_pd_16        , 13, 0xfff8, 0x4660},
	{m68000_not_di_16        , 13, 0xfff8, 0x4668},
	{m68000_not_ix_16        , 13, 0xfff8, 0x4670},
	{m68000_not_aw_16        , 16, 0xffff, 0x4678},
	{m68000_not_al_16        , 16, 0xffff, 0x4679},
	{m68000_not_d_32         , 13, 0xfff8, 0x4680},
	{m68000_not_ai_32        , 13, 0xfff8, 0x4690},
	{m68000_not_pi_32        , 13, 0xfff8, 0x4698},
	{m68000_not_pd_32        , 13, 0xfff8, 0x46a0},
	{m68000_not_di_32        , 13, 0xfff8, 0x46a8},
	{m68000_not_ix_32        , 13, 0xfff8, 0x46b0},
	{m68000_not_aw_32        , 16, 0xffff, 0x46b8},
	{m68000_not_al_32        , 16, 0xffff, 0x46b9},
	{m68000_or_er_d_8        , 10, 0xf1f8, 0x8000},
	{m68000_or_er_ai_8       , 10, 0xf1f8, 0x8010},
	{m68000_or_er_pi_8       , 10, 0xf1f8, 0x8018},
	{m68000_or_er_pi7_8      , 13, 0xf1ff, 0x801f},
	{m68000_or_er_pd_8       , 10, 0xf1f8, 0x8020},
	{m68000_or_er_pd7_8      , 13, 0xf1ff, 0x8027},
	{m68000_or_er_di_8       , 10, 0xf1f8, 0x8028},
	{m68000_or_er_ix_8       , 10, 0xf1f8, 0x8030},
	{m68000_or_er_aw_8       , 13, 0xf1ff, 0x8038},
	{m68000_or_er_al_8       , 13, 0xf1ff, 0x8039},
	{m68000_or_er_pcdi_8     , 13, 0xf1ff, 0x803a},
	{m68000_or_er_pcix_8     , 13, 0xf1ff, 0x803b},
	{m68000_or_er_i_8        , 13, 0xf1ff, 0x803c},
	{m68000_or_er_d_16       , 10, 0xf1f8, 0x8040},
	{m68000_or_er_ai_16      , 10, 0xf1f8, 0x8050},
	{m68000_or_er_pi_16      , 10, 0xf1f8, 0x8058},
	{m68000_or_er_pd_16      , 10, 0xf1f8, 0x8060},
	{m68000_or_er_di_16      , 10, 0xf1f8, 0x8068},
	{m68000_or_er_ix_16      , 10, 0xf1f8, 0x8070},
	{m68000_or_er_aw_16      , 13, 0xf1ff, 0x8078},
	{m68000_or_er_al_16      , 13, 0xf1ff, 0x8079},
	{m68000_or_er_pcdi_16    , 13, 0xf1ff, 0x807a},
	{m68000_or_er_pcix_16    , 13, 0xf1ff, 0x807b},
	{m68000_or_er_i_16       , 13, 0xf1ff, 0x807c},
	{m68000_or_er_d_32       , 10, 0xf1f8, 0x8080},
	{m68000_or_er_ai_32      , 10, 0xf1f8, 0x8090},
	{m68000_or_er_pi_32      , 10, 0xf1f8, 0x8098},
	{m68000_or_er_pd_32      , 10, 0xf1f8, 0x80a0},
	{m68000_or_er_di_32      , 10, 0xf1f8, 0x80a8},
	{m68000_or_er_ix_32      , 10, 0xf1f8, 0x80b0},
	{m68000_or_er_aw_32      , 13, 0xf1ff, 0x80b8},
	{m68000_or_er_al_32      , 13, 0xf1ff, 0x80b9},
	{m68000_or_er_pcdi_32    , 13, 0xf1ff, 0x80ba},
	{m68000_or_er_pcix_32    , 13, 0xf1ff, 0x80bb},
	{m68000_or_er_i_32       , 13, 0xf1ff, 0x80bc},
	{m68000_or_re_ai_8       , 10, 0xf1f8, 0x8110},
	{m68000_or_re_pi_8       , 10, 0xf1f8, 0x8118},
	{m68000_or_re_pi7_8      , 13, 0xf1ff, 0x811f},
	{m68000_or_re_pd_8       , 10, 0xf1f8, 0x8120},
	{m68000_or_re_pd7_8      , 13, 0xf1ff, 0x8127},
	{m68000_or_re_di_8       , 10, 0xf1f8, 0x8128},
	{m68000_or_re_ix_8       , 10, 0xf1f8, 0x8130},
	{m68000_or_re_aw_8       , 13, 0xf1ff, 0x8138},
	{m68000_or_re_al_8       , 13, 0xf1ff, 0x8139},
	{m68000_or_re_ai_16      , 10, 0xf1f8, 0x8150},
	{m68000_or_re_pi_16      , 10, 0xf1f8, 0x8158},
	{m68000_or_re_pd_16      , 10, 0xf1f8, 0x8160},
	{m68000_or_re_di_16      , 10, 0xf1f8, 0x8168},
	{m68000_or_re_ix_16      , 10, 0xf1f8, 0x8170},
	{m68000_or_re_aw_16      , 13, 0xf1ff, 0x8178},
	{m68000_or_re_al_16      , 13, 0xf1ff, 0x8179},
	{m68000_or_re_ai_32      , 10, 0xf1f8, 0x8190},
	{m68000_or_re_pi_32      , 10, 0xf1f8, 0x8198},
	{m68000_or_re_pd_32      , 10, 0xf1f8, 0x81a0},
	{m68000_or_re_di_32      , 10, 0xf1f8, 0x81a8},
	{m68000_or_re_ix_32      , 10, 0xf1f8, 0x81b0},
	{m68000_or_re_aw_32      , 13, 0xf1ff, 0x81b8},
	{m68000_or_re_al_32      , 13, 0xf1ff, 0x81b9},
	{m68000_ori_to_ccr       , 16, 0xffff, 0x003c},
	{m68000_ori_to_sr        , 16, 0xffff, 0x007c},
	{m68000_ori_d_8          , 13, 0xfff8, 0x0000},
	{m68000_ori_ai_8         , 13, 0xfff8, 0x0010},
	{m68000_ori_pi_8         , 13, 0xfff8, 0x0018},
	{m68000_ori_pi7_8        , 16, 0xffff, 0x001f},
	{m68000_ori_pd_8         , 13, 0xfff8, 0x0020},
	{m68000_ori_pd7_8        , 16, 0xffff, 0x0027},
	{m68000_ori_di_8         , 13, 0xfff8, 0x0028},
	{m68000_ori_ix_8         , 13, 0xfff8, 0x0030},
	{m68000_ori_aw_8         , 16, 0xffff, 0x0038},
	{m68000_ori_al_8         , 16, 0xffff, 0x0039},
	{m68000_ori_d_16         , 13, 0xfff8, 0x0040},
	{m68000_ori_ai_16        , 13, 0xfff8, 0x0050},
	{m68000_ori_pi_16        , 13, 0xfff8, 0x0058},
	{m68000_ori_pd_16        , 13, 0xfff8, 0x0060},
	{m68000_ori_di_16        , 13, 0xfff8, 0x0068},
	{m68000_ori_ix_16        , 13, 0xfff8, 0x0070},
	{m68000_ori_aw_16        , 16, 0xffff, 0x0078},
	{m68000_ori_al_16        , 16, 0xffff, 0x0079},
	{m68000_ori_d_32         , 13, 0xfff8, 0x0080},
	{m68000_ori_ai_32        , 13, 0xfff8, 0x0090},
	{m68000_ori_pi_32        , 13, 0xfff8, 0x0098},
	{m68000_ori_pd_32        , 13, 0xfff8, 0x00a0},
	{m68000_ori_di_32        , 13, 0xfff8, 0x00a8},
	{m68000_ori_ix_32        , 13, 0xfff8, 0x00b0},
	{m68000_ori_aw_32        , 16, 0xffff, 0x00b8},
	{m68000_ori_al_32        , 16, 0xffff, 0x00b9},
	{m68020_pack_rr          , 10, 0xf1f8, 0x8140},
	{m68020_pack_mm_ax7      , 13, 0xf1ff, 0x814f},
	{m68020_pack_mm_ay7      , 13, 0xfff8, 0x8f48},
	{m68020_pack_mm_axy7     , 16, 0xffff, 0x8f4f},
	{m68020_pack_mm          , 10, 0xf1f8, 0x8148},
	{m68000_pea_ai           , 13, 0xfff8, 0x4850},
	{m68000_pea_di           , 13, 0xfff8, 0x4868},
	{m68000_pea_ix           , 13, 0xfff8, 0x4870},
	{m68000_pea_aw           , 16, 0xffff, 0x4878},
	{m68000_pea_al           , 16, 0xffff, 0x4879},
	{m68000_pea_pcdi         , 16, 0xffff, 0x487a},
	{m68000_pea_pcix         , 16, 0xffff, 0x487b},
	{m68000_rst              , 16, 0xffff, 0x4e70},
	{m68000_ror_s_8          , 10, 0xf1f8, 0xe018},
	{m68000_ror_s_16         , 10, 0xf1f8, 0xe058},
	{m68000_ror_s_32         , 10, 0xf1f8, 0xe098},
	{m68000_ror_r_8          , 10, 0xf1f8, 0xe038},
	{m68000_ror_r_16         , 10, 0xf1f8, 0xe078},
	{m68000_ror_r_32         , 10, 0xf1f8, 0xe0b8},
	{m68000_ror_ea_ai        , 13, 0xfff8, 0xe6d0},
	{m68000_ror_ea_pi        , 13, 0xfff8, 0xe6d8},
	{m68000_ror_ea_pd        , 13, 0xfff8, 0xe6e0},
	{m68000_ror_ea_di        , 13, 0xfff8, 0xe6e8},
	{m68000_ror_ea_ix        , 13, 0xfff8, 0xe6f0},
	{m68000_ror_ea_aw        , 16, 0xffff, 0xe6f8},
	{m68000_ror_ea_al        , 16, 0xffff, 0xe6f9},
	{m68000_rol_s_8          , 10, 0xf1f8, 0xe118},
	{m68000_rol_s_16         , 10, 0xf1f8, 0xe158},
	{m68000_rol_s_32         , 10, 0xf1f8, 0xe198},
	{m68000_rol_r_8          , 10, 0xf1f8, 0xe138},
	{m68000_rol_r_16         , 10, 0xf1f8, 0xe178},
	{m68000_rol_r_32         , 10, 0xf1f8, 0xe1b8},
	{m68000_rol_ea_ai        , 13, 0xfff8, 0xe7d0},
	{m68000_rol_ea_pi        , 13, 0xfff8, 0xe7d8},
	{m68000_rol_ea_pd        , 13, 0xfff8, 0xe7e0},
	{m68000_rol_ea_di        , 13, 0xfff8, 0xe7e8},
	{m68000_rol_ea_ix        , 13, 0xfff8, 0xe7f0},
	{m68000_rol_ea_aw        , 16, 0xffff, 0xe7f8},
	{m68000_rol_ea_al        , 16, 0xffff, 0xe7f9},
	{m68000_roxr_s_8         , 10, 0xf1f8, 0xe010},
	{m68000_roxr_s_16        , 10, 0xf1f8, 0xe050},
	{m68000_roxr_s_32        , 10, 0xf1f8, 0xe090},
	{m68000_roxr_r_8         , 10, 0xf1f8, 0xe030},
	{m68000_roxr_r_16        , 10, 0xf1f8, 0xe070},
	{m68000_roxr_r_32        , 10, 0xf1f8, 0xe0b0},
	{m68000_roxr_ea_ai       , 13, 0xfff8, 0xe4d0},
	{m68000_roxr_ea_pi       , 13, 0xfff8, 0xe4d8},
	{m68000_roxr_ea_pd       , 13, 0xfff8, 0xe4e0},
	{m68000_roxr_ea_di       , 13, 0xfff8, 0xe4e8},
	{m68000_roxr_ea_ix       , 13, 0xfff8, 0xe4f0},
	{m68000_roxr_ea_aw       , 16, 0xffff, 0xe4f8},
	{m68000_roxr_ea_al       , 16, 0xffff, 0xe4f9},
	{m68000_roxl_s_8         , 10, 0xf1f8, 0xe110},
	{m68000_roxl_s_16        , 10, 0xf1f8, 0xe150},
	{m68000_roxl_s_32        , 10, 0xf1f8, 0xe190},
	{m68000_roxl_r_8         , 10, 0xf1f8, 0xe130},
	{m68000_roxl_r_16        , 10, 0xf1f8, 0xe170},
	{m68000_roxl_r_32        , 10, 0xf1f8, 0xe1b0},
	{m68000_roxl_ea_ai       , 13, 0xfff8, 0xe5d0},
	{m68000_roxl_ea_pi       , 13, 0xfff8, 0xe5d8},
	{m68000_roxl_ea_pd       , 13, 0xfff8, 0xe5e0},
	{m68000_roxl_ea_di       , 13, 0xfff8, 0xe5e8},
	{m68000_roxl_ea_ix       , 13, 0xfff8, 0xe5f0},
	{m68000_roxl_ea_aw       , 16, 0xffff, 0xe5f8},
	{m68000_roxl_ea_al       , 16, 0xffff, 0xe5f9},
	{m68010_rtd              , 16, 0xffff, 0x4e74},
	{m68000_rte              , 16, 0xffff, 0x4e73},
	{m68020_rtm              , 12, 0xfff0, 0x06c0},
	{m68000_rtr              , 16, 0xffff, 0x4e77},
	{m68000_rts              , 16, 0xffff, 0x4e75},
	{m68000_sbcd_rr          , 10, 0xf1f8, 0x8100},
	{m68000_sbcd_mm_ax7      , 13, 0xfff8, 0x8f08},
	{m68000_sbcd_mm_ay7      , 13, 0xf1ff, 0x810f},
	{m68000_sbcd_mm_axy7     , 16, 0xffff, 0x8f0f},
	{m68000_sbcd_mm          , 10, 0xf1f8, 0x8108},
	{m68000_st_d             , 13, 0xfff8, 0x50c0},
	{m68000_st_ai            , 13, 0xfff8, 0x50d0},
	{m68000_st_pi            , 13, 0xfff8, 0x50d8},
	{m68000_st_pi7           , 16, 0xffff, 0x50df},
	{m68000_st_pd            , 13, 0xfff8, 0x50e0},
	{m68000_st_pd7           , 16, 0xffff, 0x50e7},
	{m68000_st_di            , 13, 0xfff8, 0x50e8},
	{m68000_st_ix            , 13, 0xfff8, 0x50f0},
	{m68000_st_aw            , 16, 0xffff, 0x50f8},
	{m68000_st_al            , 16, 0xffff, 0x50f9},
	{m68000_sf_d             , 13, 0xfff8, 0x51c0},
	{m68000_sf_ai            , 13, 0xfff8, 0x51d0},
	{m68000_sf_pi            , 13, 0xfff8, 0x51d8},
	{m68000_sf_pi7           , 16, 0xffff, 0x51df},
	{m68000_sf_pd            , 13, 0xfff8, 0x51e0},
	{m68000_sf_pd7           , 16, 0xffff, 0x51e7},
	{m68000_sf_di            , 13, 0xfff8, 0x51e8},
	{m68000_sf_ix            , 13, 0xfff8, 0x51f0},
	{m68000_sf_aw            , 16, 0xffff, 0x51f8},
	{m68000_sf_al            , 16, 0xffff, 0x51f9},
	{m68000_shi_d            , 13, 0xfff8, 0x52c0},
	{m68000_shi_ai           , 13, 0xfff8, 0x52d0},
	{m68000_shi_pi           , 13, 0xfff8, 0x52d8},
	{m68000_shi_pi7          , 16, 0xffff, 0x52df},
	{m68000_shi_pd           , 13, 0xfff8, 0x52e0},
	{m68000_shi_pd7          , 16, 0xffff, 0x52e7},
	{m68000_shi_di           , 13, 0xfff8, 0x52e8},
	{m68000_shi_ix           , 13, 0xfff8, 0x52f0},
	{m68000_shi_aw           , 16, 0xffff, 0x52f8},
	{m68000_shi_al           , 16, 0xffff, 0x52f9},
	{m68000_sls_d            , 13, 0xfff8, 0x53c0},
	{m68000_sls_ai           , 13, 0xfff8, 0x53d0},
	{m68000_sls_pi           , 13, 0xfff8, 0x53d8},
	{m68000_sls_pi7          , 16, 0xffff, 0x53df},
	{m68000_sls_pd           , 13, 0xfff8, 0x53e0},
	{m68000_sls_pd7          , 16, 0xffff, 0x53e7},
	{m68000_sls_di           , 13, 0xfff8, 0x53e8},
	{m68000_sls_ix           , 13, 0xfff8, 0x53f0},
	{m68000_sls_aw           , 16, 0xffff, 0x53f8},
	{m68000_sls_al           , 16, 0xffff, 0x53f9},
	{m68000_scc_d            , 13, 0xfff8, 0x54c0},
	{m68000_scc_ai           , 13, 0xfff8, 0x54d0},
	{m68000_scc_pi           , 13, 0xfff8, 0x54d8},
	{m68000_scc_pi7          , 16, 0xffff, 0x54df},
	{m68000_scc_pd           , 13, 0xfff8, 0x54e0},
	{m68000_scc_pd7          , 16, 0xffff, 0x54e7},
	{m68000_scc_di           , 13, 0xfff8, 0x54e8},
	{m68000_scc_ix           , 13, 0xfff8, 0x54f0},
	{m68000_scc_aw           , 16, 0xffff, 0x54f8},
	{m68000_scc_al           , 16, 0xffff, 0x54f9},
	{m68000_scs_d            , 13, 0xfff8, 0x55c0},
	{m68000_scs_ai           , 13, 0xfff8, 0x55d0},
	{m68000_scs_pi           , 13, 0xfff8, 0x55d8},
	{m68000_scs_pi7          , 16, 0xffff, 0x55df},
	{m68000_scs_pd           , 13, 0xfff8, 0x55e0},
	{m68000_scs_pd7          , 16, 0xffff, 0x55e7},
	{m68000_scs_di           , 13, 0xfff8, 0x55e8},
	{m68000_scs_ix           , 13, 0xfff8, 0x55f0},
	{m68000_scs_aw           , 16, 0xffff, 0x55f8},
	{m68000_scs_al           , 16, 0xffff, 0x55f9},
	{m68000_sne_d            , 13, 0xfff8, 0x56c0},
	{m68000_sne_ai           , 13, 0xfff8, 0x56d0},
	{m68000_sne_pi           , 13, 0xfff8, 0x56d8},
	{m68000_sne_pi7          , 16, 0xffff, 0x56df},
	{m68000_sne_pd           , 13, 0xfff8, 0x56e0},
	{m68000_sne_pd7          , 16, 0xffff, 0x56e7},
	{m68000_sne_di           , 13, 0xfff8, 0x56e8},
	{m68000_sne_ix           , 13, 0xfff8, 0x56f0},
	{m68000_sne_aw           , 16, 0xffff, 0x56f8},
	{m68000_sne_al           , 16, 0xffff, 0x56f9},
	{m68000_seq_d            , 13, 0xfff8, 0x57c0},
	{m68000_seq_ai           , 13, 0xfff8, 0x57d0},
	{m68000_seq_pi           , 13, 0xfff8, 0x57d8},
	{m68000_seq_pi7          , 16, 0xffff, 0x57df},
	{m68000_seq_pd           , 13, 0xfff8, 0x57e0},
	{m68000_seq_pd7          , 16, 0xffff, 0x57e7},
	{m68000_seq_di           , 13, 0xfff8, 0x57e8},
	{m68000_seq_ix           , 13, 0xfff8, 0x57f0},
	{m68000_seq_aw           , 16, 0xffff, 0x57f8},
	{m68000_seq_al           , 16, 0xffff, 0x57f9},
	{m68000_svc_d            , 13, 0xfff8, 0x58c0},
	{m68000_svc_ai           , 13, 0xfff8, 0x58d0},
	{m68000_svc_pi           , 13, 0xfff8, 0x58d8},
	{m68000_svc_pi7          , 16, 0xffff, 0x58df},
	{m68000_svc_pd           , 13, 0xfff8, 0x58e0},
	{m68000_svc_pd7          , 16, 0xffff, 0x58e7},
	{m68000_svc_di           , 13, 0xfff8, 0x58e8},
	{m68000_svc_ix           , 13, 0xfff8, 0x58f0},
	{m68000_svc_aw           , 16, 0xffff, 0x58f8},
	{m68000_svc_al           , 16, 0xffff, 0x58f9},
	{m68000_svs_d            , 13, 0xfff8, 0x59c0},
	{m68000_svs_ai           , 13, 0xfff8, 0x59d0},
	{m68000_svs_pi           , 13, 0xfff8, 0x59d8},
	{m68000_svs_pi7          , 16, 0xffff, 0x59df},
	{m68000_svs_pd           , 13, 0xfff8, 0x59e0},
	{m68000_svs_pd7          , 16, 0xffff, 0x59e7},
	{m68000_svs_di           , 13, 0xfff8, 0x59e8},
	{m68000_svs_ix           , 13, 0xfff8, 0x59f0},
	{m68000_svs_aw           , 16, 0xffff, 0x59f8},
	{m68000_svs_al           , 16, 0xffff, 0x59f9},
	{m68000_spl_d            , 13, 0xfff8, 0x5ac0},
	{m68000_spl_ai           , 13, 0xfff8, 0x5ad0},
	{m68000_spl_pi           , 13, 0xfff8, 0x5ad8},
	{m68000_spl_pi7          , 16, 0xffff, 0x5adf},
	{m68000_spl_pd           , 13, 0xfff8, 0x5ae0},
	{m68000_spl_pd7          , 16, 0xffff, 0x5ae7},
	{m68000_spl_di           , 13, 0xfff8, 0x5ae8},
	{m68000_spl_ix           , 13, 0xfff8, 0x5af0},
	{m68000_spl_aw           , 16, 0xffff, 0x5af8},
	{m68000_spl_al           , 16, 0xffff, 0x5af9},
	{m68000_smi_d            , 13, 0xfff8, 0x5bc0},
	{m68000_smi_ai           , 13, 0xfff8, 0x5bd0},
	{m68000_smi_pi           , 13, 0xfff8, 0x5bd8},
	{m68000_smi_pi7          , 16, 0xffff, 0x5bdf},
	{m68000_smi_pd           , 13, 0xfff8, 0x5be0},
	{m68000_smi_pd7          , 16, 0xffff, 0x5be7},
	{m68000_smi_di           , 13, 0xfff8, 0x5be8},
	{m68000_smi_ix           , 13, 0xfff8, 0x5bf0},
	{m68000_smi_aw           , 16, 0xffff, 0x5bf8},
	{m68000_smi_al           , 16, 0xffff, 0x5bf9},
	{m68000_sge_d            , 13, 0xfff8, 0x5cc0},
	{m68000_sge_ai           , 13, 0xfff8, 0x5cd0},
	{m68000_sge_pi           , 13, 0xfff8, 0x5cd8},
	{m68000_sge_pi7          , 16, 0xffff, 0x5cdf},
	{m68000_sge_pd           , 13, 0xfff8, 0x5ce0},
	{m68000_sge_pd7          , 16, 0xffff, 0x5ce7},
	{m68000_sge_di           , 13, 0xfff8, 0x5ce8},
	{m68000_sge_ix           , 13, 0xfff8, 0x5cf0},
	{m68000_sge_aw           , 16, 0xffff, 0x5cf8},
	{m68000_sge_al           , 16, 0xffff, 0x5cf9},
	{m68000_slt_d            , 13, 0xfff8, 0x5dc0},
	{m68000_slt_ai           , 13, 0xfff8, 0x5dd0},
	{m68000_slt_pi           , 13, 0xfff8, 0x5dd8},
	{m68000_slt_pi7          , 16, 0xffff, 0x5ddf},
	{m68000_slt_pd           , 13, 0xfff8, 0x5de0},
	{m68000_slt_pd7          , 16, 0xffff, 0x5de7},
	{m68000_slt_di           , 13, 0xfff8, 0x5de8},
	{m68000_slt_ix           , 13, 0xfff8, 0x5df0},
	{m68000_slt_aw           , 16, 0xffff, 0x5df8},
	{m68000_slt_al           , 16, 0xffff, 0x5df9},
	{m68000_sgt_d            , 13, 0xfff8, 0x5ec0},
	{m68000_sgt_ai           , 13, 0xfff8, 0x5ed0},
	{m68000_sgt_pi           , 13, 0xfff8, 0x5ed8},
	{m68000_sgt_pi7          , 16, 0xffff, 0x5edf},
	{m68000_sgt_pd           , 13, 0xfff8, 0x5ee0},
	{m68000_sgt_pd7          , 16, 0xffff, 0x5ee7},
	{m68000_sgt_di           , 13, 0xfff8, 0x5ee8},
	{m68000_sgt_ix           , 13, 0xfff8, 0x5ef0},
	{m68000_sgt_aw           , 16, 0xffff, 0x5ef8},
	{m68000_sgt_al           , 16, 0xffff, 0x5ef9},
	{m68000_sle_d            , 13, 0xfff8, 0x5fc0},
	{m68000_sle_ai           , 13, 0xfff8, 0x5fd0},
	{m68000_sle_pi           , 13, 0xfff8, 0x5fd8},
	{m68000_sle_pi7          , 16, 0xffff, 0x5fdf},
	{m68000_sle_pd           , 13, 0xfff8, 0x5fe0},
	{m68000_sle_pd7          , 16, 0xffff, 0x5fe7},
	{m68000_sle_di           , 13, 0xfff8, 0x5fe8},
	{m68000_sle_ix           , 13, 0xfff8, 0x5ff0},
	{m68000_sle_aw           , 16, 0xffff, 0x5ff8},
	{m68000_sle_al           , 16, 0xffff, 0x5ff9},
	{m68000_stop             , 16, 0xffff, 0x4e72},
	{m68000_sub_er_d_8       , 10, 0xf1f8, 0x9000},
	{m68000_sub_er_ai_8      , 10, 0xf1f8, 0x9010},
	{m68000_sub_er_pi_8      , 10, 0xf1f8, 0x9018},
	{m68000_sub_er_pi7_8     , 13, 0xf1ff, 0x901f},
	{m68000_sub_er_pd_8      , 10, 0xf1f8, 0x9020},
	{m68000_sub_er_pd7_8     , 13, 0xf1ff, 0x9027},
	{m68000_sub_er_di_8      , 10, 0xf1f8, 0x9028},
	{m68000_sub_er_ix_8      , 10, 0xf1f8, 0x9030},
	{m68000_sub_er_aw_8      , 13, 0xf1ff, 0x9038},
	{m68000_sub_er_al_8      , 13, 0xf1ff, 0x9039},
	{m68000_sub_er_pcdi_8    , 13, 0xf1ff, 0x903a},
	{m68000_sub_er_pcix_8    , 13, 0xf1ff, 0x903b},
	{m68000_sub_er_i_8       , 13, 0xf1ff, 0x903c},
	{m68000_sub_er_d_16      , 10, 0xf1f8, 0x9040},
	{m68000_sub_er_a_16      , 10, 0xf1f8, 0x9048},
	{m68000_sub_er_ai_16     , 10, 0xf1f8, 0x9050},
	{m68000_sub_er_pi_16     , 10, 0xf1f8, 0x9058},
	{m68000_sub_er_pd_16     , 10, 0xf1f8, 0x9060},
	{m68000_sub_er_di_16     , 10, 0xf1f8, 0x9068},
	{m68000_sub_er_ix_16     , 10, 0xf1f8, 0x9070},
	{m68000_sub_er_aw_16     , 13, 0xf1ff, 0x9078},
	{m68000_sub_er_al_16     , 13, 0xf1ff, 0x9079},
	{m68000_sub_er_pcdi_16   , 13, 0xf1ff, 0x907a},
	{m68000_sub_er_pcix_16   , 13, 0xf1ff, 0x907b},
	{m68000_sub_er_i_16      , 13, 0xf1ff, 0x907c},
	{m68000_sub_er_d_32      , 10, 0xf1f8, 0x9080},
	{m68000_sub_er_a_32      , 10, 0xf1f8, 0x9088},
	{m68000_sub_er_ai_32     , 10, 0xf1f8, 0x9090},
	{m68000_sub_er_pi_32     , 10, 0xf1f8, 0x9098},
	{m68000_sub_er_pd_32     , 10, 0xf1f8, 0x90a0},
	{m68000_sub_er_di_32     , 10, 0xf1f8, 0x90a8},
	{m68000_sub_er_ix_32     , 10, 0xf1f8, 0x90b0},
	{m68000_sub_er_aw_32     , 13, 0xf1ff, 0x90b8},
	{m68000_sub_er_al_32     , 13, 0xf1ff, 0x90b9},
	{m68000_sub_er_pcdi_32   , 13, 0xf1ff, 0x90ba},
	{m68000_sub_er_pcix_32   , 13, 0xf1ff, 0x90bb},
	{m68000_sub_er_i_32      , 13, 0xf1ff, 0x90bc},
	{m68000_sub_re_ai_8      , 10, 0xf1f8, 0x9110},
	{m68000_sub_re_pi_8      , 10, 0xf1f8, 0x9118},
	{m68000_sub_re_pi7_8     , 13, 0xf1ff, 0x911f},
	{m68000_sub_re_pd_8      , 10, 0xf1f8, 0x9120},
	{m68000_sub_re_pd7_8     , 13, 0xf1ff, 0x9127},
	{m68000_sub_re_di_8      , 10, 0xf1f8, 0x9128},
	{m68000_sub_re_ix_8      , 10, 0xf1f8, 0x9130},
	{m68000_sub_re_aw_8      , 13, 0xf1ff, 0x9138},
	{m68000_sub_re_al_8      , 13, 0xf1ff, 0x9139},
	{m68000_sub_re_ai_16     , 10, 0xf1f8, 0x9150},
	{m68000_sub_re_pi_16     , 10, 0xf1f8, 0x9158},
	{m68000_sub_re_pd_16     , 10, 0xf1f8, 0x9160},
	{m68000_sub_re_di_16     , 10, 0xf1f8, 0x9168},
	{m68000_sub_re_ix_16     , 10, 0xf1f8, 0x9170},
	{m68000_sub_re_aw_16     , 13, 0xf1ff, 0x9178},
	{m68000_sub_re_al_16     , 13, 0xf1ff, 0x9179},
	{m68000_sub_re_ai_32     , 10, 0xf1f8, 0x9190},
	{m68000_sub_re_pi_32     , 10, 0xf1f8, 0x9198},
	{m68000_sub_re_pd_32     , 10, 0xf1f8, 0x91a0},
	{m68000_sub_re_di_32     , 10, 0xf1f8, 0x91a8},
	{m68000_sub_re_ix_32     , 10, 0xf1f8, 0x91b0},
	{m68000_sub_re_aw_32     , 13, 0xf1ff, 0x91b8},
	{m68000_sub_re_al_32     , 13, 0xf1ff, 0x91b9},
	{m68000_suba_d_16        , 10, 0xf1f8, 0x90c0},
	{m68000_suba_a_16        , 10, 0xf1f8, 0x90c8},
	{m68000_suba_ai_16       , 10, 0xf1f8, 0x90d0},
	{m68000_suba_pi_16       , 10, 0xf1f8, 0x90d8},
	{m68000_suba_pd_16       , 10, 0xf1f8, 0x90e0},
	{m68000_suba_di_16       , 10, 0xf1f8, 0x90e8},
	{m68000_suba_ix_16       , 10, 0xf1f8, 0x90f0},
	{m68000_suba_aw_16       , 13, 0xf1ff, 0x90f8},
	{m68000_suba_al_16       , 13, 0xf1ff, 0x90f9},
	{m68000_suba_pcdi_16     , 13, 0xf1ff, 0x90fa},
	{m68000_suba_pcix_16     , 13, 0xf1ff, 0x90fb},
	{m68000_suba_i_16        , 13, 0xf1ff, 0x90fc},
	{m68000_suba_d_32        , 10, 0xf1f8, 0x91c0},
	{m68000_suba_a_32        , 10, 0xf1f8, 0x91c8},
	{m68000_suba_ai_32       , 10, 0xf1f8, 0x91d0},
	{m68000_suba_pi_32       , 10, 0xf1f8, 0x91d8},
	{m68000_suba_pd_32       , 10, 0xf1f8, 0x91e0},
	{m68000_suba_di_32       , 10, 0xf1f8, 0x91e8},
	{m68000_suba_ix_32       , 10, 0xf1f8, 0x91f0},
	{m68000_suba_aw_32       , 13, 0xf1ff, 0x91f8},
	{m68000_suba_al_32       , 13, 0xf1ff, 0x91f9},
	{m68000_suba_pcdi_32     , 13, 0xf1ff, 0x91fa},
	{m68000_suba_pcix_32     , 13, 0xf1ff, 0x91fb},
	{m68000_suba_i_32        , 13, 0xf1ff, 0x91fc},
	{m68000_subi_d_8         , 13, 0xfff8, 0x0400},
	{m68000_subi_ai_8        , 13, 0xfff8, 0x0410},
	{m68000_subi_pi_8        , 13, 0xfff8, 0x0418},
	{m68000_subi_pi7_8       , 16, 0xffff, 0x041f},
	{m68000_subi_pd_8        , 13, 0xfff8, 0x0420},
	{m68000_subi_pd7_8       , 16, 0xffff, 0x0427},
	{m68000_subi_di_8        , 13, 0xfff8, 0x0428},
	{m68000_subi_ix_8        , 13, 0xfff8, 0x0430},
	{m68000_subi_aw_8        , 16, 0xffff, 0x0438},
	{m68000_subi_al_8        , 16, 0xffff, 0x0439},
	{m68000_subi_d_16        , 13, 0xfff8, 0x0440},
	{m68000_subi_ai_16       , 13, 0xfff8, 0x0450},
	{m68000_subi_pi_16       , 13, 0xfff8, 0x0458},
	{m68000_subi_pd_16       , 13, 0xfff8, 0x0460},
	{m68000_subi_di_16       , 13, 0xfff8, 0x0468},
	{m68000_subi_ix_16       , 13, 0xfff8, 0x0470},
	{m68000_subi_aw_16       , 16, 0xffff, 0x0478},
	{m68000_subi_al_16       , 16, 0xffff, 0x0479},
	{m68000_subi_d_32        , 13, 0xfff8, 0x0480},
	{m68000_subi_ai_32       , 13, 0xfff8, 0x0490},
	{m68000_subi_pi_32       , 13, 0xfff8, 0x0498},
	{m68000_subi_pd_32       , 13, 0xfff8, 0x04a0},
	{m68000_subi_di_32       , 13, 0xfff8, 0x04a8},
	{m68000_subi_ix_32       , 13, 0xfff8, 0x04b0},
	{m68000_subi_aw_32       , 16, 0xffff, 0x04b8},
	{m68000_subi_al_32       , 16, 0xffff, 0x04b9},
	{m68000_subq_d_8         , 10, 0xf1f8, 0x5100},
	{m68000_subq_ai_8        , 10, 0xf1f8, 0x5110},
	{m68000_subq_pi_8        , 10, 0xf1f8, 0x5118},
	{m68000_subq_pi7_8       , 13, 0xf1ff, 0x511f},
	{m68000_subq_pd_8        , 10, 0xf1f8, 0x5120},
	{m68000_subq_pd7_8       , 13, 0xf1ff, 0x5127},
	{m68000_subq_di_8        , 10, 0xf1f8, 0x5128},
	{m68000_subq_ix_8        , 10, 0xf1f8, 0x5130},
	{m68000_subq_aw_8        , 13, 0xf1ff, 0x5138},
	{m68000_subq_al_8        , 13, 0xf1ff, 0x5139},
	{m68000_subq_d_16        , 10, 0xf1f8, 0x5140},
	{m68000_subq_a_16        , 10, 0xf1f8, 0x5148},
	{m68000_subq_ai_16       , 10, 0xf1f8, 0x5150},
	{m68000_subq_pi_16       , 10, 0xf1f8, 0x5158},
	{m68000_subq_pd_16       , 10, 0xf1f8, 0x5160},
	{m68000_subq_di_16       , 10, 0xf1f8, 0x5168},
	{m68000_subq_ix_16       , 10, 0xf1f8, 0x5170},
	{m68000_subq_aw_16       , 13, 0xf1ff, 0x5178},
	{m68000_subq_al_16       , 13, 0xf1ff, 0x5179},
	{m68000_subq_d_32        , 10, 0xf1f8, 0x5180},
	{m68000_subq_a_32        , 10, 0xf1f8, 0x5188},
	{m68000_subq_ai_32       , 10, 0xf1f8, 0x5190},
	{m68000_subq_pi_32       , 10, 0xf1f8, 0x5198},
	{m68000_subq_pd_32       , 10, 0xf1f8, 0x51a0},
	{m68000_subq_di_32       , 10, 0xf1f8, 0x51a8},
	{m68000_subq_ix_32       , 10, 0xf1f8, 0x51b0},
	{m68000_subq_aw_32       , 13, 0xf1ff, 0x51b8},
	{m68000_subq_al_32       , 13, 0xf1ff, 0x51b9},
	{m68000_subx_rr_8        , 10, 0xf1f8, 0x9100},
	{m68000_subx_rr_16       , 10, 0xf1f8, 0x9140},
	{m68000_subx_rr_32       , 10, 0xf1f8, 0x9180},
	{m68000_subx_mm_8_ax7    , 13, 0xfff8, 0x9f08},
	{m68000_subx_mm_8_ay7    , 13, 0xf1ff, 0x910f},
	{m68000_subx_mm_8_axy7   , 16, 0xffff, 0x9f0f},
	{m68000_subx_mm_8        , 10, 0xf1f8, 0x9108},
	{m68000_subx_mm_16       , 10, 0xf1f8, 0x9148},
	{m68000_subx_mm_32       , 10, 0xf1f8, 0x9188},
	{m68000_swap             , 13, 0xfff8, 0x4840},
	{m68000_tas_d            , 13, 0xfff8, 0x4ac0},
	{m68000_tas_ai           , 13, 0xfff8, 0x4ad0},
	{m68000_tas_pi           , 13, 0xfff8, 0x4ad8},
	{m68000_tas_pi7          , 16, 0xffff, 0x4adf},
	{m68000_tas_pd           , 13, 0xfff8, 0x4ae0},
	{m68000_tas_pd7          , 16, 0xffff, 0x4ae7},
	{m68000_tas_di           , 13, 0xfff8, 0x4ae8},
	{m68000_tas_ix           , 13, 0xfff8, 0x4af0},
	{m68000_tas_aw           , 16, 0xffff, 0x4af8},
	{m68000_tas_al           , 16, 0xffff, 0x4af9},
	{m68000_trap             , 12, 0xfff0, 0x4e40},
	{m68020_trapt_0          , 16, 0xffff, 0x50fc},
	{m68020_trapt_16         , 16, 0xffff, 0x50fa},
	{m68020_trapt_32         , 16, 0xffff, 0x50fb},
	{m68020_trapf_0          , 16, 0xffff, 0x51fc},
	{m68020_trapf_16         , 16, 0xffff, 0x51fa},
	{m68020_trapf_32         , 16, 0xffff, 0x51fb},
	{m68020_traphi_0         , 16, 0xffff, 0x52fc},
	{m68020_traphi_16        , 16, 0xffff, 0x52fa},
	{m68020_traphi_32        , 16, 0xffff, 0x52fb},
	{m68020_trapls_0         , 16, 0xffff, 0x53fc},
	{m68020_trapls_16        , 16, 0xffff, 0x53fa},
	{m68020_trapls_32        , 16, 0xffff, 0x53fb},
	{m68020_trapcc_0         , 16, 0xffff, 0x54fc},
	{m68020_trapcc_16        , 16, 0xffff, 0x54fa},
	{m68020_trapcc_32        , 16, 0xffff, 0x54fb},
	{m68020_trapcs_0         , 16, 0xffff, 0x55fc},
	{m68020_trapcs_16        , 16, 0xffff, 0x55fa},
	{m68020_trapcs_32        , 16, 0xffff, 0x55fb},
	{m68020_trapne_0         , 16, 0xffff, 0x56fc},
	{m68020_trapne_16        , 16, 0xffff, 0x56fa},
	{m68020_trapne_32        , 16, 0xffff, 0x56fb},
	{m68020_trapeq_0         , 16, 0xffff, 0x57fc},
	{m68020_trapeq_16        , 16, 0xffff, 0x57fa},
	{m68020_trapeq_32        , 16, 0xffff, 0x57fb},
	{m68020_trapvc_0         , 16, 0xffff, 0x58fc},
	{m68020_trapvc_16        , 16, 0xffff, 0x58fa},
	{m68020_trapvc_32        , 16, 0xffff, 0x58fb},
	{m68020_trapvs_0         , 16, 0xffff, 0x59fc},
	{m68020_trapvs_16        , 16, 0xffff, 0x59fa},
	{m68020_trapvs_32        , 16, 0xffff, 0x59fb},
	{m68020_trappl_0         , 16, 0xffff, 0x5afc},
	{m68020_trappl_16        , 16, 0xffff, 0x5afa},
	{m68020_trappl_32        , 16, 0xffff, 0x5afb},
	{m68020_trapmi_0         , 16, 0xffff, 0x5bfc},
	{m68020_trapmi_16        , 16, 0xffff, 0x5bfa},
	{m68020_trapmi_32        , 16, 0xffff, 0x5bfb},
	{m68020_trapge_0         , 16, 0xffff, 0x5cfc},
	{m68020_trapge_16        , 16, 0xffff, 0x5cfa},
	{m68020_trapge_32        , 16, 0xffff, 0x5cfb},
	{m68020_traplt_0         , 16, 0xffff, 0x5dfc},
	{m68020_traplt_16        , 16, 0xffff, 0x5dfa},
	{m68020_traplt_32        , 16, 0xffff, 0x5dfb},
	{m68020_trapgt_0         , 16, 0xffff, 0x5efc},
	{m68020_trapgt_16        , 16, 0xffff, 0x5efa},
	{m68020_trapgt_32        , 16, 0xffff, 0x5efb},
	{m68020_traple_0         , 16, 0xffff, 0x5ffc},
	{m68020_traple_16        , 16, 0xffff, 0x5ffa},
	{m68020_traple_32        , 16, 0xffff, 0x5ffb},
	{m68000_trapv            , 16, 0xffff, 0x4e76},
	{m68000_tst_d_8          , 13, 0xfff8, 0x4a00},
	{m68000_tst_ai_8         , 13, 0xfff8, 0x4a10},
	{m68000_tst_pi_8         , 13, 0xfff8, 0x4a18},
	{m68000_tst_pi7_8        , 16, 0xffff, 0x4a1f},
	{m68000_tst_pd_8         , 13, 0xfff8, 0x4a20},
	{m68000_tst_pd7_8        , 16, 0xffff, 0x4a27},
	{m68000_tst_di_8         , 13, 0xfff8, 0x4a28},
	{m68000_tst_ix_8         , 13, 0xfff8, 0x4a30},
	{m68000_tst_aw_8         , 16, 0xffff, 0x4a38},
	{m68000_tst_al_8         , 16, 0xffff, 0x4a39},
	{m68020_tst_pcdi_8       , 16, 0xffff, 0x4a3a},
	{m68020_tst_pcix_8       , 16, 0xffff, 0x4a3b},
	{m68020_tst_imm_8        , 16, 0xffff, 0x4a3c},
	{m68000_tst_d_16         , 13, 0xfff8, 0x4a40},
	{m68020_tst_a_16         , 13, 0xfff8, 0x4a48},
	{m68000_tst_ai_16        , 13, 0xfff8, 0x4a50},
	{m68000_tst_pi_16        , 13, 0xfff8, 0x4a58},
	{m68000_tst_pd_16        , 13, 0xfff8, 0x4a60},
	{m68000_tst_di_16        , 13, 0xfff8, 0x4a68},
	{m68000_tst_ix_16        , 13, 0xfff8, 0x4a70},
	{m68000_tst_aw_16        , 16, 0xffff, 0x4a78},
	{m68000_tst_al_16        , 16, 0xffff, 0x4a79},
	{m68020_tst_pcdi_16      , 16, 0xffff, 0x4a7a},
	{m68020_tst_pcix_16      , 16, 0xffff, 0x4a7b},
	{m68020_tst_imm_16       , 16, 0xffff, 0x4a7c},
	{m68000_tst_d_32         , 13, 0xfff8, 0x4a80},
	{m68020_tst_a_32         , 13, 0xfff8, 0x4a88},
	{m68000_tst_ai_32        , 13, 0xfff8, 0x4a90},
	{m68000_tst_pi_32        , 13, 0xfff8, 0x4a98},
	{m68000_tst_pd_32        , 13, 0xfff8, 0x4aa0},
	{m68000_tst_di_32        , 13, 0xfff8, 0x4aa8},
	{m68000_tst_ix_32        , 13, 0xfff8, 0x4ab0},
	{m68000_tst_aw_32        , 16, 0xffff, 0x4ab8},
	{m68000_tst_al_32        , 16, 0xffff, 0x4ab9},
	{m68020_tst_pcdi_32      , 16, 0xffff, 0x4aba},
	{m68020_tst_pcix_32      , 16, 0xffff, 0x4abb},
	{m68020_tst_imm_32       , 16, 0xffff, 0x4abc},
	{m68000_unlk_a7          , 16, 0xffff, 0x4e5f},
	{m68000_unlk             , 13, 0xfff8, 0x4e58},
	{m68020_unpk_rr          , 10, 0xf1f8, 0x8180},
	{m68020_unpk_mm_ax7      , 13, 0xf1ff, 0x818f},
	{m68020_unpk_mm_ay7      , 13, 0xfff8, 0x8f88},
	{m68020_unpk_mm_axy7     , 16, 0xffff, 0x8f8f},
	{m68020_unpk_mm          , 10, 0xf1f8, 0x8188},
	{0, 0, 0, 0}
};


/*
 * Comparison function for qsort()
 * For entries with an equal number of set bits in
 * the mask compare the match values
 */
static int DECL_SPEC compare_nof_true_bits(const void* aptr, const void* bptr)
{
	const opcode_handler_struct *a = aptr, *b = bptr;
	if( a->bits != b->bits )
		return a->bits - b->bits;
	if( a->mask != b->mask )
		return a->mask - b->mask;
	return a->match - b->match;
}

/* Build the opcode handler jump table */
void m68ki_build_opcode_table(void)
{
	opcode_handler_struct *ostruct;
	uint table_length = 0;
	int i,j;

	for(ostruct = m68k_opcode_handler_table;ostruct->opcode_handler != 0;ostruct++)
		table_length++;

	qsort((void *)m68k_opcode_handler_table, table_length, sizeof(m68k_opcode_handler_table[0]), compare_nof_true_bits);

	for( i = 0; i < 0x10000; i++ )
	{
		/* default to illegal */
		m68k_instruction_jump_table[i] = m68000_illegal;
	}

	ostruct = m68k_opcode_handler_table;
	while (ostruct->mask != 0xff00)
	{
		for (i = 0;i < 0x10000;i++)
		{
			if ((i & ostruct->mask) == ostruct->match)
			{
				m68k_instruction_jump_table[i] = ostruct->opcode_handler;
			}
		}
		ostruct++;
	}
	while (ostruct->mask == 0xff00)
	{
		for (i = 0;i <= 0xff;i++)
			m68k_instruction_jump_table[ostruct->match | i] = ostruct->opcode_handler;
		ostruct++;
	}
	while (ostruct->mask == 0xf1f8)
	{
		for (i = 0;i < 8;i++)
		{
			for (j = 0;j < 8;j++)
			{
				m68k_instruction_jump_table[ostruct->match | (i << 9) | j] = ostruct->opcode_handler;
			}
		}
		ostruct++;
	}
	while (ostruct->mask == 0xfff0)
	{
		for (i = 0;i <= 0x0f;i++)
			m68k_instruction_jump_table[ostruct->match | i] = ostruct->opcode_handler;
		ostruct++;
	}
	while (ostruct->mask == 0xf1ff)
	{
		for (i = 0;i <= 0x07;i++)
			m68k_instruction_jump_table[ostruct->match | (i << 9)] = ostruct->opcode_handler;
		ostruct++;
	}
	while (ostruct->mask == 0xfff8)
	{
		for (i = 0;i <= 0x07;i++)
			m68k_instruction_jump_table[ostruct->match | i] = ostruct->opcode_handler;
		ostruct++;
	}
	while (ostruct->mask == 0xffff)
	{
		m68k_instruction_jump_table[ostruct->match] = ostruct->opcode_handler;
		ostruct++;
	}
}
