/*
 * This file is part of the Advance project.
 *
 * Copyright (C) 2002, 2003 Andrea Mazzoleni
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details. 
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "portable.h"

#include "analyze.h"
#include "strcov.h"
#include "file.h"

using namespace std;

analyze_entry_static GARBAGE[] = {

#include "analyze.dat"

{ 0, 0, 0 }
};

char MAMEDK_DATA[] = {
	0x2e, 0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x2d,
	0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x2d,
	0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x2d,
	0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x2d,
	0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x2d,
	0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x2d,
	0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x2d,
	0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x2e, 0x0d, 0x0a,
	0x7c, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x5f, 0x20,
	0x5f, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x7c, 0x0d, 0x0a,
	0x7c, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x5f, 0x20, 0x5f, 0x5f, 0x20, 0x5f,
	0x5f, 0x5f, 0x20, 0x20, 0x20, 0x5f, 0x5f, 0x20,
	0x5f, 0x20, 0x5f, 0x20, 0x5f, 0x5f, 0x20, 0x5f,
	0x5f, 0x5f, 0x20, 0x20, 0x20, 0x5f, 0x5f, 0x5f,
	0x20, 0x20, 0x20, 0x5f, 0x5f, 0x7c, 0x20, 0x7c,
	0x20, 0x7c, 0x20, 0x5f, 0x5f, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x7c, 0x0d, 0x0a,
	0x7c, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x7c, 0x20, 0x27, 0x5f, 0x20, 0x60, 0x20,
	0x5f, 0x20, 0x5c, 0x20, 0x2f, 0x20, 0x5f, 0x60,
	0x20, 0x7c, 0x20, 0x27, 0x5f, 0x20, 0x60, 0x20,
	0x5f, 0x20, 0x5c, 0x20, 0x2f, 0x20, 0x5f, 0x20,
	0x5c, 0x20, 0x2f, 0x20, 0x5f, 0x60, 0x20, 0x7c,
	0x20, 0x7c, 0x2f, 0x20, 0x2f, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x7c, 0x0d, 0x0a,
	0x7c, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x7c, 0x20, 0x7c, 0x20, 0x7c, 0x20, 0x7c,
	0x20, 0x7c, 0x20, 0x7c, 0x20, 0x28, 0x5f, 0x7c,
	0x20, 0x7c, 0x20, 0x7c, 0x20, 0x7c, 0x20, 0x7c,
	0x20, 0x7c, 0x20, 0x7c, 0x20, 0x20, 0x5f, 0x5f,
	0x2f, 0x7c, 0x20, 0x28, 0x5f, 0x7c, 0x20, 0x7c,
	0x20, 0x20, 0x20, 0x3c, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x7c, 0x0d, 0x0a,
	0x7c, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x7c, 0x5f, 0x7c, 0x20, 0x7c, 0x5f, 0x7c,
	0x20, 0x7c, 0x5f, 0x7c, 0x5c, 0x5f, 0x5f, 0x2c,
	0x5f, 0x7c, 0x5f, 0x7c, 0x20, 0x7c, 0x5f, 0x7c,
	0x20, 0x7c, 0x5f, 0x7c, 0x5c, 0x5f, 0x5f, 0x5f,
	0x28, 0x5f, 0x29, 0x5f, 0x5f, 0x2c, 0x5f, 0x7c,
	0x5f, 0x7c, 0x5c, 0x5f, 0x5c, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x7c, 0x0d, 0x0a,
	0x7c, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x7c, 0x0d, 0x0a,
	0x7c, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x68, 0x74,
	0x74, 0x70, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77,
	0x2e, 0x6d, 0x61, 0x6d, 0x65, 0x2e, 0x64, 0x6b,
	0x2f, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x7c, 0x0d, 0x0a,
	0x3e, 0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x2d,
	0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x2d,
	0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x2d,
	0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x2d,
	0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x2d,
	0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x2d,
	0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x2d,
	0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x3c, 0x0d, 0x0a,
	0x7c, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x70, 0x72, 0x6f, 0x75, 0x64, 0x6c, 0x79,
	0x20, 0x70, 0x72, 0x65, 0x73, 0x65, 0x6e, 0x74,
	0x73, 0x20, 0x72, 0x61, 0x66, 0x6c, 0x65, 0x73,
	0x69, 0x61, 0x2e, 0x7a, 0x69, 0x70, 0x20, 0x66,
	0x6f, 0x72, 0x20, 0x79, 0x6f, 0x75, 0x72, 0x20,
	0x6d, 0x61, 0x6d, 0x65, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x7c, 0x0d, 0x0a,
	0x7c, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x7c, 0x0d, 0x0a,
	0x7c, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x22, 0x52, 0x61, 0x66, 0x66, 0x6c, 0x65,
	0x73, 0x69, 0x61, 0x22, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x7c, 0x0d, 0x0a,
	0x7c, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x69, 0x73,
	0x20, 0x63, 0x6f, 0x70, 0x79, 0x72, 0x69, 0x67,
	0x68, 0x74, 0x65, 0x64, 0x20, 0x62, 0x79, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x7c, 0x0d, 0x0a,
	0x7c, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x43, 0x6f, 0x72,
	0x65, 0x6c, 0x61, 0x6e, 0x64, 0x20, 0x2f, 0x20,
	0x53, 0x65, 0x67, 0x61, 0x20, 0x31, 0x39, 0x38,
	0x36, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x7c, 0x0d, 0x0a,
	0x3e, 0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x2d,
	0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x2d,
	0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x2d,
	0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x2d,
	0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x2d,
	0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x2d,
	0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x2d,
	0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x3c, 0x0d, 0x0a,
	0x7c, 0x20, 0x20, 0x20, 0x20, 0x20, 0x59, 0x6f,
	0x75, 0x20, 0x6d, 0x61, 0x79, 0x20, 0x68, 0x61,
	0x76, 0x65, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20,
	0x67, 0x61, 0x6d, 0x65, 0x20, 0x52, 0x4f, 0x4d,
	0x20, 0x4f, 0x4e, 0x4c, 0x59, 0x20, 0x69, 0x66,
	0x20, 0x79, 0x6f, 0x75, 0x20, 0x61, 0x72, 0x65,
	0x20, 0x6c, 0x65, 0x67, 0x61, 0x6c, 0x6c, 0x79,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x7c, 0x0d, 0x0a,
	0x7c, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65,
	0x64, 0x20, 0x73, 0x6f, 0x2e, 0x20, 0x42, 0x79,
	0x20, 0x22, 0x6c, 0x65, 0x67, 0x61, 0x6c, 0x6c,
	0x79, 0x20, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x6c,
	0x65, 0x64, 0x22, 0x20, 0x77, 0x65, 0x20, 0x6d,
	0x65, 0x61, 0x6e, 0x3a, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x7c, 0x0d, 0x0a,
	0x7c, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x7c, 0x0d, 0x0a,
	0x7c, 0x20, 0x20, 0x20, 0x20, 0x20, 0x59, 0x6f,
	0x75, 0x20, 0x6f, 0x77, 0x6e, 0x20, 0x74, 0x68,
	0x65, 0x20, 0x61, 0x63, 0x74, 0x75, 0x61, 0x6c,
	0x20, 0x61, 0x72, 0x63, 0x61, 0x64, 0x65, 0x20,
	0x6f, 0x72, 0x20, 0x67, 0x61, 0x6d, 0x65, 0x70,
	0x61, 0x6b, 0x20, 0x6f, 0x66, 0x20, 0x61, 0x20,
	0x52, 0x4f, 0x4d, 0x20, 0x79, 0x6f, 0x75, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x7c, 0x0d, 0x0a,
	0x7c, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x61,
	0x72, 0x65, 0x20, 0x64, 0x6f, 0x77, 0x6e, 0x6c,
	0x6f, 0x61, 0x64, 0x69, 0x6e, 0x67, 0x2e, 0x20,
	0x55, 0x6e, 0x64, 0x65, 0x72, 0x20, 0x74, 0x68,
	0x65, 0x20, 0x63, 0x6f, 0x70, 0x79, 0x72, 0x69,
	0x67, 0x68, 0x74, 0x20, 0x6c, 0x61, 0x77, 0x73,
	0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x7c, 0x0d, 0x0a,
	0x7c, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x55, 0x2e, 0x53, 0x2e, 0x2c, 0x20, 0x79, 0x6f,
	0x75, 0x20, 0x61, 0x72, 0x65, 0x20, 0x65, 0x6e,
	0x74, 0x69, 0x74, 0x6c, 0x65, 0x64, 0x20, 0x74,
	0x6f, 0x20, 0x6f, 0x77, 0x6e, 0x20, 0x61, 0x20,
	0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x20, 0x6f,
	0x66, 0x20, 0x61, 0x6e, 0x79, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x7c, 0x0d, 0x0a,
	0x7c, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x73,
	0x6f, 0x66, 0x74, 0x77, 0x61, 0x72, 0x65, 0x20,
	0x79, 0x6f, 0x75, 0x20, 0x68, 0x61, 0x76, 0x65,
	0x20, 0x70, 0x61, 0x69, 0x64, 0x20, 0x66, 0x6f,
	0x72, 0x2e, 0x20, 0x53, 0x69, 0x6e, 0x63, 0x65,
	0x20, 0x52, 0x4f, 0x4d, 0x53, 0x20, 0x63, 0x61,
	0x6e, 0x27, 0x74, 0x20, 0x62, 0x65, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x7c, 0x0d, 0x0a,
	0x7c, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x64, 0x75, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74,
	0x65, 0x64, 0x20, 0x28, 0x6e, 0x6f, 0x74, 0x20,
	0x77, 0x69, 0x74, 0x68, 0x6f, 0x75, 0x74, 0x20,
	0x73, 0x70, 0x65, 0x63, 0x69, 0x61, 0x6c, 0x20,
	0x68, 0x61, 0x72, 0x64, 0x77, 0x61, 0x72, 0x65,
	0x29, 0x2c, 0x20, 0x52, 0x4f, 0x4d, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x7c, 0x0d, 0x0a,
	0x7c, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x69,
	0x6d, 0x61, 0x67, 0x65, 0x73, 0x20, 0x61, 0x72,
	0x65, 0x20, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x64,
	0x65, 0x64, 0x20, 0x74, 0x6f, 0x20, 0x74, 0x68,
	0x65, 0x20, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63,
	0x20, 0x61, 0x73, 0x20, 0x61, 0x20, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x7c, 0x0d, 0x0a,
	0x7c, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x7c, 0x0d, 0x0a,
	0x7c, 0x20, 0x20, 0x20, 0x20, 0x52, 0x65, 0x6d,
	0x65, 0x6d, 0x62, 0x65, 0x72, 0x2c, 0x20, 0x74,
	0x68, 0x65, 0x20, 0x70, 0x75, 0x72, 0x70, 0x6f,
	0x73, 0x65, 0x20, 0x6f, 0x66, 0x20, 0x61, 0x6e,
	0x20, 0x65, 0x6d, 0x75, 0x6c, 0x61, 0x74, 0x6f,
	0x72, 0x20, 0x69, 0x73, 0x20, 0x74, 0x6f, 0x20,
	0x70, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x65,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x7c, 0x0d, 0x0a,
	0x7c, 0x20, 0x20, 0x20, 0x20, 0x20, 0x67, 0x61,
	0x6d, 0x65, 0x73, 0x20, 0x28, 0x73, 0x6f, 0x20,
	0x74, 0x68, 0x61, 0x74, 0x20, 0x74, 0x68, 0x65,
	0x79, 0x20, 0x64, 0x6f, 0x6e, 0x27, 0x74, 0x20,
	0x64, 0x69, 0x73, 0x73, 0x61, 0x70, 0x70, 0x65,
	0x61, 0x72, 0x29, 0x2c, 0x20, 0x74, 0x6f, 0x20,
	0x68, 0x61, 0x76, 0x65, 0x20, 0x61, 0x6c, 0x6c,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x7c, 0x0d, 0x0a,
	0x7c, 0x20, 0x20, 0x20, 0x20, 0x79, 0x6f, 0x75,
	0x72, 0x20, 0x67, 0x61, 0x6d, 0x65, 0x73, 0x20,
	0x6f, 0x6e, 0x20, 0x79, 0x6f, 0x75, 0x72, 0x20,
	0x50, 0x43, 0x20, 0x28, 0x73, 0x6f, 0x20, 0x74,
	0x68, 0x61, 0x74, 0x20, 0x79, 0x6f, 0x75, 0x20,
	0x64, 0x6f, 0x6e, 0x27, 0x74, 0x20, 0x74, 0x69,
	0x65, 0x20, 0x75, 0x70, 0x20, 0x74, 0x68, 0x65,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x7c, 0x0d, 0x0a,
	0x7c, 0x20, 0x20, 0x20, 0x20, 0x66, 0x61, 0x6d,
	0x69, 0x6c, 0x79, 0x20, 0x54, 0x56, 0x29, 0x20,
	0x61, 0x6e, 0x64, 0x20, 0x74, 0x6f, 0x20, 0x6b,
	0x65, 0x65, 0x70, 0x20, 0x61, 0x20, 0x62, 0x61,
	0x63, 0x6b, 0x75, 0x70, 0x20, 0x6f, 0x66, 0x20,
	0x67, 0x61, 0x6d, 0x65, 0x73, 0x20, 0x79, 0x6f,
	0x75, 0x20, 0x6f, 0x77, 0x6e, 0x20, 0x69, 0x6e,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x7c, 0x0d, 0x0a,
	0x7c, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x63,
	0x61, 0x73, 0x65, 0x20, 0x74, 0x68, 0x65, 0x20,
	0x67, 0x61, 0x6d, 0x65, 0x20, 0x28, 0x6f, 0x72,
	0x20, 0x61, 0x72, 0x63, 0x61, 0x64, 0x65, 0x2f,
	0x68, 0x6f, 0x6d, 0x65, 0x20, 0x63, 0x6f, 0x6e,
	0x73, 0x6f, 0x6c, 0x65, 0x29, 0x20, 0x66, 0x61,
	0x69, 0x6c, 0x73, 0x20, 0x6f, 0x72, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x7c, 0x0d, 0x0a,
	0x7c, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x68, 0x61, 0x76,
	0x65, 0x20, 0x61, 0x6c, 0x72, 0x65, 0x61, 0x64,
	0x79, 0x20, 0x66, 0x61, 0x69, 0x6c, 0x65, 0x64,
	0x2e, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x7c, 0x0d, 0x0a,
	0x7c, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x7c, 0x0d, 0x0a,
	0x7c, 0x20, 0x20, 0x20, 0x49, 0x74, 0x27, 0x73,
	0x20, 0x66, 0x6f, 0x72, 0x20, 0x65, 0x64, 0x75,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c,
	0x20, 0x70, 0x75, 0x72, 0x70, 0x6f, 0x73, 0x65,
	0x73, 0x20, 0x6f, 0x6e, 0x6c, 0x79, 0x20, 0x28,
	0x69, 0x6e, 0x20, 0x63, 0x61, 0x73, 0x65, 0x20,
	0x79, 0x6f, 0x75, 0x20, 0x61, 0x72, 0x65, 0x20,
	0x61, 0x6e, 0x20, 0x20, 0x20, 0x7c, 0x0d, 0x0a,
	0x7c, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x65, 0x6d, 0x75, 0x6c,
	0x61, 0x74, 0x6f, 0x72, 0x20, 0x70, 0x72, 0x6f,
	0x67, 0x72, 0x61, 0x6d, 0x6d, 0x65, 0x72, 0x29,
	0x2e, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x7c, 0x0d, 0x0a,
	0x7c, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x7c, 0x0d, 0x0a,
	0x7c, 0x20, 0x20, 0x20, 0x20, 0x59, 0x6f, 0x75,
	0x20, 0x77, 0x69, 0x6c, 0x6c, 0x20, 0x4e, 0x45,
	0x56, 0x45, 0x52, 0x20, 0x73, 0x65, 0x6c, 0x6c,
	0x20, 0x74, 0x68, 0x65, 0x73, 0x65, 0x20, 0x52,
	0x4f, 0x4d, 0x53, 0x20, 0x66, 0x6f, 0x72, 0x20,
	0x70, 0x72, 0x6f, 0x66, 0x69, 0x74, 0x2e, 0x20,
	0x4d, 0x6f, 0x73, 0x74, 0x20, 0x67, 0x61, 0x6d,
	0x65, 0x20, 0x20, 0x20, 0x20, 0x7c, 0x0d, 0x0a,
	0x7c, 0x20, 0x20, 0x20, 0x63, 0x6f, 0x6d, 0x70,
	0x61, 0x6e, 0x69, 0x65, 0x73, 0x20, 0x64, 0x6f,
	0x6e, 0x27, 0x74, 0x20, 0x6d, 0x69, 0x6e, 0x64,
	0x20, 0x74, 0x68, 0x65, 0x20, 0x64, 0x69, 0x73,
	0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f,
	0x6e, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65,
	0x69, 0x72, 0x20, 0x67, 0x61, 0x6d, 0x65, 0x27,
	0x73, 0x20, 0x20, 0x20, 0x20, 0x7c, 0x0d, 0x0a,
	0x7c, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x52,
	0x4f, 0x4d, 0x53, 0x20, 0x62, 0x65, 0x63, 0x61,
	0x75, 0x73, 0x65, 0x20, 0x74, 0x68, 0x65, 0x79,
	0x20, 0x6e, 0x6f, 0x20, 0x6c, 0x6f, 0x6e, 0x67,
	0x65, 0x72, 0x20, 0x65, 0x78, 0x69, 0x73, 0x74,
	0x2c, 0x20, 0x62, 0x75, 0x74, 0x20, 0x74, 0x68,
	0x65, 0x79, 0x20, 0x57, 0x49, 0x4c, 0x4c, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x7c, 0x0d, 0x0a,
	0x7c, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x6d, 0x69, 0x6e, 0x64, 0x20, 0x69, 0x66,
	0x20, 0x73, 0x6f, 0x6d, 0x65, 0x6f, 0x6e, 0x65,
	0x20, 0x73, 0x65, 0x6c, 0x6c, 0x73, 0x20, 0x74,
	0x68, 0x65, 0x6d, 0x2e, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x7c, 0x0d, 0x0a,
	0x7c, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x7c, 0x0d, 0x0a,
	0x7c, 0x20, 0x20, 0x20, 0x20, 0x59, 0x6f, 0x75,
	0x20, 0x77, 0x69, 0x6c, 0x6c, 0x20, 0x4e, 0x4f,
	0x54, 0x20, 0x64, 0x69, 0x73, 0x74, 0x72, 0x69,
	0x62, 0x75, 0x74, 0x65, 0x20, 0x52, 0x4f, 0x4d,
	0x53, 0x20, 0x74, 0x6f, 0x67, 0x65, 0x74, 0x68,
	0x65, 0x72, 0x20, 0x77, 0x69, 0x74, 0x68, 0x20,
	0x65, 0x6d, 0x75, 0x6c, 0x61, 0x74, 0x6f, 0x72,
	0x73, 0x20, 0x20, 0x20, 0x20, 0x7c, 0x0d, 0x0a,
	0x7c, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x61, 0x73, 0x20,
	0x61, 0x20, 0x70, 0x61, 0x63, 0x6b, 0x61, 0x67,
	0x65, 0x2e, 0x20, 0x41, 0x6e, 0x64, 0x20, 0x61,
	0x67, 0x61, 0x69, 0x6e, 0x2c, 0x20, 0x4e, 0x4f,
	0x20, 0x73, 0x65, 0x6c, 0x6c, 0x69, 0x6e, 0x67,
	0x2e, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x7c, 0x0d, 0x0a,
	0x7c, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x7c, 0x0d, 0x0a,
	0x7c, 0x20, 0x20, 0x20, 0x20, 0x20, 0x59, 0x6f,
	0x75, 0x20, 0x77, 0x69, 0x6c, 0x6c, 0x20, 0x4e,
	0x45, 0x56, 0x45, 0x52, 0x20, 0x68, 0x6f, 0x6c,
	0x64, 0x20, 0x6d, 0x61, 0x6d, 0x65, 0x2e, 0x64,
	0x6b, 0x20, 0x28, 0x69, 0x6e, 0x63, 0x6c, 0x75,
	0x64, 0x69, 0x6e, 0x67, 0x20, 0x69, 0x74, 0x73,
	0x20, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x7c, 0x0d, 0x0a,
	0x7c, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x63,
	0x6f, 0x6d, 0x70, 0x61, 0x6e, 0x79, 0x2c, 0x20,
	0x77, 0x65, 0x62, 0x6d, 0x61, 0x73, 0x74, 0x65,
	0x72, 0x73, 0x2c, 0x20, 0x65, 0x6d, 0x70, 0x6c,
	0x6f, 0x79, 0x65, 0x65, 0x73, 0x2c, 0x20, 0x73,
	0x74, 0x61, 0x66, 0x66, 0x20, 0x6f, 0x72, 0x20,
	0x61, 0x6e, 0x79, 0x62, 0x6f, 0x64, 0x79, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x7c, 0x0d, 0x0a,
	0x7c, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x65, 0x6c, 0x73, 0x65, 0x20, 0x72, 0x65, 0x6c,
	0x61, 0x74, 0x65, 0x64, 0x20, 0x74, 0x6f, 0x20,
	0x74, 0x68, 0x69, 0x73, 0x20, 0x77, 0x65, 0x62,
	0x73, 0x69, 0x74, 0x65, 0x29, 0x20, 0x6f, 0x72,
	0x20, 0x6f, 0x75, 0x72, 0x20, 0x77, 0x65, 0x62,
	0x68, 0x6f, 0x73, 0x74, 0x73, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x7c, 0x0d, 0x0a,
	0x7c, 0x20, 0x20, 0x20, 0x20, 0x20, 0x72, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x69, 0x62, 0x6c,
	0x65, 0x20, 0x66, 0x6f, 0x72, 0x20, 0x61, 0x6e,
	0x79, 0x20, 0x64, 0x61, 0x6d, 0x61, 0x67, 0x65,
	0x20, 0x63, 0x61, 0x75, 0x73, 0x65, 0x64, 0x20,
	0x74, 0x6f, 0x20, 0x79, 0x6f, 0x75, 0x72, 0x20,
	0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x2c, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x7c, 0x0d, 0x0a,
	0x7c, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x66,
	0x6f, 0x72, 0x20, 0x61, 0x6e, 0x79, 0x20, 0x6c,
	0x65, 0x67, 0x61, 0x6c, 0x20, 0x61, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x20, 0x74, 0x61, 0x6b,
	0x65, 0x6e, 0x20, 0x61, 0x67, 0x61, 0x69, 0x6e,
	0x73, 0x74, 0x20, 0x79, 0x6f, 0x75, 0x20, 0x66,
	0x6f, 0x72, 0x20, 0x6e, 0x6f, 0x74, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x7c, 0x0d, 0x0a,
	0x7c, 0x20, 0x20, 0x6f, 0x62, 0x65, 0x79, 0x69,
	0x6e, 0x67, 0x20, 0x74, 0x68, 0x65, 0x20, 0x61,
	0x62, 0x6f, 0x76, 0x65, 0x20, 0x73, 0x74, 0x61,
	0x74, 0x65, 0x64, 0x20, 0x72, 0x75, 0x6c, 0x65,
	0x73, 0x2c, 0x20, 0x6f, 0x72, 0x20, 0x66, 0x6f,
	0x72, 0x20, 0x61, 0x6e, 0x79, 0x20, 0x6f, 0x74,
	0x68, 0x65, 0x72, 0x20, 0x72, 0x65, 0x61, 0x73,
	0x6f, 0x6e, 0x2e, 0x20, 0x20, 0x7c, 0x0d, 0x0a,
	0x7c, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x7c, 0x0d, 0x0a,
	0x7c, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x6d,
	0x61, 0x6d, 0x65, 0x2e, 0x64, 0x6b, 0x20, 0x68,
	0x61, 0x73, 0x20, 0x6e, 0x6f, 0x74, 0x20, 0x64,
	0x75, 0x6d, 0x70, 0x65, 0x64, 0x20, 0x74, 0x68,
	0x65, 0x20, 0x52, 0x4f, 0x4d, 0x53, 0x20, 0x6f,
	0x6e, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x77,
	0x65, 0x62, 0x73, 0x69, 0x74, 0x65, 0x2c, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x7c, 0x0d, 0x0a,
	0x7c, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x61, 0x6e, 0x64, 0x20, 0x6f, 0x75, 0x72, 0x20,
	0x70, 0x75, 0x72, 0x70, 0x6f, 0x73, 0x65, 0x20,
	0x69, 0x73, 0x20, 0x74, 0x6f, 0x20, 0x70, 0x72,
	0x6f, 0x76, 0x69, 0x64, 0x65, 0x20, 0x61, 0x20,
	0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x20,
	0x74, 0x6f, 0x20, 0x74, 0x68, 0x65, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x7c, 0x0d, 0x0a,
	0x7c, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x49,
	0x6e, 0x74, 0x65, 0x72, 0x6e, 0x65, 0x74, 0x20,
	0x61, 0x6e, 0x64, 0x20, 0x67, 0x61, 0x6d, 0x69,
	0x6e, 0x67, 0x20, 0x63, 0x6f, 0x6d, 0x6d, 0x75,
	0x6e, 0x69, 0x74, 0x79, 0x2e, 0x20, 0x4e, 0x6f,
	0x20, 0x68, 0x61, 0x72, 0x6d, 0x20, 0x69, 0x73,
	0x20, 0x62, 0x65, 0x69, 0x6e, 0x67, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x7c, 0x0d, 0x0a,
	0x7c, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x64, 0x6f, 0x6e, 0x65, 0x20, 0x74, 0x6f,
	0x20, 0x67, 0x61, 0x6d, 0x65, 0x20, 0x63, 0x6f,
	0x6d, 0x70, 0x61, 0x6e, 0x69, 0x65, 0x73, 0x2c,
	0x20, 0x61, 0x73, 0x20, 0x74, 0x68, 0x65, 0x20,
	0x52, 0x4f, 0x4d, 0x53, 0x20, 0x6f, 0x6e, 0x20,
	0x74, 0x68, 0x69, 0x73, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x7c, 0x0d, 0x0a,
	0x7c, 0x20, 0x20, 0x20, 0x20, 0x20, 0x77, 0x65,
	0x62, 0x73, 0x69, 0x74, 0x65, 0x20, 0x61, 0x72,
	0x65, 0x20, 0x6f, 0x66, 0x20, 0x67, 0x61, 0x6d,
	0x65, 0x73, 0x20, 0x74, 0x68, 0x61, 0x74, 0x20,
	0x61, 0x72, 0x65, 0x20, 0x6e, 0x6f, 0x20, 0x6c,
	0x6f, 0x6e, 0x67, 0x65, 0x72, 0x20, 0x66, 0x6f,
	0x72, 0x20, 0x73, 0x61, 0x6c, 0x65, 0x2c, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x7c, 0x0d, 0x0a,
	0x7c, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x66,
	0x72, 0x6f, 0x6d, 0x20, 0x77, 0x68, 0x69, 0x63,
	0x68, 0x20, 0x67, 0x61, 0x6d, 0x65, 0x20, 0x63,
	0x6f, 0x6d, 0x70, 0x61, 0x6e, 0x69, 0x65, 0x73,
	0x20, 0x63, 0x61, 0x6e, 0x20, 0x6e, 0x6f, 0x20,
	0x6c, 0x6f, 0x6e, 0x67, 0x65, 0x72, 0x20, 0x70,
	0x72, 0x6f, 0x66, 0x69, 0x74, 0x2e, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x7c, 0x0d, 0x0a,
	0x60, 0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x2d,
	0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x2d,
	0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x2d,
	0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x2d,
	0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x2d,
	0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x2d,
	0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x2d,
	0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0xb4, 0x0d, 0x0a
};

#define MAMEDK_SIZE 3648

analyze_entry::analyze_entry(const string& Aname, unsigned Asize, unsigned Acrc)
	: name(Aname), size(Asize), crc(Acrc) {
}

analyze_entry::analyze_entry(const analyze_entry& A)
	: name(A.name), size(A.size), crc(A.crc) {
}

analyze_entry::analyze_entry(const analyze_entry_static& A)
	: name(A.name), size(A.size), crc(A.crc) {
}

analyze_entry::~analyze_entry()
{
}

bool operator<(const analyze_entry& A, const analyze_entry& B)
{
	if (A.size < B.size)
		return true;
	if (A.size > B.size)
		return false;

	if (A.crc < B.crc)
		return true;
	if (A.crc > B.crc)
		return false;

	return A.name < B.name;;
}

// Check if a file is a text file, heuristic
const char* TEXT_WILD[] = {
"*.txt",
"*.doc",
"*.nfo",
"*.diz",
"readme.*",
0
};

// Check if a file is a binary file, heuristic
const char* BIN_WILD[] = {
"*.sam",
"*.wav",
0
};

static bool heuristic_is_text(const string& name, unsigned size, unsigned crc)
{
	// check name for binary
	for(unsigned i=0;BIN_WILD[i];++i) {
		if (striwildcmp(BIN_WILD[i], name.c_str())==0)
			return false;
	}

	// check name for text
	for(unsigned i=0;TEXT_WILD[i];++i) {
		if (striwildcmp(TEXT_WILD[i], name.c_str())==0)
			return true;
	}

	// check if it's empty
	if (size==0)
		return false;

	// check if the size is a power of 2
	unsigned one = 0;
	while (size) {
		if (size % 2)
			++one;
		size /= 2;
	}
	if (one==1)
		return false;

	// Note: The ZIP ASCII flag is not checked because some readme
	// contain the CTRL-Z char as end-of-file and result as a binary file

	return true;
}

static void sset(char* dst, unsigned w, const char* s)
{
	unsigned l = strlen(s);
	if (l > w)
		l = w;
	unsigned b = (w - l) / 2;

	memset(dst, ' ', w);
	memcpy(dst + b, s, l);
}

analyze::analyze(const gamearchive& gar)
{
	// insert some standard crc
	for(analyze_entry_static* i=GARBAGE;i->size;++i) {
		garbage.insert(*i);
	}

	// insert the MAMEDK crc for the current info
	for(game_by_name_set::const_iterator i=gar.begin();i!=gar.end();++i) {
		char t0[128];
		char t1[128];
		char t2[128];
		char name[64];

		snprintf(t0, sizeof(t0), "proudly presents %s.zip for your mame", i->name_get().c_str());
		snprintf(t1, sizeof(t1), "\"%s\"", i->description_get().c_str());
		snprintf(t2, sizeof(t2), "%s %s", i->manufacturer_get().c_str(), i->year_get().c_str());

		sset(MAMEDK_DATA + 64*9 + 1, 60, t0);
		sset(MAMEDK_DATA + 64*11 + 1, 60, t1);
		sset(MAMEDK_DATA + 64*13 + 1, 60, t2);

		analyze_entry_static e;

		snprintf(name, sizeof(name), "%s.txt", i->name_get().c_str());

		e.name = name;
		e.size = MAMEDK_SIZE;
		e.crc = crc_compute(MAMEDK_DATA, MAMEDK_SIZE);

		garbage.insert(e);
	}
}

analyze_type analyze::operator()(const string& name, unsigned size, unsigned crc) const
{
	if (!heuristic_is_text(name, size, crc))
		return analyze_binary;

	analyze_entry_static t;
	t.name = name.c_str();
	t.size = size;
	t.crc = crc;

	analyze_set::const_iterator i = garbage.find(t);
	if (i != garbage.end())
		return analyze_garbage;
	else
		return analyze_text;
}

