unit tm_exit;

interface
const
      ProgID : string[50] = 'unknown';
      ErrorID: string[45] = 'unknown';
      ErrorDetail: string[60] = 'none';
      ErNotify: String[50] = 'Tim Middleton (as544@torfree.net)';
      HexList: ARRAY[0..15] OF CHAR ='0123456789ABCDEF';


implementation
uses Tm_str, Tm_date;
var
   OldExit : pointer;



{$F+}
Procedure TmExit;
var f : text;
    s : string[120];
begin
     if ErrorAddr <> nil then begin
        writeln('Oops, a fatal error has occurred running ',paramstr(0));
        s:=ForceExt(paramstr(0),'ERR');
        assign(f,s); {$I-}rewrite(f);{$I+}
        if IoResult = 0 then begin
           write('Writing Error Infomation to ',s,'... ');
           writeln(f,'Date:  ',DayStr[todayDow]+', '+MonthStr[TodayMonth]+' '+nth(TodayDay)+', '+Long2Str(todayYear),
                            ', ',Long2Str(Hour12Now)+':'+LeadZero(MinuteNow,2)+' '+AMPMStr[IsPM]);
           writeln(f,'Running:  ',paramstr(0));
           writeln(f,'Program ID:  ',ProgID);
           writeln(f,'Error Code:  ',ExitCode,' at ',Lhex(longint(ErrorAddr)));
           writeln(f,'Last Process:  ',ErrorID);
           writeln(f,'Details:  ',ErrorDetail);
           writeln(f,'Email:  ',ErNotify);
           close(f);
           writeln('done.');
        end else writeln('Could not write Error Infomation to ',s,'!')
     end;
     ExitProc := OldExit;
end;
{$F-}

BEGIN
     OldExit := ExitProc;
     ExitProc := @TmExit;
END.
