/*****************************************************************************/
/* FA Partners - Created by Flemming Bregnvig bregnvig@stealthmail.com       */
/* Copyright (c) FA Partners 1997                                            */
/*---------------------------------------------------------------------------*/
/* Name        : mailmain.hpp                                                */
/* Cotains     : The mail class.                                             */
/*                                                                           */
/*---------------------------------------------------------------------------*/
/* History                                                                   */
/*---------------------------------------------------------------------------*/
/* Date        | Event                                   | Person            */
/*---------------------------------------------------------------------------*/
/* 1997-05-30  | Created                                 | FB                */
/* 1997-11-07  | Made Win32 comp.                        |                   */
/*****************************************************************************/


#ifndef _MAIL_MAIN_HPP_
#define _MAIL_MAIN_HPP_

#ifdef __TOS_OS2__
  #define INCL_DOS
  #define INCL_DOSFILEMGR
  #define INCL_DOSERRORS
  #define INCL_WIN
  #include <os2.h>
#else
  #include <windows.h>
#endif

#include <mlist.h>
#include <istring.hpp>
#include <iprofile.hpp>

#include "..\..\BanditTagger\PM_Interface\userPreference.hpp"

class ifstream;

class TagMarker;

typedef TagMarker* PTagMarker;

class TagMarker
{
  private:
  IString _tagname;
  long    _index;
  long    _htmlIndex;
  Boolean _insert;
  public:
  TagMarker() :_tagname(), _index(0), _htmlIndex(0), _insert(false) {};
  TagMarker(const IString& aString,const long aValue) :_tagname(aString),
                                                  _index(aValue), _htmlIndex(0), _insert(false) {};
  const   IString& tagname()   {return _tagname;}
  const   long     index()     {return _index  ;}
  const   long     htmlIndex() {return _htmlIndex  ;}
  Boolean          insert()    {return _insert ;}
  TagMarker&  tagname   (const IString &aString) {_tagname   = aString ; return *this;}
  TagMarker&  index     (const long    &aValue ) {_index     = aValue  ; return *this;}
  TagMarker&  htmlIndex (const long    &aValue ) {_htmlIndex = aValue  ; return *this;}
  TagMarker&  insert    (Boolean aBoolean)       {_insert    = aBoolean; return *this;}
};

class MailTagger
{
  private:
  TAGUserIni&        _userIni;
  IString            _filepath;
  IString            _tagline;
  IString            _xmailer;
  IString            _xnews;
  Boolean            _insertXMailer;
  Boolean            _insertXNews  ;
  MList<IString>     _tagProspects;
  MList<IString>     _tagList;
  IProfile _inifile;
  // Private functions.
  unsigned long  nextInSequence    (const IString& keyname, long maxNoOfTags);
  #ifdef __TOS_OS2__
  Boolean        isProspectUpdated (FILEFINDBUF3 *fileBuffer);
  Boolean        updateProspect(FILEFINDBUF3 *fileBuffer);
  #else
  Boolean        isProspectUpdated (WIN32_FIND_DATA* fileBuffer);
  Boolean        updateProspect(WIN32_FIND_DATA* fileBuffer, HANDLE filehandle);
  #endif
  const IString& getOnelines(ifstream& in, unsigned long noOfLines);
  const IString& getWysiwyg(ifstream& in, unsigned long noOfTags);
  public:
  MailTagger(TAGUserIni& aUserIni);
  // The get members.
  const IString& tagline(IString aString);
  const IString& tagline()     const {return _tagline;}
  const IString& xmailer()     const {return _xmailer;}
  const IString& xnews  ()     const {return _xnews  ;}
  MList<IString>& tagProspects()  {return _tagProspects;}
  MList<IString>& tagList()       {return _tagList;}
  //The set members.
  void  isTaglines(MList<TagMarker>& tagMarkers);
  static IString readOnelines(ifstream& in);
  static IString readWysiwyg (ifstream& in);
  IString        getRandomTagProspect();

};


class MailHandler
{
  private:
  TAGUserIni&  _userIni;
  IString _mailFilename;
  IString _orgMail;
  IString _newMail;
  MList<TagMarker> _tagMarkers;
  Boolean _changed;
  Boolean _isValid;
  Boolean _debug;
  Boolean _forceX;
  Boolean _usingNetscape;
  Boolean _htmlEnabled;
  Boolean removeX    (const IString& xtype);
  Boolean insertX    (const IString& xmailer, const IString& xtype);
  Boolean insertXTag ();
  public:
  MailHandler::MailHandler(TAGUserIni& userIni, const IString& aString, Boolean debug = false, Boolean forceX = false, Boolean usingNetscape = false);
  Boolean  insertTaglines(MailTagger& tagger);
  Boolean  save();
  Boolean  handleX();
  Boolean  anonymous();
  Boolean  changed()     const {return _changed;}
  Boolean  isValid()     const {return _isValid;}
  Boolean  htmlEnabled() const {return _htmlEnabled;}
  IString& newMail() {return _newMail;}
  MList<TagMarker>& tagMarkers() {return _tagMarkers;}
};

#endif
