/*****************************************************************************/
/* FA Partners                                                               */
/* Copyright (c) FA Partner 1997                                             */
/*---------------------------------------------------------------------------*/
/* Name        : install.cmd                                                 */
/* Description : Installs the Bandit Tagger                                  */
/*---------------------------------------------------------------------------*/
/* 1997-08-10  | Created                                 | FB                */
/* 1997-08-27  | Inserted product support option.        | FB                */
/*****************************************************************************/

'@ECHO OFF'

call RxFuncAdd 'SysCreateObject', 'RexxUtil', 'SysCreateObject'
call RxFuncAdd 'SysOpenObject'  , 'RexxUtil', 'SysOpenObject'
call RxFuncAdd 'SysMkDir'       , 'RexxUtil', 'SysMkDir'
call RxFuncAdd 'SysIni'         , 'RexxUtil', 'SysIni'

Say 'Install the Bandit Tagger to :'
pull path
Say 'Use Bandit Tagger togther with :'
Say '1. Internet Adventure'
Say '2. SouthSide Software'
Say '3. MR/2 Internet Cruiser Edition for OS/2'
Say '4. None of the above'

pull option

select
  when option = 1 then do
    xnews   = "Internet Adventurer v1.02 for OS/2 with Bandit Tagger v1.20"
    xmailer = "Internet Adventurer v1.02 for OS/2 with Bandit Tagger v1.20"
    parent  = "<INETADVFOLDER>"
  end
  when option = 2 then do
    xnews   = "PMINews 1.01a for OS/2 with Bandit Tagger v1.20"
    xmailer = "PMMail 1.92 for OS/2 with Bandit Tagger v1.20"
    parent  = "<PMMAILFLDR>"
  end
  when option = 3 then do
    xnews   = "MR/2 Internet Cruiser Edition for OS/2 v1.30a with Bandit Tagger v1.20"
    xmailer = "MR/2 Internet Cruiser Edition for OS/2 v1.30a with Bandit Tagger v1.20"
    parent  = "<WP_DESKTOP>"
  end
  otherwise
    xnews   = "Tag inserted by Bandit Tagger v1.20"
    xmailer = "Tag inserted by Bandit Tagger v1.20"
    parent = "<WP_DESKTOP>"
end

rc = SysIni('bandit.in_', 'BANDIT_USER', 'X_MAILER', xmailer);
rc = SysIni('bandit.in_', 'BANDIT_USER', 'X_NEWS'  , xnews  );

rc = SysMkDir(path)

'copy license.doc 'path'\license.doc'
'copy bandit.exe  'path'\bandit.exe'
'copy st.exe      'path'\st.exe'
'copy bandit.cmd  'path'\bandit.cmd'
'copy file_id.diz 'path'\file_id.diz'
'copy bandit.doc  'path'\bandit.doc'
'copy os2.tag     'path'\os2.tag'
'copy wysiwyg.ta_ 'path'\wysiwyg.ta_'

/* Avoid overwriting old inifiles. */
if SysIni(path'\bandit.ini', 'BANDIT_USER', 'X_MAILER') == 'ERROR:' then
  'copy bandit.in_  'path'\bandit.ini'


rc = SysOpenObject(parent, "icon", "TRUE")


rc = SysCreateObject("WPProgram", "Bandit Tagger", parent,,
                     "EXENAME="path"\bandit.exe;OBJECTID=<BANDIT>", "replace")
if rc = 0 then
  rc = SysCreateObject("WPProgram", "Bandit Tagger", "<WP_DESKTOP>",,
                     "EXENAME="path"\bandit.exe;OBJECTID=<BANDIT>", "replace")


exit
