/**********************************************************************/
/* Deregister the CWMailFile class                                    */
/**********************************************************************/

signal on Halt /* handle [Ctrl][C] */

say 'This program deregisters the CWMailFileClass' /* report */
say 'Press [Enter] to continue or [Ctrl][C],[Enter] to abort' /* report */
parse pull

call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs' /* Q&D way to load the REXX utils lib */
call SysLoadFuncs  /* Q&D way to load the REXX utils lib */

if (sysderegisterobjectclass('CWMailFile')) then /* if we can deregister the class */
do
 say 'The CWMailFile class has been deregistered.' /* report success */
end
else /* if we cannot deregister the class */
do
 say 'Error while deregistering the CWMailFile class.'  /* report failure */
end

say 'Press [Enter] to quit' /* report */
parse pull /* wait for [Enter] */

call Halt /* that's all, folks! */

/**********************************************************************/
Halt:  /* quits */
/**********************************************************************/

exit /* and quit */
