..
..ENGLISH LANGUAGE
..
..This is the unformatted raw text of the WSformat documentation in Wordstar/Write&Set
..format. You are encouraged to format and print the file. The file is also the source
..of the Winhelp file which part of the Write&Set archive. It was created by Hypermake.
..To learn more about the dot commands, move the mouse cursor over a dot command which
..you want to get described.
.bt wsformat.bmp
.gs130
.bt exclam.bmp
.gs300
.fi Title-e.ws
..(concerns Hypermake only)
.ti WSformat 0.99 Documentation
.<>
.bt blackdot.bmp
..(End Hypermake only)
.1
Introduction

.if not WSformat
.ep off
..principally, this code can be interpreted by WSformat,
..but is for Hypermake (generating online-help) only
.sfJ
 WSformat 0.99a Documentation
.sf
.ep on
.end not WSformat

.ic
.in Introduction
.2
WSformat abstract

.in Write&Set
WSformat is a formatting and printing program for Wordstar (DOS) and ASCII 
files. WSedit and WSformat together are the full-featured word processing 
suite Write&Set, running under current operating systems. Word processing with 
Write&Set divides the job of producing a document in two parts: editing and - 
later - formatting and printing. These two parts of the job are done by 
separate programs: WSedit and WSformat. Nevertheless, running the two programs 
simultaneously offers you the look-and-feel of a single program. The concept 
of separate editing and setting simplifies word processing and enables you 
compiling a single document with hundreds (or principally, thousands) of pages 
without any problems.

Write&Set is based on the Wordstar DOS philosophy ('what you see is what you 
want' and not 'what you see is what you get'). Nevertheless, WSformat does 
have a provision for document preview.

WSformat is Shareware for documents with 10 pages and more, otherwise it is 
Freeware. WSedit is a Freeware without limitations. If you do not register 
WSformat and wait a while, you are no more able to format documents which 
equal or are larger than 10 pages. This is the only Shareware limitation.

WSformat supports hyphenation, the creation of end notes and footnotes, 
generation of tables of contents and indexes, line drawing, embedding graphics 
in text and allows conditional statements. In contrast to the older DOS 
Wordstar versions, document preview and printing use functions provided by the 
Windows (or OS/2) operating systems. This means you have access to the 
printers and type fonts which are installed on the operating system.

Wordstar Compatiblity: WSformat accepts all Wordstar (DOS) files, but does not 
support all Wordstar DOS functions, i.e., those which were added after 
Wordstar Version 4. Instead, some extended functions (such as generating 
tables of contents or handling footnotes) are implemented in a 
Write&Set-specific way. Basic Wordstar 5-7 'symmetrical sequences' are 
recognized (indentions, for example).

The Write&Set command syntax is very similar to that of Hypermake. From a WS 
file, Hypermake will generate an equivalent file in RTF, Winhelp, HTML, IBM 
Help or Microsoft HTML-Help format. The Windows and IBM Help files of WSformat 
and WSedit were compiled from WS (Write&Set unformatted) files. The Hypermake 
commandline version is part of this installation and can be reached via 
WSformat menu.

WSformat requires Windows 98, Windows NT 4, OS/2 Warp 3 or later (Windows 
2000, XP respective eCS).

.2
Word Processing with Write&Set

.ID P_PROCESSING
.in wordprocessing
.in WS file
.in FMT file
Word processing with Write&Set is very different from those Windows word 
processing programs such as Winword or StarOffice, and also differs in some 
respects from Wordstar for DOS. Word processing operations are closer to Latex 
than to Winword. With Write&Set, the task of 'text content editing' and that 
of 'typesetting' are sequention operations, rather than simultaneously.

For the moment, forget all you have learned about computer word processing and 
think about the time before the personal computer was invented, when your 
'word processor' was pen, scissors, cement, etc. The way to get a complex 
document involved some or all of the following steps:

Step 1:Writing a draft in longhand, often including notes that would not 
appear in the final publication;
Step 2:Typing the draft with a typewriter;
Step 3:Correcting the text by hand on the typewriter copy;
Step 4:Sending the typewritten manuscript to the typesetter.

In the first step there was no need to consider the layout - page size, 
margins, type faces, hyphenations. The author concentrated only on the 
contents... The four steps were performed step by step. Today when you 
prepare a document using Winword, the steps are all intermingled, effectively 
taking place simultaneously. Because of this mode of operation, Winword and 
its counterpart word processors are difficult to use, if you have to prepare 
more complex documents. This design philosophy produces word processing 
programs that are big, slow, drain system resources, crash often, and in some 
cases are unable to produce the document the user requires.

And, making it more difficult, Winword and its counterpart word processors 
change the line and page formatting of a document, if you load it on a 
different computer or print it to another printer. Line and page breaks which 
are optimized by hand can force very unpleasant layout malfunctions.

By way of contrast, when documents are prepared with Write&Set, the four steps 
take place sequentially rather than concurrently.

Step 1:Editing: Text is prepared as an (unformatted) 'raw' text file (a 
*.WS file) using WSedit (or Wordstar DOS). Such a text file will not 
include fixed margins. If you use WSedit, the margin of the displayed 
text depends only on the settings of the editing window and the screen 
font. The raw text contains e.g. the information that a paragraph 
shall be a chapter heading with heading level 2, but not which font 
shall be used for this heading.

When preparing documents on your computer, WSformat will only rarely be called 
upon to process the text. This is the reason why I have decided not to create 
a single program incorporating both functions.

Step 2:Starting WSformat, formatting the unformatted raw-text WS file to 
produce a formatted FMT file:

The WSformat 'format' function reads the raw-text WS file and writes 
an FMT file. It does not modify the WS file in any way. In the FMT file, which 
can be also viewed and edited by using WSedit or Wordstar (DOS), the right 
margin is now fixed, the page breaks are apparent and visible, and words at 
the end of the line which require hyphenation are displayed accordingly. 
Heading lines have now commands for a specific font.

Step 3:Minor changes by hand on the formatted FMT file

If you are not satisfied with some formatting details, you can make small 
changes to the FMT file. These include such things as incorrect hyphenations, 
and more importantly, page breaks which can be improved by hand.

However, avoid making bigger changes to the FMT file; if these are considered 
necessary, it is more expedient to make the changes to the WS file and run 
WSformat again. Because WSformat formatting is extremely fast (about 100 pages 
per second, depending on your processor and the nature of the text), this does 
not represent a significant delay in production.

The WSformat preview feature helps in locating sections of the text where the 
printout can be improved. The printout in the Preview window mirrors exactly 
page printout.

Step 4:Printing the final version of the document

After making the final changes to the FMT file, select the physical or virtual 
printer installed on your computer and print your document. This is done the 
same way as it would be for other current word processors. Besides physical 
printers (laser or inkjet printers), it is possible to use 'virtual' printers 
(FAX and PDF creation programs). These also work on files produced with 
WSformat.

.2
Who should use Write&Set?

The Write&Set word processing suite is useful for the following users:

Users of Wordstar (DOS): Of course, all computer users who still use 
Wordstar and resist Winword and similar programs will find a new home with 
Write&Set.

Academics and other authors who have to prepare large and complex 
(scientific) documents: Authors, students, scientists and others often 
fear using winword-like programs when generating large, complex documents. 
Many people have found themselves typing and re-typing such documents, due 
to the inherent instability (and the resulting crashes) when handling such 
documents. Because of the serial processing of WSformat, there is virtually 
no limit on file size and there is no logical relationship between file 
size and stability of WSedit and WSformat. There are no problems in 
processing a document with hundreds of pages, thousands of footnotes, and 
dozens of graphics. After creating and perhaps modifying a formatted text 
file (FMT file), line breaks and page breaks are fixed even if you print 
the document to another printer.

Note to Students: WSformat is available for a special, very low student fee 
(30$).

All people who do not like winword-like software: users who do not like 
winword-like word processing software are invited to switch to Write&Set. 
Write&Set is also a fast, easy-to-use and adequate software for writing 
even simple correspondence.

Companies who want to reduce software expenses: WSedit is free and 
WSformat is much cheaper than word processors such as Winword. Helping a 
Write&Set user by telephone or by E-Mail is simpler, because dot commands 
are transmitted within the document, instead of being forced to describe 
mouse controlled actions. ('On the top left, you see an icon with a wide 
border...') By using the 'embed file .fi' command, it is possible to 
observe standards throughout documents regardless of the author. For 
example, the company letterhead to be used in all WSformat files can be 
maintained centrally, and when it is necessary to change 'boilerplate' 
text, those changes will appear in all subsequent publications.

Limitations

Write&Set does not support muli-column text editing and formatting. 
(Nevertheless, I plan multi-column printouts.) It is not intended for 
desktop-publishing of such things as newsletters, magazines, etc. It is not 
possible to include output from other applications via OLE (Object Linking and 
Embedding), and modifications in e.g. Excel are automatically transferred to 
the wordprocessor. Instead you have to copy the graphic via clipboard from 
Excel to Write&Set; Write&Set saves the graphical data in a separate file. 
When making changes to your spreadsheet, you have to update the graphic file 
manually via clipboard, something Winword will do automatically if you use 
OLE.

.1
Installation and first steps

.ID P_INSTALLATION
.in Installation
.2
Installation of Write&Set

Download the Write&Set archive file and unpack it to a new directory, e.g:
C:\Programs\WriteSet.

The two programs WSedit and WSformat are now located in subdirectories:
C:\Programs\WriteSet\WSedit
C:\Programs\WriteSet\WSformat

Now simply run the INSTALL program in the WriteSet directory. INSTALL creates 
file associations and program icons on the desktop (and in the Windows Start 
Menu). File assocation means that you can now double-click to text files. 
INSTALL does not copy files. Deinstallation is also available.

By default, WSformat hyphenation is turned off. If you want to turn 
hyphenation on, do the following:

Select the Hyphenation page in the settings notebook. For all languages 
other than German, click on 'external tex file' and select your language. 
Please note that some conventions of British and American English are 
different, so there are own settings. The browser, which uses the Google 
search engine, is started and you are directed to download the file to the 
directory where WSformat.exe resides. Tex hyphenation files are small.
For German users, I recommend the internal german hyphenation which is 
better than the tex algorithm.

When starting WSformat the first time, some initialization procedures run 
automatically (but you don't need to know about it):

-A binary file WSformat.dta which retains user settings will be generated; 
it contains the data found in the settings notebook (settings - settings 
notebook)
-A simple text file fonts.ini will be generated. It stores the information 
about the fonts which are available on your system and it assigns the "font 
characters" to concrete fonts. It is recommended that you modify this file 
to fit your needs. (settings - font definition)
-The fonts.ini text file is converted to a binary file printername.dta 
which holds detailed font information before formatting or printing. It 
gets created when you use the printer the first time. When changes are made 
to fonts.ini, e.g. 'HP Deskjet 600.dta' file is updated automatically and a 
small window 'registering fonts' appears.
-if you use the 'format' function for the first time, WSformat asks you the 
name of the printer to which formatting refers to. This should be your 
favourite printer for printouts. Later, you can change this setting 
(Settings - Settings notebook, page Program):

.2
Format and print this documentation

Instead of reading the docu, it is also useful to proceed with the Tutorial 
which explains wordprocessing with Write&Set step by step. (WSformat menu 
Help - Start Tutorial and select the first lesson.)

.in Documentation
The Write&Set archive file contains the same documentation in WS format 
(unformatted text) and in Help file format. You have got access to the Help 
file from the WSformat main window, Help menu item, or by pressing the 
yellow questionmark buttons. If you prefer a printed documentation, you are 
encouraged to print your docu.

Select the WS file

Start WSformat. First select the file which you want to format and print, in 
this case WSFDOC-E.WS in the Write&Set directory, subdirectory DOCUSRC. Click 
on the File menu item, and then choose select. You may also simply drag 
and drop the WSFDOC-E.WS file icon into the dropdown field on the WSformat 
main window.

Format the WS file

Simply press the format button. A new file, WSFDOC-E.FMT, will be 
generated.

Edit the FMT file

If you really want to create a paper print, take a look at the WSFDOC-E.FMT 
file: By default, after formatting the editor starts and selects the FMT file. 
Take a look at the page breaks which are represented in WSedit by a floating 
yellow background. If you want to improve some page breaks, simply insert 
empty lines and then save the FMT file.

Preview

You are also encouraged to preview the file; simply press the preview 
button. When saving the FMT file in the editor, the preview window is updated 
automatically. With the arrow menu items you can navigate in your document. To 
go to page 20 directly, hold down the left mouse button and drag the mouse to 
the right. Change the height and width of the Window. The preview scale 
depends on the window width. The 4x2 menu item means that 8 pages are shown 
simultaneously.

Print the file

Select a printer by using the dropdown box in the WSformat main window. Press 
the Print button, or select File - Print pages from the menu. In this 
case, you can select single pages.

.1
File formats WS and TXT

.in WS File Format
.in TXT File Format
.in ASCII Format
Because Write&Set is a successor of Wordstar (DOS), both WSedit and WSformat 
primarily support the WS DOS file format which is based on the IBM (OEM, DOS) 
codepage and is similar to the ASCII text format. Nevertheless, it's not the 
same.

If you want to use the WSedit editor, I recommend using the WS format. If you 
would like to use your own ASCII editor or you want to embed text files from 
other persons (e.g. a workgroup in a computer network), the Write&Set TXT file 
format will interest you.

Since WSformat 0.99, for unformatted files a specific ASCII txt format is also 
supported, the "Write&Set TXT format". This is a normal ASCII txt file which 
can be edited and viewed by an arbitrary text editor. An ASCII format for 
formatted files is not supported at the moment - perhaps I will do that in the 
future.

To convert WS file to Write&Set and vice versa, use WSedit (in WS file mode) 
and select File - Import and File - Export.

In WSedit 1.0, I will implement full Write&Set TXT file support including 
syntax highlighting.

The Write&Set TXT format for unformatted files has a few special properties 
which simulate some WS file specific functionality.

The first line of a Write&Set TXT file has to be
.WIN
or
.IBM
This convention defines that
the file is a Write&Set text file and not an ordinary TXT file
the file is coded in the Windows/ANSI codepage (.WIN), the default codepage 
of the Windows operating system
the file is coded in the IBM/OEM codepage (.IBM), the default codepage of 
the DOS, OS/2 and eComStation operating system.

Codepages define what sign is shown when the computer stores a specific 
numeric value ("byte"). Bascially, the Win and IBM codepage are identically, 
but extended characters of foreign languages like in german (e.g. "umlauts" , 
, ) have different positions in the codepage table. That means if you use 
the wrong codepage, other wrong characters are shown instead of german 
umlauts.

The printer characters are simulated by the ^ (roof) character, followed by 
a capital letter:
To make an underlined word, you write ^Sunderlined^S (S in capital letters). 
When using the WS format, you enter Ctrl-P-S via keyboard and a specific 
character is shown.

If you do not want to use the ^ character because you need it for another 
purpose, you can redefine it:

.PC*

Below this command, the * character has got the job of marking printer 
characters instead of the ^ character
and you write *Sunderlined*S instead

The indention characters (soft spaces) are substituted by the ~ (tilde) 
character:

~~~~This whole paragraph will be indented by the width of 4 characters.

You can redefine this character by

.SC*
Soft Character defines the * character as soft space character.


.1
User interface

.in user interface
Because WSformat is a text compiler, there are only a few dialog windows which 
forms the user interface.

.dp#23
.2
Main Window

.ID P_MAIN
.in main window
.it file selection
The WSformat main window is the central command window for editing, 
formatting, and printing text; it is where you start jobs and open other 
windows. While merely editing raw text, you can operate on your WS files 
directly with your WSedit or Wordstar editor. While formatting and printing, 
start WSformat and leave the main window open. From there, you can also 
execute the editor on unformatted text.

Selecting a WS file

There are several ways of selecting a WS file.

Click on the File menu item, and then choose select. You will get a 
file dialog which is similar to those used in many other programs.
Drop the WS file on the WSformat icon on your desktop
Drop the WS file icon onto the dropdown field of the WSformat main 
window.

After successfully selecting a WS file, some of the five WSformat function 
buttons (unform edit, format...) are enabled, depending on the existence of 
the corresponding FMT (formatted) file.

.in RTF to WS conversion
Converting an RTF file to WS

The RTF file format (rich text format) is a worldwide standard for 
transferring text data with formatting information from one wordprocessing 
software to another. E.g. you can import a text from Winword to Write&Set by 
using the RTF file format. This allows you to import not only simple text: 
also headings and footnotes are converted.

You can convert an RTF file to WS the same way like selecting a WS file: Use 
the "File - Select" dialog or drop an RTF file onto the the dropdown field of 
the WSformat main window.

Formatting a WS file

Press the Format button or select the menu item Make - formatted file. 
Either choice is acceptable.

Editing files

To edit files from WSformat, the file name of your favourite editor has to be 
entered in Settings - settings notebook, page Program. The default setting 
is WSedit.

Selecting the button unformatted - edit starts the editor with the 
designated file (with the file extension WS); selecting formatted - edit 
starts a file with the extension FMT.

The menu items file - edit - unformatted and file - edit - formatted have 
the same effect as the corresponding buttons. If the FMT file does not exist, 
the buttons are disabled, while the menu items remain enabled.

The menu item File - close editors closes all Editor windows (for 
programmers: by sending WM_CLOSE messages) of the selected project file. This 
has the same effect as clicking to the 'Window Close' button of each editor 
window. Do not use this function with a DOS (Wordstar) editor. In this case, 
you are asked whether to interrupt the DOS session or not. If you press yes, 
all data in the DOS session will be lost.

Previewing formatted files

To open the preview window, press the Preview button or select File - 
Preview.

Printing formatted files

To select a printer, press the dropdown box button and make your selection. To 
print the whole document, press the print button. To print only a section of 
the document, select the menu item File - Print pages.

While the print job is running, the print button turns into a stop 
printing button. Note that if you interrupt printing, a lot of data likely 
will have been sent to the printer queue. You can delete this data by opening 
your printer object (in Windows via Start menu).

Dropdown field and compile information

.in Dropdown field
In the middle of the WSformat main window, there's the dropdown field where 
you are able to drag and drop WS files. This will select the dropped WS 
file.

In the dropdown field, there are three lines, each with an LED. These display 
the current processing states of the three WSformat jobs:

When formatting a text, the progress of the operation is displayed on the 
first line. While formatting, the red LED glows.
While preview is activated and the preview window is shown, the yellow 
LED glows and the page number of the page currently displayed in the 
preview window is shown. The page number also appears in the title bar of 
the Preview window.
While a print job is running, the blue LED glows.

The WSformat print job is faster than the printer can print the results. The 
operating system buffers the data and sends it to the printer as requested, 
depending on the speed of the printer.

.in Multithreading
WSformat is a multi-threaded program. This means that even while WSformat 
is executing one job, it is able to do another job concurrently. Besides the 
main thread - editing the settings notebook, for example - there are three 
threads which are represented by the red, yellow and blue LED: When the LED 
glows, the thread is running. This means that you can format a file while 
another file is still being printed, but you cannot print a file while another 
file is printed. While printing a file, you can select another file and format 
or preview this new document.

The extended compile jobs Make - Text and Footnote, Make - Content and 
Make - Index are also executed in the format thread.

You are not allowed to exit WSformat until all threads are finished. If 
WSformat does not end a thread - we don't hope that such a bug occurs - close 
the main window and answer "Yes" for interrupting the running thread. In this 
case, WSformat tries to kill the threads and to close. It can rarely occur 
that this trial fails and you have to kill the WSformat application (in 
Windows, press Ctrl-Alt-Del simultaneously and select WSformat to end the 
process), but this has not happened me for months. In any case, contact the 
author if the bug can be reproduced.

.wa verti 25
.2
Settings Notebook

.in Settings notebook
You can reach the settings notebook by selecting the menu item Settings - 
Settings notebook. The data of the settings notebook is stored in the binary 
file WSformat.dta.

.3
Program page

.it Program page
.ID P_PROGRAM
In the entry field Full filename of the embedded editor, you can select the 
editor program to be executed when pressing the buttons edit unformatted and 
edit formatted on the WSformat main window. The default setting is the 
filename of WSedit. If you don't remember the filename, use the search 
button.

The auto save function let send WSformat a message to WSedit to save the 
file currently loaded, so running "format" automatically saves the WS file, 
running "preview" or "print" automatically saves the formatted file.

If the checkbox open editor after make is checked, WSformat automatically 
executes the editor with the generated file after finishing the task of 
formatting the text, generating the table of contents, or performing any 
similar operations.

With double-click into editor switches between WS and FMT file, a 
double-click into WSedit which shows an unformatted WS file let you jump into 
WSedit which shows the formatted file, with the cursor at the same text 
location, and reverse from the formatted file to the unformatted file. But 
this only works if the document has been selected in WSformat.

Directories where files are located in: You can restrict where WSformat is 
to search for files by supplying it with a list of directories. The 
directories are separated from one another by a semicolon ';'. Instead of 
typing the directory names directly, you can also use the search button. The 
directory where WSformat.exe resides is always searched, but only if the 
search in these directories has failed. First, the directory is searched where 
the current WS file resides. The list of directories refers to the following 
files:

Formatted and unformatted files, by using the .FI command
Heading template files (.HF command)
graphic files, by using the .BM and .BT commands.

Auto correct file extension affects the main window of WSformat. If this 
setting is on, you can also drop FMT files into the dropdown window and the 
unformatted file will be given the extension WS. Deselect the checkbox if 
you:
Want to re-format a FMT file
Want to use extensions other than WS for the unformatted Wordstar file
want to preview or print files other than FMT or TAF files, for example, a 
TOC (table of contents) file.

The program language is only English and German at this time. To translate 
Write&Set to other languages, I need help from native speakers. Please contact 
me if you are interested in such an effort. "Program language" does not affect 
the hyphenation algorithm.

.3
Format page

.it Format page
.ID P_FORMAT
On the format page, you can change settings concerning formatting rather than 
directly previewing or printing or setting margins. These settings are located 
on the Layout page.

Change hard spaces to soft spaces at the beginning of a line is useful if 
WordStar/WSedit conventions using soft spaces have not been observed for text 
indention. Note that enabling this function will result in a wrong format if 
normal spaces have been used to indent the first line of a paragraph. The 
default value is disabled.

Reduce factor of spaces in wrapped lines ('gum factor') affects the width of 
the spaces between the words of a wrapped line. A gum factor of '1' means that 
on average the sum of the width of all spaces in a line is reduced about the 
width of one Courier 12 character (1/10 inch). A negative gum factor enlarges 
the average width of spaces. You can change this setting in your document by 
entering '.GU', followed by the value.

.in tab stretch
Stretch factor of tabs (soft spaces) applies only to proportional fonts. In 
a proportional font, there's no single width for every character; instead 
every character is assigned its own width. If text printed in a proportional 
font table is indented using soft spaces, there is the question to which scale 
the indention refers to. This scale is now defined by the 'tab stretch' (.TS) 
value. A value of 60 means the width of one soft space is equal to 60% of the 
widest character in the font, usually the capital 'W' in a Roman alphabet. If 
you want to be sure to keep two columns of a table from overlapping, try a 
value of 100. This applies even if the column contains only 'W's. Since this 
is highly unlikely, adequate values are from 50 to 60. When creating tables 
with a proportional font, it is strongly recommended to check carefully with 
Preview.

Default line height sets the default value of the .LH command. A value of 
8 refers to the old default typewriter linespacing. 10 is a good choice for 
Roman or Helvetica 12 point.

All .LH Line Height values refer to default normal font
let WSformat change the .LH values in the formatted file, dependent on the 
current font size selected with .SF. If you select a large font, the line 
height gets enlarged automatically. This omits overprinting lines when using 
large fonts. See Line Height.


Default fonts

.it default font
Using fonts is described in an own chapter of this document. Fonts are 
represented by single letters (case-sensitive). In the file fonts.ini, font 
letters are assigned to the fonts available on your operating system. E.g. 
the letter C usually represents the font "Times Roman 12 Point".

Paragraphs are written in alternate font, if an alternate font printer 
character (Ctrl-PA) is placed at the beginning of the paragraph.

You can select default values for both the normal and alternate fonts. The 
name of the selected font written with the selected font is displayed in the 
white field on the right.

.3
Print page

.it Print page
.ID P_PRINT
Printer to which formatting refers is relevant only if you have installed 
more than one printer on your system. In such a case, selecting the active 
printer affects how WSformat will perform its calculations while formatting. 
If you select another printer for printing, the spaces between words can 
differ because of slight differences of printer font metrics. But while 
printing on a "different" printer, neither line breaks nor page breaks are 
affected.

Allow printing unformatted WS files can be useful if you have a text file 
with a table or graphics and no running text, and thus the text file will not 
need to be reflowed. Running text will not look as good as it would be with 
the formatted file. Normally, this setting should be turned off.

Concern printing groupbox

Lower the Print job priority if user input slows down while running a print 
job.

Concerning Preview groupbox

When using preview you can also choose between positioning of each character 
and positioning only each word. Positioning only each word is faster, but it 
affects the word spacing, because WSformat can only select integer values of 
font sizes and then the spaces between words can differ. The default value is 
enabled.

.3
Hyphenation page

.it Hyphenation page
.ID P_HYPHENATION
.in Hyphenation
Hyphenation is an important feature of a word processing program that must 
formatting text with a fixed right margin. The more hypenation points are 
correctly found, the better the final appearance of the document.

The default value of hyphenation is no hyphenation.

External Tex file

For all languages other than German, the external tex file setting is 
recommended. Use the Google search engine on the Internet to locate the tex 
hyphenation file (there is one available for almost every language). Once 
located, download it to your computer and then save it in or move it to your 
WSformat directory so that it will be available. These files are available for 
nearly every language. For additional information see the chapter on 
installation.

Tex hyphenation files are text files which can be viewed with an ASCII editor 
that accepts the IBM-OEM codepage. If a word is not currently in the database, 
that word will not be hyphenated in your document. This will especially affect 
the hyphenation points of such complex substantives as 'news-paper'. The 
database stores the syllables with interspersed digits which represent the 
possible hyphenation points. An odd digit means 'hyphenation allowed,' while 
an even digit indicates 'hyphenation not allowed.' These may be considered 
indicators of 'fracture' points. Digits of larger values indicate a low 
probability of a hyphenation point; low value digits indicate 'weak' and thus 
an increased likelihood. The factor Minimal rating refers to these digits. A 
minimal rating of 1 can result in a larger number of hyphenations; values of 3 
and 5 reduce the frequency of hyphenations, and produce only very good 
hyphenations. A lower frequency of hyphenations can increase the average width 
of spaces between words. A rating of 2 is not different from a value of 1.

Internal german hyphenation algorithm

In the German language, hyphenation is very important because of complex 
substantives. The internal german hyphenation function is based on a 
phonetic assessment of a word, rather than on a reference to a stored data 
base. It can thus hyphenate words which occur in text only very seldom; proper 
names fall into this category. It locates more possible hyphenations (nearly 
all in fact) than the German TeX database. In the case of a few hyphenations, 
the results of the algorithm are ambiguous. In these cases, there is a query 
option (Rckfrage) where the user is called upon to make a judgment. Many of 
these queries are humorous funny, because the wrong hyphenation alters the 
meaning. It is possible that WSformat takes note of these corrected 
hyphenations, and stores them in the files DEULERN.DTA and GRIELERN.DTA which 
resides in the directory where the document file is located in. The additional 
'Ancient Greek' algorithm is useful for scientific documents where many words 
are derived from the Greek roots. This particularly applies to syllables 
beginning with ps, pt, rh, sc and some others. In most German (commercial, 
correspondence...) these syllables occur very seldom, and the default setting 
is set to disabled.

The minimum of not separated chars settings refer to all hyphenation 
algorithms. It's a matter of document ('house') style whether a hyphenation 
will leave only two characters of the word on a line. Higher values will 
reduce the number of hyphenations; useful values are 2, 3 or 4. You can change 
this default value with the .HN (Hyphenation Number of not separated 
characters) dot command.

Do not hyphenate areas with capital letters depends on your own style 
requirements. Sometimes there are abbreviations with capital letters which 
must not be hyphenated. If your text contains sections in capital letters, you 
should disable this function. The default setting is enabled.

A manual hyphenation setting is also available. When a word must be 
hyphenated, a simple YES-NO-CANCEL dialog box is presented to the user for his 
decision.

You can change the hyphenation default setting by using the .HY command, see 
chapter Select Hyphenation.

To indicate that no attempt should be made to hyphenate it, type a leading ^PG 
character in front of the word.

.3
Layout page

.it Layout page
.ID P_LAYOUT
On the settings notebook page Layout, you can set the default values of many 
dot commands which refer to the default page layout.

The scale of all vertical values is the default typewriter line height 
(.LH8) ('lines') and of the horizontal values the width of a Courier 12 font 
character ('columns').

The dot commands also accept inch values (.PL 8.5") or cm values (.PL 
23.0). To distinguish the line/column scale from cm scale, the latter always 
requires a decimal point or comma.

On the settings notebook, only the column/inches values can be set, but if you 
move the mouse over the entry fields, you will activate a bubble help which 
shows you the value in inches or cm, depending on the scale for bubble help 
radio buttons.

Page Template let you restore and save other dot command settings referring 
the page layout. To define a new value, select one of the "Template" items, 
edit the combobox and change the dot command values. The last template you 
have chosen is the template WSformat refers to.

Write default dot commands to FMT file is useful if you want to send a 
formatted file to another WSformat user. All your dot command default settings 
are automatically written at the beginning of the formatted file. At the end 
of the FMT file, all font characters names which were used are written.

The ASCII codepage (IBM/OEM) holds single line and double line images, e.g. 
single  (Alt-196) and double  (Alt-205). WSformat does not send the ASCII 
code of these 'characters' to the printer; instead it generates graphics. The 
Line drawing settings refers to the width of lines in 1/300 inch pixels. 
Useful values are from 2 to 10. Instead of a double line, WSformat creates a 
wide line.

It is permissible to use these characters in situations other than in .LI 
line drawing tables. E.g. you can use the Alt-196 character as a long hyphen 
in running text. The length of these lines in relation to text set in 
proportional fonts depends on the '.TS' tab stretch value: The length of one 
line character corresponds to one soft space.

Codepage has two settings. There are two code pages which are very similar, 
both known as the 'IBM codepage' or the 'OEM codepage.' The difference is in 
the line drawing characters, which are made up of both small and wide lines. 
Code page 850 lacks these combined line drawing characters, but instead 
contains additional accented characters for various languages.

An important consideration in Europe is the addition of Euro-character  which 
is available only on the 850 Code page. If you have selected code page 437, it 
will be a line-drawing character instead of the Euro symbol.

.3
Notes page

.it Notes page
.ID P_NOTES
WSformat handles endnotes, footnotes and margin notes .


Settings referring to Format function

Width of left margin for margin notes sets the default value of maximum 
length of margin notes. The same can be set with the '.MN{}n' dot command, 
where 'n' represents this value.

When creating real footnotes, which means bringing text and notes on a page 
together (Make - text and footnotes), it is necessary that each footnote 
link in the text area be indicated with a marker. This marker is the internal 
character for assigning footnotes and is simply a character which is not used 
anywhere else in your document. The default value is ^PQ (ASCII value of 17 
decimal).

To enter Wordstar Printer chars ^PA...^PZ, type a ^ (circumflex) character 
and then a capital letter.

There are different ways of showing footnote links. Footnote link text in 
text area defines how the footnote link is to appear. Acceptable conventions 
for footnote links are (1), [1], and ^T1^T (superscript). Remember that you 
can define a superscript font, see chapter fonts.

Footnote link text in footnote area is the counterpart at the beginning of a 
footnote. Note the use of leading spaces to represent indention.

If you want to insert a Return inside your footnote text, you need a 
character for RETURN in footnote text which will later be converted to a 
Return. Normal Returns in footnote text are filtered. The default value is 
Alt-174.


Settings referring to 'Making Text and Footnotes'

Number of empty lines between text area and footnotes defines the distance 
between the text block and the footnote block of a single page.

The last setting hold number of lines in a paragraph together refers to the 
Make - Text and footnote task. When creating a text and footnote file (TAF 
file), WSformat has to generate the Page breaks on its own. If you select a 
value of 2, WSformat holds the first two and the last two lines of a paragraph 
together; using a value of 1 deactivates this function. Enabling this function 
(values 2 or 3) is strongly recommended.

.3
Index page

.it Index page
.ID P_INDEX
The index page stores those settings which refer to the Make - contents 
and the Make - index function of WSformat.

Concerning content creation

When creating a table of contents (TOC) files, you can select whether or not 
to write page numbers.

With Highlight main headings enabled, main headings get bold toggles. 
Anyway, WSformat writes an empty line above a main heading.

If you check Write marked paragraphs (.CT) only, only the paragraphs marked 
by .CT appear. Otherwise, WSformat tries to decide itself which paragraph is 
a content heading and which not.

Concerning index creation

Highlight weighted page numbers generates bold face page numbers for 
weighted index entries.

Sortiere... refers to a German 'umlaut' problem.

.3
PDF page

.it PDF page
.ID P_PDF
WSformat does not has the ability itself to natively create PDF files. 
Instead, this page enables you to embed a PDF creation program, such as 
"Ghostscript", "Jaws PDF creator", "Adobe Acrobat distiller" or "Free 
Distiller" for Windows.

To learn more about creating the "Portable Document Format", visit the PDF 
chapter here in the documentation.

All PDF creation programs install a virtual printer or require an installed 
virtual Postscript printer. Either way, WSformat needs to know the Printer 
driver for creating PDF files.

The Auto select file name *.PS setting is required if you create PDF files 
via PS files (recommended). The PS file is a provisional result on the way to 
the final PDF file. If you want that the PDF file to contain a table of 
contents window and/or other information (Author, Subject, Date), WSformat has 
to write this information into the PS file before converting the PS file into 
the PDF file (which cannot be patched anymore without a tool such PDF 
Compress). Without creating a PS file, WSformat cannot include this 
information, even though some PDF creation programs do have the ability of 
creating a PDF file direct from the virtual printer driver input.

WSformat lets you create PDF files with a hyperlink-enabled table of contents. 
The information will be stored in a text file with the extension PS_CNT and 
will be created while Make - create contents (TOC file) is running. Create 
PS_CNT file when "creating contents" lets you turn this function on and 
off.

PS_CNT files do contain "PDFmarks", the table of contents window in the PDF 
file.

Location of created PS file lets you select between document directory and 
TEMP directory. The TEMP directory is defined by the environment variable of 
your operating system. The TEMP directory is a useful choice if the document 
directory resides on a (slow) network drive or if you do not want the 
temporary PS file to appear in your document directory.

If your PDF creation program is not integrated with a printer driver, you can 
execute PDF creation program after creating PS file automatically. To do so, 
WSformat needs to know the full filename of PDF creation program and the 
program parameters (* = PS file name, # = PDF file name). When executing the 
PDF creation program, WSformat replaces * with the full PS file name and # 
with the full target file name (PDF file). The PDF file name is always located 
in the same directory as the Write&Set text document file.

.2
Insert Dot Commands Window

.ID P_INSERTDOTCOMMANDS
If you don't know Wordstar and Write&Set dot commands by heart, you can use 
the Insert Dot Commands Window to insert dot commands to your unformatted WS 
file. You can reach this window via WSformat main menu, item Command.

All dot commands are part of the outline tree. They are sorted to logical 
subjects.

If you know the name command, but don't remember the usage or syntax, type the 
two letters of the dot command behind go to command. This let you jump to 
the corresponding line in the outline tree.

When selecting an outline tree item, you'll get a short description 
automatically.

Before pressing the Help button, select a line in the outline tree. Help 
activates the page of the Online Help where the subject or dot command is 
explained.

Insert inserts the current dot command into the unformatted WS file in 
WSedit. This only works if a WS file was selected in WSformat and the 
unformatted editor window is open. Some commands use the WSedit titlebar for 
further information.

.2
Preview Window

.ID P_PREVIEW
.in Preview
To have access to the preview feature, first format your text. Then press the 
preview button or select File - Preview. The preview window opens and the 
yellow LED in the WSformat main window glows.

The title bar of the preview window now displays the current page number and 
the filename.

When saving the FMT file in the editor, the preview window is updated 
automatically. Changing settings in the settings notebook will also 
automatically force a preview update.

Key and mouse functionality

In the preview window, use the Pg dn and Pg up keys of your keyboard or 
the left and right mouse button. The left mouse button shows the next page, 
the right mouse button the previous page. To go to page 20, for example, hold 
down the left mouse button and drag the mouse to the right.

Change the window with and height. The preview scale depends on the window 
width. If you make the window width large, a vertical scrollbar appears.

Preview Window menu items

The preview window has got a menu bar without submenus. If the menu items are 
gray, the function is not available at the moment.

|< and >| means: go to the first and go to the last page of the document
< and >: show the previous and next page
>>> Slideshow mode: show a new page every 2 seconds.

1x1  2x1  3x1  4x2  6x3  10x5 let you select how much pages you want to see 
simultaneously. The first number defines the number of pages side by side, and 
the second number among one another. So the 4x2 setting let you show 8 pages 
simultaneously. If the current preview shows e.g. the pages from 1 to 8 and 
you press Pg dn key or the > menu item, the pages 9 to 16 are shown.

.2
Print pages dialog

.ID P_PRINTPAGES
.in print pages
To print a document from the first to the last page, select a printer in the 
main window dropdown box and press the Print button.

To print selected pages of a document, click on File - print pages. This 
brings up a small dialog window. If you press Print without entering values 
for the first and last pages, the whole document will be printed.

You are allowed to enter several page numbers in the entry field, separating 
them by commas or spaces. To print several pages, enter the first and the last 
page numbers, separating them with a hyphen.

If you want to print from a specific page to the end of the document, select a 
number for the last page which exceeds the size of the document, e.g. 
18-999.

Enabling the Exclude pages checkbox means all pages will be printed, but now 
the pages shown in the entry field are instead omitted.

You can select the Number of copies which you want printed. The document is 
printed once from the first to the last page, and then the document is printed 
a second time from the beginning; which means the page order is in collated 
sequence, such as 1, 2, 3, 1, 2, 3, etc., and not as 1, 1, 2, 2, 3, 3.

Two-sided printout means printing both sides of a paper. Normally you will 
print all pages, but in in case of two-sided printout, you can print only odd 
or only even pages. Odd pages are always located on the right side of a book 
and even pages on the left side.

Press Print to start printing and Cancel if you decide to terminate the 
job.

.2
Graphics dialog

.ID P_GRAPHICSDIALOG
.in Graphics Dialog
The graphics dialog helps you embed graphics in your WS text document.

You have access to the graphics dialog in five different ways:

Select Make - Graphics file in the WSformat main window
drop the graphics file icon into the WSformat dropdown field
drop the graphics file icon to the WSformat program icon on your desktop
Double-click to the filename parameter behind the ".BM" (Bitmap) command in 
WSedit
or, if the clipboard contains a graphic, select Edit - paste or Shift-Ins 
in WSedit.

There are two different ways of loading a graphic into the graphics dialog:

Loading the graphic from the clipboard (press the "load from clipboard" 
button)
Loading the graphic from a file (press the "load from file" button).

If you change the size of the graphics dialog window, the scale of the shown 
graphic also changes. The shown percentage shows the current scale. 100% means 
that one pixel on the screen relates to one pixel in the graphic file. Because 
WSformat knows the formatting data of your current project, it knows the 
number of required pixels and shows it in the line "required size...". You can 
select the desired resolution in the settings notebook, page print. A good 
choice for a paper print is 300 dpi (dots per inch). But WSformat cannot 
enlarge the graphic; this is the task of your graphical application producing 
the graphical data.

WSformat supports different graphic formats. There are two groups of graphic 
formats: pixel-orientated and vector-orientated. Pixel-orientated formats hold 
the graphical data in pixels. Vector-orientated formats hold the data in a 
list of drawing commands like: "draw a rectangle with a size of 50x100 and a 
pen width of 5 in red color". If the graphic is shown enlarged, 
vector-orientated formats still look fine. Enlarging pixel-orientated graphics 
forces stairs in diagonal lines. An Excel chart can be saved 
vector-orientated, but not an image.

The following graphic formats are available in the Windows version:

Windows Metafile Win32 (EMF file): a vector-orientated, platform-dependent 
format. It's the first choice for saving drawings like charts on the 
Windows platform. Metafiles have no fixed size, they have a variable 
size.
Windows Metafile Win16 (WMF file): like EMF, but this is the old Windows 
3.1 format.
Bitmap (BMP): the most common pixel-orientated format. WSformat for Windows 
does not compress BMP files, so you need a lot of space on your hard disk. 
WSformat for OS/2 compresses the BMP files.
GIF (Compuserve Graphics Interchange Format): like BMP files, but with a 
very good compression algorithm. The files are much smaller than BMP files. 
GIF is the dedicated format for abstract pixel graphics.
JPG (JPEG): The first choice for images. The compression algorithm is 
optimized for images and does not save details which are not really 
visible.

WSformat for OS/2 only supports the BMP file (compressed) and the OS/2 
Metafile format (MET files). If you want to get portable documents between 
Windows and OS/2, you have to use the BMP graphic format only.

When copying data from the clipboard and the clipboard contains Metafile data, 
the Metafile format is always chosen. You can convert the Metafile to a pixel 
file by clicking one of the radio buttons. The conversion is based on the 
"required" size, calculated from the formatting information of your text 
document and the selected resolution in the settings notebook, page print. 
The conversion reverse cannot be executed, because it does not make sense.

.IF IPF
In the current version of WSformat for OS/2, the conversion from Metafile to 
Bitmap does not work yet. I hope to fix that in the next version.

.END
If you paste a file from the clipboard, WSformat automatically makes a 
proposal for the filename. It takes the name of your text document (e.g. 
"mydoc") and concatenates the string "_gra", followed by a two-digit number: 
mydoc_gra01.bmp
If a file mydoc_gra01.bmp or mydoc_gra01.emf and so on already exists, 
mydoc_gra02.bmp is chosen and so on.

.2
Info and Error Messages

.ID P_ERRORWINDOW
.it Info and Error Messages
The "Info and Error Messages" Window appears, if specific info or error 
messsages do appear while compiling a job. Formatting simple text without 
errors won't activate this window. The Preview and the Print function does not 
use the "Info and Error Messages" Window, but formatting, converting RTF to 
WS, creating table of contents, index and "make text and footnotes" does.

An error message appears if e.g. a dot command has been used in a wrong way. 
In the message, you can see the Paragraph number ("Par") where the bug occurs. 
The paragraph number counts the Hard Returns, but neither a dot command is a 
"Paragraph", nor an empty line. WSedit shows the paragraph number in its 
titlebar.

If you use WSedit and not another editor, you can double-click to the error 
message and this will run WSedit with the cursor at the paragraph where the 
error or info messages refers to.

.2
Command line Arguments

.in Command line argument
To select a document, simply enter the file name as an argument on the command 
line. If the filename contains spaces, type 'file name' or "file name". Do not 
omit the file extension.

You can run WSformat from the command line or in batch files. In this case, 
WSformat gets closed automatically after finishing the job. There's an 
argument /f for formatting and an argument /p for printing. These 
commands relate to the format and the print button in the WSformat main 
window:

.sfM
C:\> wsformat /f MyDocument.ws
C:\> wsformat /p MyDocument.ws
C:\> wsformat /f MyDocument.ws #condition1 #condition2
.sf

With the # (Hash) character, you can define several "if conditions" 
(conditional statements) for the formatting process. WSformat accepts only one 
single job with only one document. To run several jobs, you have to execute 
WSformat several times. The order of the parameters makes no difference.

.1
RTF and HTML conversion

.in RTF conversion
.in HTML conversion
.in RTF
.in HTML
The RTF file format (Rich Text Format) is a worldwide standard for 
transferring text data with formatting information from one wordprocessing 
software to another. E.g. you can import an (unformatted) text from Write&Set 
to Winword by using the RTF file format. This allows you to import not only 
simple text: also headings and footnotes are converted.

To import an RTF file, simply drop the RTF file into the dropdown box or press 
File - Select and select the file type "RTF".

In the WSformat menu structure, you will find the command Make - RTF text. 
But WSformat does not has the ability itself for this conversion. This does 
Hypermake - also a Shareware program written by Martin Vieregg. The Hypermake 
commandline version is part of the Write&Set package since version 0.95 and 
gets executed from the WSformat Make - RTF text command. It runs separated 
from WSformat in a text window (usually white letters on black background).

The HTML file format is the file format of the World Wide Web. These files 
are viewed with a Web browser like Microsoft Internet Explorer, Netscape, 
Mozilla or Opera.

Make - HTML also executes Hypermake. Hypermake does not create only one 
single HTML file. Instead, a folder will be created containing a lot of HTML 
files, one for each chapter. To view the HTML file with your browser, click to 
the HTML file which has the same name as your WS file. E.g. if the name of 
your WS file is MYDOC.WS, the HTML start file is MYDOC.HTML and all the HTML 
files are located in the folder MYDOC.

If you want to create HTML files from the WS file format, you must use chapter 
headings, otherwise you will get an error message. Every text has to be part 
of a chapter, so begin your text with ".1". Sometimes you will have different 
commands or text, dependent on compiling HTML files or formatting and printing 
a text. Use conditional statements in this case. When formatting a text with 
WSformat, the condition "WSFORMAT" is always set.

Behind the command ".TI" on top of your WS file, you can enter a document 
title which will appear in the browser titlebar.

The user settings of Hypermake are hold in the file HMAKE\wsformat.ini which 
can be viewed with WSedit. Here, the font letters are defined independent from 
the Fonts.ini file and a lot of other settings are located here. If you are 
interested in Hypermake, please download Hypermake from 
http://www.hypermake.com .

Hypermake compiles WS files, but the internal editor of Hypermake reads and 
writes WS files only if you have got Hypermake 4.1 or later.

If you want to convert WS files which are bigger than 20 kB, you need a 
Hypermake registration key. If you have registered WSformat, you are 
encouraged use this key for Hypermake, too: Simply insert this key to the line 
"Registration code = " of the file HMAKE\wsformat.ini. Now you can compile WS 
files to RTF or HTML format without size limit. But if you want to generate 
large Winhelp, IBM Help or MS HTML-Help files, you have to buy the specific 
Hypermake registration key.

Nevertheless, you are allowed to compile the help source files located in the 
DOCUSRC directory.

.1
Creating PDF files

.in PDF
"PDF" is an abbreviaton for Adobes "Portable Document Format", a file format 
for publishing text documents.

If you have installed a PDF creation program and made your input in the 
settings notebook, page PDF, you can convert your formatted files (FMT 
files) to the PDF file format by using the WSformat main menu Make - PDF 
file.

With WSformat, you can create PDF files containing a table of contents window 
and other information (Author, Subject, Date).

.2
About PDF creation software

PDF file creation programs like "Jaws PDF creator", "Adobe Distiller" or "Free 
Distiller" in Windows and ePDF or PMPDF in OS/2-eCS do install a virtual 
"printer driver". If you print to this virtual device, you will directly 
create a PDF file. Alternatively, you can install a typical Postscript (PS) 
printer driver like "Apple Laser Writer" and let redirect the output to a PS 
file by WSformat. In a second step, this PS file can be converted to a PDF 
file by the PDF creation program.

If you want the PDF file to contain a table of contents window and other 
information (Author, Subject, Date), WSformat has to write this information 
into the PS file before converting the PS file into the PDF file (which cannot 
be patched anymore, unless a tool such as PDF Compress is used), so a direct 
conversion while printing to a PDF file does not fit the purpose.

There is a lot of PDF conversion software. The most expensive one is the 
"Adobe Distiller" software, and the less expensive is the free Ghostscript 
package. The main advantage of Adobe Distiller and its commercial competitors 
like "Jaws PDF creator" - which is cheaper, but also a good software - is the 
easy to use installation program and user interface.

.2
Embedding Ghostscript in WSformat

I have received good results with Ghostscript. It is a free program to 
generate Adobe PDF files, but it has no graphical user interface. Anyway, if 
you have have a basic computer knowledge (e.g. copying and editing files) to 
manage the installation process, it's not difficult to create good PDF files 
with WSformat and Ghostscript.

Here you will find here a download and installation instruction for using the 
free Ghostscript Software together with Write&Set. If you have installed all 
properly, you can create a PDF file simply via WSformat menu Make - PDF 
file.

1. Download Ghostscript

Go to

http://www.ghostscript.com/doc/AFPL/index.htm

and follow the links to your operating system. A download of "Ghostview" 
(GSview, a PS file viewer) is not necessary, only the Ghostscript file, e.g. 
gs814w32.exe. The file has got a length of 7 MB.

Unpack the file to a new directory of your choice, e.g. C:\GS, and remember 
the directory!

The directory holds two directories: a FONTS directory and the Ghostscript 
program directory, e.g. GS8.14.

2. Modify GS.CMD

In the Write&Set archive, you will find a file GS.CMD in the "UTIL" directory. 
Use an ASCII editor like Notepad or WSedit to read and edit this file.

If you have got Windows 95, 98 or ME, rename the file from GS.CMD to GS.BAT.

On top of this file, there are two lines beginning with "set". Edit here the 
Ghostscript program directory and a list of directories where fonts reside.

To find out where additional Postscript fonts exist in other directories, try 
in the command line prompt:

C:\> dir *.pfb /s

and make the directory names be part of the list behind GS_FONTS=, separated 
by ;

Save the GS.CMD (GS.BAT) file and leave the editor.

3. Install DO.EXE

DO.EXE is a tiny all-purpose commandline utility, used by the GS.CMD command 
file. (If you are interested in DO.EXE, read DO.TXT or simply type DO in the 
commandline without parameters. If you are familiar with the command line, you 
will like it!)

To install DO.EXE, simply copy DO.EXE from the UTIL directory to a directory 
of your PATH statement, e.g. C:\WINDOWS.

.IF IPF
To run DO.EXE, KBDVIO32.DLL has to be copied to a directory which is part of 
the LIBPATH statement, e.g. C:\OS2\DLL.
.END

4. Install a virtual Postscript Printer Driver

Install a postscript printer on your Operating System. A typical postscript 
printer is "Apple Color Laserwriter 12/600". The choice of the output device 
(e.g. LPT1:) makes no difference. You can install such a printer driver even 
if you don't have a postscript printer. (Windows: Start - Settings - Printer - 
New Printer)

On the Windows platform, you'll get best results if you install the "Generic 
postscript printer driver" from Adobe, specialized for generating PDF files. 
Visit:

http://www.adobe.com/support/downloads/product.jsp?product=44&platform=Windows

The current Adobe Windows Printer driver has got a length of 7 MB.

.IF IPF
Adobe has not published an OS/2 printer driver.
.END

5. Edit WSformat settings notebook

Start WSformat, select settings - settings notebook, page PDF.

Select the Printer driver for creating PDF files.

The default settings should fit your purpose when using Ghostscript.

If you have modified the default settings, check all checkboxes and edit the 
full name of the GS.CMD command file, e.g. "C:\Programs\WriteSet\util\gs.cmd". 
If the file exists, the edit field turns to green. The required parameters are 
* # (star, space, hash).

.2
specific PDF dot commands

You can enter an author, a subject, keywords and a document title already in 
your unformatted file:

.TI Title of the document
.KY Keyword1 Keyword2...
.AU Name of the Author
.SU Subject of the document

Alternatively, you can type:

.TI
Title of the document

If a table of contents information (PS_CNT file) is available and/or you have 
used at least one of the four commands above, WSformat adds some information 
to the PS file after it has been created and before running the PS to PDF 
conversion program (Ghostscript, Adobe Distiller...) If neither contents 
information (PS_CNT file) nor one of the dot commands above has been found, 
WSformat remains the PS file unchanged.

.WA verti 30
.dp#-
.1
Fonts

.ID P_FONTS
.in Fonts
Using fonts with WSformat is very different from Wordstar, but similar to 
Hypermake. Fonts are selected by using specific dot commands.

In WSformat and Hypermake, fonts are represented by a font letter which is 
a shortcut for a specific font description. Font letters are case-sensitive, 
so you can use A to Z and a to z for a total of 52 letters.

.2
Storing font data

.in Fonts.ini
.in Printername.dta
The information about fonts is stored in two files: Fonts.ini and 
Printername.dta. Both files are located in the directory where WSformat.exe 
resides.

Fonts.ini is a text file which can be edited with any reliable ASCII editor, 
with WSedit, or by selecting Settings - Font definition in the WSformat main 
window.

Printername.dta is a binary file which stores the same information which is 
held in the Fonts.ini file. It stores additional information about the 
selected fonts, especially the pixel width of all characters. Because the font 
metrics slightly differ from printer to printer, every printer installed on 
your system gets such a file, e.g. 'HP Deskjet 600.dta'. After changing 
Fonts.ini, the Printername.dta file is updated automatically before processing 
the next format, preview or print job. When formatting or printing, WSFormat 
gets the information from this file and not from the operating system. This 
makes formatting and printing faster.

If formatting problems occur, regulary these binary font data files are 
involved. In this case, deleting the Printername.dta file forces recalculating 
all font data and the elimination of the problems.

.2
WSformat default fonts

.in Fonts.ini
.in Font definition
.in Font character
Starting WSformat the first time causes a new Fonts.ini file to be 
generated. WSformat asks the operating system for the names of registered 
Times Roman, Helvetica and Courier fonts. Depending on this computer-specific 
query, WSformat generates a new Fonts.ini file. Please take a look at your 
Fonts.ini (Settings - font definition).

On many systems, the following fonts are listed:

.sfM
Font A = Times New Roman 8
Font B = Times New Roman 10
Font C = Times New Roman 12
Font D = Times New Roman 14
Font E = Helvetica 8
Font F = Helvetica 10
Font G = Helvetica 12
Font H = Helvetica 14
Font I = Helvetica 16
Font J = Helvetica 18
Font K = Courier New 8
Font L = Courier New 10
Font M = Courier New 12
.sf

The font letters from A to M are allocated in every WSformat installation. 
Use these fonts if you want to write a document to be sent to another 
Write&Set user without exporting all your personal settings to the FMT file. 
This font selection covers all normal word processing purposes.

If you miss some fonts, enter your own definitions, using the free font 
letters N to Z and a to z.

.2
Basic font selection in document

.in font selection
.it normal font
For selecting a font in your document, simply use the dot command

.SF (select font),

followed by the font letter. E.g.

.SFC

This selects the font 'Times New Roman 12,' because it is defined in the 
Fonts.ini file (Settings - Font definition) as:

.sfM
Font C = Times New Roman 12
.sf

Typing .SF without a parameter selects the default font which is set in 
the settings notebook, page format.


Alternate Font

.it alternate font
You can also define an alternate font

.AF (alternate font)

which is printed when a ^PA character appears at the beginning of a paragraph. 
The syntax is similar to the .SF font:

.AFC  (selects alternate font C)
.AF   (selects default alternate font).

The alternate font gets active behind the ^PA printer character. It rests 
activated until the paragraphs end with a Hard Return.

The "alternate font" is useful if you want to write specific paragraphs in a 
different font.

Subscript/Superscript font

It is useful to select a smaller font for subscript (^PV in pairs) and 
superscript (^PT in pairs) text:

.SSB
select subscript/superscript font selects e.g. font B (Times Roman 10). The 
default setting is the default font in the settings notebook, page 
format.

.2
Font Color

.in Color
The default color of fonts is black. To change the default color of a font, 
you have to add a color information in the fonts.ini file:

.sfM
Font M = Courier New 12
Font N = Courier New 12 Blue
.sf

Both fonts M and N are defined as "Courier New", size 12 points. But Font N 
will be printed in "blue", while font M will be printed in default color 
"black".

WSformat knows the following color names (which are the same as in HTML 
language):

Black, Green, Silver, Lime, Gray, Olive, White, Yellow,
Maroon, Navy, Red, Blue, Purple, Teal, Fuchsia, Aqua.

If you want to define your own colors, you can enter font values in the R:G:B 
notation in decimal values:

.sfM
Font N = Courier New 12 0:0:128
.sf

If you are not familiar with RGB colors: R means Red, G green and B blue. All 
colors you can see on your computer screen are mixed with these three colors. 
The minimum value is 0 and the maximum value is 255. White is 255:255:255 and 
black is 0:0:0. You'll get grayscales if the three color values are the same, 
like 100:100:100. The sample above (0:0:128) has no red color, no green color 
and half blue color. This color is darkblue and the same as "Navy".

.2
Extended font selection

.ID P_FONTSEXTENDED
.it extended font
If you are more ambitious in your treatment of fonts, you can define manually 
bold, italic and bold-italic fonts.

The default behaviour of WSformat is that you simply define a font by using 
.SF. When you then use the ^PB (bold) and ^PY (italic) toggles, you will get 
the same font in bold or italic styles respectively. You have the option to 
redefine the bold, italic and bold-italic fonts manually.

When interpreting a 'Font' line in the Fonts.ini file, not only is a single 
font defined, but the italic, bold and bold-italic fonts along with it:

.sfM
Font C = Times New Roman 12
Font C" = Times New Roman 12 bold
Font C' = Times New Roman 12 italic
Font C& = Times New Roman 12 bold italic
.sf

This default behavior can be turned off selectively by entering in the 
Fonts.ini file:

.sfM
AutoItalicBold = no
.sf

and can be turned on

.sfM
AutoItalicBold = yes
.sf

You can now define the bold, italic and bold-italic fonts by hand, or you can 
override these settings. Because the Fonts.ini file is interpreted 
sequentially, it is possible to overwrite a font definition without turning 
off the 'AutoItalicBold' setting.

.sfM
Font C = Times New Roman 12
Font C" = Times New Roman 13 bold
.sf

That means italic and bold-italic of the C type face are defined 
conventionally, but the bold font between two ^PB printer characters is a 
slightly larger font (13 instead of 12).

Extended font selection in document

The .SF dot command changes the previously selected fonts for normal, bold, 
italic and italic-bold styles simultaneously. If you want to change a font 
attribute selectively, there are four specific dot commands which can be 
used:

.SN   (select normal)
.SB   (select bold)
.SY   (select italic)
.SX   (select bold-italic)

.1
Basic formatting and printing commands

'formatting and printing commands' refers to the Basic text commands - dot 
commands, printer (^P) characters - which are similar to Wordstar DOS. The 
next chapter 'Extended formatting and printing commands' refers to advanced 
features such as graphics, footnotes or contents which are implemented in a 
WSformat/Hypermake specific way and not compatible with Wordstar.

The majority of WSformat text commands are identical to those in Wordstar DOS, 
but a few are new or different from Wordstar DOS. They are marked with the 
following sign:


 Wordstar DOS user, please note!

Most word processing programs save formatting and printing information in a 
binary section of the text file. Wordstar DOS and WSformat store this 
information as readable text characters. There are two kinds of these 
commands:

dot commands: A text line beginning with a dot (period), in general 
followed by two letters. Dot commands are not case-sensitive.

printer chars: Characters with an ASCII value lower than decimal 32. In 
Wordstar DOS and WSedit such characters are entered by type Ctrl-P, 
followed by a letter from A to Z.

.2
Syntax of dot commands

.in dot command
.id P_DOTCOMMANDS
A dot command must be typed on a separate line and begin with a dot in the 
leftmost margin. If the dot is not located at the first column, it will not 
treated as a dot command and will instead be be printed as text. In most 
cases, the dot is followed by two characters which are not case-sensitive. 
Many dot commands require a following argument. For example:

.RM70

sets the right margin to the value 70. You are allowed to enter spaces between 
'RM' and the number.

If you currently read the source file (WS file) of this documentation, please 
note: In this documentation, I need to print dot commands without having them 
interpreted. The first character in a line is the bold toggle and the second 
the dot, thus isolating the latter from the right margin. A line so 
constructed will thus show the dot in the left margin, as the first character 
when it is printed, and it won't be interpreted.

In Wordstar, the default horizontal page measurement is characters and the 
default vertical measurement is lines. Both directions refer to old 
typewriter conventions. A character is considered to be as wide as a 'Courier 
12' character - the only font with which most typewriters were provided - and 
the line measurement is the default (narrow-spaced) line.

All dot commands which allow character or line counts to indicate distances 
will also accept inches and cm values:

.RM 7.0"
.RM 17.8


 Note that the use of dot (decimal point) or " makes the difference: If 
the number contains a dot or a comma, it is treated as a measurement in 
centimeters or inches. The inch value is marked by the " character.

Comments

.in comment
A very useful dot command is 'dot dot'

..This won't be printed

This allows you easily to enter text which won't be printed in the finished 
document. In WSedit, these lines are shown on the editing screen in magenta.

.2
Printer command characters

.in Printer character
.in Printer char
.id P_PRINTERCHARS
In WSformat and Wordstar DOS, characters with an ASCII value lower than 
decimal 32 have got a specific meaning. These characters are not printed, but 
instead control the formatting and printing of the job.
In both Wordstar DOS and WSedit, you can enter a command to be sent to the 
printer by typing Ctrl-P (P for 'printer'), followed by a letter from A to Z. 
In the documentation, these commands are written ^PA, ^PB and so on.

In the WSedit Emphasize submenu, you will find commands for inserting 
printer characters.

Printer chars not used in pairs

.tb6
^P@(Wordstar DOS only) Text followed by this character is flush-right 
when printing
^PZ(WSedit) Text followed by this character is flush-right when 
printing
^PKText followed by this character is centered when printing

^PATurn on the alternate font until the next Hard Return
^PGThe following word is not hyphenated
^PObinding space: a line will not be divided a binding space, e.g. when 
writing "17 sec"

Printer chars used in pairs (toggles)

.it printer char bold
.it printer char italic
.it printer char superscript
.it printer char subscript
^PBselect the bold font
^PSselect underlined text
^PYselect the italic font

.SSA
^PTSuperscript, e.g. square meter m2
^PVSubscript, e.g. CO2 will be polluted
.in subscript
.in superscript
.cp2

In WSedit, you can easily insert printer characters in pairs by marking a 
block and then selecting an Emphasize menu entry.

 WSedit shows the ^PT 2 ^PT sequence simply as 2 which is part of the IBM 
Codepage, and ^PT 3 ^PT as 3. You can set the height and depth of the printout 
with the .SR command (default is .SR3) and the superscript/subscript font 
with the .SS command (select sub/superscript font), followed by a font 
letter.

.2
Text formatting commands

.it text formatting
.ID P_TEXTFORMATTING
.3
Indentions

Hard and Soft Spaces, indentions

.in indention
.in Soft space
.ID P_INDENTIONS
Wordstar DOS, WSedit and WSformat know two different kinds of Spaces: Soft 
spaces (in WSedit shown as 'snow characters') and normal 'hard' spaces. Soft 
spaces represent indentions and tabulations. While reformatting, these soft 
spaces can vanish and then appear on another place.

(If you read this text as part of the Online help file, you can't see soft 
spaces.)

.tb4
This is a sample showing soft spaces. To indent a line in WSedit, simply 
use the Tabulation (Tab) key, or press Ctrl-OG.
It is also possible first to enter text and then to indent by typing the 
Tab key, followed by the running text.
.tb10
.if WSformat
I have now selected Tabstop 10. This is a sample of the use of soft 
spaces.
Note:It is possible to begin a line with non-indented text (in this case 
the word 'Note:'), and then to indent text by typing soft spaces.
.end WSformat

To select the indention tabulator stops, enter the WSedit and Wordstar 
command

.TB 4,14,24
which e.g. sets tab stops to the rows 4, 14 and 24. In WSedit, use the tab key 
several times to go to tabstop row 24. WSedit does not support other scales 
than rows in the .TB command.

To reformat a paragraph in WSedit after changing the '.TB' tab stop position, 
type Ctrl-B. In opposite, WSformat 'format' function interprets the resulting 
soft spaces, not the '.TB' command.

 The width of soft spaces (snow characters) can be defined with the .TS 
tab stretch command.

.TS60 (also .DE60 or .DE6)
sets the width of a soft space to 60% of the capital W of the current 
proportional font (the widest character in the font). When using a fixed font, 
this setting has no effect.

.3
Hard and Soft Returns

.it Soft Return
.it Hard Return
There are also two different kinds of Returns: lines can end with either a 
Soft or a Hard Return. In WSedit, this is shown by color patches in the 
rightmost column. Soft Returns are whown in lightblue color and Hard Returns 
in darkblue-green color.

Soft Returns vanish and appear on another place while formatting. Hard Returns 
remain fixed at the same place. Soft Returns are generated by the computer; 
Hard Returns by typing the Enter key on the keyboard.

In the WSedit "special functions" menubar item, you will find commands where 
you can transform text with Softreturns into text with Hardreturns and 
reverse.


.3
Turning formatting off and on

.ID P_FORMATTING
.in formatting off
When typing tables, there is always the concern about destroying table 
formatting, because WSformat might treat the table as running text and 
reformat it. If the table does not exceed the right margin, you won't get 
problems. WSformat attempts to recognize the difference between tables or 
columns automatically, if more than 4 normal spaces occur, but sometimes this 
rule fails. In such instances, it is safer to turn off formatting 
explicitly:

.BD Formatting disabled (also .BA, .AW OFF)
.BE Formatting enabled (also .AW ON)

Both WSformat and WSedit interpretate this command. Typing Ctrl-B in the 
WSedit editor will not have an effect after typing .BD or .BA.

If you type .BD TOTAL at the beginning of a WS document, neither WSformat 
nor WSedit will do any formatting whatever, even a .BE command occurs 
later.

.3
Changing the hyphenation algorithm

.id P_HYPHENATIONCOMMAND
.it changing hyphenation
You have access to the hyphenation algorithm choice within your document like 
you have on the hyphenation page of your settings notebook. This is useful 
when editing multilingual documents.

.HY OFF
or
.HY NO
hyphenation off turns hyphenation of words off.

.HY ON
turns hyphenation on again and activates the algorithm which was valid before 
turning off hyphenation.

.HY GERMAN
turns the internal german hyphenation on, using the checkbox values of the 
settings notebook.

.HY TEX
turns the external tex hyphenation on, with the tex hyphenation file which was 
last selected.

.HY Languagename.TEX
turns the external tex hyphenation on and makes the tex file Languagename.tex 
current

.HY MANUAL
or
.HY HAND
queries all possible hyphenations. A simple YES-NO-CANCEL dialog box is 
presented to the user for his decision.


.HN3 (Hyphenation number of chars)
let you change the minimum number of not separated characters when hyphenation 
is active. It can be useful to enlarge this number in headings. You are 
encouraged to enter a higher value in the HEADINGS.WS headings template file 
for every heading. Useful values are from 2 up to 5. The higher the value, the 
less hyphenation will be active.

.HN
switches the minimum number of not separated characters back to the default 
value, which is set in the settings notebook, page hyphenation.

.3
Line Height, superscript roll

.in Line Height
.ID P_LINEHEIGHT
.in superscript roll
.LH8
line height sets the line height to 8/48 inches. This is the default 
linespacing of a conventional typewriter. .LH12 means 150% of the default 
typewriter linespacing. .LH10 is a good choice for Times Roman 12 or 
Helvetica/Arial 12.

In the settings notebook on the format page, you will find the checkbox
all .LH Line Height values refer to default normal font

This has got two effects:
.tb4
all .LH commands gets changed in the FMT file, if you don't use the size of 
the default font, e.g. '12' for 'Times Roman 12'.
after selecting a new font with .SF, the line height is recalculated and 
in the FMT file, WSformat generates a new .LH entry behind the .SF 
command.

This setting omits that lines with large fonts are overprinted, but old 
Wordstar DOS user could get confused. The default setting is enabled.

If you are more exacting, you can use more specific "line height" commands. 
These commands are no more Wordstar (DOS) compatible, that means you won't see 
the correct page break with Wordstar anymore:

.SH (Soft Height) line height within a paragraph
.HH (Hard Height) line height between two paragraphs
.EH (Empty Height) line height of empty lines.

The .SH command affects all lines which are ending with a Soft Return, 
..EH all empty lines and .HH all non-empty lines ending with a Hard 
Return.

.SR3
superscript/subscript roll defines the height of superscript text (using ^PT 
in pairs) or the depth of subscript text (^PV in pairs). The default value is 
3.

.3
Text Width

.in Right Margin
.in Text Width
.ID P_PARAGRAPHWIDTH
.RM40 (or .BS40)
sets the width of the text block (right margin) to 40 (the measurement is in 
Courier 12 characters). The WSformat default value is 60 and can be modified 
in Settings - Settings notebook, page Page. The value does not correspond 
to the width of the right paper margin; you enter instead the width of your 
text (text width).

.RF (right formatting) sets the width of the text block like .RM, but does 
not affect the flush-right lines (by ^PZ or .OC on). That means lines 
flushed right refer to the last .RM value. This distinction is used by 
WSformat in Make - Contents.

.PO8
page offset defines the left paper margin. This command affects only 
previewing and printing, but neither formatting nor the text in the editor. 
The measurement is in Courier 12 characters, the default value is 8.

The width of a default sheet of paper is 83 characters. If your .PO page 
offset is 8 and the text block width (.RM 'right margin') is 60, then 83 - 
8 - 60 = 15 characters are left for the right paper margin.

.3
Line orientation

.it Line orientation
.in centered
.ID P_PARAGRAPHORIENTATION
Output centered

To center text, instead of typing ^PK in front of each line you can also use 
the appropriate dot commands:

.OC ON
.OC OFF

The default value is OFF.

.it Micro justification
Micro justification

You can also select whether text is to be set ragged right or justified:

.BL ON
Block on turns justification on (fixed right margin) using 'micro 
justification'
.BL OFF
Block off turns justification off (ragged right margin). ('Micro 
justification' is off.)

If the text is to be right justified (right margin is fixed - .BL ON), 
WSformat distributes the empty space remaining at the end of the line equally 
between all words. If the Printername.dta file which holds the character 
width of all characters and fonts which are used by the document is corrupted, 
micro justification will fail and the printed result will be unusable. In this 
case, delete the Printername.dta file; it will be re-created 
automatically.

By default, paragraphs are printed with fixed left and right margins (FMT 
formatted files), or with a fixed left and a ragged right margin (WS 
unformatted files).

The Wordstar commands .UJ and .OJ are also interpreted.

However, you won't see justification in the editor. .FL (German 'flatter' = 
bouncing) and simply .BL (block) without parameters is also interpreted.


 Do not format double- and triple-spaced text (Wordstar .OJ ON). Only 
paragraphs of single-spaced text can be formatted.

.3
Auto indention

.ID P_AUTOINDENTION
.it Auto Indention
.LM and .PM refer to the formatting process of WSformat. If you want to 
indent your text in a uniform way without reformatting in the editor by using 
'.TB' and Ctrl-B, you can use these two dot commands:

.LM6
left margin causes the text to begin in column 6; columns 1 through 5 will 
be occupied by soft spaces in the formatted file.

.PM8
paragraph margin is like the .LM command, but affects only the first line 
of each paragraph. In this case, the first line will be further indented.

To turn off automatic indention, set the default values .LM0 and .PM0.

.2
Page formatting commands

.it page formatting
.ID P_PAGEFORMATTING
.3
New Page

.it New Page
.ID P_NEWPAGE
.PA
forces the following text to the beginning a new page.

.CP10
conditional page keeps the following 10 lines together. If there is 
insufficient space on the page, a page break will be inserted at the location 
of the .CP command. In WSedit, you can mark a block and then press Ctrl-KP. 
This inserts a .CP command to always keep the marked block together.

.3
Page margins

.in page margins
.in page size
.ID P_PAGEMARGINS
The following page size and page margin commands are available. A table 
showing these dot commands with their default values is available on WSformat 
Settings - Settings notebook, page Layout.

.PL page length
.MT margin top
.MB margin bottom
.PO page offset (=left paper margin)
.RM right margin (=text width)

and, to define the separations between header/footer lines and text:

.HM header margin
.FM footer margin.

The scale of all vertical values is the default typewriter line height 
(.LH8) ('lines') and of the horizontal values the width of a Courier 12 font 
character ('columns'), the default typewriter linespacing.

The european A4 page size is 8.25" x 11.666" and the US Letter standard is 
8.5" x 11". So .PL66 is the length of a US Letter page, while .PL70 is 
the length of an european A4 page. See page templates on settings 
notebook, page Layout.

.3
Header and Footer Lines, Page Numbering

.in Header line
.in Footer line
.ID P_HEADERLINES
To get a header line which repeats on each subsequent page, enter (for 
example):

.HE My document, 1st Edition

You can place similar text at the bottom of the page (footer line):

.FO My document, 1st Edition


 You may then designate a font by combining the .HE Header and .SF Select 
Font commands:

.sfE
.HE My document, 1st Edition

or

.HEsfE My document, 1st Edition

which has no effect on the font selection of lines which follow.

To center a header or footer line, use the printer command character ^PK. To 
justify text right, use the WSedit ^PZ command (equivalent to Wordstar ^P@).

Page numbering

By default the page number in the footer line is centered:

.FO ^PK #

# will be replaced by the current page number when the document is printed.

You can change this default setting by entering your own footer and header 
commands.

.OP
To turn off printing of page numbers, use omit pages. This command let the 
footer line get void.
.PG (or .PN)
turns printing page numbers on again.

.PC30
page column prints the page number at column 30 and is retained for Wordstar 
compatibility, but will often produce unpredictable results when proportional 
fonts are used.

.PN15
page number immediately advances the page counter to the value of 15. This 
is no good practice, because it may result in the same page number occuring 
twice in the same document.

Several Header- and Footer Lines

It is possible to define up to five Header or Footer lines:

.cp15
(top of page)
.H1
.H2
.H3
.H4
.H5 = .HE

(text area)

.F1 = .FO
.F2
.F3
.F4
.F5
(end of page)

Note that these lines can appear only if the .MT and .MB values (margin 
top and margin bottom) have been assigned values which are high enough to 
allocate the necessary space. Use Preview to test whether or not the header 
and footer lines appear.


 You can set the vertical pitch (line spacing) of the header and footer 
lines, comparable to the .LH dot command.

.HH Header line Height (till WSformat 0.98 .HH)
.FH Footer line Height

The default value of these commands is 8 (= default Typewriter linespacing of 
6 lines per inch).

.3
Odd and even pages

.it Odd and even pages
.ID P_ODDEVENPAGES
 By default, the page number value has no effect to WSformat printing. If you 
want to write a book, the left page is always even (2, 4, 6), and the right 
page is odd (1, 3, 5). (If you don't believe it, take any book from your 
bookcase and make a spot check!)

.LR
Left-right causes WSformat to print all header/footer lines of left (even 
numbered) pages flush-left and all header/footer lines of right (odd numbered) 
pages flush-right.

You can treat right and left headers separately:

.HER My Header text on the right side
.HEL My Header text on the left side

and also with footer lines .FOR .FOL.

This can be also combined with the footers and with several header/footer 
lines and with font definiton:

.H4R My header text on the right side, line 1
.H5R My header text on the right side, line 2
.F1R My footer text on the right side, line 1
.F2RsfE My footer text on the right side, line 2, Font E

and so on.

If you use .LR or .HE / .FO with left/right distinction, WSformat 
automatically recognices the document as "double-sided". If you use Preview 
showing several pages simultaneously, the Preview window begins with a black 
page.

To enter separate left margins for the odd and even pages, extend the ".PO 
Page Offset" command in the following way:

.POL 13 (Page offset left)
.POR 7 (Page offset right)

.3
Paper orientation

.ID P_ORIENTATION
.LA (also '.PR or=l')

.in Paper orientation
.in Landscape
.in Portrait
turns the printer orientation to landscape; the paper width is set larger 
than the paper height. The default setting is portrait. The dot commands 
referring to the page format do not change automatically. You have to select 
the suitable page template on the Layout page of the settings notebook 
before formatting. The .LA command only refers to printing. The commands 
.PL (page length) and .RM (right margin = text width) have to be 
different.

.if os2
WSformat for OS/2 does not support changing the paper orientation. Instead, a 
message box appears while printing if the printer is not set to landscape. 
Then the settings notebook of the printer object is activated, and you should 
make the changes manually.
.end

.2
Paragraph enumeration

.ID P_PARAGRAPHENUMERATION
.in paragraph enumeration
.in Par
To locate a text in an unformatted or formatted, both WSedit and WSformat do 
enumerate paragraphs ("Par"). Because the line and page breaks are not 
apparent in the unformatted file, page and line enumeration does not exist 
here. The paragraph enumeration is the only way to locate specific text both 
in unformatted and formatted files.

Lines with dot commands and empty lines are not part of the paragraph 
enumeration, only "real" paragraphs. In WSedit, the paragraph number is shown 
in the titlebar ("Par" or german "Abs"). Error messages of WSformat also refer 
to the "Par" enumeration. If WSformat is running, double-clicking to a 
paragraph of WSedit (unformatted) let you go into WSedit (formatted) and the 
cursor goes to the same paragraph.

But if you manually copy text into the formatted files after formatting, the 
formatted file contains more paragraphs than the unformatted file: In this 
case, the paragraph enumeration below the inserted text is no more identical 
to the paragraph enumeration of the unformatted file. To avoid this, you have 
to enclose the inserted text with two enumerate paragraph dot commands:

.EP OFF
(here I've copied text into the formatted file which shall not be 
enumerated)
.EP ON

Normally, paragraph enumeration is turned on.

It can be also useful to use the .EP command together with conditional 
defines (.if). In this case, text which is only part of the unformatted file 
has to be marked.

If you generate a table of contents (Make - contents) which you normally 
copy into the formatted file after formatting, WSformat does insert .EP 
commands automatically.

.1
Extended formatting and printing commands

The extended text commands provide extended word processing facilities; these 
are implemented in a WSformat specific way. For Wordstar DOS users, the 
information in this chapter will be completely new.

.2
Graphical elements

.ID P_GRAPHICALELEMENTS

.3
Embedding graphics

.in Graphic
.in Bitmap
.in Metafile
.in BMP
.in GIF
.in JPEG
.ID P_GRAPHICS
A provision for embedding graphics was lacking in Wordstar DOS. In a graphical 
environment, it is no longer difficult to handle graphics; their support in 
WSformat is compatible with Hypermake syntax.

The graphics commands support Bitmap (BMP) files and (Windows only) GIF and 
JPEG. Then, the Windows Metafile formats EMF (Win32) and WMF (Win16) are 
supported, and the OS/2 version supports the OS/2 MET Metafile format.

WSformat offers two simple ways of embedding graphics: separated from running 
text and as part of running text.

To embed a graphic in your document separated from running text, simply 
enter

.BM Filename.bmp

The files are searched in the directory where the WS document resides and in 
all directories which are listed on the Program page of Settings - Settings 
notebook.

The .BM command is used for Metafiles as well, although technically there 
are no "bitmaps".

Instead of exporting the graphic to a file in your graphical application and 
typing the dot command in WSedit, you can also copy your graphic from your 
graphical application into the clipboard (e.g. a chart from Excel) and then 
paste the contents of the clipboard in WSedit with Edit - Paste or 
Shift-Ins. WSedit recognizes the clipboard data as a graphic and tells 
WSformat to open the graphics dialog. Double-clicking to the parameter 
behind ".BM" also activates the graphics dialog. But for this functionality, 
WSformat has to run and the current WS file should be selected in WSformat.

The .BM command is interpreted both while formatting and while printing. 
While formatting, WSformat calculates the width and height of your graphic. 
The default behavior of WSformat is that the graphics file is stretched 
horizontally and vertically until the width matches the text width (depending 
on the .RM command). The height of the graphic is calculated and WSformat 
enters empty lines into the FMT file and inserts a .CP command which holds 
these lines together in case of a page break:

.cp13

(running text above the graphic)
.CP7






.BM Filename.bmp
(running text below the graphic)


When previewing or printing, the graphics file is shown.

If you want the width of the graphics width to be different from the text 
width, you can modify the size of the graphic by entering

.BW 80
.BM Filename.bmp

bitmap width before typing the .BM command. A value of 80 means that the 
width is 80% of the text width. The graphic will be printed centered, with a 
margin of 10% on the left and 10% on the right side. The default value of 
.BW is 100. This command also influences formatting. The smaller this value, 
the fewer empty lines WSformat will insert.

If you want to omit inserting empty lines according to the height of the 
graphic, you can turn this WSformat functionality off and on:

.FG off (format graphics off)
.FG on (format graphics on)

In this case, you have to pay attention yourself that enough space above is 
available and the graphic does not overprint text.

Orientation of the Bitmap

If you have selected a bitmap width value smaller than 100, the bitmap will 
be printed centered. You can change this default setting to the orientation 
left and right by using the dot commands

.BM left
.BM right
.BM center.

These commands do have an effect for bitmaps which follow these commands. In 
consequence, you cannot print bitmaps with the filename left.bmp and so on.


Bitmap in running text: "bitmap text"

The .BM command is not appropriate if you want to embed a small graphic in 
running text. Instead, use:

.BTX Filename.bmp

.in Bitmap Text
.in Bitmap Character
X represents a bitmap character, an arbitrary character which will not 
otherwise appear in the text. This character will be replaced in your text by 
the bitmap 'filename.bmp'.

Note that bitmaps can be higher than characters, so you should select one that 
will not cause overprinting of characters on the line above. Block chars like 
 (Alt-219),  (Alt-220),  (Alt-223) are useful bitmap chars.

Text Bitmaps are already interpretated while formatting. WSformat treats such 
bitmaps as characters and calculates the width of the bitmap to let the right 
margin justified.

The scale of the .BT graphics is 300 pixels per inch, which means that a 
graphics file with a 300 pixel width gets a 1 inch (2,54 cm) width on your 
printout. You can change this value by entering:

.GS
graphics scale. Place this command above your .BT command.

You are allowed to define up to 20 bitmap chars simultaneously.

To deactivate a character-bitmap definition, enter:

.BTX

without specifying a filename. The actual character will then be printed, 
rather than the bitmap.

.3
Line drawing

.in line characters
.in line drawing
.ID P_LINEDRAWING
The IBM codepage contains some characters which represent lines instead of 
letters. You can use combinations of these characters to draw boxes.

WSformat does not send line characters to the printer directly. Instead, it 
sends bitmap images of the characters to be printed. The main reason for doing 
this are that line drawing characters must be printed only at the default line 
height .LH8. To draw an unbroken vertical line, line drawing characters are 
converted to commands like 'draw a line from coordinate X to coordinate Y.'

You are encouraged to use these line drawing characters in running text  e.g. 
as a dash (Alt-196, narrow lines)
.tb4
or for lists (Alt-205, wide lines).

Characters which represent double lines are shown as wide lines in preview and 
on printout. You can set the width of the narrow and wide lines in the 
settings notebook, page Layout.

.in Block character
Block characters  (Alt-219),  (Alt-220),  (Alt-223) and - only 437 codepage 
- Alt-221 and Alt-222 are also sent as bitmap graphics. Here as an example is 
a large exclamation mark


 which is made by using such block characters (not visible on Winhelp which 
uses ANSI Codepage).


Creating Boxes

As creating boxes is usually a tedious job, a dot command has been defined to 
facilitate line drawing. The following example illustrates its use.

.sfM
.cp12
 .LIXY

      X                           X

            Operating systems

      Y                 Y                X            X
            Novell         IBM              Hardware
      Y       Y                          X            X
          DOS   Netware    OS/2
      X                           X
 .LI
.sf

The result will be: (view FMT file or make preview)

.LIXY
.cp12

      X                           X

            Operating systems

      Y                 Y                X            X
             Novell        IBM              Hardware
      Y       Y                          X            X
         DOS    Netware    OS/2
      X                           X
.LI

.afB
(Viewing Winhelp, you won't see the correct line characters.)

In the dot command .LIXYZ, X represents an arbitrary character marking the 
corners of the box, Y a partition of the box. Z, placed in front of X or Y, 
generates double lines (wide lines). A combination of single and double lines 
requires the Codepage 437 selection (Page Layout in the settings 
notebook).

The Z char in the .LIXYZ command for producing double lines has to be a 
^P-character like ^PE or ^PR which won't be used in the text. When using the 
^OD command in WSedit, you can make the ^P-characters invisible to check the 
correct orientation of the box.

WSformat supports proportional fonts in line drawings. The .TS tab stretch 
command is very important in this case. You can specify the width of your 
boxes with the .TS command. If this produces overlapping columns, enlarge 
the .TS command value (default is 60).

Changing the width of the lines

The dot command

.LS3
sets the narrow (small) line width of single line characters to 3 Pixel (1 
Pixel is 1/300 Inch)
.LW5
sets the wide line width of double line characters to 5 Pixel (1 Pixel is 
1/300 Inch)

You can set the default values of these two dot commands on the Layout page 
of the settings notebook.

.3
Dot and Square characters

.ID P_DOTCHARS
.in dot character
.in square character
For lists, it can be useful to mark each paragraph with a conspicious 
character. You can use a hyphen - or a longer hyphen (Alt-196) or a thick long 
hyphen (Alt-205) or the character ALT-254 of the IBM codepage  which 
represents a filled square. But the appearance of Alt-254 depends on the 
selected font. A better choice is to redefine an arbitrary character with the 
dot command

.DTX 3 30

drawing text or dot. X represents an arbitrary character which will not 
otherwise appear in the text. Then you can enter one or two numbers from 1 to 
100. If the numbers is lower than 10, the number represents a specific shape 
of the drawing:

1: (black, filled) circle
2: non-filled circle
3: filled square box
4: non-filled square box
5: filled rounded square box
6: non-filled rounded square box.

A number of 10 and above defines the size of the drawing in percent, while 100 
represents the height of a capital letter of the selected font. If you don't 
define a size, the default value 35 will be chosen.

By default, WSformat redefines the Alt-254 character with shape 3 (filled 
square box) and size 35. If you do not want this character to be redefined, 
you can turn off this definition by entering the .DTX command without a 
number (instead of X, type the Alt-254 character). A current character 
definition can be removed by this means.

.WA hori 30
.2
Chapters, headings, table of contents

.in heading
..in contents
.in chapters
.it table of contents
.ID P_HEADINGS
WSedit, WSformat and Hypermake provide easy-to-use support for headings and 
tables of contents.

.3
Heading commands in your unformatted text

You can arrange your text with heading levels, as you would in a technical 
document:

first heading
    first sub-heading
    second sub-heading
         first sub-sub-heading
         second sub-sub-heading
    third sub-heading
second heading

In the WSedit/WSformat/Hypermake format, the headings are designated in the 
following manner:

.sfM
 .1
 first heading

 .2
 first sub-heading

 .2
 second sub-heading

 .3
 first sub sub-heading

 .3
 second sub sub-heading

 .2
 third sub-heading

 .1
 second heading
.sf

On the line immediately following the dot command for the heading level, you 
enter the heading text. Heading text can be longer than one line, but must not 
extend beyond a single paragraph: a Hard Return marks the end of the 
heading.

In your printout, your document is structured like this:

1. first heading
     1.1 first sub heading
     1.2 second sub heading
          1.2.1 first sub sub heading
          1.2.2 second sub sub heading
     1.3 third sub heading
2. second heading

WSformat handles up to 9 heading levels, but Hypermake is limited to only 6 
heading levels. WSformat also supports other conventions for enumerations 
(letters, roman numerals, as well as others).

Please note that Hypermake requires using these headings: every text has to be 
part of a chapter.

.3
Headings and WSedit

WSedit provides support for headings and tables of contents, expressed in 
WSformat / Hypermake syntax.

First, headings are highlighted in green, if the heading checkbox is checked 
on the Highlt page of the WSedit settings notebook (press ^OO).

Second, to help navigating in your unformatted text, WSedit has a contents 
window. ^OC opens the contents window. ^OI also opens the contents window and 
then jumps to the chapter where the text cursor is currently located.

.3
Formatting a text with headings

.ID P_HEADINGFORMATTING
When formatting an unformatted text which contains heading commands, these 
commands are converted to a concrete heading enumeration, to commands for font 
selection, line spacing and page breaks. Previewing and printing the formatted 
file will display headings in their final correct form.

.in headings file
.in headings template file
The way these dot commands are to be converted to other commands is defined in 
the headings template file or simply headings file. This file can be 
viewed by selecting settings - headings template in the WSformat main 
window. This shows the file HEADINGS.WS (german GLIFORM.WS) which is located 
in the directory where WSformat.exe resides. The file is self-explanatory.

People prefer different ways of enumerating headings. Today, although decimal 
classification is a standard, WSformat also supports other forms of 
enumerations:

1.1 Decimal classification without last dot
1.1. Decimal classification with last dot

I. Roman numerals (up to 38 = XXXVIII)
A. Capital letters
1. Customary (arabic) numerals
a. lowercase letters
aa. double lowercase letters
[alpha character]. Ancient greek characters

Instead of typing a dot behind the character, a right parenthesis ')' is also 
possible, thus: 1)

Ancient greek characters require Codepage 437 (Alpha = Alt-224 etc.), see 
settings notebook, page Layout.

In the headings template file, you can define any or all of these styles of 
enumeration.

You are at liberty to modify this file. If you want to use other heading 
files, first make a copy of HEADINGS.WS and then modify the copy. Simply place 
your HEADINGS.WS file in the directory where your document files are located 
(WSformat first scans this directory), or substitute another filename, e.g. 
MYHEADING.WS, and then include the dot command

.HF MyHeading.ws  (or .GF)

heading file before entering the first .1 command.

.CN 3.2.5   (or .GN)
sets the current content numbering. You have to enter decimal notation here. 
Use e.g. .CN5 at the beginning if you have got a separate document 
containing chapter 5 and 6. The equivalent Wordstar command .P-doublecross 
is also interpreted.

.3
Writing out a table of contents

WSformat let you create a table of contents file (TOC file). There are two 
different ways: Since WSformat 0.99, write marked paragraphs (.CT) only 
(Settings notebook, page index) is the default setting (manual recognition). 
That means, that all paragraphs which should be part of the table of contents, 
have to be prefixed by .CT (content).

If you do not mark the checkbox, in addition to the paragraphs prefixed by 
.CT  other lines fitting some specific criterions are made part of the table 
of contents ("Automatic recognition").

.4
Manual recognition

.in Manual recognition
.ID P_CONTENTSHAND
.CT

contents text let the following paragraph get part of the contents. 
Sample:

.CT
Illustration List

if a paragraph should get part of the contents and you do not want to get this 
text part of running text, you can write:

.CT Illustration List

On the "index" page of the settings notebook, you can select whether only the 
paragraphs marked by .CT get part of the contents or also other paragraphs 
where WSformat decides that it looks like a heading.

.4
Automatic recognition

.in Automatic recognition
From a technical point of view, the Make - Content function operates 
independently of the headings function, explained above. It does only 
interpret formatted files which no longer contain any heading commands (.1 
etc.). So you can also use Make - Content if you have entered your headings 
manually. WSformat takes a careful look to the beginning of each paragraph of 
your formatted file and decides whether or not to copy this file into the 
table of contents file. If there is any uncertainty, the line is nevertheless 
copied to the table of contents file. It is always advisable to take a close 
look at the table of contents file and delete any lines which are not 
headings.

The criteria are: after reading spaces and printer characters at the beginning 
of a paragraph, the first acceptable characters have to be
one or two normal (arabic) digits or latin numberals up to XXXVIII, 
followed by a dot or a close-parenthesis ')'
one or two upper- or lower-case letters, followed by a close-parenthesis 
')'
a single captial letter, followed by a dot.

.tb30
Unrecognized Recognized
123. 12.
345) 34)
7  7.
IL. XXXVIII.
IV  IV)
B   B.
ab. ab)
aac) ac)
.tb4

Because a TAF file (text and footnotes) will usually contain many paragraphs 
beginning with a number followed by ')' - the footnote paragraphs - all 
lines in TAF files with a number and ')' are not copied to the Table of 
Contents file.

.4
Executing table of contents creation

.ID P_CONTENTS
After finishing your FMT formatted file and fixing all page breaks, WSformat 
helps you prepare a properly numbered table of contents with page numbers.

Already in the unformatted file enter, for example, something like:

.sfM
 .PA
 Contents of this document

 .ci5
 .. (later, place the table of contents file here)
 .PA

 .PA
.sf

There are two aspects to consider:

.in Contents Indention
.CI
contents indention sets the tab stop while formatting the table of contents 
file, comparable to the Wordstar/WSedit .TB command. The value has to be the 
maximum number of characters of your deepest heading enumeration. E. g. if you 
have selected decimal classification and use headings up to level 3, the width 
of the heading enumeration will not exceed 5:

.sfM
123456789
1.1.1 TextTextText
.sf

In this case, a .CI value of 5 or more fits your purpose.

The other aspect to consider is how many pages the table of contents will 
occupy. Because the table is printed before the running text begins, the 
length of the table influences the page numbering of your document. You will 
therefore have to estimate the length of the table (in pages) and then enter 
several .PA page break commands, so the first page of your running text 
will get the final page number. If your first trial fails, edit the FMT file 
and enlarge or reduce the number of .PA commands. Please remember that you 
have to enter at least one empty line between two .PA commands.

After inserting the .CI dot command and .PA page breaks as described above 
into the unformatted file, do the following to embed a table of contents file 
in your formatted file:

Select Make - Content in the WSformat main window. The extension of the 
contents file is TOC.
Now open the formatted file which has remained unchanged while executing 
Make - Content.
Remember the page number of the first page of your running text.
Delete the .PA commands you have inserted previously.
Copy the contents of the TOC file to the location you previously allocated 
in the FMT file.
Locate the first page of your running text again and see what page number 
WSformat has assigned to it. If the number has changed, leave the formatted 
file without saving any changes, re-open it, delete or insert a .PA 
command, and repeat the procedure.

In the settings notebook, page index, you can specify whether to write 
page numbers or not, and whether or not to highlight main headings in 
boldface. In any case, an empty line is inserted before writing a main 
heading. The first heading type which occurs in the formatted file will be 
considered the 'main heading.' This can differ from the .1 command in the 
unformatted file.

.3
Table of contents in PDF files

.in PDF content creation
WSformat has some functionality for creating PDF files. When creating a table 
of contents (TOC file), a file with the extension PS_CNT is also created if 
the checkbox create PS_CNT file when creating contents (Settings notebook, 
page PDF) is set. This file is already in Postscript format and will be 
added automatically when running Make - PDF file in the WSformat menu. 
WSformat first prints the document to a file with the extension PS instead 
of printing to the printer. Before it runs the PDF creation program 
(Ghostscript, Adobe Distiller or others), it copies the PS_CNT file to the end 
of the Postscript file.

If you use automatic recognition of WSformat and too many lines become part of 
the contents, then use manual recognition with the ".CT" command before each 
line which you want to be part of the contents and select write marked 
paragraphs (.CT) only.

.WA hori 30
.2
Footnotes, End Notes, Margin Notes

.in footnote
.in end note
.in endnote
.in margin note
.ID P_NOTESGENERAL
WSformat supports footnotes and endnotes in an easy and uncomplicated way.

If you prepare a file using Wordstar DOS 5-7, load such a file with footnotes 
or end notes into WSedit, and then save the file, these notes are converted to 
WSformat and Hypermake format.

Because WSedit and WSformat does not support multi-column text, there is a 
special implementation for creating margin notes. Margin notes are very 
short text (e.g. 3 or 5 characters long) which appear in the left margin 
area.

.3
Writing footnotes or end notes in your unformatted file

.it footnote character
Generating Footnotes or end notes with WSformat is very simple. For example, 
footnote text can be quoted in brackets like [This will be the content of the 
footnote] after entering the dot command footnote usage:

.FU[]

Other useful footnote bracket pairs are { }, < > or  (Alt-220)  (Alt-223). 
In WSedit, you can highlight these specific characters (^OO settings notebook, 
Hightlt page, entryfield spec. chars).

At this state, it is not determined whether you will create footnotes (notes 
at the bottom of every page) or end notes (collected at the end of the 
document).

You can add a font selection to the footnote dot command:

.FU[]sfB

This will select font B for your footnotes or end notes.

To select a line height for your footnotes or end notes which is different 
from running text, add LH followed by your preferred value:

.FU[]sfBlh7

The order of SF and LH makes no difference.

.in Footnote file
.in Endnote file
.in FUN file
While formatting, WSformat creates

an FMT file where the notes text has disappeared and instead a footnote 
link appears
an FUN file (.FU Notes file) which contains the text for all notes.

You can modify the appearance of your footnote links in the settings 
notebook, page notes.

.3
Handling end notes

To embed the .FU notes file at the end of your document, you can manually 
copy the FUN file to the end of the FMT file after formatting, or you leave 
this job to WSformat:

.FI *.FUN

Place this command exactly as it appears above (type the '*' sign, not the 
filename) at the end of your unformatted file. This will cause the 
contents of the FUN file to appear in the FMT file. You cannot enter 
additional notes text in your running text after typing this .FI command.

The Wordstar command .PE is also interpreted.

.3
Getting real footnotes

.in TAF file
Up to yet, you have only a separate file containing the text of your 
footnotes.

Make - Text and Footnote merges an FMT (formatted text) with an FUN file 
(notes text) file. The result is a TAF file which combines Text and 
Footnotes.

When merging text and footnotes together, WSformat has to make page breaks by 
itself. There is no way anymore to basically optimize the page break by hand 
in the formatted file.

In the notes page of the settings notebook, you can define that e.g. the 2 
first and the 2 last lines of a paragraph are always hold together. This omits 
a result where the first or the last line of a paragraphs rests alone on a 
page.

However, this function is not adequate to produce proper page breaks. You 
frequently have to use the .PA page break and especially .CP 
conditional page break. All tables, enumerations and so on have to be 
prefixed by .CP commands to omit page breaks. The more .CP commands you 
use in your unformatted file, the fewer formatting runs you need to produce a 
satisfactory final TAF file.

WSformat inserts the page breaks in the TAF file one line ahead of where they 
are necessary. You are therefore both permitted and encouraged to make minor 
changes in your TAF file by moving the last line on a page of your running 
text (Wordstar DOS and WSedit ^Y and ^U) to the beginning of the next page, or 
to do the converse.

.3
Margin Notes

Margin notes are short notes which occur in the indented left margin of the 
formatted file. When insertion of margin notes is activated, all formatted 
text will be indented to tet the room for margin notes. The usage in the 
unformatted file is similar to the footnote / end note command of WSformat.

Instead of .FU, you enter .MN margin notes.

.sfL
.MN<>3
Here is an example of a margin note <007>. In the formatted file, "007" would 
occur in the indented left margin of your text, between the soft spaces (snow 
characters).
.sf

The characters < and > bracket the text of a margin note. '3' sets the 
maximum length of margin notes (in number of characters) to 3. That means 
that the space allocated for the margin is sufficient to accommodate when 
printing margin notes with a length of 3 characters: the first character of 
the paragraph appears in column 5, and the number of soft spaces which are 
inserted is 4.

In the settings notebook, page Notes you can set a default value for the 
length of margin notes if you do not use a numeric value in the .MN 
command.

When using margin notes, the text width is increased, while the right margin 
gets less.

If you want to specify a font attribute (bold, italic) for your margin notes, 
you can extend the .MN command by entering ^P, followed by the appropriate 
Printer command character:

.MN<>3^Y^Y
sets the margin notes font attribute to italic. The order makes no 
difference.

.MN
without parameters turns off the margin notes function.

Margin notes and error messages

It is not possible to print two margin notes on one line. Another limitation 
is that the length of the margin notes may not exceed the numeric value 
entered in the .MN command, because the space in the margin would be 
insufficient to accommodate it.

.WA verti 25
.2
Index

.in Index
.ID P_INDEXGENERAL
.3
Introduction

Both WSformat and Hypermake can prepare indexes; the commands in the source 
text are nearly identical. However, the results differ.

WSformat creates a file INDEX_1.WS where the format of the index is the 
following:

Computer Networks 27

Workgroup
-, administration 53
-, computing 57

The INDEX_1.WS shows the index entries in alphabetic order.

To generate an index, mark the index entries in the unformatted WS file by 
using dot commands and special characters explained below. Then format the 
text. After the page breaks of the FMT file are adjusted, the last task is to 
select the menu item Make - Index. WSformat reads the FMT file (without 
changing it), writes all index entries into the temporary Wordstar file 
Projectname.IX1, merges the information of all *.IX1 files (even of different 
WS projects, see Volumes) together and writes a file INDEX_1.WS, which 
contains the generated index. You can then copy this file by hand into your 
FMT file. (You may then delete the *.IX1 files; they are not deleted by 
WSformat.)

Compatibility to Hypermake index functionality

There are some special features beyond those available in Hypermake:

emphasised index entries, where the page numbers appear in bold face
several indexes INDEX_2.WS, INDEX_3.WS, for example, one only for 
locations, another only for persons.
one index for several WS project files which represent different volumes.

The index commands in your source text are identical to the Hypermake syntax. 
The .IN and .IT commands in this document refer to this function, but it 
is also possible to mark words or expressions in running text (not used in the 
source file of the WSformat documentation).

Hypermake knows only one index and does not support emphasized entries. 
Instead, it creates links from all other occurrences of the expression to the 
marked occurrence.

.3
Index char, Marking a single word

Enabling index function; selecting the Index Character

.it index character
In the WS file, the dot command

.IC#  (or .IZ#)

index character let you specify an index character. # represents an 
arbitrary character which is not otherwise used in your text. This setting is 
valid up to the end of your document.

Marking a single word

You can mark a single word for indexing with the index char.

.sfM
A #workgroup is a group of people...
.sf

The index char is visible both in the WS and the FMT file, but is neither 
printed nor shown in the Preview window.

.3
Marking a phrase of several words

When using the index char, only one word will be marked. A word ends with the 
first character which is not a letter or '-'.

To mark a phrase, you have to use colons ':' as brackets:

.sfM
Today, the #:security of computers: is...
 ...
Nevertheless, the #:security of mainframes: can be...
 ...
But the #:usability of computers; has to...
.sf

In the index, it will appear as:

.sfM
computers, usability of 37
security
-, of computers 37
-, of mainframes 37
.sf

.in leading word
Note the difference between the first and second examples and the third: A 
`#:XXXX:' with a colon at the end will use the first word of the phrase as the 
leading word; a `#:XXXX;' with a semicolon after the last word. The leading 
word is the word which determines the alphabetic order in the index.

You can use the `colon brackets' to crop endings:

.sfM
The importance of #:computer:s is growing...
.sf

In the index `computer' will appear without the `s'.

.3
Marking outside the running text

With the dot command INdex

.in security of computers

you can place a word or a phrase in the index. Because it is a dot command, 
`phrase' will not be printed. You can use this command when the phrase you 
want to place in the index does not appear explicitly in the running text.

For Wordstar compatibility, .IX with all specific Wordstar syntax is also 
supported.

.in index turned
Normally, the first word of the phrase will be the leading word. If you want 
instead to make the last word the leading word, such as using the brackets 
colon-semicolon in running text, you can use the dot command index turned.

.it usability of computers

has the same effect as

.in computers usability of

Because Hypermake treats these two lines different, it is useful to use the 
.in index turned notation in WSformat, and it is more legible in the WS 
file.

.3
Emphasized Index entries

`Emphasized index entries' receive a bold-case page number in the index. To 
emphasize an index entry, type the index char twice

.sfL
A ##workgroup is a group of people...
Today, the ##:security of computers: is...
.sf

or use the dot commands .IN or .IT in upper-case letters:

.IT usability of computers

instead of

.it usability of computers

.3
Several Indexes

WSformat supports more than one index; Hypermake does not.

To produce several indexes, you must use the .IC command several times, e. 
g.:

.IC# (default index)
.IC& (location index)
.IC% (person index)

(But Hypermake allows only one index. In Hypermake, you can change the index 
character when using .IC a second time.)

You can now use three index characters in the running text. It is possible to 
mark an expression for several indexes:

.sfM
A #&%workgroup is a group of people...
.sf

You also have access to the additional indexes by using the dot commands:

.IN& New York
.IN#&% Workgroup

.IN with no index character refers to the first index.

When using Make - Index, the indexes are written to the files INDEX_1.WS, 
INDEX_2.WS, INDEX_3.WS.


.3
Managing Project Volumes

.in Volumes
While running Make - Index, the current FMT file is read and information 
about index entries is stored in the Wordstar file Projectname.IX1. You can 
produce one or more such volumes. The only thing required is to write a number 
between the name of the file and the file extension ".WS":

.sfM
MyProject1.WS
MyProject2.WS
MyProject3.WS
.sf

and then to run Make - Index on all these projects. Because the temporary 
file MyProject1.IX1 remains available when running Make - Index on 
MyProject2, you get several *.IX1 files. The merging function always 
refers to all *.IX1 files and merges all Projects (Volumes) together. To 
distinguish Page 30 of MyProject1 from Page 30 of MyProject2, the page 
numbers are also shown as roman numerals for the different volumes in the file 
INDEX_1.WS:

security
-, of computers I-30
-, of mainframes II-30

If you have also got a WS file with no decimal number in the filename, then 
the index entries of this WS file won't get a roman numeral.

WSformat can generate roman numerals up to 38.

.2
Dot Command Macros

.in dot command macros
.in macros for dot commands
Sometimes there's the need of typing the same dot commands again and again. 
For example, you want to embed several tables in your document, you need to 
turn justification off, change the line spacing, the font and turn off 
formatting. At the end of the table, you need to restore the old values.

For this purpose, you can define arbitrary personal dot commands ("dot command 
macros") which are concatenating several known dot commands:

.TAB := .BL .BA .SFC .LH8
.TEXT := .FL .BE .SFG .LH12

On the left side of ":=", you type the new command, and on the right side the 
definition of the new command. The spaces between the dot commands and near 
the ":=" characters are optional.

Instead of the chain of dot commands, you simply type your new dot command 
instead. The length of the new dot command names are not limited to two 
characters. You are allowed to overwrite existing Write&Set dot command names 
without problems, but you won't have access to the old meaning anymore, of 
course.

It is possible to use a dot command macro within a definition of a dot command 
macro.

In the formatted file, the chain of normal dot commands is shown instead of 
the dot command macro.

.2
Embedding files

.ID P_EMBEDDINGFILES
.it Embedding files
Embedding files

.FI Filename
File is a very powerful command. The contents of the text file Filename 
are inserted at the position where the .FI command is located. This command 
is interpreted while formatting but not while printing.

To embed graphic files, use the .BM command instead.

The file extension makes a great difference.

.FI Filename.ws
.FI Filename.fmt

If the file extension is WS, WSformat interprets the file as an unformatted 
file and while formatting, full dot command interpretation and formatting are 
used. If the file extension is not WS, the contents of the file are simply 
copied to the formatted file without interpreting commands.

WS and TXT (ASCII) files

The .FI command supports both Wordstar files and Write&Set TXT files. You 
can mix these file types within one project.

Save and Remember current formatting values

.in save values
.in remember values
When using the .FI embed file command, it can be useful to save and 
remember current values of dot command settings.

.S:FONTS
.R:FONTS
saves and remembers all current font data (normal, alternate, bold, 
italic, bold-italic, superscript).

.S:LINEHEIGHT
.R:LINEHEIGHT
saves and remembers the current state of the .LH command.

.2
Conditional statements

.in if condition
.in conditional statement
.ID P_IFCONDITION
With conditional statements, you can create slightly different variations of 
the FMT files, derived from the same source text. If you insert these commands 
in the FMT file manually, these commands will not be interpreted during 
previewing and printing, because only the format function recognizes these 
commands.

There are three dot commands:

.sfM
 .IF CONDITION
 .ELSE
 .END
.sf

The condition statements are not case-sensitive. Note that The ELSE command 
need not be included.

This means text between these commands is interpreted only if the condition is 
set (is true). They are set in the WSformat main window, if entry field. You 
may enter more than one condition, which must be separated by spaces.

The condition WSFORMAT is always set. Use this condition to distinguish text 
designated for Hypermake or for WSformat. The OS/2 version of WSformat also 
sets the condition OS2.

WSformat also supports the following expressions:

.sfM
 .IF NOT COND
 .IF COND1 AND COND2
 .IF COND1 OR COND2
.sf

I regret that more sophisticated if-conditions grouped with parentheses are 
not supported.

The Wordstar command .EI end if can be used instead of the .END 
command.

.1
FAQ

.in FAQ
I will place questions I get from you here, together with the answers.

.WA verti 25
.1
About

.in WSformat
.ID P_ABOUT
.2
Registration

.ID P_REGISTRATION
.in Registration
.in price
.in fee
WSformat is Freeware if you want to format documents with less than 10 pages 
and Shareware for documents with more than 10 pages. After 50 number of uses 
without registering WSformat you won't be able to format documents which are 
longer than 10 pages; registering removes this limitation. You are allowed to 
send WSformat to friends or to a publishing house for printing your formatted 
document. The printing function has no Shareware limitation. The registration 
key rests on your computer. WSedit is a real Freeware.

The normal registration fee is 60 Dollar or 50 EUR. The student 
registration fee is only 25$ or 20 EUR.

The key is valid for all 1.X versions and for all supported operating 
systems.

When ordering more than one licenses, you will get a 33% discount for every 
additional license (non-student licenses).

.URL http://www.bmtmicro.com
.in BMT Micro
.LOCAL
You can register this software via BMT Micro . If you want to get the student 
price, please send a copy of your Student ID to BMT Micro. Please visit
http://www.writeandset.com/english/register.html
to get a BMT Micro order form.

If you contact BMT Micro, I will get informed by E-Mail. Then I send you the 
registration key. This process takes 1-2 days.

If you have got a bank account in an Euro country, you can transfer the money 
to my bank account in Germany, Dresdner Bank in Ottobrunn. Since July-1-2003, 
you can make money transfer between EURO countries without extra cost. You 
need the following international account information:
BIC: DRES DE FF
IBAN: DE33 70080000 0756462400
In this case send me your Student ID via postal mail or fia FAX to Germany 
(I'll send you my FAX number via E-Mail.)

.2
Disclaimer

WSformat is provided as is and comes with no warranty of any kind, either 
expressed or implied. In no event will the author be liable for any damages 
resulting from the use of this software.

.2
Author

.bw 20
.bm center
.bm Martin.bmp

.in Author
Dr. Martin Vieregg, 38. I've studied economics. My main job is working in my 
own consulting company. Our special subject is public transport, especially 
railways and airports. The title of my doctoral (PhD) thesis was 'increasing 
efficiency of railway long-distance passenger traffic'.

.in Contacting the author
.in E-Mail
E-Mail address: Martin@hypermake.de

Homepage of my Freeware- and Shareware programs:

http://www.hypermake.com


Postal Address:

Dr. Martin Vieregg
Emdenstr. 11
D-81735 Munich
(Germany)


.2
Versions and future plans

.in program versions
If you have bug reports and ideas for new functionality, please E-Mail me!

WSformat 0.99

improved preview for two-sided printouts (a document is two-sided, if you 
use .HEL .HER or .FOL .FOR or .LR (left-right mode, affects the 
header/footer line orientation)).
PgDn in preview on top of a page scrolls a page down, otherwise shows the 
next page
new dot command .RF (Right Formatting) is like .RM (Right Margin), but does 
not affect ^P@ (WSedit ^PZ) right-orientated lines.
.FG on/off (format graphics) let you omit inserting empty lines for 
graphics while formatting
Creating Contents: you can turn off the automatic contents line recognition 
in the settings notebook, so only the lines with prefixed ".CT" (content) 
gets part of the table of contents
Three new dot commands .HH Hard Line Height, .SH Soft Line Height and .EH 
Empty Line Height let you specify line height more acccurate than .LH. (.LH 
sets all three values simultaneously.) This extension enables you to define 
different line heights within paragraphs and between paragraphs. Of course, 
you won't see correct page breaks anymore when using original Wordstar 
instead of WSedit.
PDF creation support: If you select Make - PDF file, WSformat prints the 
document to a virtual printer which you have selected in the settings 
notebook, page PDF. The output goes to a Postscript (PS) file instead of a 
printer port.
PDF creation support: After finishing "printing" to the PS file, WSformat 
appends PDFmarks to the PS file. These marks contain document information 
holding in dot commands: .TI (Title) .KY (Keywords), .AU (Author) and .SU 
(Subject).
PDF creation support: full-featured PDF content window with chapter 
headings where the reader can navigate.
PDF creation support: Step-by-step instruction for using WSformat together 
with the free Ghostscript package
in addition to the WS file format, ASCII text file support for unformatted 
files: "Write&Set TXT format"
Colored fonts (via font definition file).
running WSformat via commandline arguments (formatting, printing, 
conditional defines)
Shareware limitation set down to formatting 10 pages.

WSformat 0.98

More graphic formats: Besides BMP, for Windows are also GIF, JPEG and the 
Metafile formats EMF and WMF supported. For OS/2, in addition to BMP, the 
OS/2 Metafile format MET is supported.
Graphics dialog enables you easy embedding of graphic files into WS text 
files. If the clipboard contains a graphic, pressing Shift-Ins in WSedit 
opens the WSformat graphics dialog.
Improved preview: a menu bar offers you a lot of new functionality, e.g. 
previewing several pages simultaneously, up to 50 pages. If a single page 
is viewed very small, lines are shown instead of font text lines. Preview 
speed is now faster.
Dot command macros enables you defining your own dot commands concatenating 
several known dot commands.

WSformat 0.97

with the new dot command .DT you can draw small circles and squares for 
paragraph lists for other purpose by defining arbitrary characters which 
are not used otherwise in your text
a "PDF" page was added in the settings notebook and a new command "Make - 
PDF" let you comfortably embed PDF creation software. PDFmarks are 
supported via BMK files (for use with ePDF to get a PDF contents page), and 
in the next version of WSformat PDFmarks are directly supported for all PDF 
creation programs
you can change the orientation of .BM bitmaps from center to left and 
right
.CT (contents text) enables you grabbing arbitrary text paragraphs for the 
contents
File - Select remembers the last directory
Doubleclick-jumping between editors for WS and FMT file can be turned off 
in the settings notebook, page "program"

Future versions

Planned for the next version (1.00)

Improved RTF import/export.

Perhaps I will publish a smaller Freeware EXE version with preview and print 
functionality only, looking like Acrobat Reader.

.in Linux version
After publishing Write&Set 1.0, I want to publish a Linux version. To 
translate Write&Set to other languages, I need help from native speakers. 
Please contact me if you are interested in such an effort.

Older Versions

WSformat 0.96

First version also in german language.

WSformat 0.95

Another important bugfix.

WSformat 0.94

A really important bugfix, dozens of smaller bugs now fixed. New Name 
"Write&Set" for WSedit+WSformat. A "insert dot command" window (click to the 
"command" menu item in WSformat main menu) is programmed new and let you 
insert dot commands per mouse click.

WSformat 0.92, 0.93

the first beta version, a lot of bugs fixed. Bubble help file dothelpe.txt 
explains the WSformat commands in the WSedit editor window.

WSformat 0.85

points the focus to communication between WSformat and WSedit. The archive 
file also contains a new WSedit program.

The new functions concerning both programs are:
-Double-click to a message in the error message window opens WSedit with the 
cursor in the paragraph refering to the error message
-Running "format" automatically saves the WS file, running "preview" or 
"print" automatically saves the formatted file (see settings notebook, 
page Program, checkbox auto save).

The .FM formatting on/off command has been replaced by .BD .BE (enable/disable 
formatting) because .FM is already allocated by "foot margin".

WSformat 0.84

has got a "format info and error message window" where error and info messages 
appear concerning formatting: E.g. an error message occurs here if a dot 
command is used in a wrong way.
Then 0.84 fixes some redraw problems of the preview window.

WSformat 0.83

contains the index functionality. The index is also described in the docu 
(chapter extended text formatting). A handful minor bugfixes.

WSformat 0.82

is only a bugfix of 0.81.

WSformat 0.81

The first published version of WSformat. 0.8X are alpha versions.

.2
History

.in History
.in StarExtender
In the late 80's, I published a Worstar DOS extension program 'StarExtender' 
in german language which had hyphenation, footnote, Line drawing, index and 
proportional printing support. WSformat is based on this program which is 
very-well tested for a lot of years. This is the reason that the basic format 
functionality works very well even WSformat is 0.9X beta state software. (It 
could also be StarExtender 3.9X). But it took one year hard work for 
publishing the first WSformat version. Because the formatting and printing 
kernel is optimized for old computers from the late 80's, today WSformat is 
extremely fast.

.2
Bug report

Known Bugs

With Windows 98 and ME, preview text with Metafiles is sometimes defective: 
the Metafiles are drawn several times, with wrong sizes. The behaviour cannot 
be reproduced. Printing is not envolved. NT-based Windows version seem to be 
OK (Win NT4, 2000, XP).

.in bugs
Fixed Bugs

0.99a.1: defective fonts.ini generation (double usage of one font character) 
forces harmful font problems
0.99a.2: some malfunctions in the command window
0.99a.3: in german documentation, jumping to wrong pages of context-sensitive 
help
0.99a.4: in preview, header line of the first page is not shown
0.99a.5: cannot open font test file (Settings - font test file)
0.99a.6: wrong default settings in the PDF page of the settings notebook
0.99a.7: malfunctions when inserting dot commands via command window into 
WSedit
.if IPF
0.99a.8: if preview Window overlaps with a program which floats to top, 
closing the preview window exists WSformat
0.99a.9: changing size of WSformat command window forces problems
.end


0.99: not worth to mention

0.98a.1: (OS/2) Metafiles were not printed correctly to physical printers; 
virtual printers were not envolved.
0.98a.2: .PN (changing a page number) did not work properly in preview 
window
0.98a.3: preview window redraw problems
0.98a.4: (Win) wrong calculation of character width (-> formatting and 
printing malfunction) if a  printer is used with a non-default resolution

0.98.01: Registration was only valid after restarting WSformat
0.98.02: If the format thread was interrupted by the user, WSformat couldn't 
be closed correctly
0.98.03: .LH default value could be zero -> corrupted preview and printing
0.98.04: "unform edit" was enabled if the file was not created yet
0.98.05: if a toggle like ^PS was opened, but not closed, an error message was 
missing

0.97.01: Minor bugs concerning navigation in preview window
0.97.02: ".PO" had no effect for the directly following text line
0.97.03: malfunctions when making content (TOC file remained sometimes empty, 
wrong font)
0.97.04: Doubleclick-jumping between WS and FMT file opened wrong document 
files
0.97.05: Settings notebook, page Format: Program crashed when Font edit field 
empty
0.97.06: Problems with registration code
0.97.07: Footnote/endnote file last words did not appear
0.97.08: (OS/2) Command window: "Scale" Radio buttons did not appear

0.96.01: Bold/Italic font default was not defined -> wrong formatting
0.96.02: .BTX Bitmap width in running text was not calculated -> wrong 
formatting
0.96.03: Help file was not activated from the "insert dot commdands" window
0.96.04: Conflicts between Hypermake/WSformat dot command syntax solved

0.94 and 0.95 fixes also a lot of smaller bugs, not worth all to mention. In 
0.94, communication between WSformat, WSedit and reverse was buggy, especially 
in the Windows version. So features which were already programmed have not 
worked.

0.94.01: several Preview window redraw problems fixed
0.94.02: Fonts names with " characters, e.g. .SFA" did not work
0.94.03: wrong page break when using comment lines
0.94.04: WSformat crashes while closing when the "registering fonts" window 
was active

0.92, 0.93: smaller bugfixes

0.85.01: Preview in Landscape format was not programmed yet
0.85.02: running WSedit from WSformat with long filenames containing spaces 
did not work
0.85.03: Underlining several words in running text was not continous

0.84.01: redraw problems of the preview window

0.83 fixes also a handful other minor bugs, not worth to mention.

0.82.01: malfunction using .PM and .LM
0.82.02: malfunction when creating Fonts.ini if a large number of fonts is 
installed

0.81.01: (Win95-98-ME) Registering printer fonts fails, program hangs
0.81.02: (all) WSformat.dta user settings were not written


.2
Download Location

http://www.WriteAndSet.com
http://www.WriteAndSet.com/english/download.html

Filenames:
OS/2-eCS version: wset-os2.zip
Win95/98/ME/NT/Win2000/XP version: wset-win.zip

Archive file names with version number (e.g. wset100.zip) are usually the 
Windows version.

.2
Trademarks

IBM and OS/2 is a registered trademark of International Business Machines 
Corp.
WordStar is a trademark of The Learning Company.
Windows is a trademark of Microsoft.

.2
Other progs

Other programs I have written, both Windows 95/98/ME/NT/2000/XP and OS/2 
(Linux versions for some programs are planned)

.in Hypermake
Hypermake:
A Hypertext compiler which creates HTML files, Winhelp MS HTML-Help and OS/2 
Help from WSformat source files and ASCII files with dot commands. The 
WSformat help file is created from the unformatted documentation file by 
Hypermake. Automatic linking, window arrangement, helptables, footnotes, 
tables and other features. Shareware if source file > 20 kB. The commandline 
version of Hypermake (without user interface) is part of the Write&Set 
archive, to get activated from WSformat main menu, Make - HTML and Make - 
RTF.

.in WSedit
WSedit:
Wordstar (DOS)-compatible editor: Reading and writing Wordstar (DOS) files, 
ASCII IBM and ISO codepage. Supports Wordstar Ctrl key commands and CUA 
commands. Syntax-highlightning, Translation, spell checking, function key 
macro recorder and a lot of other features. WSedit handles very large ASCII 
files. Freeware.

4allCalc/pmCalc: a "pocket" calculator automatic clipboard functionality, 
programmers and scientific  functions, Regression. There's a separate input 
and output field, the formula you type rests in the input field. (Shareware)

TinyAlarm:
A simple countdown with a slider from 1 to 60, an alarm by entering alarm time 
and a chime. System shutdown. Freeware.

cd-shortcut:
instead of whole directory names you enter only substrings. Searching through 
several drives and opening OS/2 WPS folders. Freeware.

Simple Zipshell:
Packing and unpacking ZIP files by using the graphical desktop. Freeware. The 
smallest ZIP unpacking/packing program of the world.

Clear:
(only OS/2) Uses also Info-Zip and let you backup your data e.g. on floppies. 
You can enter filenames like *.BAK which are not copied, directories which are 
skipped. Then you can enter filenames with a specific age which are deleted. 
Freeware.

For more information, screenshots and downloads, visit my Homepage

http://www.hypermake.com

end of document