
                           Hed version 1.7 beta

                        Brief manual (in beta also)
                  




                             HED KEY REFERENCE

General Commands
----------------


 Alt-O          Open file. A wildcard will open all the matching
                files. Logical drives (partitions) can be opened
                as well by specifying the drive letter followed
                by a semicolon (e.g. 'D:').

 Alt-Q          Quit file.

 Alt-N          Next file.

 Alt-P          Previous file. HeD can open multiple files. Use
                Alt-N, Alt-P to browse through these files.

 F3             Abort changes in file.

 F2             Save file (write changes).

 Alt-F2         Save as under a different filename.

 F9             Shell to command prompt.

 Alt-F9         Execute program.

 Ctrl-F4        Calculator.

 Ctrl-M         Record Macro.

 Alt-X          Exit.


Moving around
-------------


 Home           Go to the beginning of the line.

 End            Go to the end of the line.

 Ctrl-PageUp    Go to the top of the panel.

 Ctrl-PageDown  Go to the end of the panel.

 Ctrl-Home      Go to the beginning of the file.

 End            Go to the end of the file. An additional right
                arrow is required to move past the end of the
                file.

 Ctrl-RArrow    Slide the panel to the right.

 Ctrl-LArrow    Slide the panel to the left.

                NOTE: When in disassembly mode, HeD will always
                try to find the original stream of code so as
                to avoid placing the panel's start in between
                instructions. Sliding the panel left or right
                is useful when needed to go to an exact location
                (e.g. in the middle of an instruction).

 Ctrl-G         Go to offset.

                NOTE: HeD accepts arithmetic expressions in any
                number requester. So, instead of a number you can
                enter complex expressions. For example:
                0x100+345*(1<<8).

 Alt-G          Go to virtual offset. (More on this on the virtual
                offset section of this manual).

 Ctrl-B         Go back to previous position (undo last goto).

 Alt-Shf[0...9] Save position.

 Alt-[0...9]    Return to position.

 Alt-PgDwn      Go to next change. Will jump to the next byte
                that has been previously changed. This is useful
                to keep track of changed data in various places
                of a large file.

 Alt-PgUp       Go to previous change.



Viewing options
---------------


 Tab            Switch between ascii and hex panels in normal
                mode. Switch between hex and instructions while
                in disassembly mode.

 Alt-V          Toggle between hexadecimal and disassembly mode.

 Alt-D          Toggle between hexadecimal and decimal offset
                representation.

 Alt-F          Select text filter.

 Alt-U          Toggle segment size (16bits or 32bits). This will
                change the mode the internal assembler and
                disassembler works. For more information look at
                "Assembling and Disassembling" section.


Changing data
-------------

 +              Increase number at cursor location.

 -              Decrease number.

 Del            Undo byte.

 Backspace      Move backwards and undo.

 Alt-Enter      Insert number at cursor location. The inserted
                expression will be evaluated and will be placed
                at the cursor location as a 8, 16 or 32bit number.

 F11            Insert character. Selects a character from the
                ascii character table.

 Ctrl-Ins       Copy to HeD's internal clipboard. To select data
                for copying hold down the Shift key while moving.
                Data from the clipboard can be pasted into the
                data panel or in dialog boxes.

 Shift-Ins      Paste from internal clipboard.

 Alt-Ctrl-Ins   Copy selection to file. Data can be saved as
                binary, hex or disassembly.

 Shift-Ctrl-Ins Paste file into current location.

 Ctrl-Del       Undo all changes within selection.



Searching for data
-------------------


 F5             Find number.

 F6             Find text string.

 F7             Find hexadecimal data.

 F8             Super find. For details about finding look at
                'Finding & Replacing' section of this documentation.

 Alt-F5         Find number and replace.

 Alt-F6         Find text and replace.

 Alt-F7         Find hex and replace.

 Alt-F8         Super find and replace.

 Ctrl-F6        Search in assembly text.

 Ctrl-F8        Find reference.


 Shift-F7       Redo last search.




                             DIALOG BOXES KEYS


 Tab            Switch between dialog box controls.

 Shift-Tab      Switch between dialog box controls (backwards).

 Shift-Ins      Paste data into entry boxes.

 Alt-Up         Previous matching selection in list box.

 Alt-Down       Next matching selection in list box. You can select a
                line in a list box by typing the text it contains.
                Alt-Up Alt-Down will browse through all matching lines.




                            FINDING & REPLACING


 Find hex:

 Finds hex data in the file. Enter the hex data to search for or
paste it from the internal clipboard. The keystroke Alt-? will
insert a wildcard. A wildcard in the search pattern matches any
data. A wildcard in the replace pattern will leave anafected the
corresponding byte.


 Find texts:

 Finds text in the file. Case sensitive or insensitive searches
can be specified. Wildcards can be used in a similar way.


 Find number:

 Finds a number in the file. Dword, words or byte sizes may be
specified. HeD uses the little endian notation of the x86 chips.
That is, the bytes are written in memory in order of significance.
For example the number 0x1344 is encoded as 44 13. A number or
an arithmetic expression can be inserted here.


 Super find:

 Superfind is an advanced more flexible way of searching for
data. The search expression consists of a series of wildcards,
each for every byte, separated by a space character.

 Wildcards use the ? - [ ] , ! symbols much in the same way used
by the unix shell. The following examples will clarify the use of
these wildcards.

  1?h 3Eh 44h

   This expression will match a string that has the first
  hex number of the first byte equal to 1 and a second and
  third byte of 3Eh and 44h.

   E8h [0-100d]

   The first byte should equal E8 (hex) and the second must
  be in the range of 0 to 100 (decimal).

   90h !90h

   The first byte should equal 90h while the second must
  not equal 90h

   1B

   Search for 01, not 1B ! The trailing b indicates the
  number is binary.

   ???????0b ???????1b

   Search for an even number immediately followed by an
  odd number.

     1?1d

   Matches all decimal numbers having a first and last
  digit of 1.

   ![3,5,[10-34]]

   Number should not be 3, 5 or in the range of 10
  to 34


  NOTE: Replace data in super find is simple hex data.



  Find Reference:

 Searches the file for branch reference to a specified offset
or to the current location if no offset is specified (use this
if the cursor is at the beginning of a procedure). The first
call to Find Reference will always start from the beginning of
the file. Subsequent calls (Shift-F7) will continue the search
from the last found reference.

 The algorithm Find Reference is using is quite simple and it
is based on two simple rules of 386 assembly: the branch offset
is always the last data encoded in a x86 instruction and that
the branch offset is added to the offset of the _next_ instruction.
So Find Reference simply searches for numbers (of the specified
size) whose value added to the offset of the byte following the
number sums up to the requested offset.

 In addition find reference can check if the previous byte of
the number found is a valid opcode of a branch instruction (jmp,
call etc).




                              LX & PE PARSING


 HeD can use the information located in executables to correctly
display system calls and instructions that require fixup
translation. HeD so far support two file formats: Linear executables
(LX) used by 32bit OS/2 programs, and portable executables (PE)
used by 32bit Win32s and Win32c programs. Elf binary support will
also be included in feature versions of HeD.

 While both PE and LX export names and ordinals in much the same  
way import translation differs considerably. In order to understand
and use PE import information you should read carefully the following
explanation.



                            PE IMPORT EXPANSION


 In LX binaries a table holds information for all imported entry
points and where they are located within the image. For example,
if a module calls PMSHELL.45 three times, three entries in the
import table point to the offset within the image where these
fixups should be applied.

 PE binaries don't enumerate all occurrences of imported entry
points. In fact PE binaries don't have any information about the 
place where imported references should be applied at all. Import 
expansion is done through jump tables. These jump tables are 
filled in by the system loader during execution.

 Lets consider the previous example. A module call PMSHELL.45 
three times. Now lets assume that the start of the jump table
is in virtual offset 0x1000 and that PMSHELL.45 is the second
entry in the table, that is offset 0x1004. All call's to 
PMSHELL.45 appear as 'call dword ptr [00001004]'. It's obvious 
that no fixup need be applied since these instructions are
statically linked to the virtual address of the fixup table.

 At this point arises problem. HeD needs to know beforehand
all the offsets within the file where fixups are applied.
Imported names in portable executables don't contain fixup
information. Since there appears no other way to do this HeD
scan's the entire file for assembly instruction that use the
import jump table !

 This sounds too complicated to be true but it works. It really
does. The whole process takes some time but this shouldn't be a
problem (though running 'HeD \windows\system\*' isn't such a
good idea unless you have very fast CPU and lots of memory).



                              VIRTUAL OFFSETS


 By selecting Fixups/Show virtual/actual offset, you can select
whether HeD's status line will display actual file offset or
virtual memory offset. Virtual memory offset is the memory
location where the data you are viewing will reside once the
program is loaded. You can go directly to a virtual offset using
Fixups/Go to virtual offset.

 Virtual offset can be used to jump to a code offset provided by
a debugger or by a system report. When a module generates an exception
write down the eip number provided in the dialog box. Then load the
module in HeD and go to that virtual offset. You will see the instruction
that generated the exception.

 Note: objects in OS/2 LX images may be relocated in different memory
base than the one specified in the LX header. Actual virtual offset
might not always correspond to a correct memory location.



                              IMPORT EXPANSION


 Import expansion is a mechanism to translate imported ordinals to
the actual names of the imported entry points. HeD has no other way
of finding imported ordinal names other by looking up a database
containing module/ordinal/name information.

 The database is a text file containing entries describing ordinal
names. Each entry has the format:

 MODULE.#ODRINAL  NAME

 The file is called imports.dat and should be placed in HeD's directory.
A default imports.dat file that describes common OS/2 API imports comes
along with HeD.

 To enable import name expansion select the Fixups/Load Import Data menu,
or enable loadimports keyword in HeD.cfg.





                         DISASSEMBLING & ASSEMBLING


 HeD has build in assembling and Disassembling capabilities. Pressing
Alt-V at any time will switch between hex and disassembling mode.

 HeD uses tasms and masm opcode representation. That is the target goes
first and sizes are denoted using 'byte ptr', 'word ptr' and 'dword ptr'
prefixes. A thorough explanation of the 386 instruction encodings is
beyond the scope of this documentation. It is assumed that the user will
have some experience with TD, tasm or masm.

 Some additional explanation is required on branches (jumps, calls, jump
under conditions etc). Relative branch targets are calculated and shown as
file offsets. That is the offset shown in a jump statement is not the
actual number that will appear when the module is loaded but it is the
offset within the file where the instruction points to. Effectively,
pressing enter on a branch statement will jump to the target location.
In addition HeD can also follow far inter-object fixed branches using
the information in the LX header (of course LX fixups must first be
loaded).

 To enter instructions press space or simply start typing the
instruction and the appropriate dialog will pop up. Hex data can be
entered as well by pressing tab.





                       KNOWN BUGS / KNOWN LIMITATIONS


 Limitations and bugs known to the author. Most of these will be
corrected in feature versions:


- HeD's hex panel is hardwired to 16*16.

- HeD's disassembly panel is hardwired to 16 chars height.

- HeD can't assemble floating point instructions.

- Replacing routines aren't really optimized. Mass replaces of
very frequent appearing data can take quite a long time.

- Opcode checking in find reference will not match long conditional
jumps (0F 8*) . Only short conditional (7*) jumps will be mathced.



                              ACKNOWLEDGMENTS


 Panagiotis Malakoudis. The official HeD beta tester :). Cracking
programs has never been more inspiring.

 Peter Fitzsimmons for helping me on a OS/2 programming issue.

 All the guys in Team OS/2 Greece for their support.

 All of you out there in the internet who send me bug reports
and requests for new features.


.



 Dimitris Kotsonis
 jnk@fryni.physics.upatras.gr

