/*
 What's it called: TeX Front End key definitions (texfek.e), v3.0

 What does it do:  Defines the TeX keysets and syntax assist procedures.

 Who and When:     Jo Koenen 7/94
                   Jon Hacker 8/95
                   Walter Schmidt  04/2000
*/

compile if not defined(ENTER_ACTION)
   const ENTER_ACTION = 'ADDLINE'
compile endif

compile if not defined(ENHANCED_ENTER_KEYS)
   const ENHANCED_ENTER_KEYS = 1 -- ???
compile endif

compile if not defined(LATEX_SYNTAX_INDENT)
   const LATEX_SYNTAX_INDENT = 2 -- changed v2.2
compile endif   

/*
Ŀ
  Tex keysets are loaded during defselect                                   
  We put the keys statement in the defselect so that we can check           
  to make sure it is a TeX file before we load the keyset.                  

*/

defproc setTeXKeySets
    universal app_hini

    if tex_is_file() then  -- if TeX doc/style loaded
        if queryprofile( app_hini, TEX_APP, 'TEX_KEYS') then
            if translate(.keyset) <> 'TEXKEYSA' then keys TEXKEYSA endif
        else
            if translate(.keyset) <> 'TEXKEYSN' then keys TEXKEYSN endif
        endif -- TEX_KEYS
    endif  -- TeX doc/style loaded


/*
Ŀ
  Define the TeX syntax assist key set combo                                

*/

defkeys TEXKEYSA   -- quick keys + syntax expansion + EPMTeX accelerator keys 
define TEXACCEL = 1
define TEXCOMPL = 1
include 'texfed.e'

defkeys TEXKEYSN   -- quick keys + syntax expansion
define TEXACCEL = 0
define TEXCOMPL = 1
include 'texfed.e'

/*
ͻ
 TeX syntax assist procedure definitions.                                   
                                                                            
 What does it do:  The enter and space bar keys have been defined to have   
                   specific TeX editing features in this keyset.            
                                                                            
ͼ
*/

  defproc tex_first_expansion
    retc=1   -- default return code
  compile if EVERSION >= 5
    if .line then  -- current line number
  compile else
    if .line and (not command_state()) then
  compile endif
      getline line
      line=strip(line,'T') -- remove trailing spaces
      line_l=substr(line,1,.col-1) -- split line into two parts at cursor
      line_r=substr(line,.col)
      linelen=length(line_l)
      if linelen > 2 then
        wrd=substr(line_l,.col-3,3)
      else
        wrd=line_l
      endif
-- expand \begin
      if wrd='\be' then
        replaceline line_l'gin{}'line_r
        if not insert_state() then insert_toggle
        compile if EVERSION >= '5.50'
          call fixup_cursor()
        compile endif
        endif
        .col=.col+4
-- expand \cite
      elseif wrd='\ci' then
        replaceline line_l'te{}'line_r
        if not insert_state() then insert_toggle
        compile if EVERSION >= '5.50'
          call fixup_cursor()
        compile endif
        endif
        .col=.col+3  -- reposition cursor
-- expand \label
      elseif wrd='\la' then
        replaceline line_l'bel{}'line_r
        if not insert_state() then insert_toggle
        compile if EVERSION >= '5.50'
          call fixup_cursor()
        compile endif
        endif
        .col=.col+4  -- reposition cursor
-- expand \ref
      elseif wrd='\re' then
        replaceline line_l'f{}'line_r
        if not insert_state() then insert_toggle
        compile if EVERSION >= '5.50'
          call fixup_cursor()
        compile endif
        endif
        .col=.col+2  -- reposition cursor
-- expand \fraction
      elseif wrd='\fr' then
        replaceline line_l'ac{}{}'line_r
        if not insert_state() then insert_toggle
        compile if EVERSION >= '5.50'
          call fixup_cursor()
        compile endif
        endif
        .col=.col+3  -- reposition cursor
-- expand equation
      elseif wrd='equ' then
        replaceline line_l'ation'line_r
        if not insert_state() then insert_toggle
        compile if EVERSION >= '5.50'
          call fixup_cursor()
        compile endif
        endif
        .col=.col+6  -- reposition cursor
-- expand eqnarray
      elseif wrd='eqn' then
        replaceline line_l'array'line_r
        if not insert_state() then insert_toggle
        compile if EVERSION >= '5.50'
          call fixup_cursor()
        compile endif
        endif
        .col=.col+6  -- reposition cursor
-- expand footnote
      elseif wrd='\fo' then
        replaceline line_l'otnote{}'line_r
        if not insert_state() then insert_toggle
        compile if EVERSION >= '5.50'
          call fixup_cursor()
        compile endif
        endif
        .col=.col+7  -- reposition cursor
-- expand pageref
      elseif wrd='\pa' then
        replaceline line_l'geref{}'line_r
        if not insert_state() then insert_toggle
        compile if EVERSION >= '5.50'
          call fixup_cursor()
        compile endif
        endif
        .col=.col+6  -- reposition cursor
-- expand \(
      elseif rightstr(wrd,2)='\(' then
        replaceline line_l' \)'line_r
        if not insert_state() then insert_toggle
        compile if EVERSION >= '5.50'
          call fixup_cursor()
        compile endif
        endif
        .col=.col+1  -- reposition cursor
-- future expansions added here
      else  -- wrd =
        retc=0  -- didn't match wrd, no expansion performed
      endif
    else   -- .line  at top of file, abort expansion
      retc=0
    endif  -- .line = 0
  return retc

/*
Ŀ
  Define second TeX syntax expansion procedure for spacebar and enter       
    -- returns 1 if expansion performed                                     

*/
  defproc tex_second_expansion
    retc=1  -- default return value
    if .line then
      getline lin
      parse value lin with '\begin{'texword'}'args
      c=max(1,verify(lin,' '))-1 -- number of spaces before first word
      -- environment recognized?
      if texword <> '' then
;        c=max(1,verify(lin,' '))-1 -- number of spaces before first word
        if texword='tabular' and args = '' then 
          -- stay compatible with previous behaviour:
          line_l=substr(lin,1,.col)
          line_r=substr(lin,.col+1)
          replaceline line_l'{|c|}'line_r
          insertline substr('',1,c)'\end{'texword'}',.line+1
        elseif texword='macrocode' then
          replaceline '%    \begin{macrocode}'
          insertline '%    \end{macrocode}',.line+1
        else
          insertline substr('',1,c)'\end{'texword'}',.line+1
        endif
        call einsert_line()  -- position cursor on a new line following \begin
compile if (LATEX_SYNTAX_INDENT > 0)
        if (texword = 'verbatim') or 
           (texword = 'verbatim*') or 
           (texword = 'macrocode') then
           .col = 1
        elseif (texword <> 'document') then
           .col = .col + LATEX_SYNTAX_INDENT
        endif
compile endif        
      elseif rightstr(strip(lin, 'T'), 2)='\[' then
;        c=max(1,verify(lin,' '))-1 -- number of spaces before first word
        insertline  substr('',1,c)'\]',.line+1
        call einsert_line()
compile if (LATEX_SYNTAX_INDENT > 0)
        .col = .col + LATEX_SYNTAX_INDENT
compile endif        
      else
        retc=0
      endif -- environment
    else
      retc=0
    endif -- .line
  return retc

-- finis

