/*
 * Constant HOLD_INDENT_IN_STREAM_MODE to modify the behaviour of the
 * enter key in stream mode. Only applies to henter_common().
 */

const
compile if not defined(HOLD_INDENT_IN_STREAM_MODE)
   HOLD_INDENT_IN_STREAM_MODE = 0
compile endif

/*
 * 01/96 by herbert
 * makes the keyset with the name at cursor position the current
 * keyset
 */
defproc new_keyset()
getline newkeys
newkeys=substr( newkeys, .col)
parse value newkeys with newkeys rest
sayerror 'changed keyset to 'newkeys
.keyset = newkeys

/*
 * 03/1995 by herbert
 * Snappy enter-behaviour, stays at current column, even shifts
 * text to it when splitting a line
 */
defproc hinsert_line()
if .line then
      split
   else
      insert
      up
   endif
   getline line
   parse value pmargins() with leftcol . paracol .
   if line='' or not .line then
      .col=paracol
   else
      call pfirst_nonblank()
      if .col=paracol then .col=leftcol; endif
   endif
   down
   getline line
   if line<>'' then
      old_insert = insertstate()
      if old_insert <> 1 then insert_toggle endif
      newcol = .col
      .col = 1
      do urx=1 to newcol-1
         keyin ' '
      enddo
      .col = newcol
      if old_insert <> 1 then insert_toggle endif
   endif

/*
 * Slightly enhanced enter_common()
 *  If Constant HOLD_INDENT_IN_STREAM_MODE is set to 1
 *  hinsert_line is called.
 */
compile if ENHANCED_ENTER_KEYS
defproc henter_common(action)
 compile if WANT_CUA_MARKING = 'SWITCH'
   universal CUA_marking_switch
 compile endif
 compile if WANT_STREAM_MODE = 'SWITCH'
   universal stream_mode
   if stream_mode then
 compile endif
 compile if WANT_STREAM_MODE
    compile if HOLD_INDENT_IN_STREAM_MODE = 1
      call hinsert_line()
    compile else
      if .line then
  compile if WANT_CUA_MARKING
   compile if WANT_CUA_MARKING = 'SWITCH'
         if CUA_marking_switch then
   compile endif
            if not process_mark_like_cua() and   -- There was no mark
               not insert_state() then           -- & we're in replace mode
               delete_char    -- Delete the character, to emulate replacing the
            endif             -- marked character with a newline.
   compile if WANT_CUA_MARKING = 'SWITCH'
         endif
   compile endif
  compile endif  -- WANT_CUA_MARKING
         split
         .col=1
         down
      else
         insert
         .col=1
      endif
   compile endif --- HOLD_INDENT_IN_STREAM_MODE = 1
      return
 compile endif  -- WANT_STREAM_MODE
 compile if WANT_STREAM_MODE = 'SWITCH'
   endif
 compile endif
 compile if WANT_STREAM_MODE <> 1
   if .line = .last  & (action=3 | action=5) then  -- 'ADDATEND' | 'DEPENDS+'
      call einsert_line()
      down                       -- This keeps the === Bottom === line visible.
      return
   endif
;     'NEXTLINE' 'ADDATEND'                        'DEPENDS'  'DEPENDS+'
   if action=2 | action=3 | (not insert_state() & (action=4 | action=5)) then
      down                          -- go to next line
      begin_line
      return
   endif
   if action=6 then
      call splitlines()
      call pfirst_nonblank()
      down
;;    refresh
      return
   endif
   call einsert_line()           -- insert a line
 compile endif  -- WANT_STREAM_MODE <> 1
compile endif

/*
 * 03/1995 by Herbert :
 * - Added a defproc smart_backspace() for programming modes. It detects
 *   the indent level of the current paragraph and of those above and
 *   then backspaces to the next lower indent level.
 */

defproc smart_backspace()
   getline line
   this_col = .col
   if line = '' then
      left_col = this_col
   else
      call pfirst_nonblank()
      left_col = .col
      .col = this_col
   endif
   if this_col = 1 | this_col > left_col
   then
      call do_backspace()
   else
      this_line = .line
      lc = 0
      do while .line & .col >= this_col
         up
         lc = lc + 1
         call pfirst_nonblank()
      enddo
      if .col <> left_col then left_col = this_col - .col endif
      do i = 1 to lc
          down
      enddo
      .col = this_col
      do i = 1 to left_col
         call do_backspace()
      enddo
   endif

/*
 * Snappy Semicolon like known from Emacs :-)
 * If a ';' is entered at the end of a line
 * a newline will be performed
 * For Expansion purposes the ';' has to be
 * entered before!
 */
defproc Emacs_Semicolon()
   getline line
   if length( line) < .col then
      call hinsert_line()
   endif

/*
 * Smart closing '}' for Cmode: performs a smart_backspace() if
 *    there's no nonblank char left from cursor
 */
defproc cmode_closing_brace()
   this_col = .col
   call pfirst_nonblank()
   left_col = .col
   .col = this_col
   if this_col <>1 & (left_col = 1 | left_col >= this_col)
   then call smart_backspace()
   endif
   keyin '}'
   this_col = .col
   .col = .col - 1
   call passist()
   call passist()
   .col = this_col

