/**********************************************************************/
/*                                                                    */
/*        File: startup.cr                                            */
/*     Created: 4 Jul 1994                                            */
/* Description: Crisp initialisation, tuning and setup macro          */
/*                                                                    */
/**********************************************************************/

# include	"crisp.h"

int		_c_indent_loaded,
		_c_compile_loaded;

void
startup()
{
	_c_compile_loaded = _c_indent_loaded = 0;
	/*****************************************/
	/*	  If BPACKAGES variable is set, 	 */
	/*	  load language extension macros	 */
	/*****************************************/
	if (getenv("BPACKAGES") != "")
		load_macro("language");
	/*****************************************/
	/*	  Set screenblanker on, with 15 	 */
	/*	  minute timeout					 */
	/*****************************************/
	scrblank(15);
	/*****************************************/
	/*	 Tell user what version is running.  */
	/*****************************************/
	version();
}



/*************************************************************************/
/*																		 */
/*	  The following macros are for langauge sensitive editing. If		 */
/*	  the BPACKAGES system is load because the environment variable 	 */
/*	  is set and the 'language' package is loaded, these macros are 	 */
/*	  called as part of file initialisation.							 */
/*																		 */
/*	  Note that tabs are not normally set here, but are already set 	 */
/*	  in the _extension macro in crisp.cr (called by crisp when the 	 */
/*	  file is first loaded). However, since these macros are called 	 */
/*	  after _extension, overrides can be inserted here if necessary.	 */
/*																		 */
/*************************************************************************/

void
load_indent()
{
	if (!_c_indent_loaded++)
		load_macro("indent");
}

void
load_compile()
{
	if (!_c_compile_loaded++)
		load_macro("compile");
}


void
_default()
{
}

void
_c()
{
	load_indent();
	load_compile();
}

void
_C()
{
	_c();
}

void
_cpp()
{
	_c();
}

void
_cr()
{
	_c();
}

void
_h()
{
	load_indent();
}

void
_hpp()
{
	_c();
}

void
_asm()
{
	load_indent();
	load_compile();
}

void
_inc()
{
	_h();
}

void
_bat()
{
	tabs(5,9);
}

void
_BAT()
{
	tabs(5,9);
}

void
_cmd()
{
	tabs(5,9);
}

void
_CMD()
{
	tabs(5,9);
}

void
_pas()
{
	tabs(3,5);
}

void
_PAS()
{
	tabs(3,5);
}


