/*********************************************************************************/
/*    Description: CRISP C macros												 */
/*********************************************************************************/

# include	"crisp.h"

/*****************************************************************************/
/*    Macro to convert forward prototype declarations to ANSI C prototype	 */
/*    declarations. It is assumed that forward declarations are of the form: */
/*    type func(xxx), where xxx is the parameter list inside a comment		 */
/*    string. We simply remove the comments.								 */
/*****************************************************************************/

void
ansic()
{	int	n;

	top_of_buffer();
	n = re_translate(SF_PROMPT, "{^[A-Za-z]*(}/\\*{*}\\*/);", "\\0\\1);");
	message("%d declarations changed to ANSI C.", n);
}

/*****************************************************************************/
/*    Macro to convert K&R forward prototype declarations to ANSI C			 */
/*    prototype declarations. It is assumed that forward declarations are of */
/*    the form: type func(xxx), where xxx is the parameter list inside a	 */
/*    comment string. We simply remove the comments.						 */
/*****************************************************************************/

void
krc()
{	int	n;

	top_of_buffer();
	n = re_translate(SF_PROMPT, 
		"{^[A-Za-z][^y][^p][^e][^d][^e][^f]*(}{*});", 
		"\\0/*\\1*/);");
	message("%d declarations changed to K&R C.", n);
}

/*****************************************************************************/
/* Following macro simply displays the C hierarchy chart in a popup window.  */
/*****************************************************************************/

list hier_list =
{
	"Arity       Operator                                   Assoc",
	"--------------------------------------------------------------",
	"binary   ()  []  ->  .                                 l -> r",
	"unary    !   ~   ++  --  -  (type)  *  &  sizeof       r -> l",
	"binary   *   /   %                                     l -> r",
	"binary   +   -                                         l -> r",
	"binary   <<  >>                                        l -> r",
	"binary   <   <=  >   >=                                l -> r",
	"binary   ==  !=                                        l -> r",
	"binary   &                                             l -> r",
	"binary   ^                                             l -> r",
	"binary   |                                             l -> r",
	"binary   &&                                            l -> r",
	"binary   ||                                            l -> r",
	"ternary  ?:                                            r -> l",
	"binary   = += -= *= /= %= >>= <<= &= ^= |=             r -> l",
	"binary   ,                                             l -> r",
	"--------------------------------------------------------------",
	"                                               From K&R, p 49"
};

void
hier()
{
	select_list("C operator precedence & associativity", "", 1, hier_list);
}
