/********************************************************************
 *																	*
 *		CRISP - Custom Reduced Instruction Set Programmers Editor	*
 *																	*
 *		(C) Paul Fox, 1989											*
 *																	*
 *	  Please See COPYLEFT notice.									*
 *																	*
 ********************************************************************/
# include	"crisp.h"

# define	BRACKETS	"[](){}"
void
find_matching_brace()
{
	string bracket, mbracket, s, s1;
	int br_level, i, incr, fwd;

	save_position();
	bracket = read(1);
	if (index(bracket, BRACKETS) == 0) {
		if (re_search(SF_UNIX, "[()[\\]{}]") <= 0) {
			beep();
			return;
			}
		bracket = read(1);
		}
	message("Locating matching bracket...");
	i = index(BRACKETS, bracket) - 1;
	fwd = i & 1;
	incr = -1;
	if (fwd)
		incr = 1;
	i = 2*i+1;
	mbracket = substr("[][]()(){}{}", i, 2);
	s = "[" + quote_regexp(mbracket) + "]";
	s1 = substr(mbracket, 1, 1);

	br_level = 1;
	while (br_level > 0) {
		if (fwd) {
			prev_char();
			if (re_search(SF_BACKWARDS, s) <= 0)
				break;
			}
		else {
			next_char();
			if (re_search(NULL, s) <= 0)
				break;
			}
		if (read(1) == s1)
			br_level -= incr;
		else
			br_level += incr;
		}
	if (br_level) {
		error("Matching %s not found.", mbracket);
		restore_position();
		beep();
		return;
		}
	restore_position(0);
	message("");

}

#define TRUE		1
#define FALSE		0
#define FWD			0
#define BACK		1
#define DONE		2

string brace_pattern = "[\\{\\}]";

int
char_search(int direction)
{

	return (direction) ? search_back(brace_pattern)
					   : search_fwd(brace_pattern);
}

void
check_braces()
{
	int 	tot_count,
			start_line,
			start_col,
			mismatch,
			char_we_got,
			direction;
	string	char_holder,
			msg_pattern,
			msg_text;

	msg_pattern = "Checking braces, %d unmatched {s.";
	inq_position(start_line, start_col);
	top_of_buffer();
	tot_count = 0;
	mismatch = FALSE;
	direction = FWD;
	while (direction != DONE)
	{
		while (char_search(direction) && !mismatch)
		{
			sprintf(msg_text, msg_pattern, tot_count);
			message(msg_text);
			char_holder = read(1);
			if (direction == BACK)
				char_we_got = index("}{", char_holder);
			else
				char_we_got = index("{}", char_holder);
			if (char_we_got == 1)
				++tot_count;
			else
			{
				if (char_we_got == 2)
				{
					if (tot_count)
						--tot_count;
					else
					{
						if (direction == BACK)
							message("Mismatched opening brace.");
						else
							message("Mismatched closing brace.");
						mismatch = TRUE;
					}
				}
			}
			if (!mismatch)
			{
				if (direction == BACK)
					prev_char(1);
				else
					next_char(1);
			}
		}
		if (!mismatch)
		{
			if (tot_count)
			{
				end_of_buffer();
				tot_count = 0;
				direction = BACK;
				msg_pattern = "Locating mismatch, %d unmatched }s.";
			}
			else
				direction = DONE;
		}
		else
			direction = DONE;
	}
	if (!mismatch)
	{
		message("All braces match.");
		move_abs(start_line, start_col);
	}
}

