IMPLEMENTATION MODULE IPFDump;

  IMPORT Str, Out, IPF;

  PROCEDURE OutSlot (i: IPF.anIndex);
    VAR
      j, k:     IPF.anIndex;
      w:        IPF.aWord;
      word:     IPF.aString;
      id:       IPF.aWord;
      len:      IPF.anIndex;
      base:     IPF.anIndex;
      spc:      BOOLEAN;
      mono:     BOOLEAN;
      leftMargin,
      rightMargin,
      style,
      align,
      color:    SHORTCARD;
      ref:      IPF.anIndex;
      ch:       CHAR;
    BEGIN
      WITH IPF.Slot^[i]^ DO
        spc:= TRUE; mono:= FALSE;
        leftMargin:= 0; rightMargin:= 1;
        style:= 0; align:= 0;
        FOR j:= 0 TO textCnt-1 DO
          w:= text^[j];
          IF w >= localCnt THEN
            CASE w OF

            | 0FAH: (* paragraph *)
              Out.S( "{par}" );
              Out.Ln; Out.Ln; spc:= TRUE;

            | 0FCH: (* space control *)
              IF spc THEN Out.S( "{spc-}" ) ELSE Out.S( "{spc+}" ) END;
              spc:= NOT spc;

            | 0FDH: (* line break *)
              Out.S( "{line}" );
              Out.Ln; spc:= TRUE;

            | 0FEH: (* space *)
              Out.S( "{spc}" );
              Out.S( " " );

            | 0FFH: (* escape *)
              len:= VAL(IPF.anIndex, text^[j+1] ); id:= text^[j+2]; base:= j+3;
              INC( j, len ); DEC(len,2);
              Out.S( "{esc" );
              FOR k:= base-1 TO base+len-1 DO
                Out.S( ":" ); Out.CL( VAL(CARDINAL,text^[k]),0 );
              END;
              Out.S( ">" ); Out.CL( VAL(CARDINAL,text^[base+len]),0 );
              Out.S( "}" );
              CASE id OF

              | 2, 17, 18:  (* set left margin *)
                Out.S( "{left" ); Out.CL(VAL(CARDINAL,text^[base]),0); Out.S( "}" );
                IF (id = 17) OR (leftMargin >= text^[base]) THEN
                  Out.Ln;
                END;
                leftMargin:= text^[base];
                FOR k:= 1 TO VAL(CARDINAL,leftMargin) DO Out.S( " " ) END;
                spc:= TRUE;

              | 3: (* set right margin *)
                Out.S( "{right" ); Out.CL(VAL(CARDINAL,text^[base]),0); Out.S( "}" );
                rightMargin:= text^[base];

              | 4: (* change style *)
                Out.S( "{style" ); Out.CL(VAL(CARDINAL,text^[base]),0); Out.S( "}" );
                style:= text^[base];

              | 5, 7: (* reference *)
                ref:= VAL(IPF.anIndex,text^[base]) + 256 * VAL(IPF.anIndex,text^[base+1]);
                Out.S( "{ref+" ); Out.CL(ref,0);
                Out.S( ";" ); Out.CL( VAL(CARDINAL,id),0 );
                FOR k:= base+2 TO base+len-1 DO
                  Out.S( ":" ); Out.CL( VAL(CARDINAL,text^[k]),0 );
                END;
                Out.S( "}" );
                Out.S( "[" );

              | 8: (* end of reference *)
                Out.S( "{ref-}" );
                Out.S( "]" );

              | 11: (* begin monospace example *)
                Out.S( "{mono+}" );
                Out.Ln; mono:= TRUE;

              | 12: (* end monospace example *)
                Out.S( "{mono-}" );
                Out.Ln; mono:= FALSE;

              | 15: (* inline reference *)
                IF len = 3 THEN k:= 1 ELSE k:= 0 END;
                ref:= VAL(IPF.anIndex,text^[base+k]) + 256 * VAL(IPF.anIndex,text^[base+k+1]);
                Out.S( "{ref+" ); Out.CL(ref,0);
                Out.S( ";" ); Out.CL( VAL(CARDINAL,id),0 );
                Out.S( "}" );
                Out.S( "[" );
                Out.S( IPF.Toc^[ref]^.title^ );
                Out.S( "]" );

              | 26: (* begin lines *)
                Out.S( "{lines+}" );
                Out.Ln;
                align:= text^[base];

              | 27: (* end lines *)
                Out.S( "{lines-}" );
                Out.Ln;

              ELSE
                Out.S( "{esc" ); Out.CL( VAL(CARDINAL,id),0 );
                Out.S( ";" ); Out.CL( VAL(CARDINAL,len),0 );
                Out.S( "}" );
              END;

            ELSE (*plain control*)
              Out.S( "{" ); Out.CL( VAL(CARDINAL,w),0 ); Out.S( "}" );
            END;

          ELSE (*plain word*)
            Str.Assign( word, IPF.Dict^[local^[w]]^ );
            Out.S( word );
            IF spc AND NOT mono THEN Out.S( " " ) END;

          END (*if control or word*);
        END (*for words*);
      END (*with slot*);
    END OutSlot;


END IPFDump.
