-- create a tablespace we can use
CREATE TABLESPACE testspace2 LOCATION '/pgsql/testtablespace2';

-- create a schema we can use
CREATE SCHEMA testschema;

-- try a table
CREATE TABLE testschema.foo (i int) TABLESPACE testspace2;
SELECT relname, spcname FROM pg_catalog.pg_tablespace t, pg_catalog.pg_class c
    where c.reltablespace = t.oid AND c.relname = 'foo';

INSERT INTO testschema.foo VALUES(1);
INSERT INTO testschema.foo VALUES(2);

-- index
CREATE INDEX foo_idx on testschema.foo(i) TABLESPACE testspace2;
SELECT relname, spcname FROM pg_catalog.pg_tablespace t, pg_catalog.pg_class c
    where c.reltablespace = t.oid AND c.relname = 'foo_idx';

-- Will fail with bad path
CREATE TABLESPACE badspace LOCATION '/no/such/location';

-- No such tablespace
CREATE TABLE bar (i int) TABLESPACE nosuchspace;

-- Fail, not empty
DROP TABLESPACE testspace2;

DROP SCHEMA testschema CASCADE;

-- Should succeed
DROP TABLESPACE testspace2;
