/*
 * This file was generated automatically by xsubpp version 1.9508 from the
 * contents of SPI.xs. Do not edit this file, edit SPI.xs instead.
 *
 *	ANY CHANGES MADE HERE WILL BE LOST!
 *
 */

#line 1 "SPI.xs"
/* this must be first: */
#include "postgres.h"

/* perl stuff */
#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"
#include "ppport.h"

#include "spi_internal.h"


/*
 * Implementation of plperl's elog() function
 *
 * If the error level is less than ERROR, we'll just emit the message and
 * return.  When it is ERROR, elog() will longjmp, which we catch and
 * turn into a Perl croak().  Note we are assuming that elog() can't have
 * any internal failures that are so bad as to require a transaction abort.
 *
 * This is out-of-line to suppress "might be clobbered by longjmp" warnings.
 */
static void
do_spi_elog(int level, char *message)
{
	MemoryContext oldcontext = CurrentMemoryContext;

	PG_TRY();
	{
		elog(level, "%s", message);
	}
	PG_CATCH();
	{
		ErrorData  *edata;

		/* Must reset elog.c's state */
		MemoryContextSwitchTo(oldcontext);
		edata = CopyErrorData();
		FlushErrorState();

		/* Punt the error to Perl */
		croak("%s", edata->message);
	}
	PG_END_TRY();
}


#line 58 "SPI.c"
XS(XS__elog); /* prototype to pass -Wmissing-prototypes */
XS(XS__elog)
{
    dXSARGS;
    if (items != 2)
	Perl_croak(aTHX_ "Usage: elog(level, message)");
    {
	int	level = (int)SvIV(ST(0));
	char*	message = (char *)SvPV_nolen(ST(1));
#line 58 "SPI.xs"
		if (level > ERROR)		/* no PANIC allowed thanks */
			level = ERROR;
		if (level < DEBUG5)
			level = DEBUG5;
		do_spi_elog(level, message);
#line 74 "SPI.c"
    }
    XSRETURN_EMPTY;
}

XS(XS__DEBUG); /* prototype to pass -Wmissing-prototypes */
XS(XS__DEBUG)
{
    dXSARGS;
    if (items != 0)
	Perl_croak(aTHX_ "Usage: DEBUG()");
    {
	int	RETVAL;
	dXSTARG;

	RETVAL = spi_DEBUG();
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

XS(XS__LOG); /* prototype to pass -Wmissing-prototypes */
XS(XS__LOG)
{
    dXSARGS;
    if (items != 0)
	Perl_croak(aTHX_ "Usage: LOG()");
    {
	int	RETVAL;
	dXSTARG;

	RETVAL = spi_LOG();
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

XS(XS__INFO); /* prototype to pass -Wmissing-prototypes */
XS(XS__INFO)
{
    dXSARGS;
    if (items != 0)
	Perl_croak(aTHX_ "Usage: INFO()");
    {
	int	RETVAL;
	dXSTARG;

	RETVAL = spi_INFO();
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

XS(XS__NOTICE); /* prototype to pass -Wmissing-prototypes */
XS(XS__NOTICE)
{
    dXSARGS;
    if (items != 0)
	Perl_croak(aTHX_ "Usage: NOTICE()");
    {
	int	RETVAL;
	dXSTARG;

	RETVAL = spi_NOTICE();
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

XS(XS__WARNING); /* prototype to pass -Wmissing-prototypes */
XS(XS__WARNING)
{
    dXSARGS;
    if (items != 0)
	Perl_croak(aTHX_ "Usage: WARNING()");
    {
	int	RETVAL;
	dXSTARG;

	RETVAL = spi_WARNING();
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

XS(XS__ERROR); /* prototype to pass -Wmissing-prototypes */
XS(XS__ERROR)
{
    dXSARGS;
    if (items != 0)
	Perl_croak(aTHX_ "Usage: ERROR()");
    {
	int	RETVAL;
	dXSTARG;

	RETVAL = spi_ERROR();
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

XS(XS__spi_exec_query); /* prototype to pass -Wmissing-prototypes */
XS(XS__spi_exec_query)
{
    dXSARGS;
    if (items < 1)
	Perl_croak(aTHX_ "Usage: spi_exec_query(query, ...)");
    {
	char*	query = (char *)SvPV_nolen(ST(0));
#line 86 "SPI.xs"
		HV *ret_hash;
		int limit = 0;
#line 186 "SPI.c"
	SV *	RETVAL;
#line 89 "SPI.xs"
		if (items > 2)
			croak("Usage: spi_exec_query(query, limit) or spi_exec_query(query)");
		if (items == 2)
			limit = SvIV(ST(1));
		ret_hash = plperl_spi_exec(query, limit);
		RETVAL = newRV_noinc((SV*) ret_hash);
#line 195 "SPI.c"
	ST(0) = RETVAL;
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}

#ifdef __cplusplus
extern "C"
#endif
XS(boot_SPI); /* prototype to pass -Wmissing-prototypes */
XS(boot_SPI)
{
    dXSARGS;
    char* file = __FILE__;

        newXSproto("elog", XS__elog, file, "$$");
        newXSproto("DEBUG", XS__DEBUG, file, "");
        newXSproto("LOG", XS__LOG, file, "");
        newXSproto("INFO", XS__INFO, file, "");
        newXSproto("NOTICE", XS__NOTICE, file, "");
        newXSproto("WARNING", XS__WARNING, file, "");
        newXSproto("ERROR", XS__ERROR, file, "");
        newXSproto("spi_exec_query", XS__spi_exec_query, file, "$;@");

    /* Initialisation Section */

#line 100 "SPI.xs"
    items = 0;  /* avoid 'unused variable' warning */

#line 225 "SPI.c"

    /* End of Initialisation Section */

    XSRETURN_YES;
}

