/*-------------------------------------------------------------------------
 *
 * shmem.c
 *	  IBM OS/2 Shared Memory Emulation
 *
 * Portions Copyright (c) 1996-2004, PostgreSQL Global Development Group
 * Portions Copyright (c) 2004, Lorne R Sunley
 *
 * IDENTIFICATION
 *	  $PostgreSQL: pgsql/src/backend/port/ibmos2/shmem.c,v 1.8 2004/08/29 05:06:46 momjian Exp $
 *
 *-------------------------------------------------------------------------
 */
#define INCL_DOSMEMMGR
#define INCL_DOSERRORS
#define INCL_EXAPIS
//#define INCL_EXAPIS_MAPPINGS
#include <os2.h>
#include <stdio.h>
#include <errno.h>
#include <sys/shm.h>

/* Detach from a shared mem area based on its address */
int
shmdt(const void *shmaddr)
{
	APIRET rc;
	rc = DosFreeMemEx((VOID *) shmaddr);
	if (rc == NO_ERROR)
		return 0;

	errno = EINVAL;
	return -1;
}
/* Attach to an existing area */
void *
shmat(int memId, const void *shmaddr, int flag)
{
	APIRET rc;
	ULONG  testSize = 20000000;
	ULONG  testFlags;
	void * lpmem;

	/* TODO -- shmat needs to count # attached to shared mem */
	lpmem = (void *)memId;
	rc = DosGetSharedMemEx( lpmem, PAG_WRITE | PAG_READ );	
	if (rc != NO_ERROR)
	{
		if (rc == ERROR_ACCESS_DENIED)
		{
			/* we may already have the region so query the memory address to see if we have access */
			rc = DosQueryMem( lpmem, &testSize, &testFlags);
			if (rc != NO_ERROR) 
			{ 
				errno = EINVAL;
				lpmem = (void *) -1;
				return lpmem;
			}
			/* check if read/write and shared region base page */
			if (!(testFlags & (PAG_SHARED | PAG_BASE | PAG_READ | PAG_WRITE)))
			{ 
				errno = EINVAL;
				lpmem = (void *) -1;
				return lpmem;
			}
		}
		else
		{
				errno = EINVAL;
				lpmem = (void *) -1;
				return lpmem;
		}
	}
	if (shmaddr)
		shmaddr = lpmem;
	return lpmem;
}
/* Control a shared mem area */
int
shmctl(int shmid, int flag, struct shmid_ds * shm_ds)
{
	APIRET rc;
	ULONG  testSize = 2000000;
	ULONG  testFlags;

	if (flag == IPC_RMID)
	{
		/* Delete the area */
		int hmap = shmget(shmid, 0, 0);
		rc = DosFreeMemEx((VOID *) hmap);
		return 0;
	}
	if (flag == IPC_STAT)
	{
		rc = DosQueryMem( (void *)shmid, &testSize, &testFlags);
		if (rc != NO_ERROR) 
		{ 
			/* Shared memory does not exist */
			errno = EINVAL;
			return -1;
		}
		else
		{
			if (!(testFlags & (PAG_SHARED | PAG_BASE )))
			{
			/* Shared memory does exist */
				if (shm_ds)
				{
					/* segment size is all we know about */
					shm_ds->shm_segsz = testSize;
				}
				if (!(testFlags & PAG_READ))
				{
					/* read access denied */
					errno = EACCES;
					return -1;
				}

				errno = 0;
				return 0;
			}
			else
			{
				/* not a shared memory base page */
				errno = EINVAL;
				return -1;
			}
		}
	}
	errno = EINVAL;
	return -1;
}
/* Get an area based on the IPC key */
int
shmget(key_t memKey, size_t size, int flag)
{
	VOID		*hmap = NULL;
	char		szShareMem[32];
	APIRET		rc;
	sprintf(szShareMem, "\\SHAREMEM\\.%d" , (int)memKey);
	if (flag & IPC_CREAT)
	{
//		rc = DosAllocSharedMem(&hmap, szShareMem, (ULONG)size, PAG_READ | PAG_WRITE | PAG_COMMIT | OBJ_ANY );
		rc = DosAllocSharedMemEx(&hmap, NULL, (ULONG)size, OBJ_FORK | PAG_READ | PAG_WRITE | PAG_COMMIT | OBJ_ANY | OBJ_GIVEABLE | OBJ_GETTABLE  );
	}
	else
	{
		rc = DosGetNamedSharedMemEx(&hmap, szShareMem, PAG_READ | PAG_WRITE | PAG_COMMIT );
		if (!hmap)
		{
			errno = ENOENT;
			return -1;
		}
	}
	if (rc == ERROR_ALREADY_EXISTS && hmap && (flag & (IPC_CREAT | IPC_EXCL)))
	{
		/* Caller wanted to create the segment -- error if already exists */
		errno = EEXIST;
		return -1;
	}
	else if (!hmap)
	{
		/* Unable to get shared memory */
		errno = EINVAL;
		return -1;
	}
	return (int) hmap;
}
