/*
 * os2dlsym - obtain a procedure address from a shared library
 *
 * specialized function to compensate for gcc 3.3.5 adding a leading "_" to
 * function names
 *
 */

#include <os2.h>
#include <dlfcn.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
void *os2dlsym(void *handle, const char *symbol);

void *os2dlsym(void *handle, const char *symbol)
{

	/* work area to add a "_" to a function name (GCC compiler in OS/2 adds them) */
	char	underFuncname[260];
	void *	retval;

	retval = dlsym(handle, symbol);
	/* if we get this error try adding a leading "_" to funcname */
	if (retval == NULL)
	{
		strcpy(underFuncname, "_");
		strcat(underFuncname, symbol);
		retval = dlsym(handle, underFuncname);
	}
	return retval;

}



