/**************************************************************************************
** ODBCDR2
**
** Version 1
**
** This file contains the parameters and values to use in setting up
** each database driver
** install.
**
** You can modify this file for new ODBC driver that need to be install
**
** (The install process also needs a ODBCDR2 file which contains the
** setup information for each driver listed in this file)
**
**
** NOTE:  File names must be in UPPER CASE
**
***************************************************************************************/

RxReturnByName("DrvSetup")      /* RXU function for returning varible values */



DrvSetup.0 = 27                        /* number of groups/drivers */



/*dBase */
DrvSetup.1.0 = 8                       /* number of entries for this group/driver */
DrvSetup.1.1.t = "APILevel"            /* each entry has a "title" */
DrvSetup.1.1.v = 1                     /* and a value */
DrvSetup.1.2.t = "ConnectFunctions"
DrvSetup.1.2.v = "YYN"
DrvSetup.1.3.t = "DriverODBCVer"
DrvSetup.1.3.v = "02.10"
DrvSetup.1.4.t = "FileUsage"
DrvSetup.1.4.v = 1
DrvSetup.1.5.t = "FileExtns"
DrvSetup.1.5.v = "*.dbf"
DrvSetup.1.6.t = "SQLLevel"
DrvSetup.1.6.v = 0
DrvSetup.1.7.t = "Setup"
DrvSetup.1.7.v = ""
DrvSetup.1.8.t = "Driver"              /* This entry specifies the database driver file */
DrvSetup.1.8.v = ""                    /* If the value is empty then the driver file name (the first entry for a group) */
                                       /* is used from the driver required list (ODBCDrv1) */
                                       /* If the entry SETUP has a blank value then it is also automatically filled */
                                       /* from the driver file name */
/*ORACLE*/
DrvSetup.2.0 = 7
DrvSetup.2.1.t = "APILevel"
DrvSetup.2.1.v = 1
DrvSetup.2.2.t = "ConnectFunctions"
DrvSetup.2.2.v = "YYY"
DrvSetup.2.3.t = "DriverODBCVer"
DrvSetup.2.3.v = "02.10"
DrvSetup.2.4.t = "FileUsage"
DrvSetup.2.4.v = 0
DrvSetup.2.5.t = "SQLLevel"
DrvSetup.2.5.v = 1
DrvSetup.2.6.t = "Driver"
DrvSetup.2.6.v = ""
DrvSetup.2.7.t = "Setup"
DrvSetup.2.7.v = ""

/*ORACLE7*/
DrvSetup.3.0 = 7
DrvSetup.3.1.t = "APILevel"
DrvSetup.3.1.v = 1
DrvSetup.3.2.t = "ConnectFunctions"
DrvSetup.3.2.v = "YYY"
DrvSetup.3.3.t = "DriverODBCVer"
DrvSetup.3.3.v = "02.10"
DrvSetup.3.4.t = "FileUsage"
DrvSetup.3.4.v = 0
DrvSetup.3.5.t = "SQLLevel"
DrvSetup.3.5.v = 1
DrvSetup.3.6.t = "Driver"
DrvSetup.3.6.v = ""
DrvSetup.3.7.t = "Setup"
DrvSetup.3.7.v = ""

/*SQLSERVER*/
DrvSetup.4.0 = 7
DrvSetup.4.1.t = "APILevel"
DrvSetup.4.1.v = 1
DrvSetup.4.2.t = "ConnectFunctions"
DrvSetup.4.2.v = "YYY"
DrvSetup.4.3.t = "DriverODBCVer"
DrvSetup.4.3.v = "02.10"
DrvSetup.4.4.t = "FileUsage"
DrvSetup.4.4.v = 0
DrvSetup.4.5.t = "SQLLevel"
DrvSetup.4.5.v = 1
DrvSetup.4.6.t = "Driver"
DrvSetup.4.6.v = ""
DrvSetup.4.7.t = "Setup"
DrvSetup.4.7.v = ""

/*ODBCINST_SYBASE*/
DrvSetup.5.0 = 7
DrvSetup.5.1.t = "APILevel"
DrvSetup.5.1.v = 1
DrvSetup.5.2.t = "ConnectFunctions"
DrvSetup.5.2.v = "YYY"
DrvSetup.5.3.t = "DriverODBCVer"
DrvSetup.5.3.v = "02.10"
DrvSetup.5.4.t = "FileUsage"
DrvSetup.5.4.v = 0
DrvSetup.5.5.t = "SQLLevel"
DrvSetup.5.5.v = 1
DrvSetup.5.6.t = "Driver"
DrvSetup.5.6.v = ""
DrvSetup.5.7.t = "Setup"
DrvSetup.5.7.v = ""

/*ODBCINST_TEXTFILE*/
DrvSetup.6.0 = 8
DrvSetup.6.1.t = "APILevel"
DrvSetup.6.1.v = 1
DrvSetup.6.2.t = "ConnectFunctions"
DrvSetup.6.2.v = "YYN"
DrvSetup.6.3.t = "DriverODBCVer"
DrvSetup.6.3.v = "02.10"
DrvSetup.6.4.t = "FileUsage"
DrvSetup.6.4.v = 1
DrvSetup.6.5.t = "FileExtns"
DrvSetup.6.5.v = "*.*"
DrvSetup.6.6.t = "SQLLevel"
DrvSetup.6.6.v = 1
DrvSetup.6.7.t = "Driver"
DrvSetup.6.7.v = ""
DrvSetup.6.8.t = "Setup"
DrvSetup.6.8.v = ""


/*Sybase SQL Anywhere*/
DrvSetup.7.0 = 2
DrvSetup.7.1.t = "Driver"
DrvSetup.7.1.v = "WOD502.DLL"
DrvSetup.7.2.t = "Setup"
DrvSetup.7.2.v = ""

/*Dirk Ohme Oracle*/
DrvSetup.8.0 = 2
DrvSetup.8.1.t = "Driver"
DrvSetup.8.1.v = ""
DrvSetup.8.2.t = "Setup"
DrvSetup.8.2.v = ""

/*miniSQL*/
DrvSetup.9.0 = 2
DrvSetup.9.1.t = "Driver"
DrvSetup.9.1.v = ""
DrvSetup.9.2.t = "Setup"
DrvSetup.9.2.v = ""

/*mySQL*/
DrvSetup.10.0 = 2
DrvSetup.10.1.t = "Driver"
DrvSetup.10.1.v = ""
DrvSetup.10.2.t = "Setup"
DrvSetup.10.2.v = ""

/*Postgres SQL 7.01*/
DrvSetup.11.0 = 2
DrvSetup.11.1.t = "Driver"
DrvSetup.11.1.v = "psqlodbc.dll"
DrvSetup.11.2.t = "Setup"
DrvSetup.11.2.v =  psqlodbs.dll

/*BTRIEVE*/
DrvSetup.12.0 = 9
DrvSetup.12.1.t = "APILevel"
DrvSetup.12.1.v = 1
DrvSetup.12.2.t = "ConnectFunctions"
DrvSetup.12.2.v = "YYY"
DrvSetup.12.3.t = "Driver"
DrvSetup.12.3.v = ""
DrvSetup.12.4.t = "DriverODBCVer"
DrvSetup.12.4.v = "03.01"
DrvSetup.12.5.t = "FileExtns"
DrvSetup.12.5.v = "*.dta"
DrvSetup.12.6.t = "FileUsage"
DrvSetup.12.6.v = 1
DrvSetup.12.7.t = "Setup"
DrvSetup.12.7.v = ""
DrvSetup.12.8.t = "SQLLevel"
DrvSetup.12.8.v = 1
DrvSetup.12.9.t = "UsageCount"
DrvSetup.12.9.v = 0

/*DB2*/
DrvSetup.13.0 = 8
DrvSetup.13.1.t = "APILevel"
DrvSetup.13.1.v = 1
DrvSetup.13.2.t = "ConnectFunctions"
DrvSetup.13.2.v = "YYY"
DrvSetup.13.3.t = "Driver"
DrvSetup.13.3.v = ""
DrvSetup.13.4.t = "DriverODBCVer"
DrvSetup.13.4.v = "03.01"
DrvSetup.13.5.t = "FileUsage"
DrvSetup.13.5.v = 0
DrvSetup.13.6.t = "Setup"
DrvSetup.13.6.v = ""
DrvSetup.13.7.t = "SQLLevel"
DrvSetup.13.7.v = 1
DrvSetup.13.8.t = "UsageCount"
DrvSetup.13.8.v = 0

/*dBase*/
DrvSetup.14.0 = 9
DrvSetup.14.1.t = "APILevel"
DrvSetup.14.1.v = 1
DrvSetup.14.2.t = "ConnectFunctions"
DrvSetup.14.2.v = "YYY"
DrvSetup.14.3.t = "Driver"
DrvSetup.14.3.v = ""
DrvSetup.14.4.t = "DriverODBCVer"
DrvSetup.14.4.v = "03.01"
DrvSetup.14.5.t = "FileExtns"
DrvSetup.14.5.v = "*.dbf"
DrvSetup.14.6.t = "FileUsage"
DrvSetup.14.6.v = 1
DrvSetup.14.7.t = "Setup"
DrvSetup.14.7.v = ""
DrvSetup.14.8.t = "SQLLevel"
DrvSetup.14.8.v = 1
DrvSetup.14.9.t = "UsageCount"
DrvSetup.14.9.v = 0

/*INFORMIX5*/
DrvSetup.15.0 = 8
DrvSetup.15.1.t = "APILevel"
DrvSetup.15.1.v = 1
DrvSetup.15.2.t = "ConnectFunctions"
DrvSetup.15.2.v = "YYY"
DrvSetup.15.3.t = "Driver"
DrvSetup.15.3.v = ""
DrvSetup.15.4.t = "DriverODBCVer"
DrvSetup.15.4.v = "03.01"
DrvSetup.15.5.t = "FileUsage"
DrvSetup.15.5.v = 0
DrvSetup.15.6.t = "Setup"
DrvSetup.15.6.v = ""
DrvSetup.15.7.t = "SQLLevel"
DrvSetup.15.7.v = 1
DrvSetup.15.8.t = "UsageCount"
DrvSetup.15.8.v = 0

/*ORACLE7*/
DrvSetup.16.0 = 8
DrvSetup.16.1.t = "APILevel"
DrvSetup.16.1.v = 1
DrvSetup.16.2.t = "ConnectFunctions"
DrvSetup.16.2.v = "YYY"
DrvSetup.16.3.t = "Driver"
DrvSetup.16.3.v = ""
DrvSetup.16.4.t = "DriverODBCVer"
DrvSetup.16.4.v = "03.01"
DrvSetup.16.5.t = "FileUsage"
DrvSetup.16.5.v = 0
DrvSetup.16.6.t = "Setup"
DrvSetup.16.6.v = ""
DrvSetup.16.7.t = "SQLLevel"
DrvSetup.16.7.v = 1
DrvSetup.16.8.t = "UsageCount"
DrvSetup.16.8.v = 0

/*SYBASESQLSERVER*/
DrvSetup.17.0 = 8
DrvSetup.17.1.t = "APILevel"
DrvSetup.17.1.v = 1
DrvSetup.17.2.t = "ConnectFunctions"
DrvSetup.17.2.v = "YYY"
DrvSetup.17.3.t = "Driver"
DrvSetup.17.3.v = ""
DrvSetup.17.4.t = "DriverODBCVer"
DrvSetup.17.4.v = "03.01"
DrvSetup.17.5.t = "FileUsage"
DrvSetup.17.5.v = 0
DrvSetup.17.6.t = "Setup"
DrvSetup.17.6.v = ""
DrvSetup.17.7.t = "SQLLevel"
DrvSetup.17.7.v = 1
DrvSetup.17.8.t = "UsageCount"
DrvSetup.17.8.v = 0



/*TEXTe*/
DrvSetup.18.0 = 9
DrvSetup.18.1.t = "APILevel"
DrvSetup.18.1.v = 1
DrvSetup.18.2.t = "ConnectFunctions"
DrvSetup.18.2.v = "YYY"
DrvSetup.18.3.t = "Driver"
DrvSetup.18.3.v = ""
DrvSetup.18.4.t = "DriverODBCVer"
DrvSetup.18.4.v = "03.01"
DrvSetup.18.5.t = "FileExtns"
DrvSetup.18.5.v = "*.*"
DrvSetup.18.6.t = "FileUsage"
DrvSetup.18.6.v = 1
DrvSetup.18.7.t = "Setup"
DrvSetup.18.7.v = ""
DrvSetup.18.8.t = "SQLLevel"
DrvSetup.18.8.v = 1
DrvSetup.18.9.t = "UsageCount"
DrvSetup.18.9.v = 0


/*Watcom SQL 4*/
DrvSetup.19.0 = 2
DrvSetup.19.1.t = "Driver"
DrvSetup.19.1.v = "WOD402.DLL"
DrvSetup.19.2.t = "Setup"
DrvSetup.19.2.v = "WOD402.DLL"




/*INFORMIX5*/
DrvSetup.20.0 = 6
DrvSetup.20.1.t = "APILevel"
DrvSetup.20.1.v = 1
DrvSetup.20.2.t = "ConnectFunctions"
DrvSetup.20.2.v = "YYY"
DrvSetup.20.3.t = "DriverODBCVer"
DrvSetup.20.3.v = "02.10"
DrvSetup.20.4.t = "FileUsage"
DrvSetup.20.4.v = 0
DrvSetup.20.5.t = "SQLLevel"
DrvSetup.20.5.v = 1
DrvSetup.20.6.t = "Driver"
DrvSetup.20.6.v = ""


/*MDI*/
DrvSetup.21.0 = 6
DrvSetup.21.1.t = "APILevel"
DrvSetup.21.1.v = 1
DrvSetup.21.2.t = "ConnectFunctions"
DrvSetup.21.2.v = "YYY"
DrvSetup.21.3.t = "DriverODBCVer"
DrvSetup.21.3.v = "02.10"
DrvSetup.21.4.t = "FileUsage"
DrvSetup.21.4.v = 0
DrvSetup.21.5.t = "SQLLevel"
DrvSetup.21.5.v = 1
DrvSetup.21.6.t = "Driver"
DrvSetup.21.6.v = ""


/*INGRES6404*/
DrvSetup.22.0 = 6
DrvSetup.22.1.t = "APILevel"
DrvSetup.22.1.v = 1
DrvSetup.22.2.t = "ConnectFunctions"
DrvSetup.22.2.v = "YYY"
DrvSetup.22.3.t = "DriverODBCVer"
DrvSetup.22.3.v = "02.10"
DrvSetup.22.4.t = "FileUsage"
DrvSetup.22.4.v = 0
DrvSetup.22.5.t = "SQLLevel"
DrvSetup.22.5.v = 1
DrvSetup.22.6.t = "Driver"
DrvSetup.22.6.v = ""

/*DB2*/
DrvSetup.23.0 = 6
DrvSetup.23.1.t = "APILevel"
DrvSetup.23.1.v = 1
DrvSetup.23.2.t = "ConnectFunctions"
DrvSetup.23.2.v = "YYN"
DrvSetup.23.3.t = "DriverODBCVer"
DrvSetup.23.3.v = "02.10"
DrvSetup.23.4.t = "FileUsage"
DrvSetup.23.4.v = 0
DrvSetup.23.5.t = "SQLLevel"
DrvSetup.23.5.v = 1
DrvSetup.23.6.t = "Driver"
DrvSetup.23.6.v = ""



/*Gupta SQLBASE*/
DrvSetup.24.0 = 6
DrvSetup.24.1.t = "APILevel"
DrvSetup.24.1.v = 1
DrvSetup.24.2.t = "ConnectFunctions"
DrvSetup.24.2.v = "YYY"
DrvSetup.24.3.t = "DriverODBCVer"
DrvSetup.24.3.v = "02.10"
DrvSetup.24.4.t = "FileUsage"
DrvSetup.24.4.v = 0
DrvSetup.24.5.t = "SQLLevel"
DrvSetup.24.5.v = 1
DrvSetup.24.6.t = "Driver"
DrvSetup.24.6.v = ""


/*Watcom SQL 4.2*/
DrvSetup.25.0 = 2
DrvSetup.25.1.t = "Driver"
DrvSetup.25.1.v = "WOD40220.DLL"
DrvSetup.25.2.t = "Setup"
DrvSetup.25.2.v = "WOD40220.DLL"


/*Postgres SQL 7.2*/
DrvSetup.26.0 = 2
DrvSetup.26.1.t = "Driver"
DrvSetup.26.1.v = "psqlodbc.dll"
DrvSetup.26.2.t = "Setup"
DrvSetup.26.2.v =  psqlodbc.dll


/*IBM DB2 ODBC Driver */
DrvSetup.27.0 = 2
DrvSetup.27.1.t = "Driver"
DrvSetup.27.1.v = "DB2CLI.DLL"
DrvSetup.27.2.t = "Setup"
DrvSetup.27.2.v = "DB2ODBC.DLL"


return DrvSetup.0