#include <stdlib.h>
#include <ctype.h>
#include <stdio.h>
#include <string.h>
#include <time.h>
#include "mrl.h"

/* Lokalni prototypy */
void GKludgeVal(FILE *f,char *buf);

void toLH(unsigned char *tmp, const unsigned int newp)
{
 *(tmp+1)=newp/256;
 *tmp=newp-(newp/256)*256;
}

void toINT(const unsigned char *tmp,unsigned int *n)
{
 *n=*tmp;
 *n+=256*((unsigned int)*(tmp+1));
}

void 
CreName (char *outbuf, const char *dir, unsigned int number)
{
  char buf[12];
  if (dir)
    {
      strcpy (outbuf, dir);
      strcat (outbuf, "\\");
    }
  sprintf (buf, "%u", number);
  strcat (outbuf, buf);
  strcat (outbuf, ".MSG");
}

void 
UpdateLRP(unsigned int newp, const char *filename)
{
 FILE *f;
 char tmp[2];
 f=fopen(filename,"wb");
 if(f==NULL)
   {
     perror("Lastread update failed");
     WriteLog(logname,"Lastread update failed",'!');
     return;
   }
 toLH(tmp,newp);
 fwrite(tmp,2,1,f);
 fclose(f);
}

int GetMID(const char *name,char *msgid, char *replyto)
{
 FILE *f;
 char buf[7];
 char *buf2;
 int x=-1;
 if(!(buf2=malloc(280))) return -1;
 memset(buf,0,7);
 strcpy(msgid,"");
 strcpy(replyto,"");
 if(!(f=fopen(name,"rb"))) return -1;
 if((fseek(f,190,SEEK_SET))) {
				fclose(f);
                                free(buf2);
				return -1;
			     }
 while(1)
 {
 fread(buf,1,1,f); /* Scan for ^A */
 if (*buf!='\x01') { fclose(f); free(buf2);return x;}
 if(!fread(buf,6,1,f)) { fclose(f); free(buf2);return x;}
 if(!strcmp(buf,"MSGID:"))
  { 
   GKludgeVal(f,buf2);
   strcpy(msgid,buf2);
   x=0;
   continue;
  }
 if(!strcmp(buf,"REPLY:"))
  { 
   GKludgeVal(f,buf2);
   strcpy(replyto,buf2);
   x=0;
   continue;
  }
 GKludgeVal(f,buf2);
 }/* while */
}

void GKludgeVal(FILE *f,char *buf)
{
 int ch,pos;
 ch=0;
 pos=0;
 while((ch!=EOF)&&(ch!='\x0d'))
 {
  ch=tolower(fgetc(f));
  *(buf+pos)=ch;
  if (ch!=' ')  pos++;  /* skip space */
 }
 *(buf+pos-1)='\x0'; /* set End of String */
}

int SetLinks(const char *fname,unsigned int prev, unsigned int next)
{
 unsigned char buf[2];
 FILE *f;
 if(!(f=fopen(fname,"r+b"))) return -1;
 if(fseek(f,184,SEEK_SET)) { fclose(f);return -1;}
 toLH(buf,prev);
 fwrite(buf,2,1,f);
 if(fseek(f,188,SEEK_SET)) { fclose(f);return -1;}
 toLH(buf,next);
 fwrite(buf,2,1,f);
 fclose(f);
 return 0;
};

int GetLinks(const char *fname,unsigned int *prev, unsigned int *next)
{
 unsigned char buf[2];
 FILE *f;
 if(!(f=fopen(fname,"rb"))) return -1;
 if(fseek(f,184,SEEK_SET)) { fclose(f);return -1;}
 fread(buf,2,1,f);
 toINT(buf,prev);
 if(fseek(f,188,SEEK_SET)) { fclose(f);return -1;}
 fread(buf,2,1,f);
 toINT(buf,next);
 fclose(f);
 return 0;
};

int WriteLog(const char *fname,const char *what,const char stat)
{
 FILE *f;
 char *cas;
 char dayno[3];
 char month[4];
 char cas2[9];
 char junk[4];
 time_t sec=time(NULL);
/* kontrola loglevelu 
level. co loguje+vsechny znaky predchozi ci nezname
5          -
4          *
3          :
2          #
1          +
0          ! kriticke chyby
*/

 if (loglevel==-1) return 0; /* zadny log nevedeme panove a damy */
 if ( (stat==' ') && (loglevel<6) ) return 0; /* rozsireni BT oproti Squish */
 if ( (stat=='-') && (loglevel<5) ) return 0;
 if ( (stat=='*') && (loglevel<4) ) return 0;
 if ( (stat==':') && (loglevel<3) ) return 0;
 if ( (stat=='#') && (loglevel<2) ) return 0;
 if ( (stat=='+') && (loglevel<1) ) return 0;

 cas=ctime(&sec);
 if(fname==NULL) return 0;
 if(!(f=fopen(fname,"a+t"))) return -1;
 sscanf(cas,"%s %s %s %s",junk,month,dayno,cas2);
 if(what) fprintf(f,"%c %s %s %s "APP_NAME" %s\n",stat,dayno,month,cas2,what);
          else
          fprintf(f,"\n"); /* What=NULL jen odradkuji */

 fclose(f);
 return 0;
}
 