/*--------------------------------------------------------------------------*/
/*                                                                          */
/*                                                                          */
/*      ------------         Bit-Bucket Software, Co.                       */
/*      \ 10001101 /         Writers and Distributors of                    */
/*       \ 011110 /          Freely Available<tm> Software.                 */
/*        \ 1011 /                                                          */
/*         ------                                                           */
/*                                                                          */
/*              (C) Copyright 1987-96, Bit Bucket Software Co.              */
/*                                                                          */
/*                                                                          */
/*                                                                          */
/*                     Squish scan for unread mail                          */
/*                                                                          */
/*                                                                          */
/*    For complete  details  of the licensing restrictions, please refer    */
/*    to the License  agreement,  which  is published in its entirety in    */
/*    the MAKEFILE and BT.C, and also contained in the file LICENSE.260.    */
/*                                                                          */
/*    USE  OF THIS FILE IS SUBJECT TO THE  RESTRICTIONS CONTAINED IN THE    */
/*    BINKLEYTERM  LICENSING  AGREEMENT.  IF YOU DO NOT FIND THE TEXT OF    */
/*    THIS  AGREEMENT IN ANY OF THE  AFOREMENTIONED FILES,  OR IF YOU DO    */
/*    NOT HAVE THESE FILES,  YOU  SHOULD  IMMEDIATELY CONTACT BIT BUCKET    */
/*    SOFTWARE CO.  AT ONE OF THE  ADDRESSES  LISTED BELOW.  IN NO EVENT    */
/*    SHOULD YOU  PROCEED TO USE THIS FILE  WITHOUT HAVING  ACCEPTED THE    */
/*    TERMS  OF  THE  BINKLEYTERM  LICENSING  AGREEMENT,  OR  SUCH OTHER    */
/*    AGREEMENT AS YOU ARE ABLE TO REACH WITH BIT BUCKET SOFTWARE, CO.      */
/*                                                                          */
/*                                                                          */
/* You can contact Bit Bucket Software Co. at any one of the following      */
/* addresses:                                                               */
/*                                                                          */
/* Bit Bucket Software Co.        FidoNet  1:104/501, 1:343/491             */
/* P.O. Box 460398                AlterNet 7:42/1491                        */
/* Aurora, CO 80046               BBS-Net  86:2030/1                        */
/*                                Internet f491.n343.z1.fidonet.org         */
/*                                                                          */
/* Please feel free to contact us at any time to share your comments about  */
/* our software and/or licensing policies.                                  */
/*                                                                          */
/*--------------------------------------------------------------------------*/

/* Include this file before any other includes or defines! */

#include "includes.h"

#include "squish.h"

#define OPEN_FLAGS          O_RDWR | O_BINARY
#define SHARE_FLAGS         SH_DENYNO
#define PERMISSION_FLAGS    S_IREAD | S_IWRITE
#define MSG_RDLEN           sizeof(XMSG) + sqbase.sz_sqhdr

typedef struct
{
	SQHDR sqhdr;
	XMSG xmsg;
} SQMSG;

static int SquishOpen (char *, PSQBASE);

int 
SquishScan (char *pszName)
{
	int fh;
	int unread;
	FOFS fofs;
	SQBASE sqbase;
	SQMSG sqmsg;
	char szSqd[256];

	strcpy (szSqd, pszName);
	strcat (szSqd, ".SQD");

	if ((fh = SquishOpen (szSqd, &sqbase)) < 0)
	{
		status_line (MSG_TXT (M_SQUISH_OPENERR), szSqd);
		return 0;
	}

	fofs = sqbase.begin_frame;
	unread = 0;

	while (fofs)
	{
		if ((lseek (fh, fofs, SEEK_SET)) != (long)fofs)
		{
			close (fh);
			status_line (MSG_TXT (M_SQUISH_SEEKERR), szSqd);
			return 0;
		}

		if ((read (fh, &sqmsg, MSG_RDLEN)) < (int)MSG_RDLEN)
		{
			close (fh);
			status_line (MSG_TXT (M_SQUISH_READERR), szSqd);
			return 0;
		}

		if (sqmsg.sqhdr.id != (dword) SQHDRID)
		{
			close (fh);
			status_line (MSG_TXT (M_SQUISH_TRASHED_HDR), szSqd);
			return 0;
		}

		if (sqmsg.sqhdr.frame_type == FRAME_NORMAL)
		{
			if (!(sqmsg.xmsg.attr & MSGREAD))
			{
				unread++;
			}

			fofs = sqmsg.sqhdr.next_frame;
		}
	}

	close (fh);
	return unread;
}

static int 
SquishOpen (char *pszName, PSQBASE psqbase)
{
	int fh;

	if ((fh = sopen (pszName,
				OPEN_FLAGS,
				SHARE_FLAGS,
				PERMISSION_FLAGS)) != -1)
	{
		if ((read (fh, psqbase, sizeof (SQBASE))) < sizeof (SQBASE))
		{
			close (fh);
			fh = -1;
		}
	}

	return fh;
}
