/*--------------------------------------------------------------------------*/
/*                                                                          */
/*                                                                          */
/*      ------------         Bit-Bucket Software, Co.                       */
/*      \ 10001101 /         Writers and Distributors of                    */
/*       \ 011110 /          Freely Available<tm> Software.                 */
/*        \ 1011 /                                                          */
/*         ------                                                           */
/*                                                                          */
/*              (C) Copyright 1987-96, Bit Bucket Software Co.              */
/*                                                                          */
/*                                                                          */
/*                                                                          */
/*                BinkleyTerm WaZOO/EMSI Sendmail Processor                 */
/*                                                                          */
/*                                                                          */
/*    For complete  details  of the licensing restrictions, please refer    */
/*    to the License  agreement,  which  is published in its entirety in    */
/*    the MAKEFILE and BT.C, and also contained in the file LICENSE.260.    */
/*                                                                          */
/*    USE  OF THIS FILE IS SUBJECT TO THE  RESTRICTIONS CONTAINED IN THE    */
/*    BINKLEYTERM  LICENSING  AGREEMENT.  IF YOU DO NOT FIND THE TEXT OF    */
/*    THIS  AGREEMENT IN ANY OF THE  AFOREMENTIONED FILES,  OR IF YOU DO    */
/*    NOT HAVE THESE FILES,  YOU  SHOULD  IMMEDIATELY CONTACT BIT BUCKET    */
/*    SOFTWARE CO.  AT ONE OF THE  ADDRESSES  LISTED BELOW.  IN NO EVENT    */
/*    SHOULD YOU  PROCEED TO USE THIS FILE  WITHOUT HAVING  ACCEPTED THE    */
/*    TERMS  OF  THE  BINKLEYTERM  LICENSING  AGREEMENT,  OR  SUCH OTHER    */
/*    AGREEMENT AS YOU ARE ABLE TO REACH WITH BIT BUCKET SOFTWARE, CO.      */
/*                                                                          */
/*                                                                          */
/* You can contact Bit Bucket Software Co. at any one of the following      */
/* addresses:                                                               */
/*                                                                          */
/* Bit Bucket Software Co.        FidoNet  1:104/501, 1:343/491             */
/* P.O. Box 460398                AlterNet 7:42/1491                        */
/* Aurora, CO 80046               BBS-Net  86:2030/1                        */
/*                                Internet f491.n343.z1.fidonet.org         */
/*                                                                          */
/* Please feel free to contact us at any time to share your comments about  */
/* our software and/or licensing policies.                                  */
/*                                                                          */
/*--------------------------------------------------------------------------*/

/* Include this file before any other includes or defines! */

#include "includes.h"

#ifdef HAVE_HYDRA
#include "hydra.h"
#endif

extern int WaZOO_callback (char *);
extern int WaZOO_time (long);

/*--------------------------------------------------------------------------*/
/* WaZOO/EMSI                                                               */
/*--------------------------------------------------------------------------*/
void 
WaZOO (int originator)
{
	int iFstat;
	int i = 0, akas = 0;
	char j[200];
	char k[100];
	ADDR saved_addr;

	/*--------------------------------------------------------------------*/
	/* Initialize WaZOO/EMSI                                              */
	/*--------------------------------------------------------------------*/

	iFstat = made_request = got_arcmail = got_packet = 0;

	Netmail_Session = 1;

	isOriginator = originator;

	if (originator &&
		((remote_addr.Zone != called_addr.Zone)	||
		(remote_addr.Net != called_addr.Net)	||
		(remote_addr.Node != called_addr.Node)	||
		(remote_addr.Point != called_addr.Point)))
	{
		(void) sprintf (k, "%s", Full_Addr_Str (&remote_addr));
		(void) sprintf (j, MSG_TXT (M_CALLED), Full_Addr_Str (&called_addr), k);
		status_line (j);
	}
	else if (!originator)
		called_addr = remote_addr;

	/* If we are using an external mail agent, call it now. */

	if (remote_pickup == -2)
	{
		num_rakas = akas = 1;
		status_line (">External Mail Session");
		remote_akas[0] = called_addr;
		(void) send_WaZOO ();
		goto end_WaZOO;
	}

	/* We need to have DCD here. */

	if (!CARRIER)
		return;

	saved_addr = called_addr;
	switch (remote_pickup)
	{
	case -1:					/* WaZOO Session */
		akas = 1;
		status_line (">WaZOO Session");
		remote_akas[0] = called_addr;
		break;

	case 1:
		status_line (">EMSI, no pickup-all");
		if (num_rakas >= 1)
		{
			akas = 1;
			remote_akas[0] = called_addr;
		}
		break;

	case 2:
		status_line (">EMSI, pickup-all");
		akas = num_rakas;
		break;

	default:
		akas = 0;
		break;
	}

	/* Flag all AKA's received */

	for (i = 0; i < akas; i++)
	{
		status_line (">Setting flag_file for %s", Full_Addr_Str (&remote_akas[i]));
		if (flag_file (TEST_AND_SET, &remote_akas[i], 1))
		{
			int n;

			status_line (">Failed to set flag_file for %s", Full_Addr_Str (&remote_akas[i]));

			/* Couldn't flag it, shift everything down one */

			akas--;
			for (n = i + 1; n <= akas; n++)
				remote_akas[n - 1] = remote_akas[n];

			/* Do this loop again since we just replaced this remote_aka */
			i--;

		}
	}

	if (akas <= 0)
		goto end_WaZOO;

	num_rakas = akas;

	/* Let's look into the BiDi protocols first */

	if (janus_baud >= cur_baud.rate_value || janus_OK)
	{

#ifdef HAVE_HYDRA

		/* Because Hydra is chosen first by other mailers, we have
		   to do the same. But if we are the called system, we told
           the other guy we couldn't do it. */

		if (!originator && (remote_capabilities & DOES_IANUS) && !no_janus)
			remote_capabilities &= ~DOES_HYDRA;

		if (((unsigned) remote_capabilities & DOES_HYDRA) && !no_hydra)
		{
			status_line ("%s Hydra", MSG_TXT (M_WAZOO_METHOD));
			remote_capabilities &= ~(ZED_ZIPPER | ZED_ZAPPER | DOES_IANUS);
			saved_addr = called_addr;
			hydra_init (hydra_options);
			(void) send_WaZOO();
			hydra_deinit();
			called_addr = saved_addr;
			goto end_WaZOO;
		}
#endif /* HAVE_HYDRA */

		/* Now let's try Janus */

		if (((unsigned) remote_capabilities & DOES_IANUS) && !no_janus)
		{
			status_line ("%s Janus", MSG_TXT (M_WAZOO_METHOD));
			Janus ();
			goto end_WaZOO;
		}
	}

	/* See if we can both do ZEDZAP */
	if ((remote_capabilities & ZED_ZAPPER) && (!no_zapzed))
	{
		status_line ("%s ZedZap", MSG_TXT (M_WAZOO_METHOD));
		remote_capabilities &= ~(ZED_ZIPPER | DOES_HYDRA | DOES_IANUS);
	}
	else if ((remote_capabilities & ZED_ZIPPER) && (!no_zapzed))
	{
		status_line ("%s ZedZip", MSG_TXT (M_WAZOO_METHOD));
		remote_capabilities &= ~(ZED_ZAPPER | DOES_HYDRA | DOES_IANUS);
	}
	else
	{
		if (remote_pickup == -1)
		{
			status_line ("%s DietIFNA", MSG_TXT (M_WAZOO_METHOD));
			if (originator)
			{
				FTSC_sender (1);
			}
			else
			{
				(void) FTSC_receiver (1);
			}
		}
		goto end_WaZOO;
	}

	/*--------------------------------------------------------------------*/
	/* ORIGINATOR: send/receive/send                                      */
	/*--------------------------------------------------------------------*/
	if (originator)
	{
		(void) send_WaZOO ();
		if (!CARRIER || no_pickup)
			goto end_WaZOO;
		if (!get_Zmodem (CURRENT.sc_Inbound, NULL))
			goto end_WaZOO;

		if (!CARRIER)
			goto end_WaZOO;
		iFstat = respond_to_file_requests (0, WaZOO_callback, WaZOO_time);
		if (iFstat)
			(void) Send_Zmodem (NULL, NULL, ((iFstat) ? END_BATCH : NOTHING_TO_DO), DO_WAZOO);
		mail_finished = 1;
	}

	/*--------------------------------------------------------------------*/
	/* CALLED SYSTEM: receive/send/receive                                */
	/*--------------------------------------------------------------------*/
	else
	{
		if (!get_Zmodem (CURRENT.sc_Inbound, NULL))
			goto end_WaZOO;
		if (!CARRIER)
			goto end_WaZOO;
		if (remote_pickup != 0)
			(void) send_WaZOO ();
		if (!CARRIER || !made_request)
			goto end_WaZOO;
		(void) get_Zmodem (CURRENT.sc_Inbound, NULL);
	}

end_WaZOO:
	called_addr = saved_addr;
	for (i = 0; i < akas; i++)
		flag_file (CLEAR_FLAG, &remote_akas[i], 1);
	status_line (MSG_TXT (M_WAZOO_END));

}								/* WaZOO */

/*--------------------------------------------------------------------------*/
/* RESPOND TO FILE REQUEST                                                  */
/*--------------------------------------------------------------------------*/
int 
respond_to_file_requests (int f_sent,
	int (*callback) (char *), int (*calltime) (long))
{
	char req[80];
	struct stat buf;
	int nfiles = 0;
	FILE *fp;
	int np;
	char *s;
	int fsent;
	ADDR foo;

	fsent = f_sent;				/* copy into local var  */
	/* this is for callback */
	if (!(matrix_mask & TAKE_REQ))
		goto done;

	for (np = 0; np <= ALIAS_CNT; np++)
	{
		foo = alias[np];

		if (foo.Net == 0)
			break;

		/* For a point, massage the address to get the right .REQ filename */

		if (foo.Point != 0)
		{
			foo.Node = foo.Point;
			foo.Point = 0;
			foo.Net = (pvtnet > 0) ? (unsigned int) pvtnet : 0;
		}

		(void) sprintf (req, request_template, CURRENT.sc_Inbound, Hex_Addr_Str (&foo), TaskNumber);

		if (!stat (req, &buf))
		{
			if ((fp = fopen (req, read_ascii)) == NULL)
			{
				(void) got_error (MSG_TXT (M_OPEN_MSG), req);
				goto done;
			}

			while (!feof (fp))
			{
				req[0] = 0;
				if (fgets (req, 79, fp) == NULL)
					break;

				/* ; as the first char is a comment */
				if (req[0] == ';')
					continue;

				/* Get rid of the newline at the end */
				s = (char *) (req + strlen (req) - 1);
				while ((s >= req) && isspace (*s))
					*s-- = '\0';

				if (req[0] == '\0')
					continue;

				if ((nfiles = n_frproc (req, nfiles, callback, calltime)) < 0)
					break;
			}

			(void) fclose (fp);

			(void) sprintf (req, request_template, CURRENT.sc_Inbound, Hex_Addr_Str (&foo), TaskNumber);
			(void) unlink (req);
			/* once we have satisfied a request, we can get out of here */
			break;
		}
	}

done:
	return fsent;
}
