/******************************************************************/
/* Name         :Install.cmd                                      */
/* Sprache      :REXX OS/2                                        */
/* Autor        :Thorsten Ahlers                                  */
/* Datum        :14.07.2000                                       */
/* Funktion     :Installationsprozedur fr TS Uhr                 */
/******************************************************************/

/* Funktionen laden                                      */
call RxFuncAdd "SysLoadFuncs", "RexxUtil", "SysLoadFuncs"
call SysLoadFuncs


/* Abfrage Instalation JA/NEIN */
say 'Zur Installation mu sich das Installationsprogramm'
say 'Mit den Programmdateien in dem Verzeichniss befinden'
say 'von dem es spter gestartet werden soll'
say 'Zum starten der Instalation Antworten Sie mit "JA"'
parse upper pull Antwort
if Antwort \= 'JA' then EXIT

/* Read me - Datei anzeigen */
'@e.exe Read.me'
say ''
say 'Wenn Sie mit den Bedingungen Einverstanden sind'
say 'Antworten Sie mit "JA"'
parse upper pull Antwort
if Antwort \= 'JA' then EXIT

/* Installationsverzeichnis ermitteln */
InstPfad = Directory()

/* Programmobjekte auf der Arbeitsoberflche */
If SysCreateObject('WPFOLDER', 'TS - Uhr',,
                   '<WP_DESKTOP>',,
                   'OBJECTID=<TSUhr-Ordner>',,
                   'U') = 0 then do
  say 'Programmordner konnte nicht erstellt werden'
  say 'Bitte besttigen Sie mit [Return]'
  pull Dummy
  EXIT
end /* do */

If SysCreateObject('WPProgram', 'TS - Uhr',,
                   '<TSUhr-Ordner>',,
                   'OBJECTID=<TSUhr-Prog>;' ||,
                   'EXENAME=' || InstPfad || '\TS_Uhr.exe;',,
                   'U') = 0 then do
  say 'Programm konnte nicht erstellt werden'
  say 'Bitte besttigen Sie mit [Return]'
  pull Dummy
end /* do */

/* Programmopjekt in Startupordner JA/NEIN */
say ''
say 'Wenn die TS Uhr beim Systemstart automatisch gestartet'
say 'werden soll Antworten Sie bitte mit "JA"'
parse upper pull Antwort
if Antwort = 'JA' then do
  If SysCreateShadow('<TSUhr-Prog>','<WP_START>') = 0 then do
    say 'Programmobjekt konnte nicht im Systemstart erstellt werden'
    say 'Bitte besttigen Sie mit [Return]'
    pull Dummy
  end /* do */
end /* do */

If SysCreateObject('WPProgram', 'Read.me',,
                   '<TSUhr-Ordner>',,
                   'OBJECTID=<TSUhr-Readme>;' ||,
                   'EXENAME=e.exe;' ||,
                   'PARAMETERS=' || InstPfad || '\Read.me;',,
                   'U') = 0 then do
  say 'Programmobjekt konnte nicht erstellt werden'
  say 'Bitte besttigen Sie mit [Return]'
  pull Dummy
end /* do */

return(0)


