/* Install/UnInstall script for World Clock */

PARSE ARG action
IF RxFuncQuery('SysLoadFuncs') THEN DO
    CALL RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
    CALL SysLoadFuncs
END
CALL RxFuncAdd  'FastIniStart','FastIni','FastIniStart'
CALL RxFuncAdd  'FastIniEnd','FastIni','FastIniEnd'

CALL SysCls
action = TRANSLATE(LEFT(action,1))
SELECT
    WHEN action = 'I' THEN CALL InstallMe
    WHEN action = 'U' THEN CALL UnInstallMe
    OTHERWISE CALL WhatAction
END
Exit

/* End of Install.cmd */

/* WhatAction - no action selected */

WhatAction:     PROCEDURE

CALL SysCls
SAY ' '
SAY 'Please enter installation parameter (I=Install, U=UnInstall, other=Exit):'
ans = TRANSLATE(SysGetKey('ECHO'))
SELECT
    WHEN ans = 'I' THEN CALL InstallMe
    WHEN ans = 'U' THEN CALL UnInstallMe
    OTHERWISE CALL NoAction 'Installation failed.'
END
RETURN

/* End of WhatAction */

/* NoAction - abort Install */

NoAction:   PROCEDURE

PARSE ARG noinstmsg
SAY ' '
SAY noinstmsg
SAY 'Press any key to exit ...'
ans = SysGetKey('NOECHO')
Exit

/* End of NoAction */

/* InstallMe - install World Clock */

InstallMe:  PROCEDURE

progname = 'World Clock'
required = 'WClock.exe ASTRO.DAT CITIES.DAT HOLIDAYS.DAT TIMEZONE.DAT WClock.dll ENGLISH.INI'
IF RIGHT(Directory(),2) = ':\' THEN DO
    SAY 'Problem! '||progname||' can not be installed in root directory.'
    SAY 'Create directory for '||progname||', copy files there and start this procedure again.'
    SAY 'Press any key to exit ...'
    ans = SysGetKey('NOECHO')
    Exit
END

CALL SysCls
SAY 'Welcome to '||progname||' Installation procedure!'
SAY 'Your files are in directory: '||Directory()
SAY 'This procedure will create Folder and Program objects for '||progname||','
SAY 'Press "Y" to start Installation, any other key to exit...'
ans = TRANSLATE(SysGetKey('ECHO'))
SELECT
    WHEN ans = 'Y' THEN NOP
    OTHERWISE CALL NoAction 'Installation aborted.'
END

SAY ' '
SAY 'Checking files:'
DO i = 1 TO WORDS(required)
    SAY '- '||WORD(required,i)
    IF STREAM(WORD(required,i),'C','QUERY EXISTS') = '' THEN DO
        CALL NoAction WORD(required,i)||' - Missing file. Installation failed!'
    END
END

SAY ' '
inifile = 'WCLOCK.INI'
inikey.1 = 'Banner'
inival.1 = '1 1 20 9'
inikey.2 = 'Bubble'
inival.2 = '300 3 9.WarpSans#255 255 132'
inikey.3 = 'Calendar'
inival.3 = '1 1_default'
inikey.4 = 'Clock'
inival.4 = '1 5 2 1 200 50 1 1 1 0 0'
inikey.5 = 'Color'
inival.5 = '#0'
inikey.6 = 'Confirm'
inival.6 = '1 1'
inikey.7 = 'CurrLang'
inival.7 = 'ENGLISH'
inikey.8 = 'Date'
inival.8 = '1 1 1 1 0 1 1'
inikey.9 = 'Directory'
inival.9 = Directory()
inikey.10 = 'Font'
inival.10 = '9.WarpSans'
inikey.11 = 'Free'
inival.11 = '0 0 0 0'
inikey.12 = 'Messages'
inival.12 = '1 1 1 1'
inikey.13 = 'Style'
inival.13 = 'W'
inikey.14 = 'Time'
inival.14 = '1 1 0 1 1'
inikey.15 = 'TimeSound'
inival.15 = '1 1 1 1 1 1'
inikey.16 = 'Timer'
inival.16 = '995 5 10'
inikey.17 = 'Universal'
inival.17 = '0 1 0 0 0 0 0 0'
inikey.18 = 'WorldTime'
inival.18 = '1 World0.met'
inikey.0 = 18

iniRc = FastIniStart(inifile,'IniHandle')
SAY 'Writing values to '||inifile
SAY ' '

SELECT
    WHEN STREAM(inifile,'C','QUERY EXISTS') = '' THEN DO
        SAY inifile||' does not exist in current directory. Writing default settings'
        DO i = 1 TO inikey.0
            CALL SysIni inifile, 'Settings', inikey.i, inival.i
        END
    END
    OTHERWISE DO
        SAY '- Settings'
        oldval = SysIni(inifile, 'Settings', inikey.4)     /* Clock */
        IF WORDS(oldval) = 10 THEN DO
            CALL SysIni inifile, 'Settings', inikey.4, SUBWORD(oldval,1,6)||' 1 '||SUBWORD(oldval,7)
        END
        IF WORDS(oldval) = 9 THEN DO
            CALL SysIni inifile, 'Settings', inikey.4, SUBWORD(oldval,1,3)||' '||WORD(oldval,2)*WORD(oldval,3)||' '||SUBWORD(oldval,4,5)||' 1 '||SUBWORD(oldval,6)
        END
        oldval = SysIni(inifile, 'Settings', inikey.3)         /* Calendar */
        IF WORDS(oldval) > 3 THEN DO
            CALL SysIni inifile, 'Settings', inikey.3, DELWORD(oldval,2,2)
        END
        oldval = SysIni(inifile, 'Settings', inikey.12)         /* Messages */
        IF WORDS(oldval) = 7 THEN DO
            CALL SysIni inifile, 'Settings', inikey.12, SUBWORD(oldval,4)
        END
        oldval = SysIni(inifile, 'Settings', inikey.14)         /* Time */
        IF WORDS(oldval) = 6 THEN DO
            CALL SysIni inifile, 'Settings', inikey.12, SUBWORD(oldval,1,5)
        END
        oldval = SysIni(inifile, 'Settings', inikey.17)        /* Universal */
        IF WORDS(oldval) = 5 THEN DO
            CALL SysIni inifile, 'Settings', inikey.17, SUBWORD(oldval,1,4)||' 0 0 0 '||SUBWORD(oldval,5)
        END
        DO i = 1 TO inikey.0
            oldval = SysIni(inifile, 'Settings', inikey.i)
            SELECT
                WHEN WORDS(oldval) = WORDS(inival.i) THEN NOP
                OTHERWISE CALL SysIni inifile, 'Settings', inikey.i, inival.i
            END
        END
    END
END

SAY '- Language'
CALL SysIni inifile, 'Language', 'ENGLISH', 'English.inf'

SAY '- Cities'
DO i = 1 TO 30
    IF SysIni(inifile, 'Cities',i) = 'ERROR:' THEN DO
        CALL SysIni inifile, 'Cities', i, 'UTC, <regions>'
    END
END

SAY '- World maps'
inikey.1 =  'World0.met'
inikey.2 =  'World1.met'
inikey.3 =  'World2.met'
inikey.4 =  'World3.met'
inikey.5 =  'World4.met'
inikey.0 =  5
inival.1 = 'Default World map'
inival.2 = 'Political World map'
inival.3 = 'Relief World map'
inival.4 = 'World map made from satellite photos (without clouds)'
inival.5 = 'Night World map with city lights'
inival.0 = 5
DO k = 1 TO inikey.0
    IF SysIni(inifile, 'WorldMap', inikey.k) = 'ERROR:' THEN DO
        CALL SysIni inifile, 'WorldMap', inikey.k, inival.k
    END
END

SAY '- Events'
CALL SysIni inifile, 'Calendar', 'ALL:', 'inikey.'
SELECT
    WHEN SYMBOL('inikey.0') \= 'VAR' THEN NOP
    WHEN inikey.0 = 0 THEN NOP
    OTHERWISE DO
        DO k = 1 TO inikey.0
            oldval = SysIni(inifile,'Calendar',inikey.k)
            PARSE VALUE inikey.k WITH olddate oldtime
            IF DATATYPE(olddate) = 'NUM' & LENGTH(olddate) = 8 THEN DO
                newdate = olddate
            END
            IF POS('-',olddate) = 5 & LASTPOS('-',olddate) = 8 THEN DO
                newdate = SPACE(TRANSLATE(olddate,' ','-'),0)
            END
            CALL SysIni inifile, 'Event', newdate||' '||oldtime, oldval
            CALL SysIni inifile, 'Calendar', inikey.k, 'DELETE:'
        END
    END
END
CALL SysIni inifile, 'CityEvent', 'ALL:', 'inikey.'
SELECT
    WHEN SYMBOL('inikey.0') \= 'VAR' THEN NOP
    WHEN inikey.0 = 0 THEN NOP
    OTHERWISE DO
        DO k = 1 TO inikey.0
            oldval = SysIni(inifile,'CityEvent',inikey.k)
            IF WORDS(inikey.k) = 1 THEN DO
                newkey = inikey.k
                PARSE VALUE oldval WITH oldtime '01'x oldevent
            END
            IF WORDS(inikey.k) = 2 THEN DO
                PARSE VALUE inikey.k WITH newkey oldtime
                oldevent = oldval
            END
            newtime = oldtime
            IF POS(':',oldtime) = 0 THEN DO
                newtime = RIGHT(oldtime%3600,2,'0')||':'||RIGHT((oldtime//3600)%60,2,0)
            END
            CALL SysIni inifile, 'Event', newkey||' '||newtime, oldevent
            CALL SysIni inifile, 'CityEvent', inikey.k, 'DELETE:'
        END
    END
END
inikey.1 = '3'
inikey.2 = '4'
inikey.0 = 2
inival.1 = 'Time is changed from Standard time to Daylight Saving time. Please adjust your clock!'||'01'x||'<WP_CLOCK>'
inival.2 = 'Time is changed from Daylight Saving time to Standard time. Please adjust your clock!'||'01'x||'<WP_CLOCK>'
inival.0 = 2
DO k = 1 TO inikey.0
    IF SysIni(inifile, 'Events', inikey.k) = 'ERROR:' THEN DO
        CALL SysIni inifile, 'Events', inikey.k, inival.k
    END
END

SAY '- Hints'
CALL SysIni inifile, 'CityHint', 'ALL:', 'inikey.'
SELECT
    WHEN SYMBOL('inikey.0') \= 'VAR' THEN NOP
    WHEN inikey.0 = 0 THEN NOP
    OTHERWISE DO
        DO k = 1 TO inikey.0
            IF WORDS(inikey.k) = 1 THEN DO
                oldval = SysIni(inifile,'CityHint',inikey.k)
                newkey = INSERT(' ',inikey.k,LENGTH(inikey.k)-1)
                CALL SysIni inifile, 'CityHint', newkey, oldval
                CALL SysIni inifile, 'CityHint', inikey.k, 'DELETE:'
            END
        END
    END
END
inikey.1 = '1 0'
inikey.2 = '1 1'
inikey.3 = '1 2'
inikey.4 = '1 3'
inikey.0 = 4
inival.1 = '1 This is my city'
inival.2 = '4'
inival.3 = '5'
inival.4 = '3'
inival.0 = 4
DO k = 1 TO inikey.0
    IF SysIni(inifile, 'CityHint', inikey.k) = 'ERROR:' THEN DO
        CALL SysIni inifile, 'CityHint', inikey.k, inival.k
    END
END

iniRc = FastIniEnd('IniHandle')

SAY ' '
InstallDir = Directory()

FoldTitle='World Clock'||'^Version 1.4.0'
Icon1=Directory()||'\Folder1.ico'
Icon2=Directory()||'\Folder2.ico'
Icon='ICONFILE='Icon1||';ICONNFILE=1,'||Icon2
Setup='OBJECTID=<WCLOCK140_FOLDER>;'||Icon||''
Action = 'U'
dummy = SysCreateObject('WPFolder',FoldTitle,'<WP_DESKTOP>',Setup,'U')
SAY FoldTitle||' Folder - '||rc1(dummy)

title.1 = progname
setup.1 = 'OBJECTID=<WCLOCK140_PROG>;EXENAME='InstallDir'\WClock.exe;ICONFILE='InstallDir'\WClock.ico;STARTUPDIR='InstallDir''
title.2 = progname||'^(Personal REXX)'
setup.2 = 'OBJECTID=<WCLOCK140_PREX>;EXENAME='InstallDir'\WClockPR.cmd;ICONFILE='InstallDir'\WClock.ico;STARTUPDIR='InstallDir''
title.3 = 'Read me 1st'||'^(English)'
setup.3 = 'OBJECTID=<WCLOCK140_1STENG>;EXENAME=E.exe;PARAMETERS='InstallDir'\ReadEng.1st;STARTUPDIR='InstallDir''
title.4 = progname||'^History (English)'
setup.4 = 'OBJECTID=<WCLOCK140_HSTENG>;EXENAME=E.exe;PARAMETERS='InstallDir'\HistEng.txt;STARTUPDIR='InstallDir''
title.5 = progname||'^manual (English)'
setup.5 = 'OBJECTID=<WCLOCK140_HLPENG>;EXENAME=View.exe;PARAMETERS='InstallDir'\English.inf;STARTUPDIR='InstallDir''
title.0 = 5
DO i = 1 TO title.0
    dummy = SysCreateObject('WPProgram',title.i,'<WCLOCK140_FOLDER>',setup.i,'U')
    SAY TRANSLATE(title.i,' ','^')||' - '||rc1(dummy)
END

SAY ' '
SAY 'Installation finished. Press any key to exit ...'
ans = SysGetKey('NOECHO')
Exit

/* End of InstallMe */

/* UnInstallMe - uninstall World Clock */

UnInstallMe: PROCEDURE

progname = 'World Clock'
CALL SysCls
SAY 'This is '||progname||' UnInstallation procedure!'
SAY 'Your files are in directory: '||Directory()
SAY 'This procedure will destroy '||progname||' Folder and Program objects'
SAY 'Press "Y" to start UnInstall, any other key to exit...'
ans = TRANSLATE(SysGetKey('ECHO'))
SELECT
    WHEN ans = 'Y' THEN NOP
    OTHERWISE CALL NoAction 'UnInstall aborted.'
END
SAY ' '
SAY 'Destroying Folder and Program objects'
CALL SysDestroyObject '<WCLOCK140_HLPSWE>'
CALL SysDestroyObject '<WCLOCK140_HSTSWE>'
CALL SysDestroyObject '<WCLOCK140_1STSWE>'
CALL SysDestroyObject '<WCLOCK140_HLPFRE>'
CALL SysDestroyObject '<WCLOCK140_HSTFRE>'
CALL SysDestroyObject '<WCLOCK140_1STFRE>'
CALL SysDestroyObject '<WCLOCK140_HLPDUT>'
CALL SysDestroyObject '<WCLOCK140_HSTDUT>'
CALL SysDestroyObject '<WCLOCK140_1STDUT>'
CALL SysDestroyObject '<WCLOCK140_HSTENG>'
CALL SysDestroyObject '<WCLOCK140_1STENG>'
CALL SysDestroyObject '<WCLOCK140_HLPENG>'
CALL SysDestroyObject '<WCLOCK140_PREX>'
CALL SysDestroyObject '<WCLOCK140_PROG>'
CALL SysDestroyObject '<WCLOCK140_FOLDER>'
SAY ' '
SAY 'UnInstallation complete.'
SAY 'You can delete files in directory '||Directory()
SAY 'To install '||progname||' again, start Install I. Press any key to exit...'
ans = SysGetKey('NOECHO')
Exit

/* End of UnInstallMe */

/* rc1 - return code - SysCreateObject */

rc1:        PROCEDURE

PARSE ARG rcSysCreateObject
SELECT
    WHEN rcSysCreateObject = 0 THEN rc1 = 'Error'
    OTHERWISE rc1 = 'OK'
END
RETURN rc1

/* End of rc1 */
