/* This file is part of statist
**
** It is distributed under the GNU General Public License.
** See the file COPYING for details.
** 
** (c) 1997 Dirk Melcher
**
**  some changes by Bernhard Reiter  http://www.usf.Uni-Osnabrueck.DE/~breiter
**  $Id: iodefs.c,v 1.2 2000/07/20 14:39:50 breiter Rel $
***************************************************************/

#include<stdio.h>
#include<string.h>

extern int errno;

#define FOPEN(name, mode, fp)                                     \
  if ((fp = fopen(name, mode))==NULL) {                           \
    fprintf(stderr, 								\
    	_("Module %s line %i:\n", "Modul %s Zeile %i:\n"), 		\
	__FILE__, __LINE__);  							\
    fprintf(stderr, _("   Error while opening file %s: %s\n",	\
			"   Fehler beim Oeffnen von Datei %s:  %s\n",	\
            name, strerror(errno));                               \
    exit(1);                                                      \
  }

#define FWRITE(ptr, size, nmemb, fp)                               \
  if (fwrite(ptr, size, nmemb, fp) != nmemb) {                    \
    fprintf(stderr, 								\
    	_("Module %s line %i:\n", "Modul %s Zeile %i:\n"), 		\
	__FILE__, __LINE__);  							\
    fprintf(stderr,_("   Error while writing with fwrite: %s\n",	\
     			"   Fehler beim Schreiben mit fwrite :  %s\n"),	\
	      strerror(errno));                                   	\
    exit(1);                                                      \
  }                                                              

#define FREAD(ptr, size, nmemb, fp)                               \
  if (fread(ptr, size, nmemb, fp) != nmemb) {                     \
    fprintf(stderr, 								\
    	_("Module %s line %i:\n", "Modul %s Zeile %i:\n"), 		\
	__FILE__, __LINE__);  							\
    if (feof(fp)) {                                               \
      fprintf(stderr, 								\
	_("   Error while reading with fread: Unexpected end of file\n", \
	"  Fehler beim Lesen mit fread: Unerwartetes Dateiende\n") ); \
    }                                                             \
    else {                                                        \
      fprintf(stderr, 								\
		_("   Error while reading with fread: %s\n", 		\
		"   Fehler beim Lesen mit fread :  %s\n"),   		\
	      strerror(errno));                                   	\
    }                                                             \
    exit(1);                                                      \
  }                                                              
  
#define FGETS(line, size, fp)                                     \
  if (fgets(line, size, fp)==NULL) {                              \
    fprintf(stderr, 								\
    	_("Module %s line %i:\n", "Modul %s Zeile %i:\n"), 		\
	__FILE__, __LINE__);  							\
    if (feof(fp)) {                                               \
      fprintf(stderr, 								\
	_("   Error while reading with fgets: Unexpected end of file\n", \
		"  Fehler beim Lesen mit fgets: Unerwartetes Dateiende\n") );\
    }                                                             \
    else {                                                        \
      fprintf(stderr,								\
		_("   Error while reading with fgets: %s\n", 		\
		"   Fehler beim Lesen mit fgets:  %s\n"),   		\
	      strerror(errno));                                     \
    }                                                             \
    exit(1);                                                      \
  }                                                              


#define FCLOSE(fp)                                                \
  if (fclose(fp) != 0) {                                          \
    fprintf(stderr, 								\
    	_("Module %s line %i:\n", "Modul %s Zeile %i:\n"), 		\
	__FILE__, __LINE__);  							\
    fprintf(stderr, 								\
		_("   Error while attempting to close file: %s\n",	\
    		"   Fehler beim Schliessen einer Datei: %s\n",)		\
            strerror(errno));                                     \
    exit(1);                                                      \
  }



int main() {
  FILE *file;
  char line[255]; 

  FOPEN("readline.c", "r", file);
  FGETS(line, 255, file);
  FCLOSE(file);

  return 0;
}

