/* Icon Plus
 * Copyright (C) 2001 Dmitry A.Steklenev
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. All advertising materials mentioning features or use of this
 *    software must display the following acknowledgment:
 *    "This product includes software developed by Dmitry A.Steklenev".
 *
 * 4. Redistributions of any form whatsoever must retain the following
 *    acknowledgment:
 *    "This product includes software developed by Dmitry A.Steklenev".
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR OR CONTRIBUTORS "AS IS"
 * AND ANY EXPRESSED OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * AUTHOR OR THE CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: ic_chlist.cpp,v 1.2 2001/05/31 05:35:37 glass Exp $
 */

#include "ic_chlist.h"
#include <string.h>

/*------------------------------------------------------------------
 * Constructs the strings list
 *------------------------------------------------------------------*/
ICChList::ICChList()
{
  lst_strings = 0;
  lst_size    = 0;
}

/*------------------------------------------------------------------
 * Destructs the strings list
 *------------------------------------------------------------------*/
ICChList::~ICChList()
{
  for( iterator i = begin(); i != end(); i++ )
    delete *i;

  delete[] lst_strings;
}

/*------------------------------------------------------------------
 * Inserts the string as the last item in the list
 *------------------------------------------------------------------*/
void ICChList::push_back( const char* string )
{
  char** new_list = new char*[lst_size+1];
  char** old_list = lst_strings;
  size_type i;

  for( i = 0; i < lst_size; i++ )
    new_list[i] = old_list[i];

  new_list[i] = new char[strlen(string)+1];
  strcpy( new_list[i], string );

  lst_strings = new_list;
  lst_size   += 1;

  delete[] old_list;
}

