/* Icon Plus
 * Copyright (C) 2001 Dmitry A.Steklenev
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. All advertising materials mentioning features or use of this
 *    software must display the following acknowledgment:
 *    "This product includes software developed by Dmitry A.Steklenev".
 *
 * 4. Redistributions of any form whatsoever must retain the following
 *    acknowledgment:
 *    "This product includes software developed by Dmitry A.Steklenev".
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR OR CONTRIBUTORS "AS IS"
 * AND ANY EXPRESSED OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * AUTHOR OR THE CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: ic_icl.h,v 1.1 2001/05/29 12:14:27 glass Exp $
 */

#ifndef IC_ICL_H
#define IC_ICL_H

#include "ic_windows.h"
#include "ic_chlist.h"

struct win_executable
{
  UINT16 type;      /* Signature of the executable file. */
  UINT32 ne_offset; /* Offset of New Executable header from beginning of file. */
  UINT16 ne_type;   /* Signature of the New Executable file. */
  UINT16 rs_offset; /* Offset of beginning of resource table relative to beginning
                       of New Executable header. */
  UINT16 rs_shift;  /* Alignment shift count for resource data. */
};

struct win_resource_directory
{
  UINT16 type;      /* This is an integer type if the high-order bit is
                       set (8000h); otherwise, it is an offset to the type string,
                       the offset is relative to the beginning of the resource
                       table. A zero type ID marks the end of the resource type
                       information blocks. */
  UINT16 count;     /* Number of resources of this type. */
  UINT32 reserved;  /* Reserved for run-time use. */
  long   offset;    /* This is not a part of the standard header! */
};

#define RT_ICON       0x8003
#define RT_GROUP_ICON 0x800E

struct win_resource_entry
{
  UINT16 offset;    /* File offset to the contents of the resource data,
                       relative to beginning of file. The offset is in terms
                       of the alignment shift count value specified at
                       beginning of the resource table. */
  UINT16 size;      /* Length of the resource in the file (in bytes)/ */
  UINT16 flags;     /* Resource flag word. */
  UINT16 id;        /* Resource ID. This is an integer type if the high-order
                       bit is set (8000h), otherwise it is the offset to the
                       resource string, the offset is relative to the
                       beginning of the resource table. */
  UINT32 reserved;  /* Reserved for run-time use. */
};

class ICICL : public ICWindows
{
  public:
    ICICL( ICFile* load_file )
    {
      init(load_file);
    }

  public:
    virtual void    init( ICFile*     load_file );
    virtual ICFile* find( const char* save_path );

  protected:
    virtual win_icon_entry load_entry();

  private:
    ICFile*  file;
    ICChList name_list;

    win_executable         header;
    win_resource_directory group;
    win_resource_directory icons;
};

#endif
