/* Icon Plus
 * Copyright (C) 2001 Dmitry A.Steklenev
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. All advertising materials mentioning features or use of this
 *    software must display the following acknowledgment:
 *    "This product includes software developed by Dmitry A.Steklenev".
 *
 * 4. Redistributions of any form whatsoever must retain the following
 *    acknowledgment:
 *    "This product includes software developed by Dmitry A.Steklenev".
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR OR CONTRIBUTORS "AS IS"
 * AND ANY EXPRESSED OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * AUTHOR OR THE CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: ic_file.h,v 1.4 2001/05/31 05:37:03 glass Exp $
 */

#ifndef IC_FILE_H
#define IC_FILE_H

#include "ic_config.h"
#include <stdio.h>

/**
 * Icon Plus file input/output
 *
 * The ICFile class creates and manages a file.
 * @author Dmitry A Steklenev
 */

class ICFile
{
  public:
    /** Constructs the file object */
    ICFile( const char* filename, const char* path = 0 );
    /** Destructs the file object */
   ~ICFile();

  public:
    /** Opens file for reading */
    int open_for_read ();
    /** Opens file for writing */
    int open_for_write();
    /** Close open file */
    int close();
    /** Returns true if file is open */
    int is_open() const;

  public:
    /** Reads one byte */
    BYTE   read_byte ();
    /** Reads 16bit big-endian integer */
    UINT16 read_int16();
    /** Reads 24bit big-endian integer */
    UINT32 read_int24();
    /** Reads 32bit big-endian integer */
    UINT32 read_int32();

    /** Write one byte */
    void write_byte ( BYTE   );
    /** Write 16bit big-endian integer */
    void write_int16( UINT16 );
    /** Write 24bit big-endian integer */
    void write_int24( UINT32 );
    /** Write 32bit big-endian integer */
    void write_int32( UINT32 );

  public:
    /** Returns the file name */
    const char* name() const;
    /** Changes the current file position */
    long seek( long offset );
    /** Returns the current file position */
    long tell();

  private:
    char* file_name;
    FILE* file_handle;
};

/*------------------------------------------------------------------
 * Returns true if file is open
 *------------------------------------------------------------------*/
inline int ICFile::is_open() const
{
  return file_handle != 0;
}

/*------------------------------------------------------------------
 * Returns the file name
 *------------------------------------------------------------------*/
inline const char* ICFile::name() const
{
  return file_name;
}

#endif
